[![GraphQLConf 2024 Banner: September 10-12, San Francisco. Hosted by the GraphQL Foundation](https://github.com/user-attachments/assets/bdb8cd5d-5186-4ece-b06b-b00a499b7868)](https://graphql.org/conf/2024/?utm_source=github&utm_medium=graphql_config&utm_campaign=readme)

<!-- Uncomment when we remove GraphQL Conf banner -->
<!-- ![GraphQL Config](https://i.imgur.com/hw5tXw2.gif 'GraphQL Config') -->

[![npm version](https://badge.fury.io/js/graphql-config.svg)](https://npmjs.com/package/graphql-config)
[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg?style=flat-square)](https://github.com/prettier/prettier)
[![renovate-app badge](https://img.shields.io/badge/renovate-app-blue.svg)](https://renovateapp.com/)
[![Discord Chat](https://img.shields.io/discord/625400653321076807)](https://discord.gg/xud7bH9)

**GraphQL Config** - one configuration for all your GraphQL tools (supported by most tools, editors & IDEs).
The easiest way to configure your development environment with your GraphQL Schema.

**As a developer**, you gain simplicity and a central place to setup libraries, tools and your IDE extensions.

**As a library author** GraphQL Config makes it easier to maintain the code responsible for handling configuration, loading GraphQL schemas or even files with GraphQL operations and fragments. GraphQL Config provides a set of useful methods and an easy-to-work-with API.

## Example

```yaml
schema: ./schema.json
documents: ./src/components/**/*.jsx
```

## Installation and Usage

Visit our website [**graphql-config.com**](https://graphql-config.com/) to learn more about the GraphQL Config.

## Help & Community

Join our [Discord chat](https://discord.gg/xud7bH9) if you run into issues or have questions. We love talking to you!

## Contributions

Contributions, issues and feature requests are very welcome. If you are using this package and fixed a bug for yourself, please consider submitting a PR!

And if this is your first time contributing to this project, please do read our [Contributor Workflow Guide](https://github.com/the-guild-org/Stack/blob/master/CONTRIBUTING.md) before you get started off.

### Code of Conduct

Help us keep GraphQL Config open and inclusive. Please read and follow our [Code of Conduct](https://github.com/the-guild-org/Stack/blob/master/CODE_OF_CONDUCT.md) as adopted from [Contributor Covenant](https://www.contributor-covenant.org/)

### License

[![GitHub license](https://img.shields.io/badge/license-MIT-lightgrey.svg?maxAge=2592000)](https://raw.githubusercontent.com/apollostack/apollo-ios/master/LICENSE)

MIT
