import type { Logger } from "../../../../utils/logger.cjs";
import type { SupergraphState } from "../../../state.cjs";
import { Edge } from "./edge.cjs";
import { FieldMove, Move } from "./moves.cjs";
import { Node } from "./node.cjs";
import type { SelectionResolver } from "./selection.cjs";
export declare class Graph {
    name: string;
    private supergraphState;
    private selectionResolver;
    private ignoreInaccessible;
    private _warnedAboutIncorrectEdge;
    private nodesByTypeIndex;
    private edgesByHeadTypeIndex;
    private edgesByTailTypeIndex;
    private typeNameToNodeIndexes;
    private typeChildren;
    private typeChildrenCache;
    private isSubgraph;
    private logger;
    private id;
    private idSymbol;
    private fieldEdgesWithProgressiveOverride;
    private fieldEdgesWithOverride;
    private superFieldEdgesToApplyOverride;
    constructor(logger: Logger, id: string | Symbol, name: string, supergraphState: SupergraphState, selectionResolver: SelectionResolver, ignoreInaccessible?: boolean);
    addUnreachableTypes(): this;
    addFromRoots(): this;
    addInterfaceObjectFields(): void;
    addFromEntities(): this;
    addSubgraph(graph: Graph): void;
    private connectUnionOrInterface;
    private connectEntities;
    private addProvidedInterfaceFields;
    private addProvidedUnionFields;
    private addProvidedField;
    joinSubgraphs(): this;
    addOverriddenFields(): this;
    private duplicateNode;
    private replaceEdgeAt;
    print(asLink?: boolean): string;
    graphNameToId(graphName: string): string | undefined;
    nodeOf(typeName: string): Node;
    nodeOf(typeName: string, failIfMissing: true): Node;
    nodeOf(typeName: string, failIfMissing?: false): Node | undefined;
    nodesOf(typeName: string, failIfMissing?: boolean): Node[];
    private getSameGraphEdgesOfIndex;
    fieldEdgesOfHead(head: Node, fieldName: string): Edge<FieldMove>[];
    abstractEdgesOfHead(head: Node): Edge<Move>[];
    private filterEdges;
    entityEdgesOfHead(head: Node): Edge<Move>[];
    indirectEdgesOfHead(head: Node): Edge<Move>[];
    edgesOfHead(head: Node): Edge<Move>[];
    edgesOfTail(tail: Node): Edge<Move>[];
    possibleTypesOf(typeName: string): string[];
    canReachTypeFromType(fromTypeName: string, toTypeName: string): boolean;
    private createNodesAndEdgesForType;
    private ensureNonOrSingleNode;
    private createNodesAndEdgesForObjectType;
    private createNodeForScalarType;
    private createNodeForEnumType;
    private createNodeForUnionType;
    private createNodeForInterfaceType;
    private createEdgeForInterfaceTypeField;
    private createEdgeForObjectTypeField;
    private createTypeNode;
    private createNode;
    private addNode;
    private ignoreEdge;
    private addEdge;
    private getIndexesOfType;
    private trueOrIfSubgraphThen;
    private isSupergraph;
    private isMergedGraph;
}
//# sourceMappingURL=graph.d.ts.map