import { Session } from '@shopify/shopify-api';
import { SessionStorage } from '@shopify/shopify-app-session-storage';
import type { PrismaClient } from '@prisma/client';
interface PrismaSessionStorageOptions {
    tableName?: string;
    connectionRetries?: number;
    connectionRetryIntervalMs?: number;
}
export interface PrismaSessionStorageInterface extends SessionStorage {
    isReady(): Promise<boolean>;
}
export declare class PrismaSessionStorage<T extends PrismaClient> implements PrismaSessionStorageInterface {
    private prisma;
    private ready;
    private readonly tableName;
    private connectionRetries;
    private connectionRetryIntervalMs;
    constructor(prisma: T, { tableName, connectionRetries, connectionRetryIntervalMs, }?: PrismaSessionStorageOptions);
    storeSession(session: Session): Promise<boolean>;
    loadSession(id: string): Promise<Session | undefined>;
    deleteSession(id: string): Promise<boolean>;
    deleteSessions(ids: string[]): Promise<boolean>;
    findSessionsByShop(shop: string): Promise<Session[]>;
    isReady(): Promise<boolean>;
    private ensureReady;
    private pollForTable;
    private sessionToRow;
    private rowToSession;
    private getSessionTable;
}
export declare class MissingSessionTableError extends Error {
    readonly cause: Error;
    constructor(message: string, cause: Error);
}
export declare class MissingSessionStorageError extends Error {
    constructor(message: string);
}
export {};
//# sourceMappingURL=prisma.d.ts.map