import { Session, Shopify, ShopifyRestResources } from '@shopify/shopify-api';
import { AppConfig, AppConfigArg } from '../../../config-types';
import { BasicParams } from '../../../types';
import { ApiConfigWithFutureFlags, ApiFutureFlags } from '../../../future/flags';
import { HandleAdminClientError } from '../../../clients';
import { AuthorizationStrategy, SessionContext } from './types';
export declare class MerchantCustomAuth<Config extends AppConfigArg> implements AuthorizationStrategy {
    protected api: Shopify<ApiConfigWithFutureFlags<Config['future']>, ShopifyRestResources, ApiFutureFlags<Config['future']>>;
    protected config: AppConfig;
    protected logger: Shopify['logger'];
    constructor({ api, config, logger }: BasicParams<Config['future']>);
    respondToOAuthRequests(request: Request): Promise<void>;
    authenticate(_request: Request, sessionContext: SessionContext): Promise<Session | never>;
    handleClientError(request: Request): HandleAdminClientError;
}
//# sourceMappingURL=merchant-custom-app.d.ts.map