import { Session, Shopify, ShopifyRestResources } from '@shopify/shopify-api';
import type { BasicParams } from '../../../types';
import { AppConfig, AppConfigArg } from '../../../config-types';
import { HandleAdminClientError } from '../../../clients';
import type { ApiConfigWithFutureFlags, ApiFutureFlags } from '../../../future/flags';
import { AuthorizationStrategy, SessionContext } from './types';
export declare class AuthCodeFlowStrategy<Config extends AppConfigArg, Resources extends ShopifyRestResources = ShopifyRestResources> implements AuthorizationStrategy {
    protected api: Shopify<ApiConfigWithFutureFlags<Config['future']>, ShopifyRestResources, ApiFutureFlags<Config['future']>>;
    protected config: AppConfig;
    protected logger: Shopify['logger'];
    constructor({ api, config, logger }: BasicParams);
    respondToOAuthRequests(request: Request): Promise<void | never>;
    authenticate(request: Request, sessionContext: SessionContext): Promise<Session | never>;
    handleClientError(request: Request): HandleAdminClientError;
    private ensureInstalledOnShop;
    private handleAuthBeginRequest;
    private handleAuthCallbackRequest;
    private getOfflineSession;
    private hasValidOfflineId;
    private getOfflineSessionId;
    private testSession;
    private oauthCallbackError;
    private handleInvalidOfflineSession;
}
//# sourceMappingURL=auth-code-flow.d.ts.map