import { createOrLoadOfflineSession } from '../../authenticate/helpers/create-or-load-offline-session.mjs';
import { SessionNotFoundError } from '../../errors.mjs';
import { adminClientFactory } from '../../clients/admin/factory.mjs';

function unauthenticatedAdminContextFactory(params) {
    return async (shop) => {
        const session = await createOrLoadOfflineSession(shop, params);
        if (!session) {
            throw new SessionNotFoundError(`Could not find a session for shop ${shop} when creating unauthenticated admin context`);
        }
        return {
            session,
            admin: adminClientFactory({ params, session }),
        };
    };
}

export { unauthenticatedAdminContextFactory };
//# sourceMappingURL=factory.mjs.map
