import { jsx } from 'react/jsx-runtime';

function errorBoundary(error) {
    if (error.constructor.name === 'ErrorResponse' ||
        error.constructor.name === 'ErrorResponseImpl') {
        return (jsx("div", { dangerouslySetInnerHTML: { __html: error.data || 'Handling response' } }));
    }
    throw error;
}

export { errorBoundary };
//# sourceMappingURL=error.mjs.map
