import { ensureCORSHeadersFactory } from '../../helpers/ensure-cors-headers.mjs';
import { validateSessionToken } from '../../helpers/validate-session-token.mjs';
import { getSessionTokenHeader } from '../../helpers/get-session-token-header.mjs';
import { respondToBotRequest } from '../../helpers/reject-bot-request.mjs';
import { respondToOptionsRequest } from '../../helpers/respond-to-options-request.mjs';
import '@remix-run/server-runtime';
import '../../../types.mjs';
import { getShopFromRequest } from '../../helpers/get-shop-from-request.mjs';

function authenticateExtensionFactory(params, requestType) {
    return async function authenticateExtension(request, options = {}) {
        const { logger } = params;
        const corsHeaders = options.corsHeaders ?? [];
        respondToBotRequest(params, request);
        respondToOptionsRequest(params, request, corsHeaders);
        const sessionTokenHeader = getSessionTokenHeader(request);
        logger.info(`Authenticating ${requestType} request`, {
            shop: getShopFromRequest(request),
        });
        if (!sessionTokenHeader) {
            logger.debug('Request did not contain a session token', {
                shop: getShopFromRequest(request),
            });
            throw new Response(undefined, {
                status: 401,
                statusText: 'Unauthorized',
            });
        }
        return {
            sessionToken: await validateSessionToken(params, request, sessionTokenHeader, { checkAudience: false, retryRequest: false }),
            cors: ensureCORSHeadersFactory(params, request, corsHeaders),
        };
    };
}

export { authenticateExtensionFactory };
//# sourceMappingURL=authenticate.mjs.map
