import { beginAuth } from './begin-auth.mjs';
import { redirectWithExitIframe } from './redirect-with-exitiframe.mjs';
import { redirectWithAppBridgeHeaders } from './redirect-with-app-bridge-headers.mjs';

async function redirectToAuthPage(params, request, shop, isOnline = false) {
    const { config } = params;
    const url = new URL(request.url);
    const isEmbeddedRequest = url.searchParams.get('embedded') === '1';
    const isXhrRequest = request.headers.get('authorization');
    if (isXhrRequest) {
        const redirectUri = new URL(config.auth.path, config.appUrl);
        redirectUri.searchParams.set('shop', shop);
        redirectWithAppBridgeHeaders(redirectUri.toString());
    }
    else if (isEmbeddedRequest) {
        redirectWithExitIframe(params, request, shop);
    }
    else {
        throw await beginAuth(params, request, isOnline, shop);
    }
}

export { redirectToAuthPage };
//# sourceMappingURL=redirect-to-auth-page.mjs.map
