import { redirectToBouncePage } from './redirect-to-bounce-page.mjs';

const SESSION_TOKEN_PARAM = 'id_token';
const ensureSessionTokenSearchParamIfRequired = async (params, request) => {
    const { api, logger } = params;
    const url = new URL(request.url);
    const shop = url.searchParams.get('shop');
    const searchParamSessionToken = url.searchParams.get(SESSION_TOKEN_PARAM);
    const isEmbedded = url.searchParams.get('embedded') === '1';
    if (api.config.isEmbeddedApp && isEmbedded && !searchParamSessionToken) {
        logger.debug('Missing session token in search params, going to bounce page', { shop });
        redirectToBouncePage(params, url);
    }
};

export { ensureSessionTokenSearchParamIfRequired };
//# sourceMappingURL=ensure-session-token-search-param-if-required.mjs.map
