import { HttpResponseError } from '@shopify/shopify-api';
import '@remix-run/server-runtime';
import { redirectToAuthPage } from '../helpers/redirect-to-auth-page.mjs';
import { invalidateAccessToken } from '../../helpers/invalidate-access-token.mjs';
import 'isbot';
import '../../../types.mjs';

function checkBillingFactory(params, request, session) {
    return async function checkBilling(options = {}) {
        const { api, logger } = params;
        logger.debug('Checking billing plans', { shop: session.shop, ...options });
        try {
            return await api.billing.check({
                session,
                plans: options.plans,
                isTest: options.isTest,
                returnObject: true,
            });
        }
        catch (error) {
            if (error instanceof HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken(params, session);
                throw await redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
    };
}

export { checkBillingFactory };
//# sourceMappingURL=check.mjs.map
