'use strict';

var createOrLoadOfflineSession = require('../../authenticate/helpers/create-or-load-offline-session.js');
var errors = require('../../errors.js');
var factory = require('../../clients/storefront/factory.js');

function unauthenticatedStorefrontContextFactory(params) {
    return async (shop) => {
        const session = await createOrLoadOfflineSession.createOrLoadOfflineSession(shop, params);
        if (!session) {
            throw new errors.SessionNotFoundError(`Could not find a session for shop ${shop} when creating unauthenticated storefront context`);
        }
        return {
            session,
            storefront: factory.storefrontClientFactory({ params, session }),
        };
    };
}

exports.unauthenticatedStorefrontContextFactory = unauthenticatedStorefrontContextFactory;
//# sourceMappingURL=factory.js.map
