'use strict';

function logDisabledFutureFlags(config, logger) {
    const logFlag = (flag, message) => logger.info(`Future flag ${flag} is disabled.\n\n  ${message}\n`);
    if (!config.future.unstable_newEmbeddedAuthStrategy) {
        logFlag('unstable_newEmbeddedAuthStrategy', 'Enable this to use OAuth token exchange instead of auth code to generate API access tokens.' +
            '\n  Your app must be using Shopify managed install: https://shopify.dev/docs/apps/auth/installation');
    }
}

exports.logDisabledFutureFlags = logDisabledFutureFlags;
//# sourceMappingURL=flags.js.map
