'use strict';

var types = require('../../types.js');

async function createOrLoadOfflineSession(shop, { api, config, logger }) {
    if (config.distribution === types.AppDistribution.ShopifyAdmin) {
        logger.debug('Creating custom app session from configured access token', {
            shop,
        });
        return api.session.customAppSession(shop);
    }
    else {
        logger.debug('Loading offline session from session storage', { shop });
        const offlineSessionId = api.session.getOfflineId(shop);
        const session = await config.sessionStorage.loadSession(offlineSessionId);
        return session;
    }
}

exports.createOrLoadOfflineSession = createOrLoadOfflineSession;
//# sourceMappingURL=create-or-load-offline-session.js.map
