'use strict';

var shopifyApi = require('@shopify/shopify-api');
var fetchScopesDetails = require('./client/fetch-scopes-details.js');

function queryScopesFactory(params, session, admin) {
    return async function queryScopes() {
        const { logger } = params;
        logger.debug('Querying scopes details: ', {
            shop: session.shop,
        });
        const scopesDetail = await fetchScopesDetails.fetchScopeDetail(admin);
        return mapFetchScopeDetail(scopesDetail);
    };
}
function mapFetchScopeDetail(scopesDetailResponse) {
    const appInformation = scopesDetailResponse.app;
    const granted = new shopifyApi.AuthScopes(appInformation.installation.accessScopes.map((scope) => scope.handle)).toArray(true);
    const required = new shopifyApi.AuthScopes(appInformation.requestedAccessScopes.map((scope) => scope.handle)).toArray(true);
    const optional = new shopifyApi.AuthScopes(appInformation.optionalAccessScopes.map((scope) => scope.handle)).toArray(true);
    return {
        granted,
        required,
        optional,
    };
}

exports.mapFetchScopeDetail = mapFetchScopeDetail;
exports.queryScopesFactory = queryScopesFactory;
//# sourceMappingURL=query.js.map
