'use strict';

const REVOKE_SCOPE_MUTATION = `#graphql
mutation AppRevokeAccessScopes($scopes: [String!]!) {
  appRevokeAccessScopes(scopes: $scopes){
    revoked {
      handle
    }
    userErrors {
      field
      message
    }
  }
}`;
async function revokeScopes(admin, scopes) {
    const revokeScopesResult = await admin.graphql(REVOKE_SCOPE_MUTATION, {
        variables: {
            scopes,
        },
    });
    const resultContent = await revokeScopesResult.json();
    return resultContent.data.appRevokeAccessScopes;
}

exports.revokeScopes = revokeScopes;
//# sourceMappingURL=revoke-scopes.js.map
