'use strict';

var shopifyApi = require('@shopify/shopify-api');
require('@remix-run/server-runtime');
var redirectToAuthPage = require('../helpers/redirect-to-auth-page.js');
var invalidateAccessToken = require('../../helpers/invalidate-access-token.js');
require('isbot');
require('../../../types.js');
var helpers = require('./helpers.js');

function updateUsageCappedAmountFactory(params, request, session) {
    return async function updateUsageCappedAmount(options) {
        const { api, logger } = params;
        logger.debug('Updating usage subscription capped amount', {
            shop: session.shop,
            ...options,
        });
        let result;
        try {
            result = await api.billing.updateUsageCappedAmount({
                session,
                subscriptionLineItemId: options.subscriptionLineItemId,
                cappedAmount: options.cappedAmount,
            });
        }
        catch (error) {
            if (error instanceof shopifyApi.HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken.invalidateAccessToken(params, session);
                throw await redirectToAuthPage.redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
        throw helpers.redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
    };
}

exports.updateUsageCappedAmountFactory = updateUsageCappedAmountFactory;
//# sourceMappingURL=update-usage-subscription-capped-amount.js.map
