'use strict';

var shopifyApi = require('@shopify/shopify-api');
require('@remix-run/server-runtime');
var redirectToAuthPage = require('../helpers/redirect-to-auth-page.js');
var invalidateAccessToken = require('../../helpers/invalidate-access-token.js');
require('isbot');
require('../../../types.js');

function requireBillingFactory(params, request, session) {
    const { api, logger } = params;
    return async function requireBilling(options) {
        const logContext = {
            shop: session.shop,
            plans: options.plans,
            isTest: options.isTest,
        };
        logger.debug('Checking billing for the shop', logContext);
        let data;
        try {
            data = await api.billing.check({
                session,
                plans: options.plans,
                isTest: options.isTest,
                returnObject: true,
            });
        }
        catch (error) {
            if (error instanceof shopifyApi.HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', logContext);
                await invalidateAccessToken.invalidateAccessToken(params, session);
                throw await redirectToAuthPage.redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
        if (!data.hasActivePayment) {
            logger.debug('Billing check failed', logContext);
            throw await options.onFailure(new Error('Billing check failed'));
        }
        logger.debug('Billing check succeeded', logContext);
        return data;
    };
}

exports.requireBillingFactory = requireBillingFactory;
//# sourceMappingURL=require.js.map
