'use strict';

var shopifyApi = require('@shopify/shopify-api');
require('@remix-run/server-runtime');
var redirectToAuthPage = require('../helpers/redirect-to-auth-page.js');
var invalidateAccessToken = require('../../helpers/invalidate-access-token.js');
require('isbot');
require('../../../types.js');

function cancelBillingFactory(params, request, session) {
    return async function cancelBilling(options) {
        const { api, logger } = params;
        logger.debug('Cancelling billing', { shop: session.shop, ...options });
        try {
            return await api.billing.cancel({
                session,
                subscriptionId: options.subscriptionId,
                isTest: options.isTest,
                prorate: options.prorate,
            });
        }
        catch (error) {
            if (error instanceof shopifyApi.HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken.invalidateAccessToken(params, session);
                throw await redirectToAuthPage.redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
    };
}

exports.cancelBillingFactory = cancelBillingFactory;
//# sourceMappingURL=cancel.js.map
