import jwt from 'jsonwebtoken';
import { USER_ID } from './const.mjs';
import { getShopValue } from './get-shop-value.mjs';

/**
 * Creates and signs a JWT token to use in faking authorization for testing.
 *
 * @param store The name of the store for which to create a valid JWT token.
 * @param apiKey The Client ID/API key for the store for which to create a valid JWT token.
 * @param apiSecretKey The API secret for the store for which to create a valid JWT token.
 * @param overrides Optional overrides for the JWT payload.
 * @returns {TestJwt} The JWT token and the JWT payload used to create the token.
 */
function getJwt(store, apiKey, apiSecretKey, overrides = {}) {
    const date = new Date();
    const shop = getShopValue(store);
    const payload = {
        iss: `${shop}/admin`,
        dest: `https://${shop}`,
        aud: apiKey,
        sub: `${USER_ID}`,
        exp: date.getTime() / 1000 + 3600,
        nbf: date.getTime() / 1000 - 3600,
        iat: date.getTime() / 1000 - 3600,
        jti: '1234567890',
        sid: '0987654321',
        ...overrides,
    };
    const token = jwt.sign(payload, apiSecretKey, {
        algorithm: 'HS256',
    });
    return { token, payload };
}

export { getJwt };
//# sourceMappingURL=get-jwt.mjs.map
