import { Base } from '../../base.mjs';
import { ApiVersion } from '../../../lib/types.mjs';

/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
class ApplicationCharge extends Base {
    static apiVersion = ApiVersion.January23;
    static hasOne = {};
    static hasMany = {};
    static paths = [
        { "http_method": "get", "operation": "get", "ids": [], "path": "application_charges.json" },
        { "http_method": "get", "operation": "get", "ids": ["id"], "path": "application_charges/<id>.json" },
        { "http_method": "post", "operation": "post", "ids": [], "path": "application_charges.json" }
    ];
    static resourceNames = [
        {
            "singular": "application_charge",
            "plural": "application_charges"
        }
    ];
    static async find({ session, id, fields = null }) {
        const result = await this.baseFind({
            session: session,
            requireIds: true,
            urlIds: { "id": id },
            params: { "fields": fields },
        });
        return result.data ? result.data[0] : null;
    }
    static async all({ session, since_id = null, fields = null, ...otherArgs }) {
        const response = await this.baseFind({
            session: session,
            urlIds: {},
            params: { "since_id": since_id, "fields": fields, ...otherArgs },
        });
        return response;
    }
    confirmation_url;
    created_at;
    currency;
    id;
    name;
    price;
    return_url;
    status;
    test;
    updated_at;
}

export { ApplicationCharge };
//# sourceMappingURL=application_charge.mjs.map
