import { InvalidSession, MissingRequiredArgument } from '../../error.mjs';
import { graphqlClientClass } from '../admin/graphql/client.mjs';
import '@shopify/admin-api-client';
import '@shopify/network';
import '../../types.mjs';
import '../../../runtime/crypto/crypto.mjs';
import '../../../runtime/crypto/types.mjs';
import 'compare-versions';

function graphqlProxy(config) {
    return async ({ session, rawBody }) => {
        if (!session.accessToken) {
            throw new InvalidSession('Cannot proxy query. Session not authenticated.');
        }
        const GraphqlClient = graphqlClientClass({ config });
        const client = new GraphqlClient({ session });
        let query;
        let variables;
        if (typeof rawBody === 'string') {
            query = rawBody;
        }
        else {
            query = rawBody.query;
            variables = rawBody.variables;
        }
        if (!query) {
            throw new MissingRequiredArgument('Query missing.');
        }
        const response = await client.request(query, { variables });
        return { body: response, headers: {} };
    };
}

export { graphqlProxy };
//# sourceMappingURL=graphql_proxy.mjs.map
