import { throwFailedRequest } from '../../clients/common.mjs';
import { decodeSessionToken } from '../../session/decode-session-token.mjs';
import { sanitizeShop } from '../../utils/shop-validator.mjs';
import { DataType } from '../../clients/types.mjs';
import { fetchRequestFactory } from '../../utils/fetch-request.mjs';
import { createSession } from './create-session.mjs';

var RequestedTokenType;
(function (RequestedTokenType) {
    RequestedTokenType["OnlineAccessToken"] = "urn:shopify:params:oauth:token-type:online-access-token";
    RequestedTokenType["OfflineAccessToken"] = "urn:shopify:params:oauth:token-type:offline-access-token";
})(RequestedTokenType || (RequestedTokenType = {}));
const TokenExchangeGrantType = 'urn:ietf:params:oauth:grant-type:token-exchange';
const IdTokenType = 'urn:ietf:params:oauth:token-type:id_token';
function tokenExchange(config) {
    return async ({ shop, sessionToken, requestedTokenType, }) => {
        await decodeSessionToken(config)(sessionToken);
        const body = {
            client_id: config.apiKey,
            client_secret: config.apiSecretKey,
            grant_type: TokenExchangeGrantType,
            subject_token: sessionToken,
            subject_token_type: IdTokenType,
            requested_token_type: requestedTokenType,
        };
        const cleanShop = sanitizeShop(config)(shop, true);
        const postResponse = await fetchRequestFactory(config)(`https://${cleanShop}/admin/oauth/access_token`, {
            method: 'POST',
            body: JSON.stringify(body),
            headers: {
                'Content-Type': DataType.JSON,
                Accept: DataType.JSON,
            },
        });
        if (!postResponse.ok) {
            throwFailedRequest(await postResponse.json(), false, postResponse);
        }
        return {
            session: createSession({
                accessTokenResponse: await postResponse.json(),
                shop: cleanShop,
                // We need to keep this as an empty string as our template DB schemas have this required
                state: '',
                config,
            }),
        };
    };
}

export { RequestedTokenType, tokenExchange };
//# sourceMappingURL=token-exchange.mjs.map
