import { v4 } from 'uuid';
import { Session } from '../../session/session.mjs';
import { logger } from '../../logger/index.mjs';
import { getJwtSessionId, getOfflineId } from '../../session/session-utils.mjs';

function createSession({ config, accessTokenResponse, shop, state, }) {
    const associatedUser = accessTokenResponse
        .associated_user;
    const isOnline = Boolean(associatedUser);
    logger(config).info('Creating new session', { shop, isOnline });
    const getSessionExpiration = (expires_in) => new Date(Date.now() + expires_in * 1000);
    const getOnlineSessionProperties = (responseBody) => {
        const { access_token, scope, ...rest } = responseBody;
        const sessionId = config.isEmbeddedApp
            ? getJwtSessionId(config)(shop, `${rest.associated_user.id}`)
            : v4();
        return {
            id: sessionId,
            onlineAccessInfo: rest,
            expires: getSessionExpiration(rest.expires_in),
        };
    };
    const getOfflineSessionProperties = (responseBody) => {
        const { expires_in } = responseBody;
        return {
            id: getOfflineId(config)(shop),
            ...(expires_in && { expires: getSessionExpiration(expires_in) }),
        };
    };
    return new Session({
        shop,
        state,
        isOnline,
        accessToken: accessTokenResponse.access_token,
        scope: accessTokenResponse.scope,
        ...(isOnline
            ? getOnlineSessionProperties(accessTokenResponse)
            : getOfflineSessionProperties(accessTokenResponse)),
    });
}

export { createSession };
//# sourceMappingURL=create-session.mjs.map
