import React, { useRef, useContext, useEffect, useId } from 'react';
import { ScrollableContext } from '../../context.js';

function ScrollTo() {
  const anchorNode = useRef(null);
  const scrollToPosition = useContext(ScrollableContext);
  useEffect(() => {
    if (!scrollToPosition || !anchorNode.current) {
      return;
    }
    scrollToPosition(anchorNode.current.offsetTop);
  }, [scrollToPosition]);
  const id = useId();
  // eslint-disable-next-line jsx-a11y/anchor-is-valid
  return /*#__PURE__*/React.createElement("a", {
    id: id,
    ref: anchorNode
  });
}

export { ScrollTo };
