import React from 'react';
import styles from './Connected.css.js';
import { Item } from './components/Item/Item.js';

function Connected({
  children,
  left,
  right
}) {
  const leftConnectionMarkup = left ? /*#__PURE__*/React.createElement(Item, {
    position: "left"
  }, left) : null;
  const rightConnectionMarkup = right ? /*#__PURE__*/React.createElement(Item, {
    position: "right"
  }, right) : null;
  return /*#__PURE__*/React.createElement("div", {
    className: styles.Connected
  }, leftConnectionMarkup, /*#__PURE__*/React.createElement(Item, {
    position: "primary"
  }, children), rightConnectionMarkup);
}

export { Connected };
