'use strict';

var graphqlCodegen = require('@shopify/graphql-codegen');
var apiConfigs = require('./helpers/api-configs.js');

const preset = {
    buildGeneratesSection: (options) => {
        const apiType = options.presetConfig.apiType;
        const { interfaceExtension, module, presetConfigs } = apiConfigs.apiConfigs[apiType];
        const typesFile = apiConfigs.apiConfigs[apiType].typesFile;
        return graphqlCodegen.preset.buildGeneratesSection({
            ...options,
            presetConfig: {
                ...presetConfigs,
                importTypes: {
                    namespace: presetConfigs.importTypes.namespace,
                    from: `./${typesFile}`,
                },
                interfaceExtension: ({ queryType, mutationType, }) => interfaceExtension
                    .replace('%%MODULE%%', options.presetConfig.module ?? module)
                    .replace('%%QUERY%%', queryType)
                    .replace('%%MUTATION%%', mutationType),
            },
        });
    },
};

exports.preset = preset;
//# sourceMappingURL=preset.js.map
