import {
  __publicField
} from "./chunk-VRMXEQCD.js";

// node_modules/@shopify/shopify-api/dist/esm/runtime/crypto/crypto.mjs
var cryptoVar;
try {
  cryptoVar = crypto;
} catch (_e) {
}
function setCrypto(crypto2) {
  cryptoVar = crypto2;
}

// node_modules/@shopify/shopify-api/dist/esm/runtime/platform/runtime-string.mjs
var abstractRuntimeString = () => {
  throw new Error("Missing adapter implementation for 'abstractRuntimeString' - make sure to import the appropriate adapter for your platform");
};
function setAbstractRuntimeString(func) {
  abstractRuntimeString = func;
}

// node_modules/isbot/index.mjs
var fullPattern = " daum[ /]| deusu/|(?:^|[^g])news(?!sapphire)|(?<! (?:channel/|google/))google(?!(app|/google| pixel))|(?<! cu)bots?(?:\\b|_)|(?<!(?:lib))http|(?<![hg]m)score|(?<!cam)scan|24x7|@[a-z][\\w-]+\\.|\\(\\)|\\.com\\b|\\bperl\\b|\\btime/|\\||^[\\w \\.\\-\\(?:\\):%]+(?:/v?\\d+(?:\\.\\d+)?(?:\\.\\d{1,10})*?)?(?:,|$)|^[^ ]{50,}$|^\\d+\\b|^\\W|^\\w*search\\b|^\\w+/[\\w\\(\\)]*$|^active|^ad muncher|^amaya|^avsdevicesdk/|^azure|^biglotron|^bot|^bw/|^clamav[ /]|^client/|^cobweb/|^custom|^ddg[_-]android|^discourse|^dispatch/\\d|^downcast/|^duckduckgo|^email|^facebook|^getright/|^gozilla/|^hobbit|^hotzonu|^hwcdn/|^igetter/|^jeode/|^jetty/|^jigsaw|^microsoft bits|^movabletype|^mozilla/\\d\\.\\d\\s[\\w\\.-]+$|^mozilla/\\d\\.\\d\\s\\(compatible;?(?:\\s\\w+\\/\\d+\\.\\d+)?\\)$|^navermailapp|^netsurf|^offline|^openai/|^owler|^php|^postman|^python|^rank|^read|^reed|^rest|^rss|^snapchat|^space bison|^svn|^swcd |^taringa|^thumbor/|^track|^w3c|^webbandit/|^webcopier|^wget|^whatsapp|^wordpress|^xenu link sleuth|^yahoo|^yandex|^zdm/\\d|^zoom marketplace/|agent\\b|analyzer|archive|ask jeeves/teoma|audit|bit\\.ly/|bluecoat drtr|browsex|burpcollaborator|capture|catch|check\\b|checker|chrome-lighthouse|chromeframe|classifier|cloudflare|convertify|crawl|cypress/|dareboost|datanyze|dejaclick|detect|dmbrowser|download|evc-batch/|exaleadcloudview|feed|fetcher|firephp|functionize|grab|headless|httrack|hubspot marketing grader|hydra|ibisbrowser|infrawatch|insight|inspect|iplabel|java(?!;)|library|linkcheck|mail\\.ru/|manager|measure|neustar wpm|node\\b|nutch|offbyone|onetrust|optimize|pageburst|pagespeed|parser|phantomjs|pingdom|powermarks|preview|proxy|ptst[ /]\\d|retriever|rexx;|rigor|rss\\b|scrape|server|sogou|sparkler/|speedcurve|spider|splash|statuscake|supercleaner|synapse|synthetic|tools|torrent|transcoder|url|validator|virtuoso|wappalyzer|webglance|webkit2png|whatcms/|xtate/";
var naivePattern = /bot|crawl|http|lighthouse|scan|search|spider/i;
var pattern;
function getPattern() {
  if (pattern instanceof RegExp) {
    return pattern;
  }
  try {
    pattern = new RegExp(fullPattern, "i");
  } catch (error) {
    pattern = naivePattern;
  }
  return pattern;
}
function isbot(userAgent) {
  return Boolean(userAgent) && getPattern().test(userAgent);
}

// node_modules/@shopify/shopify-api/dist/esm/runtime/crypto/types.mjs
var HashFormat;
(function(HashFormat2) {
  HashFormat2["Base64"] = "base64";
  HashFormat2["Hex"] = "hex";
})(HashFormat || (HashFormat = {}));

// node_modules/@shopify/shopify-api/dist/esm/runtime/http/index.mjs
function isOK(resp) {
  return resp.statusCode >= 200 && resp.statusCode <= 299;
}
var abstractFetch = () => {
  throw new Error("Missing adapter implementation for 'abstractFetch' - make sure to import the appropriate adapter for your platform");
};
function setAbstractFetchFunc(func) {
  abstractFetch = func;
}
var abstractConvertRequest = () => {
  throw new Error("Missing adapter implementation for 'abstractConvertRequest' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertRequestFunc(func) {
  abstractConvertRequest = func;
}
var abstractConvertIncomingResponse = () => Promise.resolve({});
var abstractConvertResponse = () => {
  throw new Error("Missing adapter implementation for 'abstractConvertResponse' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertResponseFunc(func) {
  abstractConvertResponse = func;
}
var abstractConvertHeaders = () => {
  throw new Error("Missing adapter implementation for 'abstractConvertHeaders' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertHeadersFunc(func) {
  abstractConvertHeaders = func;
}

// node_modules/@shopify/shopify-api/dist/esm/runtime/http/headers.mjs
function canonicalizeHeaderName(hdr) {
  return hdr.replace(/(^|-)(\w+)/g, (_fullMatch, start, letters) => start + letters.slice(0, 1).toUpperCase() + letters.slice(1).toLowerCase());
}
function getHeaders(headers, needle_) {
  const result = [];
  if (!headers)
    return result;
  const needle = canonicalizeHeaderName(needle_);
  for (const [key, values] of Object.entries(headers)) {
    if (canonicalizeHeaderName(key) !== needle)
      continue;
    if (Array.isArray(values)) {
      result.push(...values);
    } else {
      result.push(values);
    }
  }
  return result;
}
function getHeader(headers, needle) {
  var _a;
  if (!headers)
    return void 0;
  return (_a = getHeaders(headers, needle)) == null ? void 0 : _a[0];
}
function addHeader(headers, key, value) {
  canonicalizeHeaders(headers);
  const canonKey = canonicalizeHeaderName(key);
  let list = headers[canonKey];
  if (!list) {
    list = [];
  } else if (!Array.isArray(list)) {
    list = [list];
  }
  headers[canonKey] = list;
  list.push(value);
}
function canonicalizeValue(value) {
  if (typeof value === "number")
    return value.toString();
  return value;
}
function canonicalizeHeaders(hdr) {
  for (const [key, values] of Object.entries(hdr)) {
    const canonKey = canonicalizeHeaderName(key);
    if (!hdr[canonKey])
      hdr[canonKey] = [];
    if (!Array.isArray(hdr[canonKey]))
      hdr[canonKey] = [canonicalizeValue(hdr[canonKey])];
    if (key === canonKey)
      continue;
    delete hdr[key];
    hdr[canonKey].push(...[values].flat().map((value) => canonicalizeValue(value)));
  }
  return hdr;
}
function removeHeader(headers, needle) {
  canonicalizeHeaders(headers);
  const canonKey = canonicalizeHeaderName(needle);
  delete headers[canonKey];
}
function flatHeaders(headers) {
  if (!headers)
    return [];
  return Object.entries(headers).flatMap(([header, values]) => Array.isArray(values) ? values.map((value) => [header, value]) : [[header, values]]);
}

// node_modules/@shopify/shopify-api/dist/esm/lib/error.mjs
var ShopifyError = class extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
  }
};
var InvalidHmacError = class extends ShopifyError {
};
var InvalidShopError = class extends ShopifyError {
};
var InvalidHostError = class extends ShopifyError {
};
var InvalidJwtError = class extends ShopifyError {
};
var MissingJwtTokenError = class extends ShopifyError {
};
var InvalidDeliveryMethodError = class extends ShopifyError {
};
var SafeCompareError = class extends ShopifyError {
};
var PrivateAppError = class extends ShopifyError {
};
var HttpRequestError = class extends ShopifyError {
};
var HttpMaxRetriesError = class extends ShopifyError {
};
var HttpResponseError = class extends ShopifyError {
  constructor({ message, code, statusText, body, headers }) {
    super(message);
    __publicField(this, "response");
    this.response = {
      code,
      statusText,
      body,
      headers
    };
  }
};
var HttpRetriableError = class extends HttpResponseError {
};
var HttpInternalError = class extends HttpRetriableError {
};
var HttpThrottlingError = class extends HttpRetriableError {
  constructor({ retryAfter, ...params }) {
    super(params);
    this.response.retryAfter = retryAfter;
  }
};
var GraphqlQueryError = class extends ShopifyError {
  constructor({ message, response, headers, body }) {
    super(message);
    __publicField(this, "response");
    __publicField(this, "headers");
    __publicField(this, "body");
    this.response = response;
    this.headers = headers;
    this.body = body;
  }
};
var InvalidOAuthError = class extends ShopifyError {
};
var BotActivityDetected = class extends ShopifyError {
};
var CookieNotFound = class extends ShopifyError {
};
var InvalidSession = class extends ShopifyError {
};
var InvalidWebhookError = class extends ShopifyError {
  constructor({ message, response }) {
    super(message);
    __publicField(this, "response");
    this.response = response;
  }
};
var MissingWebhookCallbackError = class extends InvalidWebhookError {
};
var MissingRequiredArgument = class extends ShopifyError {
};
var InvalidRequestError = class extends ShopifyError {
};
var BillingError = class extends ShopifyError {
  constructor({ message, errorData }) {
    super(message);
    __publicField(this, "errorData");
    this.errorData = errorData;
  }
};
var FeatureDeprecatedError = class extends ShopifyError {
};

// node_modules/@shopify/shopify-api/dist/esm/runtime/crypto/utils.mjs
async function createSHA256HMAC(secret, payload, returnFormat = HashFormat.Base64) {
  var _a;
  const cryptoLib = typeof ((_a = cryptoVar) == null ? void 0 : _a.webcrypto) === "undefined" ? cryptoVar : cryptoVar.webcrypto;
  const enc = new TextEncoder();
  const key = await cryptoLib.subtle.importKey("raw", enc.encode(secret), {
    name: "HMAC",
    hash: { name: "SHA-256" }
  }, false, ["sign"]);
  const signature = await cryptoLib.subtle.sign("HMAC", key, enc.encode(payload));
  return returnFormat === HashFormat.Base64 ? asBase64(signature) : asHex(signature);
}
function asHex(buffer) {
  return [...new Uint8Array(buffer)].map((byte) => byte.toString(16).padStart(2, "0")).join("");
}
var LookupTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
function asBase64(buffer) {
  let output = "";
  const input = new Uint8Array(buffer);
  for (let i = 0; i < input.length; ) {
    const byte1 = input[i++];
    const byte2 = input[i++];
    const byte3 = input[i++];
    const enc1 = byte1 >> 2;
    const enc2 = (byte1 & 3) << 4 | byte2 >> 4;
    let enc3 = (byte2 & 15) << 2 | byte3 >> 6;
    let enc4 = byte3 & 63;
    if (isNaN(byte2)) {
      enc3 = 64;
    }
    if (isNaN(byte3)) {
      enc4 = 64;
    }
    output += LookupTable[enc1] + LookupTable[enc2] + LookupTable[enc3] + LookupTable[enc4];
  }
  return output;
}
function hashString(str, returnFormat) {
  const buffer = new TextEncoder().encode(str);
  switch (returnFormat) {
    case HashFormat.Base64:
      return asBase64(buffer);
    case HashFormat.Hex:
      return asHex(buffer);
    default:
      throw new ShopifyError(`Unrecognized hash format '${returnFormat}'`);
  }
}

// node_modules/@shopify/shopify-api/dist/esm/runtime/http/utils.mjs
function splitN(str, sep, maxNumParts) {
  const parts = str.split(sep);
  const maxParts = Math.min(Math.abs(maxNumParts), parts.length);
  return [...parts.slice(0, maxParts - 1), parts.slice(maxParts - 1).join(sep)];
}

// node_modules/@shopify/shopify-api/dist/esm/runtime/http/cookies.mjs
var Cookies = class _Cookies {
  constructor(request, response, { keys = [] } = {}) {
    __publicField(this, "response");
    __publicField(this, "receivedCookieJar", {});
    __publicField(this, "outgoingCookieJar", {});
    __publicField(this, "keys", []);
    this.response = response;
    if (keys)
      this.keys = keys;
    const cookieReqHdr = getHeader(request.headers, "Cookie") ?? "";
    this.receivedCookieJar = _Cookies.parseCookies(cookieReqHdr.split(";"));
    const cookieResHdr = getHeaders(response.headers, "Set-Cookie") ?? [];
    this.outgoingCookieJar = _Cookies.parseCookies(cookieResHdr);
  }
  static parseCookies(hdrs) {
    const entries = hdrs.filter((hdr) => hdr.trim().length > 0).map((cookieDef) => {
      const [keyval, ...opts] = cookieDef.split(";");
      const [name, value] = splitN(keyval, "=", 2).map((value2) => value2.trim());
      return [
        name,
        {
          name,
          value,
          ...Object.fromEntries(opts.map((opt) => splitN(opt, "=", 2).map((value2) => value2.trim())))
        }
      ];
    });
    const jar = Object.fromEntries(entries);
    for (const cookie of Object.values(jar)) {
      if (typeof cookie.expires === "string") {
        cookie.expires = new Date(cookie.expires);
      }
    }
    return jar;
  }
  static encodeCookie(data) {
    let result = "";
    result += `${data.name}=${data.value};`;
    result += Object.entries(data).filter(([key]) => !["name", "value", "expires"].includes(key)).map(([key, value]) => `${key}=${value}`).join("; ");
    if (data.expires) {
      result += ";";
      result += `expires=${data.expires.toUTCString()}`;
    }
    return result;
  }
  toHeaders() {
    return Object.values(this.outgoingCookieJar).map((cookie) => _Cookies.encodeCookie(cookie));
  }
  updateHeader() {
    if (!this.response.headers) {
      this.response.headers = {};
    }
    removeHeader(this.response.headers, "Set-Cookie");
    this.toHeaders().map((hdr) => addHeader(this.response.headers, "Set-Cookie", hdr));
  }
  get(name) {
    var _a;
    return (_a = this.receivedCookieJar[name]) == null ? void 0 : _a.value;
  }
  deleteCookie(name) {
    this.set(name, "", {
      path: "/",
      expires: /* @__PURE__ */ new Date(0)
    });
  }
  async getAndVerify(name) {
    const value = this.get(name);
    if (!value)
      return void 0;
    if (!await this.isSignedCookieValid(name)) {
      return void 0;
    }
    return value;
  }
  get canSign() {
    var _a;
    return ((_a = this.keys) == null ? void 0 : _a.length) > 0;
  }
  set(name, value, opts = {}) {
    this.outgoingCookieJar[name] = {
      ...opts,
      name,
      value
    };
    this.updateHeader();
  }
  async setAndSign(name, value, opts = {}) {
    if (!this.canSign) {
      throw Error("No keys provided for signing.");
    }
    this.set(name, value, opts);
    const sigName = `${name}.sig`;
    const signature = await createSHA256HMAC(this.keys[0], value);
    this.set(sigName, signature, opts);
    this.updateHeader();
  }
  async isSignedCookieValid(cookieName) {
    const signedCookieName = `${cookieName}.sig`;
    if (!this.cookieExists(cookieName) || !this.cookieExists(signedCookieName)) {
      this.deleteInvalidCookies(cookieName, signedCookieName);
      return false;
    }
    const cookieValue = this.get(cookieName);
    const signature = this.get(signedCookieName);
    if (!cookieValue || !signature) {
      this.deleteInvalidCookies(cookieName, signedCookieName);
      return false;
    }
    const allCheckSignatures = await Promise.all(this.keys.map((key) => createSHA256HMAC(key, cookieValue)));
    if (!allCheckSignatures.includes(signature)) {
      this.deleteInvalidCookies(cookieName, signedCookieName);
      return false;
    }
    return true;
  }
  cookieExists(cookieName) {
    return Boolean(this.get(cookieName));
  }
  deleteInvalidCookies(...cookieNames) {
    cookieNames.forEach((cookieName) => this.deleteCookie(cookieName));
  }
};

export {
  cryptoVar,
  setCrypto,
  HashFormat,
  isOK,
  abstractFetch,
  setAbstractFetchFunc,
  abstractConvertRequest,
  setAbstractConvertRequestFunc,
  abstractConvertIncomingResponse,
  abstractConvertResponse,
  setAbstractConvertResponseFunc,
  abstractConvertHeaders,
  setAbstractConvertHeadersFunc,
  abstractRuntimeString,
  setAbstractRuntimeString,
  getHeader,
  addHeader,
  canonicalizeHeaders,
  flatHeaders,
  ShopifyError,
  InvalidHmacError,
  InvalidShopError,
  InvalidHostError,
  InvalidJwtError,
  MissingJwtTokenError,
  InvalidDeliveryMethodError,
  SafeCompareError,
  PrivateAppError,
  HttpRequestError,
  HttpMaxRetriesError,
  HttpResponseError,
  HttpInternalError,
  HttpThrottlingError,
  GraphqlQueryError,
  InvalidOAuthError,
  BotActivityDetected,
  CookieNotFound,
  InvalidSession,
  InvalidWebhookError,
  MissingWebhookCallbackError,
  MissingRequiredArgument,
  InvalidRequestError,
  BillingError,
  FeatureDeprecatedError,
  createSHA256HMAC,
  hashString,
  Cookies,
  isbot
};
//# sourceMappingURL=chunk-KCKNU53H.js.map
