
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model Session
 * 
 */
export type Session = $Result.DefaultSelection<Prisma.$SessionPayload>
/**
 * Model amz_feeds
 * 
 */
export type amz_feeds = $Result.DefaultSelection<Prisma.$amz_feedsPayload>
/**
 * Model amz_keys
 * 
 */
export type amz_keys = $Result.DefaultSelection<Prisma.$amz_keysPayload>
/**
 * Model amz_keys_backup
 * 
 */
export type amz_keys_backup = $Result.DefaultSelection<Prisma.$amz_keys_backupPayload>
/**
 * Model amz_orders
 * 
 */
export type amz_orders = $Result.DefaultSelection<Prisma.$amz_ordersPayload>
/**
 * Model amz_reportrequests
 * 
 */
export type amz_reportrequests = $Result.DefaultSelection<Prisma.$amz_reportrequestsPayload>
/**
 * Model amz_searchterms
 * 
 */
export type amz_searchterms = $Result.DefaultSelection<Prisma.$amz_searchtermsPayload>
/**
 * Model amz_variants
 * This table is a partition table and requires additional setup for migrations. Visit https://pris.ly/d/partition-tables for more info.
 */
export type amz_variants = $Result.DefaultSelection<Prisma.$amz_variantsPayload>
/**
 * Model amz_variants_master
 * This table is a partition table and requires additional setup for migrations. Visit https://pris.ly/d/partition-tables for more info.
 */
export type amz_variants_master = $Result.DefaultSelection<Prisma.$amz_variants_masterPayload>
/**
 * Model aproducts
 * This table is a partition table and requires additional setup for migrations. Visit https://pris.ly/d/partition-tables for more info.
 */
export type aproducts = $Result.DefaultSelection<Prisma.$aproductsPayload>
/**
 * Model aproducts_ext
 * 
 */
export type aproducts_ext = $Result.DefaultSelection<Prisma.$aproducts_extPayload>
/**
 * Model buybox
 * 
 */
export type buybox = $Result.DefaultSelection<Prisma.$buyboxPayload>
/**
 * Model chargerequest
 * 
 */
export type chargerequest = $Result.DefaultSelection<Prisma.$chargerequestPayload>
/**
 * Model crons
 * 
 */
export type crons = $Result.DefaultSelection<Prisma.$cronsPayload>
/**
 * Model dup_product_variants
 * 
 */
export type dup_product_variants = $Result.DefaultSelection<Prisma.$dup_product_variantsPayload>
/**
 * Model dup_products
 * 
 */
export type dup_products = $Result.DefaultSelection<Prisma.$dup_productsPayload>
/**
 * Model eb_categories
 * 
 */
export type eb_categories = $Result.DefaultSelection<Prisma.$eb_categoriesPayload>
/**
 * Model eb_categories_mapping
 * 
 */
export type eb_categories_mapping = $Result.DefaultSelection<Prisma.$eb_categories_mappingPayload>
/**
 * Model eb_keys
 * 
 */
export type eb_keys = $Result.DefaultSelection<Prisma.$eb_keysPayload>
/**
 * Model eb_orders
 * 
 */
export type eb_orders = $Result.DefaultSelection<Prisma.$eb_ordersPayload>
/**
 * Model ebproducts
 * 
 */
export type ebproducts = $Result.DefaultSelection<Prisma.$ebproductsPayload>
/**
 * Model ebpromotions
 * 
 */
export type ebpromotions = $Result.DefaultSelection<Prisma.$ebpromotionsPayload>
/**
 * Model etsy_key
 * 
 */
export type etsy_key = $Result.DefaultSelection<Prisma.$etsy_keyPayload>
/**
 * Model etsy_listing_product
 * 
 */
export type etsy_listing_product = $Result.DefaultSelection<Prisma.$etsy_listing_productPayload>
/**
 * Model fetchreviews
 * 
 */
export type fetchreviews = $Result.DefaultSelection<Prisma.$fetchreviewsPayload>
/**
 * Model fordeletion1828
 * 
 */
export type fordeletion1828 = $Result.DefaultSelection<Prisma.$fordeletion1828Payload>
/**
 * Model img_reimport_requests
 * 
 */
export type img_reimport_requests = $Result.DefaultSelection<Prisma.$img_reimport_requestsPayload>
/**
 * Model inventoryerrors
 * 
 */
export type inventoryerrors = $Result.DefaultSelection<Prisma.$inventoryerrorsPayload>
/**
 * Model locations
 * 
 */
export type locations = $Result.DefaultSelection<Prisma.$locationsPayload>
/**
 * Model newsletter
 * 
 */
export type newsletter = $Result.DefaultSelection<Prisma.$newsletterPayload>
/**
 * Model pc_images
 * 
 */
export type pc_images = $Result.DefaultSelection<Prisma.$pc_imagesPayload>
/**
 * Model permission_role
 * 
 */
export type permission_role = $Result.DefaultSelection<Prisma.$permission_rolePayload>
/**
 * Model permissions
 * 
 */
export type permissions = $Result.DefaultSelection<Prisma.$permissionsPayload>
/**
 * Model product_variants
 * This table is a partition table and requires additional setup for migrations. Visit https://pris.ly/d/partition-tables for more info.
 */
export type product_variants = $Result.DefaultSelection<Prisma.$product_variantsPayload>
/**
 * Model product_variants1
 * 
 */
export type product_variants1 = $Result.DefaultSelection<Prisma.$product_variants1Payload>
/**
 * Model products
 * This table is a partition table and requires additional setup for migrations. Visit https://pris.ly/d/partition-tables for more info.
 */
export type products = $Result.DefaultSelection<Prisma.$productsPayload>
/**
 * Model products1
 * 
 */
export type products1 = $Result.DefaultSelection<Prisma.$products1Payload>
/**
 * Model proxycrawl
 * 
 */
export type proxycrawl = $Result.DefaultSelection<Prisma.$proxycrawlPayload>
/**
 * Model rawlogs
 * 
 */
export type rawlogs = $Result.DefaultSelection<Prisma.$rawlogsPayload>
/**
 * Model reviews
 * 
 */
export type reviews = $Result.DefaultSelection<Prisma.$reviewsPayload>
/**
 * Model role_user
 * 
 */
export type role_user = $Result.DefaultSelection<Prisma.$role_userPayload>
/**
 * Model roles
 * 
 */
export type roles = $Result.DefaultSelection<Prisma.$rolesPayload>
/**
 * Model route_permission
 * 
 */
export type route_permission = $Result.DefaultSelection<Prisma.$route_permissionPayload>
/**
 * Model settings
 * 
 */
export type settings = $Result.DefaultSelection<Prisma.$settingsPayload>
/**
 * Model shopifyorders
 * 
 */
export type shopifyorders = $Result.DefaultSelection<Prisma.$shopifyordersPayload>
/**
 * Model shopifyproducts
 * This table is a partition table and requires additional setup for migrations. Visit https://pris.ly/d/partition-tables for more info.
 */
export type shopifyproducts = $Result.DefaultSelection<Prisma.$shopifyproductsPayload>
/**
 * Model sync_queue
 * 
 */
export type sync_queue = $Result.DefaultSelection<Prisma.$sync_queuePayload>
/**
 * Model tasks
 * 
 */
export type tasks = $Result.DefaultSelection<Prisma.$tasksPayload>
/**
 * Model temp_12576
 * 
 */
export type temp_12576 = $Result.DefaultSelection<Prisma.$temp_12576Payload>
/**
 * Model temp_1828
 * 
 */
export type temp_1828 = $Result.DefaultSelection<Prisma.$temp_1828Payload>
/**
 * Model temp_2958
 * 
 */
export type temp_2958 = $Result.DefaultSelection<Prisma.$temp_2958Payload>
/**
 * Model temp_3488
 * 
 */
export type temp_3488 = $Result.DefaultSelection<Prisma.$temp_3488Payload>
/**
 * Model temp_collections
 * 
 */
export type temp_collections = $Result.DefaultSelection<Prisma.$temp_collectionsPayload>
/**
 * Model temp_tweets
 * 
 */
export type temp_tweets = $Result.DefaultSelection<Prisma.$temp_tweetsPayload>
/**
 * Model test2555
 * 
 */
export type test2555 = $Result.DefaultSelection<Prisma.$test2555Payload>
/**
 * Model test_1696
 * 
 */
export type test_1696 = $Result.DefaultSelection<Prisma.$test_1696Payload>
/**
 * Model upccodes
 * 
 */
export type upccodes = $Result.DefaultSelection<Prisma.$upccodesPayload>
/**
 * Model users
 * 
 */
export type users = $Result.DefaultSelection<Prisma.$usersPayload>
/**
 * Model wm_categories
 * 
 */
export type wm_categories = $Result.DefaultSelection<Prisma.$wm_categoriesPayload>
/**
 * Model wm_category_attribute_name_mapping
 * 
 */
export type wm_category_attribute_name_mapping = $Result.DefaultSelection<Prisma.$wm_category_attribute_name_mappingPayload>
/**
 * Model wm_feeds
 * 
 */
export type wm_feeds = $Result.DefaultSelection<Prisma.$wm_feedsPayload>
/**
 * Model wm_keys
 * 
 */
export type wm_keys = $Result.DefaultSelection<Prisma.$wm_keysPayload>
/**
 * Model wm_orders
 * 
 */
export type wm_orders = $Result.DefaultSelection<Prisma.$wm_ordersPayload>
/**
 * Model wmproducts
 * 
 */
export type wmproducts = $Result.DefaultSelection<Prisma.$wmproductsPayload>
/**
 * Model xpertusernew123
 * 
 */
export type xpertusernew123 = $Result.DefaultSelection<Prisma.$xpertusernew123Payload>

/**
 * Enums
 */
export namespace $Enums {
  export const dup_products_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported',
  error: 'error',
  Ingession_in_progress: 'Ingession_in_progress'
};

export type dup_products_status = (typeof dup_products_status)[keyof typeof dup_products_status]


export const ebpromotions_discount_type: {
  Price: 'Price',
  Percentage: 'Percentage'
};

export type ebpromotions_discount_type = (typeof ebpromotions_discount_type)[keyof typeof ebpromotions_discount_type]


export const fordeletion1828_status: {
  pending: 'pending',
  shopifyprocessed: 'shopifyprocessed',
  ebayprocessed: 'ebayprocessed',
  amzdupprocessed: 'amzdupprocessed',
  completed: 'completed'
};

export type fordeletion1828_status = (typeof fordeletion1828_status)[keyof typeof fordeletion1828_status]


export const sync_queue_status: {
  pending: 'pending',
  inprogress: 'inprogress',
  completed: 'completed'
};

export type sync_queue_status = (typeof sync_queue_status)[keyof typeof sync_queue_status]


export const dup_products_sub_status: {
  readyforproduct: 'readyforproduct',
  productsubmitted: 'productsubmitted',
  readyforimage: 'readyforimage',
  imagesubmitted: 'imagesubmitted',
  readyforinventory: 'readyforinventory',
  inventorysubmitted: 'inventorysubmitted',
  readyforprice: 'readyforprice',
  pricesubmitted: 'pricesubmitted',
  readyforrelationship: 'readyforrelationship',
  relationshipsubmitted: 'relationshipsubmitted',
  completed: 'completed',
  error: 'error'
};

export type dup_products_sub_status = (typeof dup_products_sub_status)[keyof typeof dup_products_sub_status]


export const locations_status: {
  active: 'active',
  inactive: 'inactive'
};

export type locations_status = (typeof locations_status)[keyof typeof locations_status]


export const amz_reportrequests_status: {
  pending: 'pending',
  requested: 'requested',
  processed: 'processed',
  downloaded: 'downloaded',
  imported: 'imported',
  readyforfb: 'readyforfb',
  readyforur: 'readyforur',
  readyforpcr: 'readyforpcr',
  readyforshopify: 'readyforshopify',
  shopifyimported: 'shopifyimported',
  readyforfbdate: 'readyforfbdate',
  readyforcatalog: 'readyforcatalog',
  readyforsalepricefetch: 'readyforsalepricefetch'
};

export type amz_reportrequests_status = (typeof amz_reportrequests_status)[keyof typeof amz_reportrequests_status]


export const wm_feeds_feed_status: {
  active: 'active',
  archived: 'archived',
  error: 'error'
};

export type wm_feeds_feed_status = (typeof wm_feeds_feed_status)[keyof typeof wm_feeds_feed_status]


export const ebpromotions_type: {
  PriceDiscountOnly: 'PriceDiscountOnly',
  FreeShippingOnly: 'FreeShippingOnly',
  PriceDiscountAndFreeShipping: 'PriceDiscountAndFreeShipping'
};

export type ebpromotions_type = (typeof ebpromotions_type)[keyof typeof ebpromotions_type]


export const users_status: {
  active: 'active',
  inactive: 'inactive'
};

export type users_status = (typeof users_status)[keyof typeof users_status]


export const amz_feeds_status: {
  readyforproduct: 'readyforproduct',
  productsubmitted: 'productsubmitted',
  readyforimage: 'readyforimage',
  imagesubmitted: 'imagesubmitted',
  readyforinventory: 'readyforinventory',
  inventorysubmitted: 'inventorysubmitted',
  readyforprice: 'readyforprice',
  pricesubmitted: 'pricesubmitted',
  readyforrelationship: 'readyforrelationship',
  relationshipsubmitted: 'relationshipsubmitted',
  completed: 'completed',
  error: 'error',
  readyforasinupdate: 'readyforasinupdate'
};

export type amz_feeds_status = (typeof amz_feeds_status)[keyof typeof amz_feeds_status]


export const dup_product_variants_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported',
  error: 'error'
};

export type dup_product_variants_status = (typeof dup_product_variants_status)[keyof typeof dup_product_variants_status]


export const settings_shopifyorders_action: {
  end: 'end',
  outofstock: 'outofstock'
};

export type settings_shopifyorders_action = (typeof settings_shopifyorders_action)[keyof typeof settings_shopifyorders_action]


export const users_membershiptype: {
  free: 'free',
  paid: 'paid'
};

export type users_membershiptype = (typeof users_membershiptype)[keyof typeof users_membershiptype]


export const product_variants1_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported'
};

export type product_variants1_status = (typeof product_variants1_status)[keyof typeof product_variants1_status]


export const products1_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported'
};

export type products1_status = (typeof products1_status)[keyof typeof products1_status]


export const product_variants_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported'
};

export type product_variants_status = (typeof product_variants_status)[keyof typeof product_variants_status]


export const products_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported'
};

export type products_status = (typeof products_status)[keyof typeof products_status]


export const products_eb_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported',
  dataerr: 'dataerr'
};

export type products_eb_status = (typeof products_eb_status)[keyof typeof products_eb_status]


export const product_variants_eb_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported',
  dataerr: 'dataerr',
  ended: 'ended'
};

export type product_variants_eb_status = (typeof product_variants_eb_status)[keyof typeof product_variants_eb_status]


export const products_wm_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Ingestion_in_progress: 'Ingestion_in_progress',
  Publish_in_progress: 'Publish_in_progress',
  Published: 'Published',
  Unpublished: 'Unpublished',
  dataerr: 'dataerr',
  syserr: 'syserr'
};

export type products_wm_status = (typeof products_wm_status)[keyof typeof products_wm_status]


export const product_variants_wm_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Ingestion_in_progress: 'Ingestion_in_progress',
  Publish_in_progress: 'Publish_in_progress',
  Published: 'Published',
  Unpublished: 'Unpublished',
  dataerr: 'dataerr',
  syserr: 'syserr'
};

export type product_variants_wm_status = (typeof product_variants_wm_status)[keyof typeof product_variants_wm_status]


export const products_dup_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported',
  error: 'error',
  Ingession_in_progress: 'Ingession_in_progress'
};

export type products_dup_status = (typeof products_dup_status)[keyof typeof products_dup_status]


export const products_dup_sub_status: {
  readyforproduct: 'readyforproduct',
  productsubmitted: 'productsubmitted',
  readyforimage: 'readyforimage',
  imagesubmitted: 'imagesubmitted',
  readyforinventory: 'readyforinventory',
  inventorysubmitted: 'inventorysubmitted',
  readyforprice: 'readyforprice',
  pricesubmitted: 'pricesubmitted',
  readyforrelationship: 'readyforrelationship',
  relationshipsubmitted: 'relationshipsubmitted',
  completed: 'completed',
  error: 'error'
};

export type products_dup_sub_status = (typeof products_dup_sub_status)[keyof typeof products_dup_sub_status]


export const products_fulfillment: {
  Merchant: 'Merchant',
  Amazon: 'Amazon'
};

export type products_fulfillment = (typeof products_fulfillment)[keyof typeof products_fulfillment]


export const product_variants_fulfillment: {
  Merchant: 'Merchant',
  Amazon: 'Amazon'
};

export type product_variants_fulfillment = (typeof product_variants_fulfillment)[keyof typeof product_variants_fulfillment]


export const aproducts_status: {
  Already_Exist: 'Already_Exist',
  Ready_to_Import: 'Ready_to_Import',
  Import_in_progress: 'Import_in_progress',
  Imported: 'Imported'
};

export type aproducts_status = (typeof aproducts_status)[keyof typeof aproducts_status]


export const reviews_status: {
  published: 'published',
  unpublished: 'unpublished',
  EMPTY_ENUM_VALUE: 'EMPTY_ENUM_VALUE'
};

export type reviews_status = (typeof reviews_status)[keyof typeof reviews_status]


export const users_setup_step: {
  first: 'first',
  second: 'second',
  Done: 'Done'
};

export type users_setup_step = (typeof users_setup_step)[keyof typeof users_setup_step]

}

export type dup_products_status = $Enums.dup_products_status

export const dup_products_status: typeof $Enums.dup_products_status

export type ebpromotions_discount_type = $Enums.ebpromotions_discount_type

export const ebpromotions_discount_type: typeof $Enums.ebpromotions_discount_type

export type fordeletion1828_status = $Enums.fordeletion1828_status

export const fordeletion1828_status: typeof $Enums.fordeletion1828_status

export type sync_queue_status = $Enums.sync_queue_status

export const sync_queue_status: typeof $Enums.sync_queue_status

export type dup_products_sub_status = $Enums.dup_products_sub_status

export const dup_products_sub_status: typeof $Enums.dup_products_sub_status

export type locations_status = $Enums.locations_status

export const locations_status: typeof $Enums.locations_status

export type amz_reportrequests_status = $Enums.amz_reportrequests_status

export const amz_reportrequests_status: typeof $Enums.amz_reportrequests_status

export type wm_feeds_feed_status = $Enums.wm_feeds_feed_status

export const wm_feeds_feed_status: typeof $Enums.wm_feeds_feed_status

export type ebpromotions_type = $Enums.ebpromotions_type

export const ebpromotions_type: typeof $Enums.ebpromotions_type

export type users_status = $Enums.users_status

export const users_status: typeof $Enums.users_status

export type amz_feeds_status = $Enums.amz_feeds_status

export const amz_feeds_status: typeof $Enums.amz_feeds_status

export type dup_product_variants_status = $Enums.dup_product_variants_status

export const dup_product_variants_status: typeof $Enums.dup_product_variants_status

export type settings_shopifyorders_action = $Enums.settings_shopifyorders_action

export const settings_shopifyorders_action: typeof $Enums.settings_shopifyorders_action

export type users_membershiptype = $Enums.users_membershiptype

export const users_membershiptype: typeof $Enums.users_membershiptype

export type product_variants1_status = $Enums.product_variants1_status

export const product_variants1_status: typeof $Enums.product_variants1_status

export type products1_status = $Enums.products1_status

export const products1_status: typeof $Enums.products1_status

export type product_variants_status = $Enums.product_variants_status

export const product_variants_status: typeof $Enums.product_variants_status

export type products_status = $Enums.products_status

export const products_status: typeof $Enums.products_status

export type products_eb_status = $Enums.products_eb_status

export const products_eb_status: typeof $Enums.products_eb_status

export type product_variants_eb_status = $Enums.product_variants_eb_status

export const product_variants_eb_status: typeof $Enums.product_variants_eb_status

export type products_wm_status = $Enums.products_wm_status

export const products_wm_status: typeof $Enums.products_wm_status

export type product_variants_wm_status = $Enums.product_variants_wm_status

export const product_variants_wm_status: typeof $Enums.product_variants_wm_status

export type products_dup_status = $Enums.products_dup_status

export const products_dup_status: typeof $Enums.products_dup_status

export type products_dup_sub_status = $Enums.products_dup_sub_status

export const products_dup_sub_status: typeof $Enums.products_dup_sub_status

export type products_fulfillment = $Enums.products_fulfillment

export const products_fulfillment: typeof $Enums.products_fulfillment

export type product_variants_fulfillment = $Enums.product_variants_fulfillment

export const product_variants_fulfillment: typeof $Enums.product_variants_fulfillment

export type aproducts_status = $Enums.aproducts_status

export const aproducts_status: typeof $Enums.aproducts_status

export type reviews_status = $Enums.reviews_status

export const reviews_status: typeof $Enums.reviews_status

export type users_setup_step = $Enums.users_setup_step

export const users_setup_step: typeof $Enums.users_setup_step

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Sessions
 * const sessions = await prisma.session.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  const U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Sessions
   * const sessions = await prisma.session.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): PrismaClient;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb<ClientOptions>, ExtArgs, $Utils.Call<Prisma.TypeMapCb<ClientOptions>, {
    extArgs: ExtArgs
  }>>

      /**
   * `prisma.session`: Exposes CRUD operations for the **Session** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Sessions
    * const sessions = await prisma.session.findMany()
    * ```
    */
  get session(): Prisma.SessionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_feeds`: Exposes CRUD operations for the **amz_feeds** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_feeds
    * const amz_feeds = await prisma.amz_feeds.findMany()
    * ```
    */
  get amz_feeds(): Prisma.amz_feedsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_keys`: Exposes CRUD operations for the **amz_keys** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_keys
    * const amz_keys = await prisma.amz_keys.findMany()
    * ```
    */
  get amz_keys(): Prisma.amz_keysDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_keys_backup`: Exposes CRUD operations for the **amz_keys_backup** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_keys_backups
    * const amz_keys_backups = await prisma.amz_keys_backup.findMany()
    * ```
    */
  get amz_keys_backup(): Prisma.amz_keys_backupDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_orders`: Exposes CRUD operations for the **amz_orders** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_orders
    * const amz_orders = await prisma.amz_orders.findMany()
    * ```
    */
  get amz_orders(): Prisma.amz_ordersDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_reportrequests`: Exposes CRUD operations for the **amz_reportrequests** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_reportrequests
    * const amz_reportrequests = await prisma.amz_reportrequests.findMany()
    * ```
    */
  get amz_reportrequests(): Prisma.amz_reportrequestsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_searchterms`: Exposes CRUD operations for the **amz_searchterms** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_searchterms
    * const amz_searchterms = await prisma.amz_searchterms.findMany()
    * ```
    */
  get amz_searchterms(): Prisma.amz_searchtermsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_variants`: Exposes CRUD operations for the **amz_variants** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_variants
    * const amz_variants = await prisma.amz_variants.findMany()
    * ```
    */
  get amz_variants(): Prisma.amz_variantsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.amz_variants_master`: Exposes CRUD operations for the **amz_variants_master** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Amz_variants_masters
    * const amz_variants_masters = await prisma.amz_variants_master.findMany()
    * ```
    */
  get amz_variants_master(): Prisma.amz_variants_masterDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.aproducts`: Exposes CRUD operations for the **aproducts** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Aproducts
    * const aproducts = await prisma.aproducts.findMany()
    * ```
    */
  get aproducts(): Prisma.aproductsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.aproducts_ext`: Exposes CRUD operations for the **aproducts_ext** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Aproducts_exts
    * const aproducts_exts = await prisma.aproducts_ext.findMany()
    * ```
    */
  get aproducts_ext(): Prisma.aproducts_extDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.buybox`: Exposes CRUD operations for the **buybox** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Buyboxes
    * const buyboxes = await prisma.buybox.findMany()
    * ```
    */
  get buybox(): Prisma.buyboxDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.chargerequest`: Exposes CRUD operations for the **chargerequest** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Chargerequests
    * const chargerequests = await prisma.chargerequest.findMany()
    * ```
    */
  get chargerequest(): Prisma.chargerequestDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.crons`: Exposes CRUD operations for the **crons** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Crons
    * const crons = await prisma.crons.findMany()
    * ```
    */
  get crons(): Prisma.cronsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.dup_product_variants`: Exposes CRUD operations for the **dup_product_variants** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Dup_product_variants
    * const dup_product_variants = await prisma.dup_product_variants.findMany()
    * ```
    */
  get dup_product_variants(): Prisma.dup_product_variantsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.dup_products`: Exposes CRUD operations for the **dup_products** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Dup_products
    * const dup_products = await prisma.dup_products.findMany()
    * ```
    */
  get dup_products(): Prisma.dup_productsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.eb_categories`: Exposes CRUD operations for the **eb_categories** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Eb_categories
    * const eb_categories = await prisma.eb_categories.findMany()
    * ```
    */
  get eb_categories(): Prisma.eb_categoriesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.eb_categories_mapping`: Exposes CRUD operations for the **eb_categories_mapping** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Eb_categories_mappings
    * const eb_categories_mappings = await prisma.eb_categories_mapping.findMany()
    * ```
    */
  get eb_categories_mapping(): Prisma.eb_categories_mappingDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.eb_keys`: Exposes CRUD operations for the **eb_keys** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Eb_keys
    * const eb_keys = await prisma.eb_keys.findMany()
    * ```
    */
  get eb_keys(): Prisma.eb_keysDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.eb_orders`: Exposes CRUD operations for the **eb_orders** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Eb_orders
    * const eb_orders = await prisma.eb_orders.findMany()
    * ```
    */
  get eb_orders(): Prisma.eb_ordersDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.ebproducts`: Exposes CRUD operations for the **ebproducts** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Ebproducts
    * const ebproducts = await prisma.ebproducts.findMany()
    * ```
    */
  get ebproducts(): Prisma.ebproductsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.ebpromotions`: Exposes CRUD operations for the **ebpromotions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Ebpromotions
    * const ebpromotions = await prisma.ebpromotions.findMany()
    * ```
    */
  get ebpromotions(): Prisma.ebpromotionsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.etsy_key`: Exposes CRUD operations for the **etsy_key** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Etsy_keys
    * const etsy_keys = await prisma.etsy_key.findMany()
    * ```
    */
  get etsy_key(): Prisma.etsy_keyDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.etsy_listing_product`: Exposes CRUD operations for the **etsy_listing_product** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Etsy_listing_products
    * const etsy_listing_products = await prisma.etsy_listing_product.findMany()
    * ```
    */
  get etsy_listing_product(): Prisma.etsy_listing_productDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.fetchreviews`: Exposes CRUD operations for the **fetchreviews** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Fetchreviews
    * const fetchreviews = await prisma.fetchreviews.findMany()
    * ```
    */
  get fetchreviews(): Prisma.fetchreviewsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.fordeletion1828`: Exposes CRUD operations for the **fordeletion1828** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Fordeletion1828s
    * const fordeletion1828s = await prisma.fordeletion1828.findMany()
    * ```
    */
  get fordeletion1828(): Prisma.fordeletion1828Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.img_reimport_requests`: Exposes CRUD operations for the **img_reimport_requests** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Img_reimport_requests
    * const img_reimport_requests = await prisma.img_reimport_requests.findMany()
    * ```
    */
  get img_reimport_requests(): Prisma.img_reimport_requestsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.inventoryerrors`: Exposes CRUD operations for the **inventoryerrors** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Inventoryerrors
    * const inventoryerrors = await prisma.inventoryerrors.findMany()
    * ```
    */
  get inventoryerrors(): Prisma.inventoryerrorsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.locations`: Exposes CRUD operations for the **locations** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Locations
    * const locations = await prisma.locations.findMany()
    * ```
    */
  get locations(): Prisma.locationsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.newsletter`: Exposes CRUD operations for the **newsletter** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Newsletters
    * const newsletters = await prisma.newsletter.findMany()
    * ```
    */
  get newsletter(): Prisma.newsletterDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.pc_images`: Exposes CRUD operations for the **pc_images** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Pc_images
    * const pc_images = await prisma.pc_images.findMany()
    * ```
    */
  get pc_images(): Prisma.pc_imagesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.permission_role`: Exposes CRUD operations for the **permission_role** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Permission_roles
    * const permission_roles = await prisma.permission_role.findMany()
    * ```
    */
  get permission_role(): Prisma.permission_roleDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.permissions`: Exposes CRUD operations for the **permissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Permissions
    * const permissions = await prisma.permissions.findMany()
    * ```
    */
  get permissions(): Prisma.permissionsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.product_variants`: Exposes CRUD operations for the **product_variants** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Product_variants
    * const product_variants = await prisma.product_variants.findMany()
    * ```
    */
  get product_variants(): Prisma.product_variantsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.product_variants1`: Exposes CRUD operations for the **product_variants1** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Product_variants1s
    * const product_variants1s = await prisma.product_variants1.findMany()
    * ```
    */
  get product_variants1(): Prisma.product_variants1Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.products`: Exposes CRUD operations for the **products** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Products
    * const products = await prisma.products.findMany()
    * ```
    */
  get products(): Prisma.productsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.products1`: Exposes CRUD operations for the **products1** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Products1s
    * const products1s = await prisma.products1.findMany()
    * ```
    */
  get products1(): Prisma.products1Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.proxycrawl`: Exposes CRUD operations for the **proxycrawl** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Proxycrawls
    * const proxycrawls = await prisma.proxycrawl.findMany()
    * ```
    */
  get proxycrawl(): Prisma.proxycrawlDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.rawlogs`: Exposes CRUD operations for the **rawlogs** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Rawlogs
    * const rawlogs = await prisma.rawlogs.findMany()
    * ```
    */
  get rawlogs(): Prisma.rawlogsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.reviews`: Exposes CRUD operations for the **reviews** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Reviews
    * const reviews = await prisma.reviews.findMany()
    * ```
    */
  get reviews(): Prisma.reviewsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.role_user`: Exposes CRUD operations for the **role_user** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Role_users
    * const role_users = await prisma.role_user.findMany()
    * ```
    */
  get role_user(): Prisma.role_userDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.roles`: Exposes CRUD operations for the **roles** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Roles
    * const roles = await prisma.roles.findMany()
    * ```
    */
  get roles(): Prisma.rolesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.route_permission`: Exposes CRUD operations for the **route_permission** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Route_permissions
    * const route_permissions = await prisma.route_permission.findMany()
    * ```
    */
  get route_permission(): Prisma.route_permissionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.settings`: Exposes CRUD operations for the **settings** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Settings
    * const settings = await prisma.settings.findMany()
    * ```
    */
  get settings(): Prisma.settingsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.shopifyorders`: Exposes CRUD operations for the **shopifyorders** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Shopifyorders
    * const shopifyorders = await prisma.shopifyorders.findMany()
    * ```
    */
  get shopifyorders(): Prisma.shopifyordersDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.shopifyproducts`: Exposes CRUD operations for the **shopifyproducts** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Shopifyproducts
    * const shopifyproducts = await prisma.shopifyproducts.findMany()
    * ```
    */
  get shopifyproducts(): Prisma.shopifyproductsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.sync_queue`: Exposes CRUD operations for the **sync_queue** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Sync_queues
    * const sync_queues = await prisma.sync_queue.findMany()
    * ```
    */
  get sync_queue(): Prisma.sync_queueDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.tasks`: Exposes CRUD operations for the **tasks** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Tasks
    * const tasks = await prisma.tasks.findMany()
    * ```
    */
  get tasks(): Prisma.tasksDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.temp_12576`: Exposes CRUD operations for the **temp_12576** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Temp_12576s
    * const temp_12576s = await prisma.temp_12576.findMany()
    * ```
    */
  get temp_12576(): Prisma.temp_12576Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.temp_1828`: Exposes CRUD operations for the **temp_1828** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Temp_1828s
    * const temp_1828s = await prisma.temp_1828.findMany()
    * ```
    */
  get temp_1828(): Prisma.temp_1828Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.temp_2958`: Exposes CRUD operations for the **temp_2958** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Temp_2958s
    * const temp_2958s = await prisma.temp_2958.findMany()
    * ```
    */
  get temp_2958(): Prisma.temp_2958Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.temp_3488`: Exposes CRUD operations for the **temp_3488** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Temp_3488s
    * const temp_3488s = await prisma.temp_3488.findMany()
    * ```
    */
  get temp_3488(): Prisma.temp_3488Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.temp_collections`: Exposes CRUD operations for the **temp_collections** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Temp_collections
    * const temp_collections = await prisma.temp_collections.findMany()
    * ```
    */
  get temp_collections(): Prisma.temp_collectionsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.temp_tweets`: Exposes CRUD operations for the **temp_tweets** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Temp_tweets
    * const temp_tweets = await prisma.temp_tweets.findMany()
    * ```
    */
  get temp_tweets(): Prisma.temp_tweetsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.test2555`: Exposes CRUD operations for the **test2555** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Test2555s
    * const test2555s = await prisma.test2555.findMany()
    * ```
    */
  get test2555(): Prisma.test2555Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.test_1696`: Exposes CRUD operations for the **test_1696** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Test_1696s
    * const test_1696s = await prisma.test_1696.findMany()
    * ```
    */
  get test_1696(): Prisma.test_1696Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.upccodes`: Exposes CRUD operations for the **upccodes** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Upccodes
    * const upccodes = await prisma.upccodes.findMany()
    * ```
    */
  get upccodes(): Prisma.upccodesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.users`: Exposes CRUD operations for the **users** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.users.findMany()
    * ```
    */
  get users(): Prisma.usersDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.wm_categories`: Exposes CRUD operations for the **wm_categories** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Wm_categories
    * const wm_categories = await prisma.wm_categories.findMany()
    * ```
    */
  get wm_categories(): Prisma.wm_categoriesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.wm_category_attribute_name_mapping`: Exposes CRUD operations for the **wm_category_attribute_name_mapping** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Wm_category_attribute_name_mappings
    * const wm_category_attribute_name_mappings = await prisma.wm_category_attribute_name_mapping.findMany()
    * ```
    */
  get wm_category_attribute_name_mapping(): Prisma.wm_category_attribute_name_mappingDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.wm_feeds`: Exposes CRUD operations for the **wm_feeds** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Wm_feeds
    * const wm_feeds = await prisma.wm_feeds.findMany()
    * ```
    */
  get wm_feeds(): Prisma.wm_feedsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.wm_keys`: Exposes CRUD operations for the **wm_keys** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Wm_keys
    * const wm_keys = await prisma.wm_keys.findMany()
    * ```
    */
  get wm_keys(): Prisma.wm_keysDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.wm_orders`: Exposes CRUD operations for the **wm_orders** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Wm_orders
    * const wm_orders = await prisma.wm_orders.findMany()
    * ```
    */
  get wm_orders(): Prisma.wm_ordersDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.wmproducts`: Exposes CRUD operations for the **wmproducts** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Wmproducts
    * const wmproducts = await prisma.wmproducts.findMany()
    * ```
    */
  get wmproducts(): Prisma.wmproductsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.xpertusernew123`: Exposes CRUD operations for the **xpertusernew123** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Xpertusernew123s
    * const xpertusernew123s = await prisma.xpertusernew123.findMany()
    * ```
    */
  get xpertusernew123(): Prisma.xpertusernew123Delegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.19.0
   * Query Engine version: 2ba551f319ab1df4bc874a89965d8b3641056773
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import Bytes = runtime.Bytes
  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? P : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    Session: 'Session',
    amz_feeds: 'amz_feeds',
    amz_keys: 'amz_keys',
    amz_keys_backup: 'amz_keys_backup',
    amz_orders: 'amz_orders',
    amz_reportrequests: 'amz_reportrequests',
    amz_searchterms: 'amz_searchterms',
    amz_variants: 'amz_variants',
    amz_variants_master: 'amz_variants_master',
    aproducts: 'aproducts',
    aproducts_ext: 'aproducts_ext',
    buybox: 'buybox',
    chargerequest: 'chargerequest',
    crons: 'crons',
    dup_product_variants: 'dup_product_variants',
    dup_products: 'dup_products',
    eb_categories: 'eb_categories',
    eb_categories_mapping: 'eb_categories_mapping',
    eb_keys: 'eb_keys',
    eb_orders: 'eb_orders',
    ebproducts: 'ebproducts',
    ebpromotions: 'ebpromotions',
    etsy_key: 'etsy_key',
    etsy_listing_product: 'etsy_listing_product',
    fetchreviews: 'fetchreviews',
    fordeletion1828: 'fordeletion1828',
    img_reimport_requests: 'img_reimport_requests',
    inventoryerrors: 'inventoryerrors',
    locations: 'locations',
    newsletter: 'newsletter',
    pc_images: 'pc_images',
    permission_role: 'permission_role',
    permissions: 'permissions',
    product_variants: 'product_variants',
    product_variants1: 'product_variants1',
    products: 'products',
    products1: 'products1',
    proxycrawl: 'proxycrawl',
    rawlogs: 'rawlogs',
    reviews: 'reviews',
    role_user: 'role_user',
    roles: 'roles',
    route_permission: 'route_permission',
    settings: 'settings',
    shopifyorders: 'shopifyorders',
    shopifyproducts: 'shopifyproducts',
    sync_queue: 'sync_queue',
    tasks: 'tasks',
    temp_12576: 'temp_12576',
    temp_1828: 'temp_1828',
    temp_2958: 'temp_2958',
    temp_3488: 'temp_3488',
    temp_collections: 'temp_collections',
    temp_tweets: 'temp_tweets',
    test2555: 'test2555',
    test_1696: 'test_1696',
    upccodes: 'upccodes',
    users: 'users',
    wm_categories: 'wm_categories',
    wm_category_attribute_name_mapping: 'wm_category_attribute_name_mapping',
    wm_feeds: 'wm_feeds',
    wm_keys: 'wm_keys',
    wm_orders: 'wm_orders',
    wmproducts: 'wmproducts',
    xpertusernew123: 'xpertusernew123'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb<ClientOptions = {}> extends $Utils.Fn<{extArgs: $Extensions.InternalArgs }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], ClientOptions extends { omit: infer OmitOptions } ? OmitOptions : {}>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> = {
    globalOmitOptions: {
      omit: GlobalOmitOptions
    }
    meta: {
      modelProps: "session" | "amz_feeds" | "amz_keys" | "amz_keys_backup" | "amz_orders" | "amz_reportrequests" | "amz_searchterms" | "amz_variants" | "amz_variants_master" | "aproducts" | "aproducts_ext" | "buybox" | "chargerequest" | "crons" | "dup_product_variants" | "dup_products" | "eb_categories" | "eb_categories_mapping" | "eb_keys" | "eb_orders" | "ebproducts" | "ebpromotions" | "etsy_key" | "etsy_listing_product" | "fetchreviews" | "fordeletion1828" | "img_reimport_requests" | "inventoryerrors" | "locations" | "newsletter" | "pc_images" | "permission_role" | "permissions" | "product_variants" | "product_variants1" | "products" | "products1" | "proxycrawl" | "rawlogs" | "reviews" | "role_user" | "roles" | "route_permission" | "settings" | "shopifyorders" | "shopifyproducts" | "sync_queue" | "tasks" | "temp_12576" | "temp_1828" | "temp_2958" | "temp_3488" | "temp_collections" | "temp_tweets" | "test2555" | "test_1696" | "upccodes" | "users" | "wm_categories" | "wm_category_attribute_name_mapping" | "wm_feeds" | "wm_keys" | "wm_orders" | "wmproducts" | "xpertusernew123"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      Session: {
        payload: Prisma.$SessionPayload<ExtArgs>
        fields: Prisma.SessionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.SessionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.SessionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          findFirst: {
            args: Prisma.SessionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.SessionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          findMany: {
            args: Prisma.SessionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>[]
          }
          create: {
            args: Prisma.SessionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          createMany: {
            args: Prisma.SessionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.SessionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          update: {
            args: Prisma.SessionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          deleteMany: {
            args: Prisma.SessionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.SessionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.SessionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          aggregate: {
            args: Prisma.SessionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSession>
          }
          groupBy: {
            args: Prisma.SessionGroupByArgs<ExtArgs>
            result: $Utils.Optional<SessionGroupByOutputType>[]
          }
          count: {
            args: Prisma.SessionCountArgs<ExtArgs>
            result: $Utils.Optional<SessionCountAggregateOutputType> | number
          }
        }
      }
      amz_feeds: {
        payload: Prisma.$amz_feedsPayload<ExtArgs>
        fields: Prisma.amz_feedsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_feedsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_feedsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>
          }
          findFirst: {
            args: Prisma.amz_feedsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_feedsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>
          }
          findMany: {
            args: Prisma.amz_feedsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>[]
          }
          create: {
            args: Prisma.amz_feedsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>
          }
          createMany: {
            args: Prisma.amz_feedsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_feedsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>
          }
          update: {
            args: Prisma.amz_feedsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>
          }
          deleteMany: {
            args: Prisma.amz_feedsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_feedsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_feedsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_feedsPayload>
          }
          aggregate: {
            args: Prisma.Amz_feedsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_feeds>
          }
          groupBy: {
            args: Prisma.amz_feedsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_feedsGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_feedsCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_feedsCountAggregateOutputType> | number
          }
        }
      }
      amz_keys: {
        payload: Prisma.$amz_keysPayload<ExtArgs>
        fields: Prisma.amz_keysFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_keysFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_keysFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>
          }
          findFirst: {
            args: Prisma.amz_keysFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_keysFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>
          }
          findMany: {
            args: Prisma.amz_keysFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>[]
          }
          create: {
            args: Prisma.amz_keysCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>
          }
          createMany: {
            args: Prisma.amz_keysCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_keysDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>
          }
          update: {
            args: Prisma.amz_keysUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>
          }
          deleteMany: {
            args: Prisma.amz_keysDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_keysUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_keysUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keysPayload>
          }
          aggregate: {
            args: Prisma.Amz_keysAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_keys>
          }
          groupBy: {
            args: Prisma.amz_keysGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_keysGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_keysCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_keysCountAggregateOutputType> | number
          }
        }
      }
      amz_keys_backup: {
        payload: Prisma.$amz_keys_backupPayload<ExtArgs>
        fields: Prisma.amz_keys_backupFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_keys_backupFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_keys_backupFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>
          }
          findFirst: {
            args: Prisma.amz_keys_backupFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_keys_backupFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>
          }
          findMany: {
            args: Prisma.amz_keys_backupFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>[]
          }
          create: {
            args: Prisma.amz_keys_backupCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>
          }
          createMany: {
            args: Prisma.amz_keys_backupCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_keys_backupDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>
          }
          update: {
            args: Prisma.amz_keys_backupUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>
          }
          deleteMany: {
            args: Prisma.amz_keys_backupDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_keys_backupUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_keys_backupUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_keys_backupPayload>
          }
          aggregate: {
            args: Prisma.Amz_keys_backupAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_keys_backup>
          }
          groupBy: {
            args: Prisma.amz_keys_backupGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_keys_backupGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_keys_backupCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_keys_backupCountAggregateOutputType> | number
          }
        }
      }
      amz_orders: {
        payload: Prisma.$amz_ordersPayload<ExtArgs>
        fields: Prisma.amz_ordersFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_ordersFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_ordersFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>
          }
          findFirst: {
            args: Prisma.amz_ordersFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_ordersFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>
          }
          findMany: {
            args: Prisma.amz_ordersFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>[]
          }
          create: {
            args: Prisma.amz_ordersCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>
          }
          createMany: {
            args: Prisma.amz_ordersCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_ordersDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>
          }
          update: {
            args: Prisma.amz_ordersUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>
          }
          deleteMany: {
            args: Prisma.amz_ordersDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_ordersUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_ordersUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_ordersPayload>
          }
          aggregate: {
            args: Prisma.Amz_ordersAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_orders>
          }
          groupBy: {
            args: Prisma.amz_ordersGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_ordersGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_ordersCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_ordersCountAggregateOutputType> | number
          }
        }
      }
      amz_reportrequests: {
        payload: Prisma.$amz_reportrequestsPayload<ExtArgs>
        fields: Prisma.amz_reportrequestsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_reportrequestsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_reportrequestsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>
          }
          findFirst: {
            args: Prisma.amz_reportrequestsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_reportrequestsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>
          }
          findMany: {
            args: Prisma.amz_reportrequestsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>[]
          }
          create: {
            args: Prisma.amz_reportrequestsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>
          }
          createMany: {
            args: Prisma.amz_reportrequestsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_reportrequestsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>
          }
          update: {
            args: Prisma.amz_reportrequestsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>
          }
          deleteMany: {
            args: Prisma.amz_reportrequestsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_reportrequestsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_reportrequestsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_reportrequestsPayload>
          }
          aggregate: {
            args: Prisma.Amz_reportrequestsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_reportrequests>
          }
          groupBy: {
            args: Prisma.amz_reportrequestsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_reportrequestsGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_reportrequestsCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_reportrequestsCountAggregateOutputType> | number
          }
        }
      }
      amz_searchterms: {
        payload: Prisma.$amz_searchtermsPayload<ExtArgs>
        fields: Prisma.amz_searchtermsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_searchtermsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_searchtermsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>
          }
          findFirst: {
            args: Prisma.amz_searchtermsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_searchtermsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>
          }
          findMany: {
            args: Prisma.amz_searchtermsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>[]
          }
          create: {
            args: Prisma.amz_searchtermsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>
          }
          createMany: {
            args: Prisma.amz_searchtermsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_searchtermsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>
          }
          update: {
            args: Prisma.amz_searchtermsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>
          }
          deleteMany: {
            args: Prisma.amz_searchtermsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_searchtermsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_searchtermsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_searchtermsPayload>
          }
          aggregate: {
            args: Prisma.Amz_searchtermsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_searchterms>
          }
          groupBy: {
            args: Prisma.amz_searchtermsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_searchtermsGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_searchtermsCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_searchtermsCountAggregateOutputType> | number
          }
        }
      }
      amz_variants: {
        payload: Prisma.$amz_variantsPayload<ExtArgs>
        fields: Prisma.amz_variantsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_variantsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_variantsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>
          }
          findFirst: {
            args: Prisma.amz_variantsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_variantsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>
          }
          findMany: {
            args: Prisma.amz_variantsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>[]
          }
          create: {
            args: Prisma.amz_variantsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>
          }
          createMany: {
            args: Prisma.amz_variantsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_variantsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>
          }
          update: {
            args: Prisma.amz_variantsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>
          }
          deleteMany: {
            args: Prisma.amz_variantsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_variantsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_variantsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variantsPayload>
          }
          aggregate: {
            args: Prisma.Amz_variantsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_variants>
          }
          groupBy: {
            args: Prisma.amz_variantsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_variantsGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_variantsCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_variantsCountAggregateOutputType> | number
          }
        }
      }
      amz_variants_master: {
        payload: Prisma.$amz_variants_masterPayload<ExtArgs>
        fields: Prisma.amz_variants_masterFieldRefs
        operations: {
          findUnique: {
            args: Prisma.amz_variants_masterFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.amz_variants_masterFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>
          }
          findFirst: {
            args: Prisma.amz_variants_masterFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.amz_variants_masterFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>
          }
          findMany: {
            args: Prisma.amz_variants_masterFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>[]
          }
          create: {
            args: Prisma.amz_variants_masterCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>
          }
          createMany: {
            args: Prisma.amz_variants_masterCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.amz_variants_masterDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>
          }
          update: {
            args: Prisma.amz_variants_masterUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>
          }
          deleteMany: {
            args: Prisma.amz_variants_masterDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.amz_variants_masterUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.amz_variants_masterUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$amz_variants_masterPayload>
          }
          aggregate: {
            args: Prisma.Amz_variants_masterAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAmz_variants_master>
          }
          groupBy: {
            args: Prisma.amz_variants_masterGroupByArgs<ExtArgs>
            result: $Utils.Optional<Amz_variants_masterGroupByOutputType>[]
          }
          count: {
            args: Prisma.amz_variants_masterCountArgs<ExtArgs>
            result: $Utils.Optional<Amz_variants_masterCountAggregateOutputType> | number
          }
        }
      }
      aproducts: {
        payload: Prisma.$aproductsPayload<ExtArgs>
        fields: Prisma.aproductsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.aproductsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.aproductsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>
          }
          findFirst: {
            args: Prisma.aproductsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.aproductsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>
          }
          findMany: {
            args: Prisma.aproductsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>[]
          }
          create: {
            args: Prisma.aproductsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>
          }
          createMany: {
            args: Prisma.aproductsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.aproductsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>
          }
          update: {
            args: Prisma.aproductsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>
          }
          deleteMany: {
            args: Prisma.aproductsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.aproductsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.aproductsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproductsPayload>
          }
          aggregate: {
            args: Prisma.AproductsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAproducts>
          }
          groupBy: {
            args: Prisma.aproductsGroupByArgs<ExtArgs>
            result: $Utils.Optional<AproductsGroupByOutputType>[]
          }
          count: {
            args: Prisma.aproductsCountArgs<ExtArgs>
            result: $Utils.Optional<AproductsCountAggregateOutputType> | number
          }
        }
      }
      aproducts_ext: {
        payload: Prisma.$aproducts_extPayload<ExtArgs>
        fields: Prisma.aproducts_extFieldRefs
        operations: {
          findUnique: {
            args: Prisma.aproducts_extFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.aproducts_extFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>
          }
          findFirst: {
            args: Prisma.aproducts_extFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.aproducts_extFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>
          }
          findMany: {
            args: Prisma.aproducts_extFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>[]
          }
          create: {
            args: Prisma.aproducts_extCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>
          }
          createMany: {
            args: Prisma.aproducts_extCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.aproducts_extDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>
          }
          update: {
            args: Prisma.aproducts_extUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>
          }
          deleteMany: {
            args: Prisma.aproducts_extDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.aproducts_extUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.aproducts_extUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$aproducts_extPayload>
          }
          aggregate: {
            args: Prisma.Aproducts_extAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAproducts_ext>
          }
          groupBy: {
            args: Prisma.aproducts_extGroupByArgs<ExtArgs>
            result: $Utils.Optional<Aproducts_extGroupByOutputType>[]
          }
          count: {
            args: Prisma.aproducts_extCountArgs<ExtArgs>
            result: $Utils.Optional<Aproducts_extCountAggregateOutputType> | number
          }
        }
      }
      buybox: {
        payload: Prisma.$buyboxPayload<ExtArgs>
        fields: Prisma.buyboxFieldRefs
        operations: {
          findUnique: {
            args: Prisma.buyboxFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.buyboxFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>
          }
          findFirst: {
            args: Prisma.buyboxFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.buyboxFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>
          }
          findMany: {
            args: Prisma.buyboxFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>[]
          }
          create: {
            args: Prisma.buyboxCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>
          }
          createMany: {
            args: Prisma.buyboxCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.buyboxDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>
          }
          update: {
            args: Prisma.buyboxUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>
          }
          deleteMany: {
            args: Prisma.buyboxDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.buyboxUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.buyboxUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$buyboxPayload>
          }
          aggregate: {
            args: Prisma.BuyboxAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateBuybox>
          }
          groupBy: {
            args: Prisma.buyboxGroupByArgs<ExtArgs>
            result: $Utils.Optional<BuyboxGroupByOutputType>[]
          }
          count: {
            args: Prisma.buyboxCountArgs<ExtArgs>
            result: $Utils.Optional<BuyboxCountAggregateOutputType> | number
          }
        }
      }
      chargerequest: {
        payload: Prisma.$chargerequestPayload<ExtArgs>
        fields: Prisma.chargerequestFieldRefs
        operations: {
          findUnique: {
            args: Prisma.chargerequestFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.chargerequestFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>
          }
          findFirst: {
            args: Prisma.chargerequestFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.chargerequestFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>
          }
          findMany: {
            args: Prisma.chargerequestFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>[]
          }
          create: {
            args: Prisma.chargerequestCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>
          }
          createMany: {
            args: Prisma.chargerequestCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.chargerequestDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>
          }
          update: {
            args: Prisma.chargerequestUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>
          }
          deleteMany: {
            args: Prisma.chargerequestDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.chargerequestUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.chargerequestUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$chargerequestPayload>
          }
          aggregate: {
            args: Prisma.ChargerequestAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateChargerequest>
          }
          groupBy: {
            args: Prisma.chargerequestGroupByArgs<ExtArgs>
            result: $Utils.Optional<ChargerequestGroupByOutputType>[]
          }
          count: {
            args: Prisma.chargerequestCountArgs<ExtArgs>
            result: $Utils.Optional<ChargerequestCountAggregateOutputType> | number
          }
        }
      }
      crons: {
        payload: Prisma.$cronsPayload<ExtArgs>
        fields: Prisma.cronsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.cronsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.cronsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>
          }
          findFirst: {
            args: Prisma.cronsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.cronsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>
          }
          findMany: {
            args: Prisma.cronsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>[]
          }
          create: {
            args: Prisma.cronsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>
          }
          createMany: {
            args: Prisma.cronsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.cronsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>
          }
          update: {
            args: Prisma.cronsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>
          }
          deleteMany: {
            args: Prisma.cronsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.cronsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.cronsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$cronsPayload>
          }
          aggregate: {
            args: Prisma.CronsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCrons>
          }
          groupBy: {
            args: Prisma.cronsGroupByArgs<ExtArgs>
            result: $Utils.Optional<CronsGroupByOutputType>[]
          }
          count: {
            args: Prisma.cronsCountArgs<ExtArgs>
            result: $Utils.Optional<CronsCountAggregateOutputType> | number
          }
        }
      }
      dup_product_variants: {
        payload: Prisma.$dup_product_variantsPayload<ExtArgs>
        fields: Prisma.dup_product_variantsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.dup_product_variantsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.dup_product_variantsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>
          }
          findFirst: {
            args: Prisma.dup_product_variantsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.dup_product_variantsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>
          }
          findMany: {
            args: Prisma.dup_product_variantsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>[]
          }
          create: {
            args: Prisma.dup_product_variantsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>
          }
          createMany: {
            args: Prisma.dup_product_variantsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.dup_product_variantsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>
          }
          update: {
            args: Prisma.dup_product_variantsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>
          }
          deleteMany: {
            args: Prisma.dup_product_variantsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.dup_product_variantsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.dup_product_variantsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_product_variantsPayload>
          }
          aggregate: {
            args: Prisma.Dup_product_variantsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDup_product_variants>
          }
          groupBy: {
            args: Prisma.dup_product_variantsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Dup_product_variantsGroupByOutputType>[]
          }
          count: {
            args: Prisma.dup_product_variantsCountArgs<ExtArgs>
            result: $Utils.Optional<Dup_product_variantsCountAggregateOutputType> | number
          }
        }
      }
      dup_products: {
        payload: Prisma.$dup_productsPayload<ExtArgs>
        fields: Prisma.dup_productsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.dup_productsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.dup_productsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>
          }
          findFirst: {
            args: Prisma.dup_productsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.dup_productsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>
          }
          findMany: {
            args: Prisma.dup_productsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>[]
          }
          create: {
            args: Prisma.dup_productsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>
          }
          createMany: {
            args: Prisma.dup_productsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.dup_productsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>
          }
          update: {
            args: Prisma.dup_productsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>
          }
          deleteMany: {
            args: Prisma.dup_productsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.dup_productsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.dup_productsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$dup_productsPayload>
          }
          aggregate: {
            args: Prisma.Dup_productsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDup_products>
          }
          groupBy: {
            args: Prisma.dup_productsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Dup_productsGroupByOutputType>[]
          }
          count: {
            args: Prisma.dup_productsCountArgs<ExtArgs>
            result: $Utils.Optional<Dup_productsCountAggregateOutputType> | number
          }
        }
      }
      eb_categories: {
        payload: Prisma.$eb_categoriesPayload<ExtArgs>
        fields: Prisma.eb_categoriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.eb_categoriesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.eb_categoriesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>
          }
          findFirst: {
            args: Prisma.eb_categoriesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.eb_categoriesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>
          }
          findMany: {
            args: Prisma.eb_categoriesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>[]
          }
          create: {
            args: Prisma.eb_categoriesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>
          }
          createMany: {
            args: Prisma.eb_categoriesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.eb_categoriesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>
          }
          update: {
            args: Prisma.eb_categoriesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>
          }
          deleteMany: {
            args: Prisma.eb_categoriesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.eb_categoriesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.eb_categoriesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categoriesPayload>
          }
          aggregate: {
            args: Prisma.Eb_categoriesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEb_categories>
          }
          groupBy: {
            args: Prisma.eb_categoriesGroupByArgs<ExtArgs>
            result: $Utils.Optional<Eb_categoriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.eb_categoriesCountArgs<ExtArgs>
            result: $Utils.Optional<Eb_categoriesCountAggregateOutputType> | number
          }
        }
      }
      eb_categories_mapping: {
        payload: Prisma.$eb_categories_mappingPayload<ExtArgs>
        fields: Prisma.eb_categories_mappingFieldRefs
        operations: {
          findUnique: {
            args: Prisma.eb_categories_mappingFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.eb_categories_mappingFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>
          }
          findFirst: {
            args: Prisma.eb_categories_mappingFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.eb_categories_mappingFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>
          }
          findMany: {
            args: Prisma.eb_categories_mappingFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>[]
          }
          create: {
            args: Prisma.eb_categories_mappingCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>
          }
          createMany: {
            args: Prisma.eb_categories_mappingCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.eb_categories_mappingDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>
          }
          update: {
            args: Prisma.eb_categories_mappingUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>
          }
          deleteMany: {
            args: Prisma.eb_categories_mappingDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.eb_categories_mappingUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.eb_categories_mappingUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_categories_mappingPayload>
          }
          aggregate: {
            args: Prisma.Eb_categories_mappingAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEb_categories_mapping>
          }
          groupBy: {
            args: Prisma.eb_categories_mappingGroupByArgs<ExtArgs>
            result: $Utils.Optional<Eb_categories_mappingGroupByOutputType>[]
          }
          count: {
            args: Prisma.eb_categories_mappingCountArgs<ExtArgs>
            result: $Utils.Optional<Eb_categories_mappingCountAggregateOutputType> | number
          }
        }
      }
      eb_keys: {
        payload: Prisma.$eb_keysPayload<ExtArgs>
        fields: Prisma.eb_keysFieldRefs
        operations: {
          findUnique: {
            args: Prisma.eb_keysFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.eb_keysFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>
          }
          findFirst: {
            args: Prisma.eb_keysFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.eb_keysFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>
          }
          findMany: {
            args: Prisma.eb_keysFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>[]
          }
          create: {
            args: Prisma.eb_keysCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>
          }
          createMany: {
            args: Prisma.eb_keysCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.eb_keysDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>
          }
          update: {
            args: Prisma.eb_keysUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>
          }
          deleteMany: {
            args: Prisma.eb_keysDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.eb_keysUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.eb_keysUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_keysPayload>
          }
          aggregate: {
            args: Prisma.Eb_keysAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEb_keys>
          }
          groupBy: {
            args: Prisma.eb_keysGroupByArgs<ExtArgs>
            result: $Utils.Optional<Eb_keysGroupByOutputType>[]
          }
          count: {
            args: Prisma.eb_keysCountArgs<ExtArgs>
            result: $Utils.Optional<Eb_keysCountAggregateOutputType> | number
          }
        }
      }
      eb_orders: {
        payload: Prisma.$eb_ordersPayload<ExtArgs>
        fields: Prisma.eb_ordersFieldRefs
        operations: {
          findUnique: {
            args: Prisma.eb_ordersFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.eb_ordersFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>
          }
          findFirst: {
            args: Prisma.eb_ordersFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.eb_ordersFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>
          }
          findMany: {
            args: Prisma.eb_ordersFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>[]
          }
          create: {
            args: Prisma.eb_ordersCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>
          }
          createMany: {
            args: Prisma.eb_ordersCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.eb_ordersDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>
          }
          update: {
            args: Prisma.eb_ordersUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>
          }
          deleteMany: {
            args: Prisma.eb_ordersDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.eb_ordersUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.eb_ordersUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$eb_ordersPayload>
          }
          aggregate: {
            args: Prisma.Eb_ordersAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEb_orders>
          }
          groupBy: {
            args: Prisma.eb_ordersGroupByArgs<ExtArgs>
            result: $Utils.Optional<Eb_ordersGroupByOutputType>[]
          }
          count: {
            args: Prisma.eb_ordersCountArgs<ExtArgs>
            result: $Utils.Optional<Eb_ordersCountAggregateOutputType> | number
          }
        }
      }
      ebproducts: {
        payload: Prisma.$ebproductsPayload<ExtArgs>
        fields: Prisma.ebproductsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ebproductsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ebproductsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>
          }
          findFirst: {
            args: Prisma.ebproductsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ebproductsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>
          }
          findMany: {
            args: Prisma.ebproductsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>[]
          }
          create: {
            args: Prisma.ebproductsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>
          }
          createMany: {
            args: Prisma.ebproductsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ebproductsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>
          }
          update: {
            args: Prisma.ebproductsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>
          }
          deleteMany: {
            args: Prisma.ebproductsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ebproductsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ebproductsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebproductsPayload>
          }
          aggregate: {
            args: Prisma.EbproductsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEbproducts>
          }
          groupBy: {
            args: Prisma.ebproductsGroupByArgs<ExtArgs>
            result: $Utils.Optional<EbproductsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ebproductsCountArgs<ExtArgs>
            result: $Utils.Optional<EbproductsCountAggregateOutputType> | number
          }
        }
      }
      ebpromotions: {
        payload: Prisma.$ebpromotionsPayload<ExtArgs>
        fields: Prisma.ebpromotionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ebpromotionsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ebpromotionsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>
          }
          findFirst: {
            args: Prisma.ebpromotionsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ebpromotionsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>
          }
          findMany: {
            args: Prisma.ebpromotionsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>[]
          }
          create: {
            args: Prisma.ebpromotionsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>
          }
          createMany: {
            args: Prisma.ebpromotionsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ebpromotionsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>
          }
          update: {
            args: Prisma.ebpromotionsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>
          }
          deleteMany: {
            args: Prisma.ebpromotionsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ebpromotionsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ebpromotionsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ebpromotionsPayload>
          }
          aggregate: {
            args: Prisma.EbpromotionsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEbpromotions>
          }
          groupBy: {
            args: Prisma.ebpromotionsGroupByArgs<ExtArgs>
            result: $Utils.Optional<EbpromotionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ebpromotionsCountArgs<ExtArgs>
            result: $Utils.Optional<EbpromotionsCountAggregateOutputType> | number
          }
        }
      }
      etsy_key: {
        payload: Prisma.$etsy_keyPayload<ExtArgs>
        fields: Prisma.etsy_keyFieldRefs
        operations: {
          findUnique: {
            args: Prisma.etsy_keyFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.etsy_keyFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>
          }
          findFirst: {
            args: Prisma.etsy_keyFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.etsy_keyFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>
          }
          findMany: {
            args: Prisma.etsy_keyFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>[]
          }
          create: {
            args: Prisma.etsy_keyCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>
          }
          createMany: {
            args: Prisma.etsy_keyCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.etsy_keyDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>
          }
          update: {
            args: Prisma.etsy_keyUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>
          }
          deleteMany: {
            args: Prisma.etsy_keyDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.etsy_keyUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.etsy_keyUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_keyPayload>
          }
          aggregate: {
            args: Prisma.Etsy_keyAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEtsy_key>
          }
          groupBy: {
            args: Prisma.etsy_keyGroupByArgs<ExtArgs>
            result: $Utils.Optional<Etsy_keyGroupByOutputType>[]
          }
          count: {
            args: Prisma.etsy_keyCountArgs<ExtArgs>
            result: $Utils.Optional<Etsy_keyCountAggregateOutputType> | number
          }
        }
      }
      etsy_listing_product: {
        payload: Prisma.$etsy_listing_productPayload<ExtArgs>
        fields: Prisma.etsy_listing_productFieldRefs
        operations: {
          findUnique: {
            args: Prisma.etsy_listing_productFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.etsy_listing_productFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>
          }
          findFirst: {
            args: Prisma.etsy_listing_productFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.etsy_listing_productFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>
          }
          findMany: {
            args: Prisma.etsy_listing_productFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>[]
          }
          create: {
            args: Prisma.etsy_listing_productCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>
          }
          createMany: {
            args: Prisma.etsy_listing_productCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.etsy_listing_productDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>
          }
          update: {
            args: Prisma.etsy_listing_productUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>
          }
          deleteMany: {
            args: Prisma.etsy_listing_productDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.etsy_listing_productUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.etsy_listing_productUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$etsy_listing_productPayload>
          }
          aggregate: {
            args: Prisma.Etsy_listing_productAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateEtsy_listing_product>
          }
          groupBy: {
            args: Prisma.etsy_listing_productGroupByArgs<ExtArgs>
            result: $Utils.Optional<Etsy_listing_productGroupByOutputType>[]
          }
          count: {
            args: Prisma.etsy_listing_productCountArgs<ExtArgs>
            result: $Utils.Optional<Etsy_listing_productCountAggregateOutputType> | number
          }
        }
      }
      fetchreviews: {
        payload: Prisma.$fetchreviewsPayload<ExtArgs>
        fields: Prisma.fetchreviewsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.fetchreviewsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.fetchreviewsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>
          }
          findFirst: {
            args: Prisma.fetchreviewsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.fetchreviewsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>
          }
          findMany: {
            args: Prisma.fetchreviewsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>[]
          }
          create: {
            args: Prisma.fetchreviewsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>
          }
          createMany: {
            args: Prisma.fetchreviewsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.fetchreviewsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>
          }
          update: {
            args: Prisma.fetchreviewsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>
          }
          deleteMany: {
            args: Prisma.fetchreviewsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.fetchreviewsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.fetchreviewsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fetchreviewsPayload>
          }
          aggregate: {
            args: Prisma.FetchreviewsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFetchreviews>
          }
          groupBy: {
            args: Prisma.fetchreviewsGroupByArgs<ExtArgs>
            result: $Utils.Optional<FetchreviewsGroupByOutputType>[]
          }
          count: {
            args: Prisma.fetchreviewsCountArgs<ExtArgs>
            result: $Utils.Optional<FetchreviewsCountAggregateOutputType> | number
          }
        }
      }
      fordeletion1828: {
        payload: Prisma.$fordeletion1828Payload<ExtArgs>
        fields: Prisma.fordeletion1828FieldRefs
        operations: {
          findUnique: {
            args: Prisma.fordeletion1828FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.fordeletion1828FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>
          }
          findFirst: {
            args: Prisma.fordeletion1828FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.fordeletion1828FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>
          }
          findMany: {
            args: Prisma.fordeletion1828FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>[]
          }
          create: {
            args: Prisma.fordeletion1828CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>
          }
          createMany: {
            args: Prisma.fordeletion1828CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.fordeletion1828DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>
          }
          update: {
            args: Prisma.fordeletion1828UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>
          }
          deleteMany: {
            args: Prisma.fordeletion1828DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.fordeletion1828UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.fordeletion1828UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$fordeletion1828Payload>
          }
          aggregate: {
            args: Prisma.Fordeletion1828AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFordeletion1828>
          }
          groupBy: {
            args: Prisma.fordeletion1828GroupByArgs<ExtArgs>
            result: $Utils.Optional<Fordeletion1828GroupByOutputType>[]
          }
          count: {
            args: Prisma.fordeletion1828CountArgs<ExtArgs>
            result: $Utils.Optional<Fordeletion1828CountAggregateOutputType> | number
          }
        }
      }
      img_reimport_requests: {
        payload: Prisma.$img_reimport_requestsPayload<ExtArgs>
        fields: Prisma.img_reimport_requestsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.img_reimport_requestsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.img_reimport_requestsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>
          }
          findFirst: {
            args: Prisma.img_reimport_requestsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.img_reimport_requestsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>
          }
          findMany: {
            args: Prisma.img_reimport_requestsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>[]
          }
          create: {
            args: Prisma.img_reimport_requestsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>
          }
          createMany: {
            args: Prisma.img_reimport_requestsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.img_reimport_requestsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>
          }
          update: {
            args: Prisma.img_reimport_requestsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>
          }
          deleteMany: {
            args: Prisma.img_reimport_requestsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.img_reimport_requestsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.img_reimport_requestsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$img_reimport_requestsPayload>
          }
          aggregate: {
            args: Prisma.Img_reimport_requestsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateImg_reimport_requests>
          }
          groupBy: {
            args: Prisma.img_reimport_requestsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Img_reimport_requestsGroupByOutputType>[]
          }
          count: {
            args: Prisma.img_reimport_requestsCountArgs<ExtArgs>
            result: $Utils.Optional<Img_reimport_requestsCountAggregateOutputType> | number
          }
        }
      }
      inventoryerrors: {
        payload: Prisma.$inventoryerrorsPayload<ExtArgs>
        fields: Prisma.inventoryerrorsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.inventoryerrorsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.inventoryerrorsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>
          }
          findFirst: {
            args: Prisma.inventoryerrorsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.inventoryerrorsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>
          }
          findMany: {
            args: Prisma.inventoryerrorsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>[]
          }
          create: {
            args: Prisma.inventoryerrorsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>
          }
          createMany: {
            args: Prisma.inventoryerrorsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.inventoryerrorsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>
          }
          update: {
            args: Prisma.inventoryerrorsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>
          }
          deleteMany: {
            args: Prisma.inventoryerrorsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.inventoryerrorsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.inventoryerrorsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$inventoryerrorsPayload>
          }
          aggregate: {
            args: Prisma.InventoryerrorsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateInventoryerrors>
          }
          groupBy: {
            args: Prisma.inventoryerrorsGroupByArgs<ExtArgs>
            result: $Utils.Optional<InventoryerrorsGroupByOutputType>[]
          }
          count: {
            args: Prisma.inventoryerrorsCountArgs<ExtArgs>
            result: $Utils.Optional<InventoryerrorsCountAggregateOutputType> | number
          }
        }
      }
      locations: {
        payload: Prisma.$locationsPayload<ExtArgs>
        fields: Prisma.locationsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.locationsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.locationsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>
          }
          findFirst: {
            args: Prisma.locationsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.locationsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>
          }
          findMany: {
            args: Prisma.locationsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>[]
          }
          create: {
            args: Prisma.locationsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>
          }
          createMany: {
            args: Prisma.locationsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.locationsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>
          }
          update: {
            args: Prisma.locationsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>
          }
          deleteMany: {
            args: Prisma.locationsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.locationsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.locationsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$locationsPayload>
          }
          aggregate: {
            args: Prisma.LocationsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateLocations>
          }
          groupBy: {
            args: Prisma.locationsGroupByArgs<ExtArgs>
            result: $Utils.Optional<LocationsGroupByOutputType>[]
          }
          count: {
            args: Prisma.locationsCountArgs<ExtArgs>
            result: $Utils.Optional<LocationsCountAggregateOutputType> | number
          }
        }
      }
      newsletter: {
        payload: Prisma.$newsletterPayload<ExtArgs>
        fields: Prisma.newsletterFieldRefs
        operations: {
          findUnique: {
            args: Prisma.newsletterFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.newsletterFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>
          }
          findFirst: {
            args: Prisma.newsletterFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.newsletterFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>
          }
          findMany: {
            args: Prisma.newsletterFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>[]
          }
          create: {
            args: Prisma.newsletterCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>
          }
          createMany: {
            args: Prisma.newsletterCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.newsletterDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>
          }
          update: {
            args: Prisma.newsletterUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>
          }
          deleteMany: {
            args: Prisma.newsletterDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.newsletterUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.newsletterUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$newsletterPayload>
          }
          aggregate: {
            args: Prisma.NewsletterAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateNewsletter>
          }
          groupBy: {
            args: Prisma.newsletterGroupByArgs<ExtArgs>
            result: $Utils.Optional<NewsletterGroupByOutputType>[]
          }
          count: {
            args: Prisma.newsletterCountArgs<ExtArgs>
            result: $Utils.Optional<NewsletterCountAggregateOutputType> | number
          }
        }
      }
      pc_images: {
        payload: Prisma.$pc_imagesPayload<ExtArgs>
        fields: Prisma.pc_imagesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.pc_imagesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.pc_imagesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>
          }
          findFirst: {
            args: Prisma.pc_imagesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.pc_imagesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>
          }
          findMany: {
            args: Prisma.pc_imagesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>[]
          }
          create: {
            args: Prisma.pc_imagesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>
          }
          createMany: {
            args: Prisma.pc_imagesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.pc_imagesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>
          }
          update: {
            args: Prisma.pc_imagesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>
          }
          deleteMany: {
            args: Prisma.pc_imagesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.pc_imagesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.pc_imagesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$pc_imagesPayload>
          }
          aggregate: {
            args: Prisma.Pc_imagesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePc_images>
          }
          groupBy: {
            args: Prisma.pc_imagesGroupByArgs<ExtArgs>
            result: $Utils.Optional<Pc_imagesGroupByOutputType>[]
          }
          count: {
            args: Prisma.pc_imagesCountArgs<ExtArgs>
            result: $Utils.Optional<Pc_imagesCountAggregateOutputType> | number
          }
        }
      }
      permission_role: {
        payload: Prisma.$permission_rolePayload<ExtArgs>
        fields: Prisma.permission_roleFieldRefs
        operations: {
          findUnique: {
            args: Prisma.permission_roleFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.permission_roleFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>
          }
          findFirst: {
            args: Prisma.permission_roleFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.permission_roleFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>
          }
          findMany: {
            args: Prisma.permission_roleFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>[]
          }
          create: {
            args: Prisma.permission_roleCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>
          }
          createMany: {
            args: Prisma.permission_roleCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.permission_roleDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>
          }
          update: {
            args: Prisma.permission_roleUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>
          }
          deleteMany: {
            args: Prisma.permission_roleDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.permission_roleUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.permission_roleUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permission_rolePayload>
          }
          aggregate: {
            args: Prisma.Permission_roleAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePermission_role>
          }
          groupBy: {
            args: Prisma.permission_roleGroupByArgs<ExtArgs>
            result: $Utils.Optional<Permission_roleGroupByOutputType>[]
          }
          count: {
            args: Prisma.permission_roleCountArgs<ExtArgs>
            result: $Utils.Optional<Permission_roleCountAggregateOutputType> | number
          }
        }
      }
      permissions: {
        payload: Prisma.$permissionsPayload<ExtArgs>
        fields: Prisma.permissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.permissionsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.permissionsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>
          }
          findFirst: {
            args: Prisma.permissionsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.permissionsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>
          }
          findMany: {
            args: Prisma.permissionsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>[]
          }
          create: {
            args: Prisma.permissionsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>
          }
          createMany: {
            args: Prisma.permissionsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.permissionsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>
          }
          update: {
            args: Prisma.permissionsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>
          }
          deleteMany: {
            args: Prisma.permissionsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.permissionsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.permissionsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissionsPayload>
          }
          aggregate: {
            args: Prisma.PermissionsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePermissions>
          }
          groupBy: {
            args: Prisma.permissionsGroupByArgs<ExtArgs>
            result: $Utils.Optional<PermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.permissionsCountArgs<ExtArgs>
            result: $Utils.Optional<PermissionsCountAggregateOutputType> | number
          }
        }
      }
      product_variants: {
        payload: Prisma.$product_variantsPayload<ExtArgs>
        fields: Prisma.product_variantsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.product_variantsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.product_variantsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>
          }
          findFirst: {
            args: Prisma.product_variantsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.product_variantsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>
          }
          findMany: {
            args: Prisma.product_variantsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>[]
          }
          create: {
            args: Prisma.product_variantsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>
          }
          createMany: {
            args: Prisma.product_variantsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.product_variantsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>
          }
          update: {
            args: Prisma.product_variantsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>
          }
          deleteMany: {
            args: Prisma.product_variantsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.product_variantsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.product_variantsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variantsPayload>
          }
          aggregate: {
            args: Prisma.Product_variantsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProduct_variants>
          }
          groupBy: {
            args: Prisma.product_variantsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Product_variantsGroupByOutputType>[]
          }
          count: {
            args: Prisma.product_variantsCountArgs<ExtArgs>
            result: $Utils.Optional<Product_variantsCountAggregateOutputType> | number
          }
        }
      }
      product_variants1: {
        payload: Prisma.$product_variants1Payload<ExtArgs>
        fields: Prisma.product_variants1FieldRefs
        operations: {
          findUnique: {
            args: Prisma.product_variants1FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.product_variants1FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>
          }
          findFirst: {
            args: Prisma.product_variants1FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.product_variants1FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>
          }
          findMany: {
            args: Prisma.product_variants1FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>[]
          }
          create: {
            args: Prisma.product_variants1CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>
          }
          createMany: {
            args: Prisma.product_variants1CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.product_variants1DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>
          }
          update: {
            args: Prisma.product_variants1UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>
          }
          deleteMany: {
            args: Prisma.product_variants1DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.product_variants1UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.product_variants1UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$product_variants1Payload>
          }
          aggregate: {
            args: Prisma.Product_variants1AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProduct_variants1>
          }
          groupBy: {
            args: Prisma.product_variants1GroupByArgs<ExtArgs>
            result: $Utils.Optional<Product_variants1GroupByOutputType>[]
          }
          count: {
            args: Prisma.product_variants1CountArgs<ExtArgs>
            result: $Utils.Optional<Product_variants1CountAggregateOutputType> | number
          }
        }
      }
      products: {
        payload: Prisma.$productsPayload<ExtArgs>
        fields: Prisma.productsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.productsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.productsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>
          }
          findFirst: {
            args: Prisma.productsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.productsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>
          }
          findMany: {
            args: Prisma.productsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>[]
          }
          create: {
            args: Prisma.productsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>
          }
          createMany: {
            args: Prisma.productsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.productsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>
          }
          update: {
            args: Prisma.productsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>
          }
          deleteMany: {
            args: Prisma.productsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.productsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.productsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$productsPayload>
          }
          aggregate: {
            args: Prisma.ProductsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProducts>
          }
          groupBy: {
            args: Prisma.productsGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProductsGroupByOutputType>[]
          }
          count: {
            args: Prisma.productsCountArgs<ExtArgs>
            result: $Utils.Optional<ProductsCountAggregateOutputType> | number
          }
        }
      }
      products1: {
        payload: Prisma.$products1Payload<ExtArgs>
        fields: Prisma.products1FieldRefs
        operations: {
          findUnique: {
            args: Prisma.products1FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.products1FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>
          }
          findFirst: {
            args: Prisma.products1FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.products1FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>
          }
          findMany: {
            args: Prisma.products1FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>[]
          }
          create: {
            args: Prisma.products1CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>
          }
          createMany: {
            args: Prisma.products1CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.products1DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>
          }
          update: {
            args: Prisma.products1UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>
          }
          deleteMany: {
            args: Prisma.products1DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.products1UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.products1UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$products1Payload>
          }
          aggregate: {
            args: Prisma.Products1AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProducts1>
          }
          groupBy: {
            args: Prisma.products1GroupByArgs<ExtArgs>
            result: $Utils.Optional<Products1GroupByOutputType>[]
          }
          count: {
            args: Prisma.products1CountArgs<ExtArgs>
            result: $Utils.Optional<Products1CountAggregateOutputType> | number
          }
        }
      }
      proxycrawl: {
        payload: Prisma.$proxycrawlPayload<ExtArgs>
        fields: Prisma.proxycrawlFieldRefs
        operations: {
          findUnique: {
            args: Prisma.proxycrawlFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.proxycrawlFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>
          }
          findFirst: {
            args: Prisma.proxycrawlFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.proxycrawlFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>
          }
          findMany: {
            args: Prisma.proxycrawlFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>[]
          }
          create: {
            args: Prisma.proxycrawlCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>
          }
          createMany: {
            args: Prisma.proxycrawlCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.proxycrawlDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>
          }
          update: {
            args: Prisma.proxycrawlUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>
          }
          deleteMany: {
            args: Prisma.proxycrawlDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.proxycrawlUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.proxycrawlUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$proxycrawlPayload>
          }
          aggregate: {
            args: Prisma.ProxycrawlAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProxycrawl>
          }
          groupBy: {
            args: Prisma.proxycrawlGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProxycrawlGroupByOutputType>[]
          }
          count: {
            args: Prisma.proxycrawlCountArgs<ExtArgs>
            result: $Utils.Optional<ProxycrawlCountAggregateOutputType> | number
          }
        }
      }
      rawlogs: {
        payload: Prisma.$rawlogsPayload<ExtArgs>
        fields: Prisma.rawlogsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.rawlogsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.rawlogsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>
          }
          findFirst: {
            args: Prisma.rawlogsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.rawlogsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>
          }
          findMany: {
            args: Prisma.rawlogsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>[]
          }
          create: {
            args: Prisma.rawlogsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>
          }
          createMany: {
            args: Prisma.rawlogsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.rawlogsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>
          }
          update: {
            args: Prisma.rawlogsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>
          }
          deleteMany: {
            args: Prisma.rawlogsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.rawlogsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.rawlogsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rawlogsPayload>
          }
          aggregate: {
            args: Prisma.RawlogsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRawlogs>
          }
          groupBy: {
            args: Prisma.rawlogsGroupByArgs<ExtArgs>
            result: $Utils.Optional<RawlogsGroupByOutputType>[]
          }
          count: {
            args: Prisma.rawlogsCountArgs<ExtArgs>
            result: $Utils.Optional<RawlogsCountAggregateOutputType> | number
          }
        }
      }
      reviews: {
        payload: Prisma.$reviewsPayload<ExtArgs>
        fields: Prisma.reviewsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.reviewsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.reviewsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>
          }
          findFirst: {
            args: Prisma.reviewsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.reviewsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>
          }
          findMany: {
            args: Prisma.reviewsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>[]
          }
          create: {
            args: Prisma.reviewsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>
          }
          createMany: {
            args: Prisma.reviewsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.reviewsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>
          }
          update: {
            args: Prisma.reviewsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>
          }
          deleteMany: {
            args: Prisma.reviewsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.reviewsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.reviewsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$reviewsPayload>
          }
          aggregate: {
            args: Prisma.ReviewsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateReviews>
          }
          groupBy: {
            args: Prisma.reviewsGroupByArgs<ExtArgs>
            result: $Utils.Optional<ReviewsGroupByOutputType>[]
          }
          count: {
            args: Prisma.reviewsCountArgs<ExtArgs>
            result: $Utils.Optional<ReviewsCountAggregateOutputType> | number
          }
        }
      }
      role_user: {
        payload: Prisma.$role_userPayload<ExtArgs>
        fields: Prisma.role_userFieldRefs
        operations: {
          findUnique: {
            args: Prisma.role_userFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.role_userFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>
          }
          findFirst: {
            args: Prisma.role_userFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.role_userFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>
          }
          findMany: {
            args: Prisma.role_userFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>[]
          }
          create: {
            args: Prisma.role_userCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>
          }
          createMany: {
            args: Prisma.role_userCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.role_userDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>
          }
          update: {
            args: Prisma.role_userUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>
          }
          deleteMany: {
            args: Prisma.role_userDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.role_userUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.role_userUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$role_userPayload>
          }
          aggregate: {
            args: Prisma.Role_userAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRole_user>
          }
          groupBy: {
            args: Prisma.role_userGroupByArgs<ExtArgs>
            result: $Utils.Optional<Role_userGroupByOutputType>[]
          }
          count: {
            args: Prisma.role_userCountArgs<ExtArgs>
            result: $Utils.Optional<Role_userCountAggregateOutputType> | number
          }
        }
      }
      roles: {
        payload: Prisma.$rolesPayload<ExtArgs>
        fields: Prisma.rolesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.rolesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.rolesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          findFirst: {
            args: Prisma.rolesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.rolesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          findMany: {
            args: Prisma.rolesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>[]
          }
          create: {
            args: Prisma.rolesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          createMany: {
            args: Prisma.rolesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.rolesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          update: {
            args: Prisma.rolesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          deleteMany: {
            args: Prisma.rolesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.rolesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.rolesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          aggregate: {
            args: Prisma.RolesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRoles>
          }
          groupBy: {
            args: Prisma.rolesGroupByArgs<ExtArgs>
            result: $Utils.Optional<RolesGroupByOutputType>[]
          }
          count: {
            args: Prisma.rolesCountArgs<ExtArgs>
            result: $Utils.Optional<RolesCountAggregateOutputType> | number
          }
        }
      }
      route_permission: {
        payload: Prisma.$route_permissionPayload<ExtArgs>
        fields: Prisma.route_permissionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.route_permissionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.route_permissionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>
          }
          findFirst: {
            args: Prisma.route_permissionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.route_permissionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>
          }
          findMany: {
            args: Prisma.route_permissionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>[]
          }
          create: {
            args: Prisma.route_permissionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>
          }
          createMany: {
            args: Prisma.route_permissionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.route_permissionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>
          }
          update: {
            args: Prisma.route_permissionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>
          }
          deleteMany: {
            args: Prisma.route_permissionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.route_permissionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.route_permissionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$route_permissionPayload>
          }
          aggregate: {
            args: Prisma.Route_permissionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRoute_permission>
          }
          groupBy: {
            args: Prisma.route_permissionGroupByArgs<ExtArgs>
            result: $Utils.Optional<Route_permissionGroupByOutputType>[]
          }
          count: {
            args: Prisma.route_permissionCountArgs<ExtArgs>
            result: $Utils.Optional<Route_permissionCountAggregateOutputType> | number
          }
        }
      }
      settings: {
        payload: Prisma.$settingsPayload<ExtArgs>
        fields: Prisma.settingsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.settingsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.settingsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>
          }
          findFirst: {
            args: Prisma.settingsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.settingsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>
          }
          findMany: {
            args: Prisma.settingsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>[]
          }
          create: {
            args: Prisma.settingsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>
          }
          createMany: {
            args: Prisma.settingsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.settingsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>
          }
          update: {
            args: Prisma.settingsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>
          }
          deleteMany: {
            args: Prisma.settingsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.settingsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.settingsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$settingsPayload>
          }
          aggregate: {
            args: Prisma.SettingsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSettings>
          }
          groupBy: {
            args: Prisma.settingsGroupByArgs<ExtArgs>
            result: $Utils.Optional<SettingsGroupByOutputType>[]
          }
          count: {
            args: Prisma.settingsCountArgs<ExtArgs>
            result: $Utils.Optional<SettingsCountAggregateOutputType> | number
          }
        }
      }
      shopifyorders: {
        payload: Prisma.$shopifyordersPayload<ExtArgs>
        fields: Prisma.shopifyordersFieldRefs
        operations: {
          findUnique: {
            args: Prisma.shopifyordersFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.shopifyordersFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>
          }
          findFirst: {
            args: Prisma.shopifyordersFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.shopifyordersFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>
          }
          findMany: {
            args: Prisma.shopifyordersFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>[]
          }
          create: {
            args: Prisma.shopifyordersCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>
          }
          createMany: {
            args: Prisma.shopifyordersCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.shopifyordersDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>
          }
          update: {
            args: Prisma.shopifyordersUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>
          }
          deleteMany: {
            args: Prisma.shopifyordersDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.shopifyordersUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.shopifyordersUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyordersPayload>
          }
          aggregate: {
            args: Prisma.ShopifyordersAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateShopifyorders>
          }
          groupBy: {
            args: Prisma.shopifyordersGroupByArgs<ExtArgs>
            result: $Utils.Optional<ShopifyordersGroupByOutputType>[]
          }
          count: {
            args: Prisma.shopifyordersCountArgs<ExtArgs>
            result: $Utils.Optional<ShopifyordersCountAggregateOutputType> | number
          }
        }
      }
      shopifyproducts: {
        payload: Prisma.$shopifyproductsPayload<ExtArgs>
        fields: Prisma.shopifyproductsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.shopifyproductsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.shopifyproductsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>
          }
          findFirst: {
            args: Prisma.shopifyproductsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.shopifyproductsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>
          }
          findMany: {
            args: Prisma.shopifyproductsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>[]
          }
          create: {
            args: Prisma.shopifyproductsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>
          }
          createMany: {
            args: Prisma.shopifyproductsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.shopifyproductsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>
          }
          update: {
            args: Prisma.shopifyproductsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>
          }
          deleteMany: {
            args: Prisma.shopifyproductsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.shopifyproductsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.shopifyproductsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$shopifyproductsPayload>
          }
          aggregate: {
            args: Prisma.ShopifyproductsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateShopifyproducts>
          }
          groupBy: {
            args: Prisma.shopifyproductsGroupByArgs<ExtArgs>
            result: $Utils.Optional<ShopifyproductsGroupByOutputType>[]
          }
          count: {
            args: Prisma.shopifyproductsCountArgs<ExtArgs>
            result: $Utils.Optional<ShopifyproductsCountAggregateOutputType> | number
          }
        }
      }
      sync_queue: {
        payload: Prisma.$sync_queuePayload<ExtArgs>
        fields: Prisma.sync_queueFieldRefs
        operations: {
          findUnique: {
            args: Prisma.sync_queueFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.sync_queueFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>
          }
          findFirst: {
            args: Prisma.sync_queueFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.sync_queueFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>
          }
          findMany: {
            args: Prisma.sync_queueFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>[]
          }
          create: {
            args: Prisma.sync_queueCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>
          }
          createMany: {
            args: Prisma.sync_queueCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.sync_queueDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>
          }
          update: {
            args: Prisma.sync_queueUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>
          }
          deleteMany: {
            args: Prisma.sync_queueDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.sync_queueUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.sync_queueUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$sync_queuePayload>
          }
          aggregate: {
            args: Prisma.Sync_queueAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSync_queue>
          }
          groupBy: {
            args: Prisma.sync_queueGroupByArgs<ExtArgs>
            result: $Utils.Optional<Sync_queueGroupByOutputType>[]
          }
          count: {
            args: Prisma.sync_queueCountArgs<ExtArgs>
            result: $Utils.Optional<Sync_queueCountAggregateOutputType> | number
          }
        }
      }
      tasks: {
        payload: Prisma.$tasksPayload<ExtArgs>
        fields: Prisma.tasksFieldRefs
        operations: {
          findUnique: {
            args: Prisma.tasksFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.tasksFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>
          }
          findFirst: {
            args: Prisma.tasksFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.tasksFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>
          }
          findMany: {
            args: Prisma.tasksFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>[]
          }
          create: {
            args: Prisma.tasksCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>
          }
          createMany: {
            args: Prisma.tasksCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.tasksDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>
          }
          update: {
            args: Prisma.tasksUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>
          }
          deleteMany: {
            args: Prisma.tasksDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.tasksUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.tasksUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$tasksPayload>
          }
          aggregate: {
            args: Prisma.TasksAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTasks>
          }
          groupBy: {
            args: Prisma.tasksGroupByArgs<ExtArgs>
            result: $Utils.Optional<TasksGroupByOutputType>[]
          }
          count: {
            args: Prisma.tasksCountArgs<ExtArgs>
            result: $Utils.Optional<TasksCountAggregateOutputType> | number
          }
        }
      }
      temp_12576: {
        payload: Prisma.$temp_12576Payload<ExtArgs>
        fields: Prisma.temp_12576FieldRefs
        operations: {
          findUnique: {
            args: Prisma.temp_12576FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.temp_12576FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>
          }
          findFirst: {
            args: Prisma.temp_12576FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.temp_12576FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>
          }
          findMany: {
            args: Prisma.temp_12576FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>[]
          }
          create: {
            args: Prisma.temp_12576CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>
          }
          createMany: {
            args: Prisma.temp_12576CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.temp_12576DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>
          }
          update: {
            args: Prisma.temp_12576UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>
          }
          deleteMany: {
            args: Prisma.temp_12576DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.temp_12576UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.temp_12576UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_12576Payload>
          }
          aggregate: {
            args: Prisma.Temp_12576AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTemp_12576>
          }
          groupBy: {
            args: Prisma.temp_12576GroupByArgs<ExtArgs>
            result: $Utils.Optional<Temp_12576GroupByOutputType>[]
          }
          count: {
            args: Prisma.temp_12576CountArgs<ExtArgs>
            result: $Utils.Optional<Temp_12576CountAggregateOutputType> | number
          }
        }
      }
      temp_1828: {
        payload: Prisma.$temp_1828Payload<ExtArgs>
        fields: Prisma.temp_1828FieldRefs
        operations: {
          findUnique: {
            args: Prisma.temp_1828FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.temp_1828FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>
          }
          findFirst: {
            args: Prisma.temp_1828FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.temp_1828FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>
          }
          findMany: {
            args: Prisma.temp_1828FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>[]
          }
          create: {
            args: Prisma.temp_1828CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>
          }
          createMany: {
            args: Prisma.temp_1828CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.temp_1828DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>
          }
          update: {
            args: Prisma.temp_1828UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>
          }
          deleteMany: {
            args: Prisma.temp_1828DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.temp_1828UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.temp_1828UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_1828Payload>
          }
          aggregate: {
            args: Prisma.Temp_1828AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTemp_1828>
          }
          groupBy: {
            args: Prisma.temp_1828GroupByArgs<ExtArgs>
            result: $Utils.Optional<Temp_1828GroupByOutputType>[]
          }
          count: {
            args: Prisma.temp_1828CountArgs<ExtArgs>
            result: $Utils.Optional<Temp_1828CountAggregateOutputType> | number
          }
        }
      }
      temp_2958: {
        payload: Prisma.$temp_2958Payload<ExtArgs>
        fields: Prisma.temp_2958FieldRefs
        operations: {
          findUnique: {
            args: Prisma.temp_2958FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.temp_2958FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>
          }
          findFirst: {
            args: Prisma.temp_2958FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.temp_2958FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>
          }
          findMany: {
            args: Prisma.temp_2958FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>[]
          }
          create: {
            args: Prisma.temp_2958CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>
          }
          createMany: {
            args: Prisma.temp_2958CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.temp_2958DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>
          }
          update: {
            args: Prisma.temp_2958UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>
          }
          deleteMany: {
            args: Prisma.temp_2958DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.temp_2958UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.temp_2958UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_2958Payload>
          }
          aggregate: {
            args: Prisma.Temp_2958AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTemp_2958>
          }
          groupBy: {
            args: Prisma.temp_2958GroupByArgs<ExtArgs>
            result: $Utils.Optional<Temp_2958GroupByOutputType>[]
          }
          count: {
            args: Prisma.temp_2958CountArgs<ExtArgs>
            result: $Utils.Optional<Temp_2958CountAggregateOutputType> | number
          }
        }
      }
      temp_3488: {
        payload: Prisma.$temp_3488Payload<ExtArgs>
        fields: Prisma.temp_3488FieldRefs
        operations: {
          findUnique: {
            args: Prisma.temp_3488FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.temp_3488FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>
          }
          findFirst: {
            args: Prisma.temp_3488FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.temp_3488FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>
          }
          findMany: {
            args: Prisma.temp_3488FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>[]
          }
          create: {
            args: Prisma.temp_3488CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>
          }
          createMany: {
            args: Prisma.temp_3488CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.temp_3488DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>
          }
          update: {
            args: Prisma.temp_3488UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>
          }
          deleteMany: {
            args: Prisma.temp_3488DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.temp_3488UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.temp_3488UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_3488Payload>
          }
          aggregate: {
            args: Prisma.Temp_3488AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTemp_3488>
          }
          groupBy: {
            args: Prisma.temp_3488GroupByArgs<ExtArgs>
            result: $Utils.Optional<Temp_3488GroupByOutputType>[]
          }
          count: {
            args: Prisma.temp_3488CountArgs<ExtArgs>
            result: $Utils.Optional<Temp_3488CountAggregateOutputType> | number
          }
        }
      }
      temp_collections: {
        payload: Prisma.$temp_collectionsPayload<ExtArgs>
        fields: Prisma.temp_collectionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.temp_collectionsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.temp_collectionsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>
          }
          findFirst: {
            args: Prisma.temp_collectionsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.temp_collectionsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>
          }
          findMany: {
            args: Prisma.temp_collectionsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>[]
          }
          create: {
            args: Prisma.temp_collectionsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>
          }
          createMany: {
            args: Prisma.temp_collectionsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.temp_collectionsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>
          }
          update: {
            args: Prisma.temp_collectionsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>
          }
          deleteMany: {
            args: Prisma.temp_collectionsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.temp_collectionsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.temp_collectionsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_collectionsPayload>
          }
          aggregate: {
            args: Prisma.Temp_collectionsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTemp_collections>
          }
          groupBy: {
            args: Prisma.temp_collectionsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Temp_collectionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.temp_collectionsCountArgs<ExtArgs>
            result: $Utils.Optional<Temp_collectionsCountAggregateOutputType> | number
          }
        }
      }
      temp_tweets: {
        payload: Prisma.$temp_tweetsPayload<ExtArgs>
        fields: Prisma.temp_tweetsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.temp_tweetsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.temp_tweetsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>
          }
          findFirst: {
            args: Prisma.temp_tweetsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.temp_tweetsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>
          }
          findMany: {
            args: Prisma.temp_tweetsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>[]
          }
          create: {
            args: Prisma.temp_tweetsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>
          }
          createMany: {
            args: Prisma.temp_tweetsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.temp_tweetsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>
          }
          update: {
            args: Prisma.temp_tweetsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>
          }
          deleteMany: {
            args: Prisma.temp_tweetsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.temp_tweetsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.temp_tweetsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$temp_tweetsPayload>
          }
          aggregate: {
            args: Prisma.Temp_tweetsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTemp_tweets>
          }
          groupBy: {
            args: Prisma.temp_tweetsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Temp_tweetsGroupByOutputType>[]
          }
          count: {
            args: Prisma.temp_tweetsCountArgs<ExtArgs>
            result: $Utils.Optional<Temp_tweetsCountAggregateOutputType> | number
          }
        }
      }
      test2555: {
        payload: Prisma.$test2555Payload<ExtArgs>
        fields: Prisma.test2555FieldRefs
        operations: {
          findUnique: {
            args: Prisma.test2555FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.test2555FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>
          }
          findFirst: {
            args: Prisma.test2555FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.test2555FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>
          }
          findMany: {
            args: Prisma.test2555FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>[]
          }
          create: {
            args: Prisma.test2555CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>
          }
          createMany: {
            args: Prisma.test2555CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.test2555DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>
          }
          update: {
            args: Prisma.test2555UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>
          }
          deleteMany: {
            args: Prisma.test2555DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.test2555UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.test2555UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test2555Payload>
          }
          aggregate: {
            args: Prisma.Test2555AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTest2555>
          }
          groupBy: {
            args: Prisma.test2555GroupByArgs<ExtArgs>
            result: $Utils.Optional<Test2555GroupByOutputType>[]
          }
          count: {
            args: Prisma.test2555CountArgs<ExtArgs>
            result: $Utils.Optional<Test2555CountAggregateOutputType> | number
          }
        }
      }
      test_1696: {
        payload: Prisma.$test_1696Payload<ExtArgs>
        fields: Prisma.test_1696FieldRefs
        operations: {
          findUnique: {
            args: Prisma.test_1696FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.test_1696FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>
          }
          findFirst: {
            args: Prisma.test_1696FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.test_1696FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>
          }
          findMany: {
            args: Prisma.test_1696FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>[]
          }
          create: {
            args: Prisma.test_1696CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>
          }
          createMany: {
            args: Prisma.test_1696CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.test_1696DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>
          }
          update: {
            args: Prisma.test_1696UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>
          }
          deleteMany: {
            args: Prisma.test_1696DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.test_1696UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.test_1696UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$test_1696Payload>
          }
          aggregate: {
            args: Prisma.Test_1696AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTest_1696>
          }
          groupBy: {
            args: Prisma.test_1696GroupByArgs<ExtArgs>
            result: $Utils.Optional<Test_1696GroupByOutputType>[]
          }
          count: {
            args: Prisma.test_1696CountArgs<ExtArgs>
            result: $Utils.Optional<Test_1696CountAggregateOutputType> | number
          }
        }
      }
      upccodes: {
        payload: Prisma.$upccodesPayload<ExtArgs>
        fields: Prisma.upccodesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.upccodesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.upccodesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>
          }
          findFirst: {
            args: Prisma.upccodesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.upccodesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>
          }
          findMany: {
            args: Prisma.upccodesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>[]
          }
          create: {
            args: Prisma.upccodesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>
          }
          createMany: {
            args: Prisma.upccodesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.upccodesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>
          }
          update: {
            args: Prisma.upccodesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>
          }
          deleteMany: {
            args: Prisma.upccodesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.upccodesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.upccodesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$upccodesPayload>
          }
          aggregate: {
            args: Prisma.UpccodesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUpccodes>
          }
          groupBy: {
            args: Prisma.upccodesGroupByArgs<ExtArgs>
            result: $Utils.Optional<UpccodesGroupByOutputType>[]
          }
          count: {
            args: Prisma.upccodesCountArgs<ExtArgs>
            result: $Utils.Optional<UpccodesCountAggregateOutputType> | number
          }
        }
      }
      users: {
        payload: Prisma.$usersPayload<ExtArgs>
        fields: Prisma.usersFieldRefs
        operations: {
          findUnique: {
            args: Prisma.usersFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.usersFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>
          }
          findFirst: {
            args: Prisma.usersFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.usersFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>
          }
          findMany: {
            args: Prisma.usersFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>[]
          }
          create: {
            args: Prisma.usersCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>
          }
          createMany: {
            args: Prisma.usersCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.usersDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>
          }
          update: {
            args: Prisma.usersUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>
          }
          deleteMany: {
            args: Prisma.usersDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.usersUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.usersUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$usersPayload>
          }
          aggregate: {
            args: Prisma.UsersAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUsers>
          }
          groupBy: {
            args: Prisma.usersGroupByArgs<ExtArgs>
            result: $Utils.Optional<UsersGroupByOutputType>[]
          }
          count: {
            args: Prisma.usersCountArgs<ExtArgs>
            result: $Utils.Optional<UsersCountAggregateOutputType> | number
          }
        }
      }
      wm_categories: {
        payload: Prisma.$wm_categoriesPayload<ExtArgs>
        fields: Prisma.wm_categoriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.wm_categoriesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.wm_categoriesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>
          }
          findFirst: {
            args: Prisma.wm_categoriesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.wm_categoriesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>
          }
          findMany: {
            args: Prisma.wm_categoriesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>[]
          }
          create: {
            args: Prisma.wm_categoriesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>
          }
          createMany: {
            args: Prisma.wm_categoriesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.wm_categoriesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>
          }
          update: {
            args: Prisma.wm_categoriesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>
          }
          deleteMany: {
            args: Prisma.wm_categoriesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.wm_categoriesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.wm_categoriesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_categoriesPayload>
          }
          aggregate: {
            args: Prisma.Wm_categoriesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateWm_categories>
          }
          groupBy: {
            args: Prisma.wm_categoriesGroupByArgs<ExtArgs>
            result: $Utils.Optional<Wm_categoriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.wm_categoriesCountArgs<ExtArgs>
            result: $Utils.Optional<Wm_categoriesCountAggregateOutputType> | number
          }
        }
      }
      wm_category_attribute_name_mapping: {
        payload: Prisma.$wm_category_attribute_name_mappingPayload<ExtArgs>
        fields: Prisma.wm_category_attribute_name_mappingFieldRefs
        operations: {
          findUnique: {
            args: Prisma.wm_category_attribute_name_mappingFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.wm_category_attribute_name_mappingFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>
          }
          findFirst: {
            args: Prisma.wm_category_attribute_name_mappingFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.wm_category_attribute_name_mappingFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>
          }
          findMany: {
            args: Prisma.wm_category_attribute_name_mappingFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>[]
          }
          create: {
            args: Prisma.wm_category_attribute_name_mappingCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>
          }
          createMany: {
            args: Prisma.wm_category_attribute_name_mappingCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.wm_category_attribute_name_mappingDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>
          }
          update: {
            args: Prisma.wm_category_attribute_name_mappingUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>
          }
          deleteMany: {
            args: Prisma.wm_category_attribute_name_mappingDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.wm_category_attribute_name_mappingUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.wm_category_attribute_name_mappingUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_category_attribute_name_mappingPayload>
          }
          aggregate: {
            args: Prisma.Wm_category_attribute_name_mappingAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateWm_category_attribute_name_mapping>
          }
          groupBy: {
            args: Prisma.wm_category_attribute_name_mappingGroupByArgs<ExtArgs>
            result: $Utils.Optional<Wm_category_attribute_name_mappingGroupByOutputType>[]
          }
          count: {
            args: Prisma.wm_category_attribute_name_mappingCountArgs<ExtArgs>
            result: $Utils.Optional<Wm_category_attribute_name_mappingCountAggregateOutputType> | number
          }
        }
      }
      wm_feeds: {
        payload: Prisma.$wm_feedsPayload<ExtArgs>
        fields: Prisma.wm_feedsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.wm_feedsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.wm_feedsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>
          }
          findFirst: {
            args: Prisma.wm_feedsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.wm_feedsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>
          }
          findMany: {
            args: Prisma.wm_feedsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>[]
          }
          create: {
            args: Prisma.wm_feedsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>
          }
          createMany: {
            args: Prisma.wm_feedsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.wm_feedsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>
          }
          update: {
            args: Prisma.wm_feedsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>
          }
          deleteMany: {
            args: Prisma.wm_feedsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.wm_feedsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.wm_feedsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_feedsPayload>
          }
          aggregate: {
            args: Prisma.Wm_feedsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateWm_feeds>
          }
          groupBy: {
            args: Prisma.wm_feedsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Wm_feedsGroupByOutputType>[]
          }
          count: {
            args: Prisma.wm_feedsCountArgs<ExtArgs>
            result: $Utils.Optional<Wm_feedsCountAggregateOutputType> | number
          }
        }
      }
      wm_keys: {
        payload: Prisma.$wm_keysPayload<ExtArgs>
        fields: Prisma.wm_keysFieldRefs
        operations: {
          findUnique: {
            args: Prisma.wm_keysFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.wm_keysFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>
          }
          findFirst: {
            args: Prisma.wm_keysFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.wm_keysFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>
          }
          findMany: {
            args: Prisma.wm_keysFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>[]
          }
          create: {
            args: Prisma.wm_keysCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>
          }
          createMany: {
            args: Prisma.wm_keysCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.wm_keysDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>
          }
          update: {
            args: Prisma.wm_keysUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>
          }
          deleteMany: {
            args: Prisma.wm_keysDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.wm_keysUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.wm_keysUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_keysPayload>
          }
          aggregate: {
            args: Prisma.Wm_keysAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateWm_keys>
          }
          groupBy: {
            args: Prisma.wm_keysGroupByArgs<ExtArgs>
            result: $Utils.Optional<Wm_keysGroupByOutputType>[]
          }
          count: {
            args: Prisma.wm_keysCountArgs<ExtArgs>
            result: $Utils.Optional<Wm_keysCountAggregateOutputType> | number
          }
        }
      }
      wm_orders: {
        payload: Prisma.$wm_ordersPayload<ExtArgs>
        fields: Prisma.wm_ordersFieldRefs
        operations: {
          findUnique: {
            args: Prisma.wm_ordersFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.wm_ordersFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>
          }
          findFirst: {
            args: Prisma.wm_ordersFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.wm_ordersFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>
          }
          findMany: {
            args: Prisma.wm_ordersFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>[]
          }
          create: {
            args: Prisma.wm_ordersCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>
          }
          createMany: {
            args: Prisma.wm_ordersCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.wm_ordersDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>
          }
          update: {
            args: Prisma.wm_ordersUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>
          }
          deleteMany: {
            args: Prisma.wm_ordersDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.wm_ordersUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.wm_ordersUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wm_ordersPayload>
          }
          aggregate: {
            args: Prisma.Wm_ordersAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateWm_orders>
          }
          groupBy: {
            args: Prisma.wm_ordersGroupByArgs<ExtArgs>
            result: $Utils.Optional<Wm_ordersGroupByOutputType>[]
          }
          count: {
            args: Prisma.wm_ordersCountArgs<ExtArgs>
            result: $Utils.Optional<Wm_ordersCountAggregateOutputType> | number
          }
        }
      }
      wmproducts: {
        payload: Prisma.$wmproductsPayload<ExtArgs>
        fields: Prisma.wmproductsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.wmproductsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.wmproductsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>
          }
          findFirst: {
            args: Prisma.wmproductsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.wmproductsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>
          }
          findMany: {
            args: Prisma.wmproductsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>[]
          }
          create: {
            args: Prisma.wmproductsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>
          }
          createMany: {
            args: Prisma.wmproductsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.wmproductsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>
          }
          update: {
            args: Prisma.wmproductsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>
          }
          deleteMany: {
            args: Prisma.wmproductsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.wmproductsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.wmproductsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$wmproductsPayload>
          }
          aggregate: {
            args: Prisma.WmproductsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateWmproducts>
          }
          groupBy: {
            args: Prisma.wmproductsGroupByArgs<ExtArgs>
            result: $Utils.Optional<WmproductsGroupByOutputType>[]
          }
          count: {
            args: Prisma.wmproductsCountArgs<ExtArgs>
            result: $Utils.Optional<WmproductsCountAggregateOutputType> | number
          }
        }
      }
      xpertusernew123: {
        payload: Prisma.$xpertusernew123Payload<ExtArgs>
        fields: Prisma.xpertusernew123FieldRefs
        operations: {
          findUnique: {
            args: Prisma.xpertusernew123FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.xpertusernew123FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>
          }
          findFirst: {
            args: Prisma.xpertusernew123FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.xpertusernew123FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>
          }
          findMany: {
            args: Prisma.xpertusernew123FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>[]
          }
          create: {
            args: Prisma.xpertusernew123CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>
          }
          createMany: {
            args: Prisma.xpertusernew123CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.xpertusernew123DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>
          }
          update: {
            args: Prisma.xpertusernew123UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>
          }
          deleteMany: {
            args: Prisma.xpertusernew123DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.xpertusernew123UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.xpertusernew123UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$xpertusernew123Payload>
          }
          aggregate: {
            args: Prisma.Xpertusernew123AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateXpertusernew123>
          }
          groupBy: {
            args: Prisma.xpertusernew123GroupByArgs<ExtArgs>
            result: $Utils.Optional<Xpertusernew123GroupByOutputType>[]
          }
          count: {
            args: Prisma.xpertusernew123CountArgs<ExtArgs>
            result: $Utils.Optional<Xpertusernew123CountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Shorthand for `emit: 'stdout'`
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events only
     * log: [
     *   { emit: 'event', level: 'query' },
     *   { emit: 'event', level: 'info' },
     *   { emit: 'event', level: 'warn' }
     *   { emit: 'event', level: 'error' }
     * ]
     * 
     * / Emit as events and log to stdout
     * og: [
     *  { emit: 'stdout', level: 'query' },
     *  { emit: 'stdout', level: 'info' },
     *  { emit: 'stdout', level: 'warn' }
     *  { emit: 'stdout', level: 'error' }
     * 
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Instance of a Driver Adapter, e.g., like one provided by `@prisma/adapter-planetscale`
     */
    adapter?: runtime.SqlDriverAdapterFactory | null
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    session?: SessionOmit
    amz_feeds?: amz_feedsOmit
    amz_keys?: amz_keysOmit
    amz_keys_backup?: amz_keys_backupOmit
    amz_orders?: amz_ordersOmit
    amz_reportrequests?: amz_reportrequestsOmit
    amz_searchterms?: amz_searchtermsOmit
    amz_variants?: amz_variantsOmit
    amz_variants_master?: amz_variants_masterOmit
    aproducts?: aproductsOmit
    aproducts_ext?: aproducts_extOmit
    buybox?: buyboxOmit
    chargerequest?: chargerequestOmit
    crons?: cronsOmit
    dup_product_variants?: dup_product_variantsOmit
    dup_products?: dup_productsOmit
    eb_categories?: eb_categoriesOmit
    eb_categories_mapping?: eb_categories_mappingOmit
    eb_keys?: eb_keysOmit
    eb_orders?: eb_ordersOmit
    ebproducts?: ebproductsOmit
    ebpromotions?: ebpromotionsOmit
    etsy_key?: etsy_keyOmit
    etsy_listing_product?: etsy_listing_productOmit
    fetchreviews?: fetchreviewsOmit
    fordeletion1828?: fordeletion1828Omit
    img_reimport_requests?: img_reimport_requestsOmit
    inventoryerrors?: inventoryerrorsOmit
    locations?: locationsOmit
    newsletter?: newsletterOmit
    pc_images?: pc_imagesOmit
    permission_role?: permission_roleOmit
    permissions?: permissionsOmit
    product_variants?: product_variantsOmit
    product_variants1?: product_variants1Omit
    products?: productsOmit
    products1?: products1Omit
    proxycrawl?: proxycrawlOmit
    rawlogs?: rawlogsOmit
    reviews?: reviewsOmit
    role_user?: role_userOmit
    roles?: rolesOmit
    route_permission?: route_permissionOmit
    settings?: settingsOmit
    shopifyorders?: shopifyordersOmit
    shopifyproducts?: shopifyproductsOmit
    sync_queue?: sync_queueOmit
    tasks?: tasksOmit
    temp_12576?: temp_12576Omit
    temp_1828?: temp_1828Omit
    temp_2958?: temp_2958Omit
    temp_3488?: temp_3488Omit
    temp_collections?: temp_collectionsOmit
    temp_tweets?: temp_tweetsOmit
    test2555?: test2555Omit
    test_1696?: test_1696Omit
    upccodes?: upccodesOmit
    users?: usersOmit
    wm_categories?: wm_categoriesOmit
    wm_category_attribute_name_mapping?: wm_category_attribute_name_mappingOmit
    wm_feeds?: wm_feedsOmit
    wm_keys?: wm_keysOmit
    wm_orders?: wm_ordersOmit
    wmproducts?: wmproductsOmit
    xpertusernew123?: xpertusernew123Omit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type CheckIsLogLevel<T> = T extends LogLevel ? T : never;

  export type GetLogType<T> = CheckIsLogLevel<
    T extends LogDefinition ? T['level'] : T
  >;

  export type GetEvents<T extends any[]> = T extends Array<LogLevel | LogDefinition>
    ? GetLogType<T[number]>
    : never;

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type PermissionsCountOutputType
   */

  export type PermissionsCountOutputType = {
    permission_role: number
  }

  export type PermissionsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permission_role?: boolean | PermissionsCountOutputTypeCountPermission_roleArgs
  }

  // Custom InputTypes
  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PermissionsCountOutputType
     */
    select?: PermissionsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeCountPermission_roleArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: permission_roleWhereInput
  }


  /**
   * Count Type RolesCountOutputType
   */

  export type RolesCountOutputType = {
    permission_role: number
    role_user: number
  }

  export type RolesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permission_role?: boolean | RolesCountOutputTypeCountPermission_roleArgs
    role_user?: boolean | RolesCountOutputTypeCountRole_userArgs
  }

  // Custom InputTypes
  /**
   * RolesCountOutputType without action
   */
  export type RolesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolesCountOutputType
     */
    select?: RolesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * RolesCountOutputType without action
   */
  export type RolesCountOutputTypeCountPermission_roleArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: permission_roleWhereInput
  }

  /**
   * RolesCountOutputType without action
   */
  export type RolesCountOutputTypeCountRole_userArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: role_userWhereInput
  }


  /**
   * Count Type UsersCountOutputType
   */

  export type UsersCountOutputType = {
    role_user: number
  }

  export type UsersCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    role_user?: boolean | UsersCountOutputTypeCountRole_userArgs
  }

  // Custom InputTypes
  /**
   * UsersCountOutputType without action
   */
  export type UsersCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UsersCountOutputType
     */
    select?: UsersCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UsersCountOutputType without action
   */
  export type UsersCountOutputTypeCountRole_userArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: role_userWhereInput
  }


  /**
   * Models
   */

  /**
   * Model Session
   */

  export type AggregateSession = {
    _count: SessionCountAggregateOutputType | null
    _avg: SessionAvgAggregateOutputType | null
    _sum: SessionSumAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  export type SessionAvgAggregateOutputType = {
    userId: number | null
  }

  export type SessionSumAggregateOutputType = {
    userId: number | null
  }

  export type SessionMinAggregateOutputType = {
    id: string | null
    shop: string | null
    state: string | null
    isOnline: boolean | null
    scope: string | null
    expires: Date | null
    accessToken: string | null
    userId: number | null
    firstName: string | null
    lastName: string | null
    email: string | null
    accountOwner: boolean | null
    locale: string | null
    collaborator: boolean | null
    emailVerified: boolean | null
  }

  export type SessionMaxAggregateOutputType = {
    id: string | null
    shop: string | null
    state: string | null
    isOnline: boolean | null
    scope: string | null
    expires: Date | null
    accessToken: string | null
    userId: number | null
    firstName: string | null
    lastName: string | null
    email: string | null
    accountOwner: boolean | null
    locale: string | null
    collaborator: boolean | null
    emailVerified: boolean | null
  }

  export type SessionCountAggregateOutputType = {
    id: number
    shop: number
    state: number
    isOnline: number
    scope: number
    expires: number
    accessToken: number
    userId: number
    firstName: number
    lastName: number
    email: number
    accountOwner: number
    locale: number
    collaborator: number
    emailVerified: number
    _all: number
  }


  export type SessionAvgAggregateInputType = {
    userId?: true
  }

  export type SessionSumAggregateInputType = {
    userId?: true
  }

  export type SessionMinAggregateInputType = {
    id?: true
    shop?: true
    state?: true
    isOnline?: true
    scope?: true
    expires?: true
    accessToken?: true
    userId?: true
    firstName?: true
    lastName?: true
    email?: true
    accountOwner?: true
    locale?: true
    collaborator?: true
    emailVerified?: true
  }

  export type SessionMaxAggregateInputType = {
    id?: true
    shop?: true
    state?: true
    isOnline?: true
    scope?: true
    expires?: true
    accessToken?: true
    userId?: true
    firstName?: true
    lastName?: true
    email?: true
    accountOwner?: true
    locale?: true
    collaborator?: true
    emailVerified?: true
  }

  export type SessionCountAggregateInputType = {
    id?: true
    shop?: true
    state?: true
    isOnline?: true
    scope?: true
    expires?: true
    accessToken?: true
    userId?: true
    firstName?: true
    lastName?: true
    email?: true
    accountOwner?: true
    locale?: true
    collaborator?: true
    emailVerified?: true
    _all?: true
  }

  export type SessionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Session to aggregate.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Sessions
    **/
    _count?: true | SessionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: SessionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: SessionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SessionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SessionMaxAggregateInputType
  }

  export type GetSessionAggregateType<T extends SessionAggregateArgs> = {
        [P in keyof T & keyof AggregateSession]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSession[P]>
      : GetScalarType<T[P], AggregateSession[P]>
  }




  export type SessionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SessionWhereInput
    orderBy?: SessionOrderByWithAggregationInput | SessionOrderByWithAggregationInput[]
    by: SessionScalarFieldEnum[] | SessionScalarFieldEnum
    having?: SessionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SessionCountAggregateInputType | true
    _avg?: SessionAvgAggregateInputType
    _sum?: SessionSumAggregateInputType
    _min?: SessionMinAggregateInputType
    _max?: SessionMaxAggregateInputType
  }

  export type SessionGroupByOutputType = {
    id: string
    shop: string
    state: string
    isOnline: boolean
    scope: string | null
    expires: Date | null
    accessToken: string
    userId: number | null
    firstName: string | null
    lastName: string | null
    email: string | null
    accountOwner: boolean
    locale: string | null
    collaborator: boolean | null
    emailVerified: boolean | null
    _count: SessionCountAggregateOutputType | null
    _avg: SessionAvgAggregateOutputType | null
    _sum: SessionSumAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  type GetSessionGroupByPayload<T extends SessionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SessionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SessionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SessionGroupByOutputType[P]>
            : GetScalarType<T[P], SessionGroupByOutputType[P]>
        }
      >
    >


  export type SessionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    shop?: boolean
    state?: boolean
    isOnline?: boolean
    scope?: boolean
    expires?: boolean
    accessToken?: boolean
    userId?: boolean
    firstName?: boolean
    lastName?: boolean
    email?: boolean
    accountOwner?: boolean
    locale?: boolean
    collaborator?: boolean
    emailVerified?: boolean
  }, ExtArgs["result"]["session"]>



  export type SessionSelectScalar = {
    id?: boolean
    shop?: boolean
    state?: boolean
    isOnline?: boolean
    scope?: boolean
    expires?: boolean
    accessToken?: boolean
    userId?: boolean
    firstName?: boolean
    lastName?: boolean
    email?: boolean
    accountOwner?: boolean
    locale?: boolean
    collaborator?: boolean
    emailVerified?: boolean
  }

  export type SessionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "shop" | "state" | "isOnline" | "scope" | "expires" | "accessToken" | "userId" | "firstName" | "lastName" | "email" | "accountOwner" | "locale" | "collaborator" | "emailVerified", ExtArgs["result"]["session"]>

  export type $SessionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Session"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      shop: string
      state: string
      isOnline: boolean
      scope: string | null
      expires: Date | null
      accessToken: string
      userId: number | null
      firstName: string | null
      lastName: string | null
      email: string | null
      accountOwner: boolean
      locale: string | null
      collaborator: boolean | null
      emailVerified: boolean | null
    }, ExtArgs["result"]["session"]>
    composites: {}
  }

  type SessionGetPayload<S extends boolean | null | undefined | SessionDefaultArgs> = $Result.GetResult<Prisma.$SessionPayload, S>

  type SessionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<SessionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: SessionCountAggregateInputType | true
    }

  export interface SessionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Session'], meta: { name: 'Session' } }
    /**
     * Find zero or one Session that matches the filter.
     * @param {SessionFindUniqueArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends SessionFindUniqueArgs>(args: SelectSubset<T, SessionFindUniqueArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Session that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {SessionFindUniqueOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends SessionFindUniqueOrThrowArgs>(args: SelectSubset<T, SessionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Session that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindFirstArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends SessionFindFirstArgs>(args?: SelectSubset<T, SessionFindFirstArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Session that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindFirstOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends SessionFindFirstOrThrowArgs>(args?: SelectSubset<T, SessionFindFirstOrThrowArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Sessions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Sessions
     * const sessions = await prisma.session.findMany()
     * 
     * // Get first 10 Sessions
     * const sessions = await prisma.session.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const sessionWithIdOnly = await prisma.session.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends SessionFindManyArgs>(args?: SelectSubset<T, SessionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Session.
     * @param {SessionCreateArgs} args - Arguments to create a Session.
     * @example
     * // Create one Session
     * const Session = await prisma.session.create({
     *   data: {
     *     // ... data to create a Session
     *   }
     * })
     * 
     */
    create<T extends SessionCreateArgs>(args: SelectSubset<T, SessionCreateArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Sessions.
     * @param {SessionCreateManyArgs} args - Arguments to create many Sessions.
     * @example
     * // Create many Sessions
     * const session = await prisma.session.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends SessionCreateManyArgs>(args?: SelectSubset<T, SessionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Session.
     * @param {SessionDeleteArgs} args - Arguments to delete one Session.
     * @example
     * // Delete one Session
     * const Session = await prisma.session.delete({
     *   where: {
     *     // ... filter to delete one Session
     *   }
     * })
     * 
     */
    delete<T extends SessionDeleteArgs>(args: SelectSubset<T, SessionDeleteArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Session.
     * @param {SessionUpdateArgs} args - Arguments to update one Session.
     * @example
     * // Update one Session
     * const session = await prisma.session.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends SessionUpdateArgs>(args: SelectSubset<T, SessionUpdateArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Sessions.
     * @param {SessionDeleteManyArgs} args - Arguments to filter Sessions to delete.
     * @example
     * // Delete a few Sessions
     * const { count } = await prisma.session.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends SessionDeleteManyArgs>(args?: SelectSubset<T, SessionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Sessions
     * const session = await prisma.session.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends SessionUpdateManyArgs>(args: SelectSubset<T, SessionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Session.
     * @param {SessionUpsertArgs} args - Arguments to update or create a Session.
     * @example
     * // Update or create a Session
     * const session = await prisma.session.upsert({
     *   create: {
     *     // ... data to create a Session
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Session we want to update
     *   }
     * })
     */
    upsert<T extends SessionUpsertArgs>(args: SelectSubset<T, SessionUpsertArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionCountArgs} args - Arguments to filter Sessions to count.
     * @example
     * // Count the number of Sessions
     * const count = await prisma.session.count({
     *   where: {
     *     // ... the filter for the Sessions we want to count
     *   }
     * })
    **/
    count<T extends SessionCountArgs>(
      args?: Subset<T, SessionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SessionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SessionAggregateArgs>(args: Subset<T, SessionAggregateArgs>): Prisma.PrismaPromise<GetSessionAggregateType<T>>

    /**
     * Group by Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends SessionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: SessionGroupByArgs['orderBy'] }
        : { orderBy?: SessionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, SessionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSessionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Session model
   */
  readonly fields: SessionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Session.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__SessionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Session model
   */
  interface SessionFieldRefs {
    readonly id: FieldRef<"Session", 'String'>
    readonly shop: FieldRef<"Session", 'String'>
    readonly state: FieldRef<"Session", 'String'>
    readonly isOnline: FieldRef<"Session", 'Boolean'>
    readonly scope: FieldRef<"Session", 'String'>
    readonly expires: FieldRef<"Session", 'DateTime'>
    readonly accessToken: FieldRef<"Session", 'String'>
    readonly userId: FieldRef<"Session", 'Int'>
    readonly firstName: FieldRef<"Session", 'String'>
    readonly lastName: FieldRef<"Session", 'String'>
    readonly email: FieldRef<"Session", 'String'>
    readonly accountOwner: FieldRef<"Session", 'Boolean'>
    readonly locale: FieldRef<"Session", 'String'>
    readonly collaborator: FieldRef<"Session", 'Boolean'>
    readonly emailVerified: FieldRef<"Session", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * Session findUnique
   */
  export type SessionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session findUniqueOrThrow
   */
  export type SessionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session findFirst
   */
  export type SessionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session findFirstOrThrow
   */
  export type SessionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session findMany
   */
  export type SessionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter, which Sessions to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session create
   */
  export type SessionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * The data needed to create a Session.
     */
    data: XOR<SessionCreateInput, SessionUncheckedCreateInput>
  }

  /**
   * Session createMany
   */
  export type SessionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Sessions.
     */
    data: SessionCreateManyInput | SessionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Session update
   */
  export type SessionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * The data needed to update a Session.
     */
    data: XOR<SessionUpdateInput, SessionUncheckedUpdateInput>
    /**
     * Choose, which Session to update.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session updateMany
   */
  export type SessionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Sessions.
     */
    data: XOR<SessionUpdateManyMutationInput, SessionUncheckedUpdateManyInput>
    /**
     * Filter which Sessions to update
     */
    where?: SessionWhereInput
    /**
     * Limit how many Sessions to update.
     */
    limit?: number
  }

  /**
   * Session upsert
   */
  export type SessionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * The filter to search for the Session to update in case it exists.
     */
    where: SessionWhereUniqueInput
    /**
     * In case the Session found by the `where` argument doesn't exist, create a new Session with this data.
     */
    create: XOR<SessionCreateInput, SessionUncheckedCreateInput>
    /**
     * In case the Session was found with the provided `where` argument, update it with this data.
     */
    update: XOR<SessionUpdateInput, SessionUncheckedUpdateInput>
  }

  /**
   * Session delete
   */
  export type SessionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Filter which Session to delete.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session deleteMany
   */
  export type SessionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Sessions to delete
     */
    where?: SessionWhereInput
    /**
     * Limit how many Sessions to delete.
     */
    limit?: number
  }

  /**
   * Session without action
   */
  export type SessionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
  }


  /**
   * Model amz_feeds
   */

  export type AggregateAmz_feeds = {
    _count: Amz_feedsCountAggregateOutputType | null
    _avg: Amz_feedsAvgAggregateOutputType | null
    _sum: Amz_feedsSumAggregateOutputType | null
    _min: Amz_feedsMinAggregateOutputType | null
    _max: Amz_feedsMaxAggregateOutputType | null
  }

  export type Amz_feedsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_feedsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_feedsMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    products: string | null
    feed_submission_id_product: string | null
    feed_submission_id_image: string | null
    feed_submission_id_price: string | null
    feed_submission_id_inventory: string | null
    feed_submission_id_relationship: string | null
    status: $Enums.amz_feeds_status | null
    inprocess: boolean | null
    errdata: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_feedsMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    products: string | null
    feed_submission_id_product: string | null
    feed_submission_id_image: string | null
    feed_submission_id_price: string | null
    feed_submission_id_inventory: string | null
    feed_submission_id_relationship: string | null
    status: $Enums.amz_feeds_status | null
    inprocess: boolean | null
    errdata: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_feedsCountAggregateOutputType = {
    id: number
    user_id: number
    products: number
    feed_submission_id_product: number
    feed_submission_id_image: number
    feed_submission_id_price: number
    feed_submission_id_inventory: number
    feed_submission_id_relationship: number
    status: number
    inprocess: number
    errdata: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Amz_feedsAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_feedsSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_feedsMinAggregateInputType = {
    id?: true
    user_id?: true
    products?: true
    feed_submission_id_product?: true
    feed_submission_id_image?: true
    feed_submission_id_price?: true
    feed_submission_id_inventory?: true
    feed_submission_id_relationship?: true
    status?: true
    inprocess?: true
    errdata?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_feedsMaxAggregateInputType = {
    id?: true
    user_id?: true
    products?: true
    feed_submission_id_product?: true
    feed_submission_id_image?: true
    feed_submission_id_price?: true
    feed_submission_id_inventory?: true
    feed_submission_id_relationship?: true
    status?: true
    inprocess?: true
    errdata?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_feedsCountAggregateInputType = {
    id?: true
    user_id?: true
    products?: true
    feed_submission_id_product?: true
    feed_submission_id_image?: true
    feed_submission_id_price?: true
    feed_submission_id_inventory?: true
    feed_submission_id_relationship?: true
    status?: true
    inprocess?: true
    errdata?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Amz_feedsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_feeds to aggregate.
     */
    where?: amz_feedsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_feeds to fetch.
     */
    orderBy?: amz_feedsOrderByWithRelationInput | amz_feedsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_feedsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_feeds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_feeds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_feeds
    **/
    _count?: true | Amz_feedsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_feedsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_feedsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_feedsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_feedsMaxAggregateInputType
  }

  export type GetAmz_feedsAggregateType<T extends Amz_feedsAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_feeds]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_feeds[P]>
      : GetScalarType<T[P], AggregateAmz_feeds[P]>
  }




  export type amz_feedsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_feedsWhereInput
    orderBy?: amz_feedsOrderByWithAggregationInput | amz_feedsOrderByWithAggregationInput[]
    by: Amz_feedsScalarFieldEnum[] | Amz_feedsScalarFieldEnum
    having?: amz_feedsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_feedsCountAggregateInputType | true
    _avg?: Amz_feedsAvgAggregateInputType
    _sum?: Amz_feedsSumAggregateInputType
    _min?: Amz_feedsMinAggregateInputType
    _max?: Amz_feedsMaxAggregateInputType
  }

  export type Amz_feedsGroupByOutputType = {
    id: number
    user_id: number
    products: string
    feed_submission_id_product: string
    feed_submission_id_image: string
    feed_submission_id_price: string
    feed_submission_id_inventory: string
    feed_submission_id_relationship: string
    status: $Enums.amz_feeds_status
    inprocess: boolean
    errdata: string
    created_at: Date
    updated_at: Date
    _count: Amz_feedsCountAggregateOutputType | null
    _avg: Amz_feedsAvgAggregateOutputType | null
    _sum: Amz_feedsSumAggregateOutputType | null
    _min: Amz_feedsMinAggregateOutputType | null
    _max: Amz_feedsMaxAggregateOutputType | null
  }

  type GetAmz_feedsGroupByPayload<T extends amz_feedsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_feedsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_feedsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_feedsGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_feedsGroupByOutputType[P]>
        }
      >
    >


  export type amz_feedsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    products?: boolean
    feed_submission_id_product?: boolean
    feed_submission_id_image?: boolean
    feed_submission_id_price?: boolean
    feed_submission_id_inventory?: boolean
    feed_submission_id_relationship?: boolean
    status?: boolean
    inprocess?: boolean
    errdata?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["amz_feeds"]>



  export type amz_feedsSelectScalar = {
    id?: boolean
    user_id?: boolean
    products?: boolean
    feed_submission_id_product?: boolean
    feed_submission_id_image?: boolean
    feed_submission_id_price?: boolean
    feed_submission_id_inventory?: boolean
    feed_submission_id_relationship?: boolean
    status?: boolean
    inprocess?: boolean
    errdata?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type amz_feedsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "products" | "feed_submission_id_product" | "feed_submission_id_image" | "feed_submission_id_price" | "feed_submission_id_inventory" | "feed_submission_id_relationship" | "status" | "inprocess" | "errdata" | "created_at" | "updated_at", ExtArgs["result"]["amz_feeds"]>

  export type $amz_feedsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_feeds"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      products: string
      feed_submission_id_product: string
      feed_submission_id_image: string
      feed_submission_id_price: string
      feed_submission_id_inventory: string
      feed_submission_id_relationship: string
      status: $Enums.amz_feeds_status
      inprocess: boolean
      errdata: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["amz_feeds"]>
    composites: {}
  }

  type amz_feedsGetPayload<S extends boolean | null | undefined | amz_feedsDefaultArgs> = $Result.GetResult<Prisma.$amz_feedsPayload, S>

  type amz_feedsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_feedsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_feedsCountAggregateInputType | true
    }

  export interface amz_feedsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_feeds'], meta: { name: 'amz_feeds' } }
    /**
     * Find zero or one Amz_feeds that matches the filter.
     * @param {amz_feedsFindUniqueArgs} args - Arguments to find a Amz_feeds
     * @example
     * // Get one Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_feedsFindUniqueArgs>(args: SelectSubset<T, amz_feedsFindUniqueArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_feeds that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_feedsFindUniqueOrThrowArgs} args - Arguments to find a Amz_feeds
     * @example
     * // Get one Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_feedsFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_feedsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_feeds that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_feedsFindFirstArgs} args - Arguments to find a Amz_feeds
     * @example
     * // Get one Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_feedsFindFirstArgs>(args?: SelectSubset<T, amz_feedsFindFirstArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_feeds that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_feedsFindFirstOrThrowArgs} args - Arguments to find a Amz_feeds
     * @example
     * // Get one Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_feedsFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_feedsFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_feeds that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_feedsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.findMany()
     * 
     * // Get first 10 Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_feedsWithIdOnly = await prisma.amz_feeds.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_feedsFindManyArgs>(args?: SelectSubset<T, amz_feedsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_feeds.
     * @param {amz_feedsCreateArgs} args - Arguments to create a Amz_feeds.
     * @example
     * // Create one Amz_feeds
     * const Amz_feeds = await prisma.amz_feeds.create({
     *   data: {
     *     // ... data to create a Amz_feeds
     *   }
     * })
     * 
     */
    create<T extends amz_feedsCreateArgs>(args: SelectSubset<T, amz_feedsCreateArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_feeds.
     * @param {amz_feedsCreateManyArgs} args - Arguments to create many Amz_feeds.
     * @example
     * // Create many Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_feedsCreateManyArgs>(args?: SelectSubset<T, amz_feedsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_feeds.
     * @param {amz_feedsDeleteArgs} args - Arguments to delete one Amz_feeds.
     * @example
     * // Delete one Amz_feeds
     * const Amz_feeds = await prisma.amz_feeds.delete({
     *   where: {
     *     // ... filter to delete one Amz_feeds
     *   }
     * })
     * 
     */
    delete<T extends amz_feedsDeleteArgs>(args: SelectSubset<T, amz_feedsDeleteArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_feeds.
     * @param {amz_feedsUpdateArgs} args - Arguments to update one Amz_feeds.
     * @example
     * // Update one Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_feedsUpdateArgs>(args: SelectSubset<T, amz_feedsUpdateArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_feeds.
     * @param {amz_feedsDeleteManyArgs} args - Arguments to filter Amz_feeds to delete.
     * @example
     * // Delete a few Amz_feeds
     * const { count } = await prisma.amz_feeds.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_feedsDeleteManyArgs>(args?: SelectSubset<T, amz_feedsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_feeds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_feedsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_feedsUpdateManyArgs>(args: SelectSubset<T, amz_feedsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_feeds.
     * @param {amz_feedsUpsertArgs} args - Arguments to update or create a Amz_feeds.
     * @example
     * // Update or create a Amz_feeds
     * const amz_feeds = await prisma.amz_feeds.upsert({
     *   create: {
     *     // ... data to create a Amz_feeds
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_feeds we want to update
     *   }
     * })
     */
    upsert<T extends amz_feedsUpsertArgs>(args: SelectSubset<T, amz_feedsUpsertArgs<ExtArgs>>): Prisma__amz_feedsClient<$Result.GetResult<Prisma.$amz_feedsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_feeds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_feedsCountArgs} args - Arguments to filter Amz_feeds to count.
     * @example
     * // Count the number of Amz_feeds
     * const count = await prisma.amz_feeds.count({
     *   where: {
     *     // ... the filter for the Amz_feeds we want to count
     *   }
     * })
    **/
    count<T extends amz_feedsCountArgs>(
      args?: Subset<T, amz_feedsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_feedsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_feeds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_feedsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_feedsAggregateArgs>(args: Subset<T, Amz_feedsAggregateArgs>): Prisma.PrismaPromise<GetAmz_feedsAggregateType<T>>

    /**
     * Group by Amz_feeds.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_feedsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_feedsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_feedsGroupByArgs['orderBy'] }
        : { orderBy?: amz_feedsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_feedsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_feedsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_feeds model
   */
  readonly fields: amz_feedsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_feeds.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_feedsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_feeds model
   */
  interface amz_feedsFieldRefs {
    readonly id: FieldRef<"amz_feeds", 'Int'>
    readonly user_id: FieldRef<"amz_feeds", 'Int'>
    readonly products: FieldRef<"amz_feeds", 'String'>
    readonly feed_submission_id_product: FieldRef<"amz_feeds", 'String'>
    readonly feed_submission_id_image: FieldRef<"amz_feeds", 'String'>
    readonly feed_submission_id_price: FieldRef<"amz_feeds", 'String'>
    readonly feed_submission_id_inventory: FieldRef<"amz_feeds", 'String'>
    readonly feed_submission_id_relationship: FieldRef<"amz_feeds", 'String'>
    readonly status: FieldRef<"amz_feeds", 'amz_feeds_status'>
    readonly inprocess: FieldRef<"amz_feeds", 'Boolean'>
    readonly errdata: FieldRef<"amz_feeds", 'String'>
    readonly created_at: FieldRef<"amz_feeds", 'DateTime'>
    readonly updated_at: FieldRef<"amz_feeds", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_feeds findUnique
   */
  export type amz_feedsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * Filter, which amz_feeds to fetch.
     */
    where: amz_feedsWhereUniqueInput
  }

  /**
   * amz_feeds findUniqueOrThrow
   */
  export type amz_feedsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * Filter, which amz_feeds to fetch.
     */
    where: amz_feedsWhereUniqueInput
  }

  /**
   * amz_feeds findFirst
   */
  export type amz_feedsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * Filter, which amz_feeds to fetch.
     */
    where?: amz_feedsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_feeds to fetch.
     */
    orderBy?: amz_feedsOrderByWithRelationInput | amz_feedsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_feeds.
     */
    cursor?: amz_feedsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_feeds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_feeds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_feeds.
     */
    distinct?: Amz_feedsScalarFieldEnum | Amz_feedsScalarFieldEnum[]
  }

  /**
   * amz_feeds findFirstOrThrow
   */
  export type amz_feedsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * Filter, which amz_feeds to fetch.
     */
    where?: amz_feedsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_feeds to fetch.
     */
    orderBy?: amz_feedsOrderByWithRelationInput | amz_feedsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_feeds.
     */
    cursor?: amz_feedsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_feeds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_feeds.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_feeds.
     */
    distinct?: Amz_feedsScalarFieldEnum | Amz_feedsScalarFieldEnum[]
  }

  /**
   * amz_feeds findMany
   */
  export type amz_feedsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * Filter, which amz_feeds to fetch.
     */
    where?: amz_feedsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_feeds to fetch.
     */
    orderBy?: amz_feedsOrderByWithRelationInput | amz_feedsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_feeds.
     */
    cursor?: amz_feedsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_feeds from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_feeds.
     */
    skip?: number
    distinct?: Amz_feedsScalarFieldEnum | Amz_feedsScalarFieldEnum[]
  }

  /**
   * amz_feeds create
   */
  export type amz_feedsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_feeds.
     */
    data: XOR<amz_feedsCreateInput, amz_feedsUncheckedCreateInput>
  }

  /**
   * amz_feeds createMany
   */
  export type amz_feedsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_feeds.
     */
    data: amz_feedsCreateManyInput | amz_feedsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_feeds update
   */
  export type amz_feedsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_feeds.
     */
    data: XOR<amz_feedsUpdateInput, amz_feedsUncheckedUpdateInput>
    /**
     * Choose, which amz_feeds to update.
     */
    where: amz_feedsWhereUniqueInput
  }

  /**
   * amz_feeds updateMany
   */
  export type amz_feedsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_feeds.
     */
    data: XOR<amz_feedsUpdateManyMutationInput, amz_feedsUncheckedUpdateManyInput>
    /**
     * Filter which amz_feeds to update
     */
    where?: amz_feedsWhereInput
    /**
     * Limit how many amz_feeds to update.
     */
    limit?: number
  }

  /**
   * amz_feeds upsert
   */
  export type amz_feedsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_feeds to update in case it exists.
     */
    where: amz_feedsWhereUniqueInput
    /**
     * In case the amz_feeds found by the `where` argument doesn't exist, create a new amz_feeds with this data.
     */
    create: XOR<amz_feedsCreateInput, amz_feedsUncheckedCreateInput>
    /**
     * In case the amz_feeds was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_feedsUpdateInput, amz_feedsUncheckedUpdateInput>
  }

  /**
   * amz_feeds delete
   */
  export type amz_feedsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
    /**
     * Filter which amz_feeds to delete.
     */
    where: amz_feedsWhereUniqueInput
  }

  /**
   * amz_feeds deleteMany
   */
  export type amz_feedsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_feeds to delete
     */
    where?: amz_feedsWhereInput
    /**
     * Limit how many amz_feeds to delete.
     */
    limit?: number
  }

  /**
   * amz_feeds without action
   */
  export type amz_feedsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_feeds
     */
    select?: amz_feedsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_feeds
     */
    omit?: amz_feedsOmit<ExtArgs> | null
  }


  /**
   * Model amz_keys
   */

  export type AggregateAmz_keys = {
    _count: Amz_keysCountAggregateOutputType | null
    _avg: Amz_keysAvgAggregateOutputType | null
    _sum: Amz_keysSumAggregateOutputType | null
    _min: Amz_keysMinAggregateOutputType | null
    _max: Amz_keysMaxAggregateOutputType | null
  }

  export type Amz_keysAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_keysSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_keysMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    merchant_id: string | null
    marketplace_id: string | null
    access_key_id: string | null
    secret_access_key: string | null
    mws_token: string | null
    access_token: string | null
    refresh_token: string | null
    tokengeneratedon: Date | null
    valid: boolean | null
    country: string | null
    amazon_website: string | null
    product_import: boolean | null
    inventory_sync: boolean | null
    lastdatafetched: Date | null
    lastfbafetched: Date | null
    lastordersfetched: Date | null
    dateofmodification: Date | null
    temp: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_keysMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    merchant_id: string | null
    marketplace_id: string | null
    access_key_id: string | null
    secret_access_key: string | null
    mws_token: string | null
    access_token: string | null
    refresh_token: string | null
    tokengeneratedon: Date | null
    valid: boolean | null
    country: string | null
    amazon_website: string | null
    product_import: boolean | null
    inventory_sync: boolean | null
    lastdatafetched: Date | null
    lastfbafetched: Date | null
    lastordersfetched: Date | null
    dateofmodification: Date | null
    temp: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_keysCountAggregateOutputType = {
    id: number
    user_id: number
    merchant_id: number
    marketplace_id: number
    access_key_id: number
    secret_access_key: number
    mws_token: number
    access_token: number
    refresh_token: number
    tokengeneratedon: number
    valid: number
    country: number
    amazon_website: number
    product_import: number
    inventory_sync: number
    lastdatafetched: number
    lastfbafetched: number
    lastordersfetched: number
    dateofmodification: number
    temp: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Amz_keysAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_keysSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_keysMinAggregateInputType = {
    id?: true
    user_id?: true
    merchant_id?: true
    marketplace_id?: true
    access_key_id?: true
    secret_access_key?: true
    mws_token?: true
    access_token?: true
    refresh_token?: true
    tokengeneratedon?: true
    valid?: true
    country?: true
    amazon_website?: true
    product_import?: true
    inventory_sync?: true
    lastdatafetched?: true
    lastfbafetched?: true
    lastordersfetched?: true
    dateofmodification?: true
    temp?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_keysMaxAggregateInputType = {
    id?: true
    user_id?: true
    merchant_id?: true
    marketplace_id?: true
    access_key_id?: true
    secret_access_key?: true
    mws_token?: true
    access_token?: true
    refresh_token?: true
    tokengeneratedon?: true
    valid?: true
    country?: true
    amazon_website?: true
    product_import?: true
    inventory_sync?: true
    lastdatafetched?: true
    lastfbafetched?: true
    lastordersfetched?: true
    dateofmodification?: true
    temp?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_keysCountAggregateInputType = {
    id?: true
    user_id?: true
    merchant_id?: true
    marketplace_id?: true
    access_key_id?: true
    secret_access_key?: true
    mws_token?: true
    access_token?: true
    refresh_token?: true
    tokengeneratedon?: true
    valid?: true
    country?: true
    amazon_website?: true
    product_import?: true
    inventory_sync?: true
    lastdatafetched?: true
    lastfbafetched?: true
    lastordersfetched?: true
    dateofmodification?: true
    temp?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Amz_keysAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_keys to aggregate.
     */
    where?: amz_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys to fetch.
     */
    orderBy?: amz_keysOrderByWithRelationInput | amz_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_keys
    **/
    _count?: true | Amz_keysCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_keysAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_keysSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_keysMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_keysMaxAggregateInputType
  }

  export type GetAmz_keysAggregateType<T extends Amz_keysAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_keys]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_keys[P]>
      : GetScalarType<T[P], AggregateAmz_keys[P]>
  }




  export type amz_keysGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_keysWhereInput
    orderBy?: amz_keysOrderByWithAggregationInput | amz_keysOrderByWithAggregationInput[]
    by: Amz_keysScalarFieldEnum[] | Amz_keysScalarFieldEnum
    having?: amz_keysScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_keysCountAggregateInputType | true
    _avg?: Amz_keysAvgAggregateInputType
    _sum?: Amz_keysSumAggregateInputType
    _min?: Amz_keysMinAggregateInputType
    _max?: Amz_keysMaxAggregateInputType
  }

  export type Amz_keysGroupByOutputType = {
    id: number
    user_id: number
    merchant_id: string
    marketplace_id: string
    access_key_id: string
    secret_access_key: string
    mws_token: string
    access_token: string | null
    refresh_token: string | null
    tokengeneratedon: Date | null
    valid: boolean
    country: string
    amazon_website: string
    product_import: boolean
    inventory_sync: boolean
    lastdatafetched: Date
    lastfbafetched: Date | null
    lastordersfetched: Date | null
    dateofmodification: Date | null
    temp: string
    created_at: Date
    updated_at: Date
    _count: Amz_keysCountAggregateOutputType | null
    _avg: Amz_keysAvgAggregateOutputType | null
    _sum: Amz_keysSumAggregateOutputType | null
    _min: Amz_keysMinAggregateOutputType | null
    _max: Amz_keysMaxAggregateOutputType | null
  }

  type GetAmz_keysGroupByPayload<T extends amz_keysGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_keysGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_keysGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_keysGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_keysGroupByOutputType[P]>
        }
      >
    >


  export type amz_keysSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    merchant_id?: boolean
    marketplace_id?: boolean
    access_key_id?: boolean
    secret_access_key?: boolean
    mws_token?: boolean
    access_token?: boolean
    refresh_token?: boolean
    tokengeneratedon?: boolean
    valid?: boolean
    country?: boolean
    amazon_website?: boolean
    product_import?: boolean
    inventory_sync?: boolean
    lastdatafetched?: boolean
    lastfbafetched?: boolean
    lastordersfetched?: boolean
    dateofmodification?: boolean
    temp?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["amz_keys"]>



  export type amz_keysSelectScalar = {
    id?: boolean
    user_id?: boolean
    merchant_id?: boolean
    marketplace_id?: boolean
    access_key_id?: boolean
    secret_access_key?: boolean
    mws_token?: boolean
    access_token?: boolean
    refresh_token?: boolean
    tokengeneratedon?: boolean
    valid?: boolean
    country?: boolean
    amazon_website?: boolean
    product_import?: boolean
    inventory_sync?: boolean
    lastdatafetched?: boolean
    lastfbafetched?: boolean
    lastordersfetched?: boolean
    dateofmodification?: boolean
    temp?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type amz_keysOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "merchant_id" | "marketplace_id" | "access_key_id" | "secret_access_key" | "mws_token" | "access_token" | "refresh_token" | "tokengeneratedon" | "valid" | "country" | "amazon_website" | "product_import" | "inventory_sync" | "lastdatafetched" | "lastfbafetched" | "lastordersfetched" | "dateofmodification" | "temp" | "created_at" | "updated_at", ExtArgs["result"]["amz_keys"]>

  export type $amz_keysPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_keys"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      merchant_id: string
      marketplace_id: string
      access_key_id: string
      secret_access_key: string
      mws_token: string
      access_token: string | null
      refresh_token: string | null
      tokengeneratedon: Date | null
      valid: boolean
      country: string
      amazon_website: string
      product_import: boolean
      inventory_sync: boolean
      lastdatafetched: Date
      lastfbafetched: Date | null
      lastordersfetched: Date | null
      dateofmodification: Date | null
      temp: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["amz_keys"]>
    composites: {}
  }

  type amz_keysGetPayload<S extends boolean | null | undefined | amz_keysDefaultArgs> = $Result.GetResult<Prisma.$amz_keysPayload, S>

  type amz_keysCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_keysFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_keysCountAggregateInputType | true
    }

  export interface amz_keysDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_keys'], meta: { name: 'amz_keys' } }
    /**
     * Find zero or one Amz_keys that matches the filter.
     * @param {amz_keysFindUniqueArgs} args - Arguments to find a Amz_keys
     * @example
     * // Get one Amz_keys
     * const amz_keys = await prisma.amz_keys.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_keysFindUniqueArgs>(args: SelectSubset<T, amz_keysFindUniqueArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_keys that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_keysFindUniqueOrThrowArgs} args - Arguments to find a Amz_keys
     * @example
     * // Get one Amz_keys
     * const amz_keys = await prisma.amz_keys.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_keysFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_keysFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_keys that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keysFindFirstArgs} args - Arguments to find a Amz_keys
     * @example
     * // Get one Amz_keys
     * const amz_keys = await prisma.amz_keys.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_keysFindFirstArgs>(args?: SelectSubset<T, amz_keysFindFirstArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_keys that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keysFindFirstOrThrowArgs} args - Arguments to find a Amz_keys
     * @example
     * // Get one Amz_keys
     * const amz_keys = await prisma.amz_keys.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_keysFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_keysFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_keys that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keysFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_keys
     * const amz_keys = await prisma.amz_keys.findMany()
     * 
     * // Get first 10 Amz_keys
     * const amz_keys = await prisma.amz_keys.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_keysWithIdOnly = await prisma.amz_keys.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_keysFindManyArgs>(args?: SelectSubset<T, amz_keysFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_keys.
     * @param {amz_keysCreateArgs} args - Arguments to create a Amz_keys.
     * @example
     * // Create one Amz_keys
     * const Amz_keys = await prisma.amz_keys.create({
     *   data: {
     *     // ... data to create a Amz_keys
     *   }
     * })
     * 
     */
    create<T extends amz_keysCreateArgs>(args: SelectSubset<T, amz_keysCreateArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_keys.
     * @param {amz_keysCreateManyArgs} args - Arguments to create many Amz_keys.
     * @example
     * // Create many Amz_keys
     * const amz_keys = await prisma.amz_keys.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_keysCreateManyArgs>(args?: SelectSubset<T, amz_keysCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_keys.
     * @param {amz_keysDeleteArgs} args - Arguments to delete one Amz_keys.
     * @example
     * // Delete one Amz_keys
     * const Amz_keys = await prisma.amz_keys.delete({
     *   where: {
     *     // ... filter to delete one Amz_keys
     *   }
     * })
     * 
     */
    delete<T extends amz_keysDeleteArgs>(args: SelectSubset<T, amz_keysDeleteArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_keys.
     * @param {amz_keysUpdateArgs} args - Arguments to update one Amz_keys.
     * @example
     * // Update one Amz_keys
     * const amz_keys = await prisma.amz_keys.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_keysUpdateArgs>(args: SelectSubset<T, amz_keysUpdateArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_keys.
     * @param {amz_keysDeleteManyArgs} args - Arguments to filter Amz_keys to delete.
     * @example
     * // Delete a few Amz_keys
     * const { count } = await prisma.amz_keys.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_keysDeleteManyArgs>(args?: SelectSubset<T, amz_keysDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keysUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_keys
     * const amz_keys = await prisma.amz_keys.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_keysUpdateManyArgs>(args: SelectSubset<T, amz_keysUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_keys.
     * @param {amz_keysUpsertArgs} args - Arguments to update or create a Amz_keys.
     * @example
     * // Update or create a Amz_keys
     * const amz_keys = await prisma.amz_keys.upsert({
     *   create: {
     *     // ... data to create a Amz_keys
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_keys we want to update
     *   }
     * })
     */
    upsert<T extends amz_keysUpsertArgs>(args: SelectSubset<T, amz_keysUpsertArgs<ExtArgs>>): Prisma__amz_keysClient<$Result.GetResult<Prisma.$amz_keysPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keysCountArgs} args - Arguments to filter Amz_keys to count.
     * @example
     * // Count the number of Amz_keys
     * const count = await prisma.amz_keys.count({
     *   where: {
     *     // ... the filter for the Amz_keys we want to count
     *   }
     * })
    **/
    count<T extends amz_keysCountArgs>(
      args?: Subset<T, amz_keysCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_keysCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_keysAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_keysAggregateArgs>(args: Subset<T, Amz_keysAggregateArgs>): Prisma.PrismaPromise<GetAmz_keysAggregateType<T>>

    /**
     * Group by Amz_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keysGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_keysGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_keysGroupByArgs['orderBy'] }
        : { orderBy?: amz_keysGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_keysGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_keysGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_keys model
   */
  readonly fields: amz_keysFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_keys.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_keysClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_keys model
   */
  interface amz_keysFieldRefs {
    readonly id: FieldRef<"amz_keys", 'Int'>
    readonly user_id: FieldRef<"amz_keys", 'Int'>
    readonly merchant_id: FieldRef<"amz_keys", 'String'>
    readonly marketplace_id: FieldRef<"amz_keys", 'String'>
    readonly access_key_id: FieldRef<"amz_keys", 'String'>
    readonly secret_access_key: FieldRef<"amz_keys", 'String'>
    readonly mws_token: FieldRef<"amz_keys", 'String'>
    readonly access_token: FieldRef<"amz_keys", 'String'>
    readonly refresh_token: FieldRef<"amz_keys", 'String'>
    readonly tokengeneratedon: FieldRef<"amz_keys", 'DateTime'>
    readonly valid: FieldRef<"amz_keys", 'Boolean'>
    readonly country: FieldRef<"amz_keys", 'String'>
    readonly amazon_website: FieldRef<"amz_keys", 'String'>
    readonly product_import: FieldRef<"amz_keys", 'Boolean'>
    readonly inventory_sync: FieldRef<"amz_keys", 'Boolean'>
    readonly lastdatafetched: FieldRef<"amz_keys", 'DateTime'>
    readonly lastfbafetched: FieldRef<"amz_keys", 'DateTime'>
    readonly lastordersfetched: FieldRef<"amz_keys", 'DateTime'>
    readonly dateofmodification: FieldRef<"amz_keys", 'DateTime'>
    readonly temp: FieldRef<"amz_keys", 'String'>
    readonly created_at: FieldRef<"amz_keys", 'DateTime'>
    readonly updated_at: FieldRef<"amz_keys", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_keys findUnique
   */
  export type amz_keysFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys to fetch.
     */
    where: amz_keysWhereUniqueInput
  }

  /**
   * amz_keys findUniqueOrThrow
   */
  export type amz_keysFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys to fetch.
     */
    where: amz_keysWhereUniqueInput
  }

  /**
   * amz_keys findFirst
   */
  export type amz_keysFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys to fetch.
     */
    where?: amz_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys to fetch.
     */
    orderBy?: amz_keysOrderByWithRelationInput | amz_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_keys.
     */
    cursor?: amz_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_keys.
     */
    distinct?: Amz_keysScalarFieldEnum | Amz_keysScalarFieldEnum[]
  }

  /**
   * amz_keys findFirstOrThrow
   */
  export type amz_keysFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys to fetch.
     */
    where?: amz_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys to fetch.
     */
    orderBy?: amz_keysOrderByWithRelationInput | amz_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_keys.
     */
    cursor?: amz_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_keys.
     */
    distinct?: Amz_keysScalarFieldEnum | Amz_keysScalarFieldEnum[]
  }

  /**
   * amz_keys findMany
   */
  export type amz_keysFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys to fetch.
     */
    where?: amz_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys to fetch.
     */
    orderBy?: amz_keysOrderByWithRelationInput | amz_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_keys.
     */
    cursor?: amz_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys.
     */
    skip?: number
    distinct?: Amz_keysScalarFieldEnum | Amz_keysScalarFieldEnum[]
  }

  /**
   * amz_keys create
   */
  export type amz_keysCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_keys.
     */
    data: XOR<amz_keysCreateInput, amz_keysUncheckedCreateInput>
  }

  /**
   * amz_keys createMany
   */
  export type amz_keysCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_keys.
     */
    data: amz_keysCreateManyInput | amz_keysCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_keys update
   */
  export type amz_keysUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_keys.
     */
    data: XOR<amz_keysUpdateInput, amz_keysUncheckedUpdateInput>
    /**
     * Choose, which amz_keys to update.
     */
    where: amz_keysWhereUniqueInput
  }

  /**
   * amz_keys updateMany
   */
  export type amz_keysUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_keys.
     */
    data: XOR<amz_keysUpdateManyMutationInput, amz_keysUncheckedUpdateManyInput>
    /**
     * Filter which amz_keys to update
     */
    where?: amz_keysWhereInput
    /**
     * Limit how many amz_keys to update.
     */
    limit?: number
  }

  /**
   * amz_keys upsert
   */
  export type amz_keysUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_keys to update in case it exists.
     */
    where: amz_keysWhereUniqueInput
    /**
     * In case the amz_keys found by the `where` argument doesn't exist, create a new amz_keys with this data.
     */
    create: XOR<amz_keysCreateInput, amz_keysUncheckedCreateInput>
    /**
     * In case the amz_keys was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_keysUpdateInput, amz_keysUncheckedUpdateInput>
  }

  /**
   * amz_keys delete
   */
  export type amz_keysDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
    /**
     * Filter which amz_keys to delete.
     */
    where: amz_keysWhereUniqueInput
  }

  /**
   * amz_keys deleteMany
   */
  export type amz_keysDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_keys to delete
     */
    where?: amz_keysWhereInput
    /**
     * Limit how many amz_keys to delete.
     */
    limit?: number
  }

  /**
   * amz_keys without action
   */
  export type amz_keysDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys
     */
    select?: amz_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys
     */
    omit?: amz_keysOmit<ExtArgs> | null
  }


  /**
   * Model amz_keys_backup
   */

  export type AggregateAmz_keys_backup = {
    _count: Amz_keys_backupCountAggregateOutputType | null
    _avg: Amz_keys_backupAvgAggregateOutputType | null
    _sum: Amz_keys_backupSumAggregateOutputType | null
    _min: Amz_keys_backupMinAggregateOutputType | null
    _max: Amz_keys_backupMaxAggregateOutputType | null
  }

  export type Amz_keys_backupAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_keys_backupSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_keys_backupMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    merchant_id: string | null
    marketplace_id: string | null
    access_key_id: string | null
    secret_access_key: string | null
    mws_token: string | null
    valid: boolean | null
    country: string | null
    amazon_website: string | null
    product_import: boolean | null
    inventory_sync: boolean | null
    lastdatafetched: Date | null
    lastfbafetched: Date | null
    lastordersfetched: Date | null
    dateofmodification: Date | null
    temp: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_keys_backupMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    merchant_id: string | null
    marketplace_id: string | null
    access_key_id: string | null
    secret_access_key: string | null
    mws_token: string | null
    valid: boolean | null
    country: string | null
    amazon_website: string | null
    product_import: boolean | null
    inventory_sync: boolean | null
    lastdatafetched: Date | null
    lastfbafetched: Date | null
    lastordersfetched: Date | null
    dateofmodification: Date | null
    temp: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_keys_backupCountAggregateOutputType = {
    id: number
    user_id: number
    merchant_id: number
    marketplace_id: number
    access_key_id: number
    secret_access_key: number
    mws_token: number
    valid: number
    country: number
    amazon_website: number
    product_import: number
    inventory_sync: number
    lastdatafetched: number
    lastfbafetched: number
    lastordersfetched: number
    dateofmodification: number
    temp: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Amz_keys_backupAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_keys_backupSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_keys_backupMinAggregateInputType = {
    id?: true
    user_id?: true
    merchant_id?: true
    marketplace_id?: true
    access_key_id?: true
    secret_access_key?: true
    mws_token?: true
    valid?: true
    country?: true
    amazon_website?: true
    product_import?: true
    inventory_sync?: true
    lastdatafetched?: true
    lastfbafetched?: true
    lastordersfetched?: true
    dateofmodification?: true
    temp?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_keys_backupMaxAggregateInputType = {
    id?: true
    user_id?: true
    merchant_id?: true
    marketplace_id?: true
    access_key_id?: true
    secret_access_key?: true
    mws_token?: true
    valid?: true
    country?: true
    amazon_website?: true
    product_import?: true
    inventory_sync?: true
    lastdatafetched?: true
    lastfbafetched?: true
    lastordersfetched?: true
    dateofmodification?: true
    temp?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_keys_backupCountAggregateInputType = {
    id?: true
    user_id?: true
    merchant_id?: true
    marketplace_id?: true
    access_key_id?: true
    secret_access_key?: true
    mws_token?: true
    valid?: true
    country?: true
    amazon_website?: true
    product_import?: true
    inventory_sync?: true
    lastdatafetched?: true
    lastfbafetched?: true
    lastordersfetched?: true
    dateofmodification?: true
    temp?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Amz_keys_backupAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_keys_backup to aggregate.
     */
    where?: amz_keys_backupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys_backups to fetch.
     */
    orderBy?: amz_keys_backupOrderByWithRelationInput | amz_keys_backupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_keys_backupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys_backups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys_backups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_keys_backups
    **/
    _count?: true | Amz_keys_backupCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_keys_backupAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_keys_backupSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_keys_backupMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_keys_backupMaxAggregateInputType
  }

  export type GetAmz_keys_backupAggregateType<T extends Amz_keys_backupAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_keys_backup]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_keys_backup[P]>
      : GetScalarType<T[P], AggregateAmz_keys_backup[P]>
  }




  export type amz_keys_backupGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_keys_backupWhereInput
    orderBy?: amz_keys_backupOrderByWithAggregationInput | amz_keys_backupOrderByWithAggregationInput[]
    by: Amz_keys_backupScalarFieldEnum[] | Amz_keys_backupScalarFieldEnum
    having?: amz_keys_backupScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_keys_backupCountAggregateInputType | true
    _avg?: Amz_keys_backupAvgAggregateInputType
    _sum?: Amz_keys_backupSumAggregateInputType
    _min?: Amz_keys_backupMinAggregateInputType
    _max?: Amz_keys_backupMaxAggregateInputType
  }

  export type Amz_keys_backupGroupByOutputType = {
    id: number
    user_id: number
    merchant_id: string
    marketplace_id: string
    access_key_id: string
    secret_access_key: string
    mws_token: string
    valid: boolean
    country: string
    amazon_website: string
    product_import: boolean
    inventory_sync: boolean
    lastdatafetched: Date
    lastfbafetched: Date
    lastordersfetched: Date
    dateofmodification: Date
    temp: string
    created_at: Date
    updated_at: Date
    _count: Amz_keys_backupCountAggregateOutputType | null
    _avg: Amz_keys_backupAvgAggregateOutputType | null
    _sum: Amz_keys_backupSumAggregateOutputType | null
    _min: Amz_keys_backupMinAggregateOutputType | null
    _max: Amz_keys_backupMaxAggregateOutputType | null
  }

  type GetAmz_keys_backupGroupByPayload<T extends amz_keys_backupGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_keys_backupGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_keys_backupGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_keys_backupGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_keys_backupGroupByOutputType[P]>
        }
      >
    >


  export type amz_keys_backupSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    merchant_id?: boolean
    marketplace_id?: boolean
    access_key_id?: boolean
    secret_access_key?: boolean
    mws_token?: boolean
    valid?: boolean
    country?: boolean
    amazon_website?: boolean
    product_import?: boolean
    inventory_sync?: boolean
    lastdatafetched?: boolean
    lastfbafetched?: boolean
    lastordersfetched?: boolean
    dateofmodification?: boolean
    temp?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["amz_keys_backup"]>



  export type amz_keys_backupSelectScalar = {
    id?: boolean
    user_id?: boolean
    merchant_id?: boolean
    marketplace_id?: boolean
    access_key_id?: boolean
    secret_access_key?: boolean
    mws_token?: boolean
    valid?: boolean
    country?: boolean
    amazon_website?: boolean
    product_import?: boolean
    inventory_sync?: boolean
    lastdatafetched?: boolean
    lastfbafetched?: boolean
    lastordersfetched?: boolean
    dateofmodification?: boolean
    temp?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type amz_keys_backupOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "merchant_id" | "marketplace_id" | "access_key_id" | "secret_access_key" | "mws_token" | "valid" | "country" | "amazon_website" | "product_import" | "inventory_sync" | "lastdatafetched" | "lastfbafetched" | "lastordersfetched" | "dateofmodification" | "temp" | "created_at" | "updated_at", ExtArgs["result"]["amz_keys_backup"]>

  export type $amz_keys_backupPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_keys_backup"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      merchant_id: string
      marketplace_id: string
      access_key_id: string
      secret_access_key: string
      mws_token: string
      valid: boolean
      country: string
      amazon_website: string
      product_import: boolean
      inventory_sync: boolean
      lastdatafetched: Date
      lastfbafetched: Date
      lastordersfetched: Date
      dateofmodification: Date
      temp: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["amz_keys_backup"]>
    composites: {}
  }

  type amz_keys_backupGetPayload<S extends boolean | null | undefined | amz_keys_backupDefaultArgs> = $Result.GetResult<Prisma.$amz_keys_backupPayload, S>

  type amz_keys_backupCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_keys_backupFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_keys_backupCountAggregateInputType | true
    }

  export interface amz_keys_backupDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_keys_backup'], meta: { name: 'amz_keys_backup' } }
    /**
     * Find zero or one Amz_keys_backup that matches the filter.
     * @param {amz_keys_backupFindUniqueArgs} args - Arguments to find a Amz_keys_backup
     * @example
     * // Get one Amz_keys_backup
     * const amz_keys_backup = await prisma.amz_keys_backup.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_keys_backupFindUniqueArgs>(args: SelectSubset<T, amz_keys_backupFindUniqueArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_keys_backup that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_keys_backupFindUniqueOrThrowArgs} args - Arguments to find a Amz_keys_backup
     * @example
     * // Get one Amz_keys_backup
     * const amz_keys_backup = await prisma.amz_keys_backup.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_keys_backupFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_keys_backupFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_keys_backup that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keys_backupFindFirstArgs} args - Arguments to find a Amz_keys_backup
     * @example
     * // Get one Amz_keys_backup
     * const amz_keys_backup = await prisma.amz_keys_backup.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_keys_backupFindFirstArgs>(args?: SelectSubset<T, amz_keys_backupFindFirstArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_keys_backup that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keys_backupFindFirstOrThrowArgs} args - Arguments to find a Amz_keys_backup
     * @example
     * // Get one Amz_keys_backup
     * const amz_keys_backup = await prisma.amz_keys_backup.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_keys_backupFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_keys_backupFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_keys_backups that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keys_backupFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_keys_backups
     * const amz_keys_backups = await prisma.amz_keys_backup.findMany()
     * 
     * // Get first 10 Amz_keys_backups
     * const amz_keys_backups = await prisma.amz_keys_backup.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_keys_backupWithIdOnly = await prisma.amz_keys_backup.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_keys_backupFindManyArgs>(args?: SelectSubset<T, amz_keys_backupFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_keys_backup.
     * @param {amz_keys_backupCreateArgs} args - Arguments to create a Amz_keys_backup.
     * @example
     * // Create one Amz_keys_backup
     * const Amz_keys_backup = await prisma.amz_keys_backup.create({
     *   data: {
     *     // ... data to create a Amz_keys_backup
     *   }
     * })
     * 
     */
    create<T extends amz_keys_backupCreateArgs>(args: SelectSubset<T, amz_keys_backupCreateArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_keys_backups.
     * @param {amz_keys_backupCreateManyArgs} args - Arguments to create many Amz_keys_backups.
     * @example
     * // Create many Amz_keys_backups
     * const amz_keys_backup = await prisma.amz_keys_backup.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_keys_backupCreateManyArgs>(args?: SelectSubset<T, amz_keys_backupCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_keys_backup.
     * @param {amz_keys_backupDeleteArgs} args - Arguments to delete one Amz_keys_backup.
     * @example
     * // Delete one Amz_keys_backup
     * const Amz_keys_backup = await prisma.amz_keys_backup.delete({
     *   where: {
     *     // ... filter to delete one Amz_keys_backup
     *   }
     * })
     * 
     */
    delete<T extends amz_keys_backupDeleteArgs>(args: SelectSubset<T, amz_keys_backupDeleteArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_keys_backup.
     * @param {amz_keys_backupUpdateArgs} args - Arguments to update one Amz_keys_backup.
     * @example
     * // Update one Amz_keys_backup
     * const amz_keys_backup = await prisma.amz_keys_backup.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_keys_backupUpdateArgs>(args: SelectSubset<T, amz_keys_backupUpdateArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_keys_backups.
     * @param {amz_keys_backupDeleteManyArgs} args - Arguments to filter Amz_keys_backups to delete.
     * @example
     * // Delete a few Amz_keys_backups
     * const { count } = await prisma.amz_keys_backup.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_keys_backupDeleteManyArgs>(args?: SelectSubset<T, amz_keys_backupDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_keys_backups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keys_backupUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_keys_backups
     * const amz_keys_backup = await prisma.amz_keys_backup.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_keys_backupUpdateManyArgs>(args: SelectSubset<T, amz_keys_backupUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_keys_backup.
     * @param {amz_keys_backupUpsertArgs} args - Arguments to update or create a Amz_keys_backup.
     * @example
     * // Update or create a Amz_keys_backup
     * const amz_keys_backup = await prisma.amz_keys_backup.upsert({
     *   create: {
     *     // ... data to create a Amz_keys_backup
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_keys_backup we want to update
     *   }
     * })
     */
    upsert<T extends amz_keys_backupUpsertArgs>(args: SelectSubset<T, amz_keys_backupUpsertArgs<ExtArgs>>): Prisma__amz_keys_backupClient<$Result.GetResult<Prisma.$amz_keys_backupPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_keys_backups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keys_backupCountArgs} args - Arguments to filter Amz_keys_backups to count.
     * @example
     * // Count the number of Amz_keys_backups
     * const count = await prisma.amz_keys_backup.count({
     *   where: {
     *     // ... the filter for the Amz_keys_backups we want to count
     *   }
     * })
    **/
    count<T extends amz_keys_backupCountArgs>(
      args?: Subset<T, amz_keys_backupCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_keys_backupCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_keys_backup.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_keys_backupAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_keys_backupAggregateArgs>(args: Subset<T, Amz_keys_backupAggregateArgs>): Prisma.PrismaPromise<GetAmz_keys_backupAggregateType<T>>

    /**
     * Group by Amz_keys_backup.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_keys_backupGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_keys_backupGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_keys_backupGroupByArgs['orderBy'] }
        : { orderBy?: amz_keys_backupGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_keys_backupGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_keys_backupGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_keys_backup model
   */
  readonly fields: amz_keys_backupFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_keys_backup.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_keys_backupClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_keys_backup model
   */
  interface amz_keys_backupFieldRefs {
    readonly id: FieldRef<"amz_keys_backup", 'Int'>
    readonly user_id: FieldRef<"amz_keys_backup", 'Int'>
    readonly merchant_id: FieldRef<"amz_keys_backup", 'String'>
    readonly marketplace_id: FieldRef<"amz_keys_backup", 'String'>
    readonly access_key_id: FieldRef<"amz_keys_backup", 'String'>
    readonly secret_access_key: FieldRef<"amz_keys_backup", 'String'>
    readonly mws_token: FieldRef<"amz_keys_backup", 'String'>
    readonly valid: FieldRef<"amz_keys_backup", 'Boolean'>
    readonly country: FieldRef<"amz_keys_backup", 'String'>
    readonly amazon_website: FieldRef<"amz_keys_backup", 'String'>
    readonly product_import: FieldRef<"amz_keys_backup", 'Boolean'>
    readonly inventory_sync: FieldRef<"amz_keys_backup", 'Boolean'>
    readonly lastdatafetched: FieldRef<"amz_keys_backup", 'DateTime'>
    readonly lastfbafetched: FieldRef<"amz_keys_backup", 'DateTime'>
    readonly lastordersfetched: FieldRef<"amz_keys_backup", 'DateTime'>
    readonly dateofmodification: FieldRef<"amz_keys_backup", 'DateTime'>
    readonly temp: FieldRef<"amz_keys_backup", 'String'>
    readonly created_at: FieldRef<"amz_keys_backup", 'DateTime'>
    readonly updated_at: FieldRef<"amz_keys_backup", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_keys_backup findUnique
   */
  export type amz_keys_backupFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys_backup to fetch.
     */
    where: amz_keys_backupWhereUniqueInput
  }

  /**
   * amz_keys_backup findUniqueOrThrow
   */
  export type amz_keys_backupFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys_backup to fetch.
     */
    where: amz_keys_backupWhereUniqueInput
  }

  /**
   * amz_keys_backup findFirst
   */
  export type amz_keys_backupFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys_backup to fetch.
     */
    where?: amz_keys_backupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys_backups to fetch.
     */
    orderBy?: amz_keys_backupOrderByWithRelationInput | amz_keys_backupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_keys_backups.
     */
    cursor?: amz_keys_backupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys_backups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys_backups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_keys_backups.
     */
    distinct?: Amz_keys_backupScalarFieldEnum | Amz_keys_backupScalarFieldEnum[]
  }

  /**
   * amz_keys_backup findFirstOrThrow
   */
  export type amz_keys_backupFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys_backup to fetch.
     */
    where?: amz_keys_backupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys_backups to fetch.
     */
    orderBy?: amz_keys_backupOrderByWithRelationInput | amz_keys_backupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_keys_backups.
     */
    cursor?: amz_keys_backupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys_backups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys_backups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_keys_backups.
     */
    distinct?: Amz_keys_backupScalarFieldEnum | Amz_keys_backupScalarFieldEnum[]
  }

  /**
   * amz_keys_backup findMany
   */
  export type amz_keys_backupFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * Filter, which amz_keys_backups to fetch.
     */
    where?: amz_keys_backupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_keys_backups to fetch.
     */
    orderBy?: amz_keys_backupOrderByWithRelationInput | amz_keys_backupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_keys_backups.
     */
    cursor?: amz_keys_backupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_keys_backups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_keys_backups.
     */
    skip?: number
    distinct?: Amz_keys_backupScalarFieldEnum | Amz_keys_backupScalarFieldEnum[]
  }

  /**
   * amz_keys_backup create
   */
  export type amz_keys_backupCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_keys_backup.
     */
    data: XOR<amz_keys_backupCreateInput, amz_keys_backupUncheckedCreateInput>
  }

  /**
   * amz_keys_backup createMany
   */
  export type amz_keys_backupCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_keys_backups.
     */
    data: amz_keys_backupCreateManyInput | amz_keys_backupCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_keys_backup update
   */
  export type amz_keys_backupUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_keys_backup.
     */
    data: XOR<amz_keys_backupUpdateInput, amz_keys_backupUncheckedUpdateInput>
    /**
     * Choose, which amz_keys_backup to update.
     */
    where: amz_keys_backupWhereUniqueInput
  }

  /**
   * amz_keys_backup updateMany
   */
  export type amz_keys_backupUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_keys_backups.
     */
    data: XOR<amz_keys_backupUpdateManyMutationInput, amz_keys_backupUncheckedUpdateManyInput>
    /**
     * Filter which amz_keys_backups to update
     */
    where?: amz_keys_backupWhereInput
    /**
     * Limit how many amz_keys_backups to update.
     */
    limit?: number
  }

  /**
   * amz_keys_backup upsert
   */
  export type amz_keys_backupUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_keys_backup to update in case it exists.
     */
    where: amz_keys_backupWhereUniqueInput
    /**
     * In case the amz_keys_backup found by the `where` argument doesn't exist, create a new amz_keys_backup with this data.
     */
    create: XOR<amz_keys_backupCreateInput, amz_keys_backupUncheckedCreateInput>
    /**
     * In case the amz_keys_backup was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_keys_backupUpdateInput, amz_keys_backupUncheckedUpdateInput>
  }

  /**
   * amz_keys_backup delete
   */
  export type amz_keys_backupDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
    /**
     * Filter which amz_keys_backup to delete.
     */
    where: amz_keys_backupWhereUniqueInput
  }

  /**
   * amz_keys_backup deleteMany
   */
  export type amz_keys_backupDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_keys_backups to delete
     */
    where?: amz_keys_backupWhereInput
    /**
     * Limit how many amz_keys_backups to delete.
     */
    limit?: number
  }

  /**
   * amz_keys_backup without action
   */
  export type amz_keys_backupDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_keys_backup
     */
    select?: amz_keys_backupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_keys_backup
     */
    omit?: amz_keys_backupOmit<ExtArgs> | null
  }


  /**
   * Model amz_orders
   */

  export type AggregateAmz_orders = {
    _count: Amz_ordersCountAggregateOutputType | null
    _avg: Amz_ordersAvgAggregateOutputType | null
    _sum: Amz_ordersSumAggregateOutputType | null
    _min: Amz_ordersMinAggregateOutputType | null
    _max: Amz_ordersMaxAggregateOutputType | null
  }

  export type Amz_ordersAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_ordersSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_ordersMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    amz_order_id: string | null
    amz_order_response: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_ordersMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    amz_order_id: string | null
    amz_order_response: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_ordersCountAggregateOutputType = {
    id: number
    user_id: number
    amz_order_id: number
    amz_order_response: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Amz_ordersAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_ordersSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_ordersMinAggregateInputType = {
    id?: true
    user_id?: true
    amz_order_id?: true
    amz_order_response?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_ordersMaxAggregateInputType = {
    id?: true
    user_id?: true
    amz_order_id?: true
    amz_order_response?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_ordersCountAggregateInputType = {
    id?: true
    user_id?: true
    amz_order_id?: true
    amz_order_response?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Amz_ordersAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_orders to aggregate.
     */
    where?: amz_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_orders to fetch.
     */
    orderBy?: amz_ordersOrderByWithRelationInput | amz_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_orders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_orders
    **/
    _count?: true | Amz_ordersCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_ordersAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_ordersSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_ordersMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_ordersMaxAggregateInputType
  }

  export type GetAmz_ordersAggregateType<T extends Amz_ordersAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_orders]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_orders[P]>
      : GetScalarType<T[P], AggregateAmz_orders[P]>
  }




  export type amz_ordersGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_ordersWhereInput
    orderBy?: amz_ordersOrderByWithAggregationInput | amz_ordersOrderByWithAggregationInput[]
    by: Amz_ordersScalarFieldEnum[] | Amz_ordersScalarFieldEnum
    having?: amz_ordersScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_ordersCountAggregateInputType | true
    _avg?: Amz_ordersAvgAggregateInputType
    _sum?: Amz_ordersSumAggregateInputType
    _min?: Amz_ordersMinAggregateInputType
    _max?: Amz_ordersMaxAggregateInputType
  }

  export type Amz_ordersGroupByOutputType = {
    id: number
    user_id: number
    amz_order_id: string
    amz_order_response: string
    created_at: Date
    updated_at: Date
    _count: Amz_ordersCountAggregateOutputType | null
    _avg: Amz_ordersAvgAggregateOutputType | null
    _sum: Amz_ordersSumAggregateOutputType | null
    _min: Amz_ordersMinAggregateOutputType | null
    _max: Amz_ordersMaxAggregateOutputType | null
  }

  type GetAmz_ordersGroupByPayload<T extends amz_ordersGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_ordersGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_ordersGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_ordersGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_ordersGroupByOutputType[P]>
        }
      >
    >


  export type amz_ordersSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    amz_order_id?: boolean
    amz_order_response?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["amz_orders"]>



  export type amz_ordersSelectScalar = {
    id?: boolean
    user_id?: boolean
    amz_order_id?: boolean
    amz_order_response?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type amz_ordersOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "amz_order_id" | "amz_order_response" | "created_at" | "updated_at", ExtArgs["result"]["amz_orders"]>

  export type $amz_ordersPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_orders"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      amz_order_id: string
      amz_order_response: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["amz_orders"]>
    composites: {}
  }

  type amz_ordersGetPayload<S extends boolean | null | undefined | amz_ordersDefaultArgs> = $Result.GetResult<Prisma.$amz_ordersPayload, S>

  type amz_ordersCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_ordersFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_ordersCountAggregateInputType | true
    }

  export interface amz_ordersDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_orders'], meta: { name: 'amz_orders' } }
    /**
     * Find zero or one Amz_orders that matches the filter.
     * @param {amz_ordersFindUniqueArgs} args - Arguments to find a Amz_orders
     * @example
     * // Get one Amz_orders
     * const amz_orders = await prisma.amz_orders.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_ordersFindUniqueArgs>(args: SelectSubset<T, amz_ordersFindUniqueArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_orders that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_ordersFindUniqueOrThrowArgs} args - Arguments to find a Amz_orders
     * @example
     * // Get one Amz_orders
     * const amz_orders = await prisma.amz_orders.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_ordersFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_ordersFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_orders that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_ordersFindFirstArgs} args - Arguments to find a Amz_orders
     * @example
     * // Get one Amz_orders
     * const amz_orders = await prisma.amz_orders.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_ordersFindFirstArgs>(args?: SelectSubset<T, amz_ordersFindFirstArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_orders that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_ordersFindFirstOrThrowArgs} args - Arguments to find a Amz_orders
     * @example
     * // Get one Amz_orders
     * const amz_orders = await prisma.amz_orders.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_ordersFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_ordersFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_orders that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_ordersFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_orders
     * const amz_orders = await prisma.amz_orders.findMany()
     * 
     * // Get first 10 Amz_orders
     * const amz_orders = await prisma.amz_orders.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_ordersWithIdOnly = await prisma.amz_orders.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_ordersFindManyArgs>(args?: SelectSubset<T, amz_ordersFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_orders.
     * @param {amz_ordersCreateArgs} args - Arguments to create a Amz_orders.
     * @example
     * // Create one Amz_orders
     * const Amz_orders = await prisma.amz_orders.create({
     *   data: {
     *     // ... data to create a Amz_orders
     *   }
     * })
     * 
     */
    create<T extends amz_ordersCreateArgs>(args: SelectSubset<T, amz_ordersCreateArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_orders.
     * @param {amz_ordersCreateManyArgs} args - Arguments to create many Amz_orders.
     * @example
     * // Create many Amz_orders
     * const amz_orders = await prisma.amz_orders.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_ordersCreateManyArgs>(args?: SelectSubset<T, amz_ordersCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_orders.
     * @param {amz_ordersDeleteArgs} args - Arguments to delete one Amz_orders.
     * @example
     * // Delete one Amz_orders
     * const Amz_orders = await prisma.amz_orders.delete({
     *   where: {
     *     // ... filter to delete one Amz_orders
     *   }
     * })
     * 
     */
    delete<T extends amz_ordersDeleteArgs>(args: SelectSubset<T, amz_ordersDeleteArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_orders.
     * @param {amz_ordersUpdateArgs} args - Arguments to update one Amz_orders.
     * @example
     * // Update one Amz_orders
     * const amz_orders = await prisma.amz_orders.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_ordersUpdateArgs>(args: SelectSubset<T, amz_ordersUpdateArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_orders.
     * @param {amz_ordersDeleteManyArgs} args - Arguments to filter Amz_orders to delete.
     * @example
     * // Delete a few Amz_orders
     * const { count } = await prisma.amz_orders.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_ordersDeleteManyArgs>(args?: SelectSubset<T, amz_ordersDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_ordersUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_orders
     * const amz_orders = await prisma.amz_orders.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_ordersUpdateManyArgs>(args: SelectSubset<T, amz_ordersUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_orders.
     * @param {amz_ordersUpsertArgs} args - Arguments to update or create a Amz_orders.
     * @example
     * // Update or create a Amz_orders
     * const amz_orders = await prisma.amz_orders.upsert({
     *   create: {
     *     // ... data to create a Amz_orders
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_orders we want to update
     *   }
     * })
     */
    upsert<T extends amz_ordersUpsertArgs>(args: SelectSubset<T, amz_ordersUpsertArgs<ExtArgs>>): Prisma__amz_ordersClient<$Result.GetResult<Prisma.$amz_ordersPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_ordersCountArgs} args - Arguments to filter Amz_orders to count.
     * @example
     * // Count the number of Amz_orders
     * const count = await prisma.amz_orders.count({
     *   where: {
     *     // ... the filter for the Amz_orders we want to count
     *   }
     * })
    **/
    count<T extends amz_ordersCountArgs>(
      args?: Subset<T, amz_ordersCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_ordersCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_ordersAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_ordersAggregateArgs>(args: Subset<T, Amz_ordersAggregateArgs>): Prisma.PrismaPromise<GetAmz_ordersAggregateType<T>>

    /**
     * Group by Amz_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_ordersGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_ordersGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_ordersGroupByArgs['orderBy'] }
        : { orderBy?: amz_ordersGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_ordersGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_ordersGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_orders model
   */
  readonly fields: amz_ordersFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_orders.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_ordersClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_orders model
   */
  interface amz_ordersFieldRefs {
    readonly id: FieldRef<"amz_orders", 'Int'>
    readonly user_id: FieldRef<"amz_orders", 'Int'>
    readonly amz_order_id: FieldRef<"amz_orders", 'String'>
    readonly amz_order_response: FieldRef<"amz_orders", 'String'>
    readonly created_at: FieldRef<"amz_orders", 'DateTime'>
    readonly updated_at: FieldRef<"amz_orders", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_orders findUnique
   */
  export type amz_ordersFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * Filter, which amz_orders to fetch.
     */
    where: amz_ordersWhereUniqueInput
  }

  /**
   * amz_orders findUniqueOrThrow
   */
  export type amz_ordersFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * Filter, which amz_orders to fetch.
     */
    where: amz_ordersWhereUniqueInput
  }

  /**
   * amz_orders findFirst
   */
  export type amz_ordersFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * Filter, which amz_orders to fetch.
     */
    where?: amz_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_orders to fetch.
     */
    orderBy?: amz_ordersOrderByWithRelationInput | amz_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_orders.
     */
    cursor?: amz_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_orders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_orders.
     */
    distinct?: Amz_ordersScalarFieldEnum | Amz_ordersScalarFieldEnum[]
  }

  /**
   * amz_orders findFirstOrThrow
   */
  export type amz_ordersFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * Filter, which amz_orders to fetch.
     */
    where?: amz_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_orders to fetch.
     */
    orderBy?: amz_ordersOrderByWithRelationInput | amz_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_orders.
     */
    cursor?: amz_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_orders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_orders.
     */
    distinct?: Amz_ordersScalarFieldEnum | Amz_ordersScalarFieldEnum[]
  }

  /**
   * amz_orders findMany
   */
  export type amz_ordersFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * Filter, which amz_orders to fetch.
     */
    where?: amz_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_orders to fetch.
     */
    orderBy?: amz_ordersOrderByWithRelationInput | amz_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_orders.
     */
    cursor?: amz_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_orders.
     */
    skip?: number
    distinct?: Amz_ordersScalarFieldEnum | Amz_ordersScalarFieldEnum[]
  }

  /**
   * amz_orders create
   */
  export type amz_ordersCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_orders.
     */
    data: XOR<amz_ordersCreateInput, amz_ordersUncheckedCreateInput>
  }

  /**
   * amz_orders createMany
   */
  export type amz_ordersCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_orders.
     */
    data: amz_ordersCreateManyInput | amz_ordersCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_orders update
   */
  export type amz_ordersUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_orders.
     */
    data: XOR<amz_ordersUpdateInput, amz_ordersUncheckedUpdateInput>
    /**
     * Choose, which amz_orders to update.
     */
    where: amz_ordersWhereUniqueInput
  }

  /**
   * amz_orders updateMany
   */
  export type amz_ordersUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_orders.
     */
    data: XOR<amz_ordersUpdateManyMutationInput, amz_ordersUncheckedUpdateManyInput>
    /**
     * Filter which amz_orders to update
     */
    where?: amz_ordersWhereInput
    /**
     * Limit how many amz_orders to update.
     */
    limit?: number
  }

  /**
   * amz_orders upsert
   */
  export type amz_ordersUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_orders to update in case it exists.
     */
    where: amz_ordersWhereUniqueInput
    /**
     * In case the amz_orders found by the `where` argument doesn't exist, create a new amz_orders with this data.
     */
    create: XOR<amz_ordersCreateInput, amz_ordersUncheckedCreateInput>
    /**
     * In case the amz_orders was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_ordersUpdateInput, amz_ordersUncheckedUpdateInput>
  }

  /**
   * amz_orders delete
   */
  export type amz_ordersDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
    /**
     * Filter which amz_orders to delete.
     */
    where: amz_ordersWhereUniqueInput
  }

  /**
   * amz_orders deleteMany
   */
  export type amz_ordersDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_orders to delete
     */
    where?: amz_ordersWhereInput
    /**
     * Limit how many amz_orders to delete.
     */
    limit?: number
  }

  /**
   * amz_orders without action
   */
  export type amz_ordersDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_orders
     */
    select?: amz_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_orders
     */
    omit?: amz_ordersOmit<ExtArgs> | null
  }


  /**
   * Model amz_reportrequests
   */

  export type AggregateAmz_reportrequests = {
    _count: Amz_reportrequestsCountAggregateOutputType | null
    _avg: Amz_reportrequestsAvgAggregateOutputType | null
    _sum: Amz_reportrequestsSumAggregateOutputType | null
    _min: Amz_reportrequestsMinAggregateOutputType | null
    _max: Amz_reportrequestsMaxAggregateOutputType | null
  }

  export type Amz_reportrequestsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_reportrequestsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_reportrequestsMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    requestid: string | null
    reportid: string | null
    reporttype: string | null
    status: $Enums.amz_reportrequests_status | null
    inprocess: boolean | null
    resync: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_reportrequestsMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    requestid: string | null
    reportid: string | null
    reporttype: string | null
    status: $Enums.amz_reportrequests_status | null
    inprocess: boolean | null
    resync: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_reportrequestsCountAggregateOutputType = {
    id: number
    user_id: number
    requestid: number
    reportid: number
    reporttype: number
    status: number
    inprocess: number
    resync: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Amz_reportrequestsAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_reportrequestsSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_reportrequestsMinAggregateInputType = {
    id?: true
    user_id?: true
    requestid?: true
    reportid?: true
    reporttype?: true
    status?: true
    inprocess?: true
    resync?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_reportrequestsMaxAggregateInputType = {
    id?: true
    user_id?: true
    requestid?: true
    reportid?: true
    reporttype?: true
    status?: true
    inprocess?: true
    resync?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_reportrequestsCountAggregateInputType = {
    id?: true
    user_id?: true
    requestid?: true
    reportid?: true
    reporttype?: true
    status?: true
    inprocess?: true
    resync?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Amz_reportrequestsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_reportrequests to aggregate.
     */
    where?: amz_reportrequestsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_reportrequests to fetch.
     */
    orderBy?: amz_reportrequestsOrderByWithRelationInput | amz_reportrequestsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_reportrequestsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_reportrequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_reportrequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_reportrequests
    **/
    _count?: true | Amz_reportrequestsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_reportrequestsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_reportrequestsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_reportrequestsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_reportrequestsMaxAggregateInputType
  }

  export type GetAmz_reportrequestsAggregateType<T extends Amz_reportrequestsAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_reportrequests]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_reportrequests[P]>
      : GetScalarType<T[P], AggregateAmz_reportrequests[P]>
  }




  export type amz_reportrequestsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_reportrequestsWhereInput
    orderBy?: amz_reportrequestsOrderByWithAggregationInput | amz_reportrequestsOrderByWithAggregationInput[]
    by: Amz_reportrequestsScalarFieldEnum[] | Amz_reportrequestsScalarFieldEnum
    having?: amz_reportrequestsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_reportrequestsCountAggregateInputType | true
    _avg?: Amz_reportrequestsAvgAggregateInputType
    _sum?: Amz_reportrequestsSumAggregateInputType
    _min?: Amz_reportrequestsMinAggregateInputType
    _max?: Amz_reportrequestsMaxAggregateInputType
  }

  export type Amz_reportrequestsGroupByOutputType = {
    id: number
    user_id: number
    requestid: string
    reportid: string
    reporttype: string
    status: $Enums.amz_reportrequests_status
    inprocess: boolean
    resync: boolean
    created_at: Date
    updated_at: Date
    _count: Amz_reportrequestsCountAggregateOutputType | null
    _avg: Amz_reportrequestsAvgAggregateOutputType | null
    _sum: Amz_reportrequestsSumAggregateOutputType | null
    _min: Amz_reportrequestsMinAggregateOutputType | null
    _max: Amz_reportrequestsMaxAggregateOutputType | null
  }

  type GetAmz_reportrequestsGroupByPayload<T extends amz_reportrequestsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_reportrequestsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_reportrequestsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_reportrequestsGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_reportrequestsGroupByOutputType[P]>
        }
      >
    >


  export type amz_reportrequestsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    requestid?: boolean
    reportid?: boolean
    reporttype?: boolean
    status?: boolean
    inprocess?: boolean
    resync?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["amz_reportrequests"]>



  export type amz_reportrequestsSelectScalar = {
    id?: boolean
    user_id?: boolean
    requestid?: boolean
    reportid?: boolean
    reporttype?: boolean
    status?: boolean
    inprocess?: boolean
    resync?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type amz_reportrequestsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "requestid" | "reportid" | "reporttype" | "status" | "inprocess" | "resync" | "created_at" | "updated_at", ExtArgs["result"]["amz_reportrequests"]>

  export type $amz_reportrequestsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_reportrequests"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      requestid: string
      reportid: string
      reporttype: string
      status: $Enums.amz_reportrequests_status
      inprocess: boolean
      resync: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["amz_reportrequests"]>
    composites: {}
  }

  type amz_reportrequestsGetPayload<S extends boolean | null | undefined | amz_reportrequestsDefaultArgs> = $Result.GetResult<Prisma.$amz_reportrequestsPayload, S>

  type amz_reportrequestsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_reportrequestsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_reportrequestsCountAggregateInputType | true
    }

  export interface amz_reportrequestsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_reportrequests'], meta: { name: 'amz_reportrequests' } }
    /**
     * Find zero or one Amz_reportrequests that matches the filter.
     * @param {amz_reportrequestsFindUniqueArgs} args - Arguments to find a Amz_reportrequests
     * @example
     * // Get one Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_reportrequestsFindUniqueArgs>(args: SelectSubset<T, amz_reportrequestsFindUniqueArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_reportrequests that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_reportrequestsFindUniqueOrThrowArgs} args - Arguments to find a Amz_reportrequests
     * @example
     * // Get one Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_reportrequestsFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_reportrequestsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_reportrequests that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_reportrequestsFindFirstArgs} args - Arguments to find a Amz_reportrequests
     * @example
     * // Get one Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_reportrequestsFindFirstArgs>(args?: SelectSubset<T, amz_reportrequestsFindFirstArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_reportrequests that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_reportrequestsFindFirstOrThrowArgs} args - Arguments to find a Amz_reportrequests
     * @example
     * // Get one Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_reportrequestsFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_reportrequestsFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_reportrequests that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_reportrequestsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.findMany()
     * 
     * // Get first 10 Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_reportrequestsWithIdOnly = await prisma.amz_reportrequests.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_reportrequestsFindManyArgs>(args?: SelectSubset<T, amz_reportrequestsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_reportrequests.
     * @param {amz_reportrequestsCreateArgs} args - Arguments to create a Amz_reportrequests.
     * @example
     * // Create one Amz_reportrequests
     * const Amz_reportrequests = await prisma.amz_reportrequests.create({
     *   data: {
     *     // ... data to create a Amz_reportrequests
     *   }
     * })
     * 
     */
    create<T extends amz_reportrequestsCreateArgs>(args: SelectSubset<T, amz_reportrequestsCreateArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_reportrequests.
     * @param {amz_reportrequestsCreateManyArgs} args - Arguments to create many Amz_reportrequests.
     * @example
     * // Create many Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_reportrequestsCreateManyArgs>(args?: SelectSubset<T, amz_reportrequestsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_reportrequests.
     * @param {amz_reportrequestsDeleteArgs} args - Arguments to delete one Amz_reportrequests.
     * @example
     * // Delete one Amz_reportrequests
     * const Amz_reportrequests = await prisma.amz_reportrequests.delete({
     *   where: {
     *     // ... filter to delete one Amz_reportrequests
     *   }
     * })
     * 
     */
    delete<T extends amz_reportrequestsDeleteArgs>(args: SelectSubset<T, amz_reportrequestsDeleteArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_reportrequests.
     * @param {amz_reportrequestsUpdateArgs} args - Arguments to update one Amz_reportrequests.
     * @example
     * // Update one Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_reportrequestsUpdateArgs>(args: SelectSubset<T, amz_reportrequestsUpdateArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_reportrequests.
     * @param {amz_reportrequestsDeleteManyArgs} args - Arguments to filter Amz_reportrequests to delete.
     * @example
     * // Delete a few Amz_reportrequests
     * const { count } = await prisma.amz_reportrequests.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_reportrequestsDeleteManyArgs>(args?: SelectSubset<T, amz_reportrequestsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_reportrequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_reportrequestsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_reportrequestsUpdateManyArgs>(args: SelectSubset<T, amz_reportrequestsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_reportrequests.
     * @param {amz_reportrequestsUpsertArgs} args - Arguments to update or create a Amz_reportrequests.
     * @example
     * // Update or create a Amz_reportrequests
     * const amz_reportrequests = await prisma.amz_reportrequests.upsert({
     *   create: {
     *     // ... data to create a Amz_reportrequests
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_reportrequests we want to update
     *   }
     * })
     */
    upsert<T extends amz_reportrequestsUpsertArgs>(args: SelectSubset<T, amz_reportrequestsUpsertArgs<ExtArgs>>): Prisma__amz_reportrequestsClient<$Result.GetResult<Prisma.$amz_reportrequestsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_reportrequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_reportrequestsCountArgs} args - Arguments to filter Amz_reportrequests to count.
     * @example
     * // Count the number of Amz_reportrequests
     * const count = await prisma.amz_reportrequests.count({
     *   where: {
     *     // ... the filter for the Amz_reportrequests we want to count
     *   }
     * })
    **/
    count<T extends amz_reportrequestsCountArgs>(
      args?: Subset<T, amz_reportrequestsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_reportrequestsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_reportrequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_reportrequestsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_reportrequestsAggregateArgs>(args: Subset<T, Amz_reportrequestsAggregateArgs>): Prisma.PrismaPromise<GetAmz_reportrequestsAggregateType<T>>

    /**
     * Group by Amz_reportrequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_reportrequestsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_reportrequestsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_reportrequestsGroupByArgs['orderBy'] }
        : { orderBy?: amz_reportrequestsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_reportrequestsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_reportrequestsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_reportrequests model
   */
  readonly fields: amz_reportrequestsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_reportrequests.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_reportrequestsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_reportrequests model
   */
  interface amz_reportrequestsFieldRefs {
    readonly id: FieldRef<"amz_reportrequests", 'Int'>
    readonly user_id: FieldRef<"amz_reportrequests", 'Int'>
    readonly requestid: FieldRef<"amz_reportrequests", 'String'>
    readonly reportid: FieldRef<"amz_reportrequests", 'String'>
    readonly reporttype: FieldRef<"amz_reportrequests", 'String'>
    readonly status: FieldRef<"amz_reportrequests", 'amz_reportrequests_status'>
    readonly inprocess: FieldRef<"amz_reportrequests", 'Boolean'>
    readonly resync: FieldRef<"amz_reportrequests", 'Boolean'>
    readonly created_at: FieldRef<"amz_reportrequests", 'DateTime'>
    readonly updated_at: FieldRef<"amz_reportrequests", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_reportrequests findUnique
   */
  export type amz_reportrequestsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * Filter, which amz_reportrequests to fetch.
     */
    where: amz_reportrequestsWhereUniqueInput
  }

  /**
   * amz_reportrequests findUniqueOrThrow
   */
  export type amz_reportrequestsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * Filter, which amz_reportrequests to fetch.
     */
    where: amz_reportrequestsWhereUniqueInput
  }

  /**
   * amz_reportrequests findFirst
   */
  export type amz_reportrequestsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * Filter, which amz_reportrequests to fetch.
     */
    where?: amz_reportrequestsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_reportrequests to fetch.
     */
    orderBy?: amz_reportrequestsOrderByWithRelationInput | amz_reportrequestsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_reportrequests.
     */
    cursor?: amz_reportrequestsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_reportrequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_reportrequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_reportrequests.
     */
    distinct?: Amz_reportrequestsScalarFieldEnum | Amz_reportrequestsScalarFieldEnum[]
  }

  /**
   * amz_reportrequests findFirstOrThrow
   */
  export type amz_reportrequestsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * Filter, which amz_reportrequests to fetch.
     */
    where?: amz_reportrequestsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_reportrequests to fetch.
     */
    orderBy?: amz_reportrequestsOrderByWithRelationInput | amz_reportrequestsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_reportrequests.
     */
    cursor?: amz_reportrequestsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_reportrequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_reportrequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_reportrequests.
     */
    distinct?: Amz_reportrequestsScalarFieldEnum | Amz_reportrequestsScalarFieldEnum[]
  }

  /**
   * amz_reportrequests findMany
   */
  export type amz_reportrequestsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * Filter, which amz_reportrequests to fetch.
     */
    where?: amz_reportrequestsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_reportrequests to fetch.
     */
    orderBy?: amz_reportrequestsOrderByWithRelationInput | amz_reportrequestsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_reportrequests.
     */
    cursor?: amz_reportrequestsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_reportrequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_reportrequests.
     */
    skip?: number
    distinct?: Amz_reportrequestsScalarFieldEnum | Amz_reportrequestsScalarFieldEnum[]
  }

  /**
   * amz_reportrequests create
   */
  export type amz_reportrequestsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_reportrequests.
     */
    data: XOR<amz_reportrequestsCreateInput, amz_reportrequestsUncheckedCreateInput>
  }

  /**
   * amz_reportrequests createMany
   */
  export type amz_reportrequestsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_reportrequests.
     */
    data: amz_reportrequestsCreateManyInput | amz_reportrequestsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_reportrequests update
   */
  export type amz_reportrequestsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_reportrequests.
     */
    data: XOR<amz_reportrequestsUpdateInput, amz_reportrequestsUncheckedUpdateInput>
    /**
     * Choose, which amz_reportrequests to update.
     */
    where: amz_reportrequestsWhereUniqueInput
  }

  /**
   * amz_reportrequests updateMany
   */
  export type amz_reportrequestsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_reportrequests.
     */
    data: XOR<amz_reportrequestsUpdateManyMutationInput, amz_reportrequestsUncheckedUpdateManyInput>
    /**
     * Filter which amz_reportrequests to update
     */
    where?: amz_reportrequestsWhereInput
    /**
     * Limit how many amz_reportrequests to update.
     */
    limit?: number
  }

  /**
   * amz_reportrequests upsert
   */
  export type amz_reportrequestsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_reportrequests to update in case it exists.
     */
    where: amz_reportrequestsWhereUniqueInput
    /**
     * In case the amz_reportrequests found by the `where` argument doesn't exist, create a new amz_reportrequests with this data.
     */
    create: XOR<amz_reportrequestsCreateInput, amz_reportrequestsUncheckedCreateInput>
    /**
     * In case the amz_reportrequests was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_reportrequestsUpdateInput, amz_reportrequestsUncheckedUpdateInput>
  }

  /**
   * amz_reportrequests delete
   */
  export type amz_reportrequestsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
    /**
     * Filter which amz_reportrequests to delete.
     */
    where: amz_reportrequestsWhereUniqueInput
  }

  /**
   * amz_reportrequests deleteMany
   */
  export type amz_reportrequestsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_reportrequests to delete
     */
    where?: amz_reportrequestsWhereInput
    /**
     * Limit how many amz_reportrequests to delete.
     */
    limit?: number
  }

  /**
   * amz_reportrequests without action
   */
  export type amz_reportrequestsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_reportrequests
     */
    select?: amz_reportrequestsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_reportrequests
     */
    omit?: amz_reportrequestsOmit<ExtArgs> | null
  }


  /**
   * Model amz_searchterms
   */

  export type AggregateAmz_searchterms = {
    _count: Amz_searchtermsCountAggregateOutputType | null
    _avg: Amz_searchtermsAvgAggregateOutputType | null
    _sum: Amz_searchtermsSumAggregateOutputType | null
    _min: Amz_searchtermsMinAggregateOutputType | null
    _max: Amz_searchtermsMaxAggregateOutputType | null
  }

  export type Amz_searchtermsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_searchtermsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_searchtermsMinAggregateOutputType = {
    id: number | null
    sku: string | null
    searchterms1: string | null
    searchterms2: string | null
    searchterms3: string | null
    searchterms4: string | null
    searchterms5: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_searchtermsMaxAggregateOutputType = {
    id: number | null
    sku: string | null
    searchterms1: string | null
    searchterms2: string | null
    searchterms3: string | null
    searchterms4: string | null
    searchterms5: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Amz_searchtermsCountAggregateOutputType = {
    id: number
    sku: number
    searchterms1: number
    searchterms2: number
    searchterms3: number
    searchterms4: number
    searchterms5: number
    user_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Amz_searchtermsAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_searchtermsSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_searchtermsMinAggregateInputType = {
    id?: true
    sku?: true
    searchterms1?: true
    searchterms2?: true
    searchterms3?: true
    searchterms4?: true
    searchterms5?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_searchtermsMaxAggregateInputType = {
    id?: true
    sku?: true
    searchterms1?: true
    searchterms2?: true
    searchterms3?: true
    searchterms4?: true
    searchterms5?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Amz_searchtermsCountAggregateInputType = {
    id?: true
    sku?: true
    searchterms1?: true
    searchterms2?: true
    searchterms3?: true
    searchterms4?: true
    searchterms5?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Amz_searchtermsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_searchterms to aggregate.
     */
    where?: amz_searchtermsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_searchterms to fetch.
     */
    orderBy?: amz_searchtermsOrderByWithRelationInput | amz_searchtermsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_searchtermsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_searchterms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_searchterms.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_searchterms
    **/
    _count?: true | Amz_searchtermsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_searchtermsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_searchtermsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_searchtermsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_searchtermsMaxAggregateInputType
  }

  export type GetAmz_searchtermsAggregateType<T extends Amz_searchtermsAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_searchterms]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_searchterms[P]>
      : GetScalarType<T[P], AggregateAmz_searchterms[P]>
  }




  export type amz_searchtermsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_searchtermsWhereInput
    orderBy?: amz_searchtermsOrderByWithAggregationInput | amz_searchtermsOrderByWithAggregationInput[]
    by: Amz_searchtermsScalarFieldEnum[] | Amz_searchtermsScalarFieldEnum
    having?: amz_searchtermsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_searchtermsCountAggregateInputType | true
    _avg?: Amz_searchtermsAvgAggregateInputType
    _sum?: Amz_searchtermsSumAggregateInputType
    _min?: Amz_searchtermsMinAggregateInputType
    _max?: Amz_searchtermsMaxAggregateInputType
  }

  export type Amz_searchtermsGroupByOutputType = {
    id: number
    sku: string
    searchterms1: string
    searchterms2: string
    searchterms3: string
    searchterms4: string
    searchterms5: string
    user_id: number
    created_at: Date
    updated_at: Date
    _count: Amz_searchtermsCountAggregateOutputType | null
    _avg: Amz_searchtermsAvgAggregateOutputType | null
    _sum: Amz_searchtermsSumAggregateOutputType | null
    _min: Amz_searchtermsMinAggregateOutputType | null
    _max: Amz_searchtermsMaxAggregateOutputType | null
  }

  type GetAmz_searchtermsGroupByPayload<T extends amz_searchtermsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_searchtermsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_searchtermsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_searchtermsGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_searchtermsGroupByOutputType[P]>
        }
      >
    >


  export type amz_searchtermsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    sku?: boolean
    searchterms1?: boolean
    searchterms2?: boolean
    searchterms3?: boolean
    searchterms4?: boolean
    searchterms5?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["amz_searchterms"]>



  export type amz_searchtermsSelectScalar = {
    id?: boolean
    sku?: boolean
    searchterms1?: boolean
    searchterms2?: boolean
    searchterms3?: boolean
    searchterms4?: boolean
    searchterms5?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type amz_searchtermsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "sku" | "searchterms1" | "searchterms2" | "searchterms3" | "searchterms4" | "searchterms5" | "user_id" | "created_at" | "updated_at", ExtArgs["result"]["amz_searchterms"]>

  export type $amz_searchtermsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_searchterms"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      sku: string
      searchterms1: string
      searchterms2: string
      searchterms3: string
      searchterms4: string
      searchterms5: string
      user_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["amz_searchterms"]>
    composites: {}
  }

  type amz_searchtermsGetPayload<S extends boolean | null | undefined | amz_searchtermsDefaultArgs> = $Result.GetResult<Prisma.$amz_searchtermsPayload, S>

  type amz_searchtermsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_searchtermsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_searchtermsCountAggregateInputType | true
    }

  export interface amz_searchtermsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_searchterms'], meta: { name: 'amz_searchterms' } }
    /**
     * Find zero or one Amz_searchterms that matches the filter.
     * @param {amz_searchtermsFindUniqueArgs} args - Arguments to find a Amz_searchterms
     * @example
     * // Get one Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_searchtermsFindUniqueArgs>(args: SelectSubset<T, amz_searchtermsFindUniqueArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_searchterms that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_searchtermsFindUniqueOrThrowArgs} args - Arguments to find a Amz_searchterms
     * @example
     * // Get one Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_searchtermsFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_searchtermsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_searchterms that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_searchtermsFindFirstArgs} args - Arguments to find a Amz_searchterms
     * @example
     * // Get one Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_searchtermsFindFirstArgs>(args?: SelectSubset<T, amz_searchtermsFindFirstArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_searchterms that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_searchtermsFindFirstOrThrowArgs} args - Arguments to find a Amz_searchterms
     * @example
     * // Get one Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_searchtermsFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_searchtermsFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_searchterms that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_searchtermsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.findMany()
     * 
     * // Get first 10 Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_searchtermsWithIdOnly = await prisma.amz_searchterms.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_searchtermsFindManyArgs>(args?: SelectSubset<T, amz_searchtermsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_searchterms.
     * @param {amz_searchtermsCreateArgs} args - Arguments to create a Amz_searchterms.
     * @example
     * // Create one Amz_searchterms
     * const Amz_searchterms = await prisma.amz_searchterms.create({
     *   data: {
     *     // ... data to create a Amz_searchterms
     *   }
     * })
     * 
     */
    create<T extends amz_searchtermsCreateArgs>(args: SelectSubset<T, amz_searchtermsCreateArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_searchterms.
     * @param {amz_searchtermsCreateManyArgs} args - Arguments to create many Amz_searchterms.
     * @example
     * // Create many Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_searchtermsCreateManyArgs>(args?: SelectSubset<T, amz_searchtermsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_searchterms.
     * @param {amz_searchtermsDeleteArgs} args - Arguments to delete one Amz_searchterms.
     * @example
     * // Delete one Amz_searchterms
     * const Amz_searchterms = await prisma.amz_searchterms.delete({
     *   where: {
     *     // ... filter to delete one Amz_searchterms
     *   }
     * })
     * 
     */
    delete<T extends amz_searchtermsDeleteArgs>(args: SelectSubset<T, amz_searchtermsDeleteArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_searchterms.
     * @param {amz_searchtermsUpdateArgs} args - Arguments to update one Amz_searchterms.
     * @example
     * // Update one Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_searchtermsUpdateArgs>(args: SelectSubset<T, amz_searchtermsUpdateArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_searchterms.
     * @param {amz_searchtermsDeleteManyArgs} args - Arguments to filter Amz_searchterms to delete.
     * @example
     * // Delete a few Amz_searchterms
     * const { count } = await prisma.amz_searchterms.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_searchtermsDeleteManyArgs>(args?: SelectSubset<T, amz_searchtermsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_searchterms.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_searchtermsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_searchtermsUpdateManyArgs>(args: SelectSubset<T, amz_searchtermsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_searchterms.
     * @param {amz_searchtermsUpsertArgs} args - Arguments to update or create a Amz_searchterms.
     * @example
     * // Update or create a Amz_searchterms
     * const amz_searchterms = await prisma.amz_searchterms.upsert({
     *   create: {
     *     // ... data to create a Amz_searchterms
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_searchterms we want to update
     *   }
     * })
     */
    upsert<T extends amz_searchtermsUpsertArgs>(args: SelectSubset<T, amz_searchtermsUpsertArgs<ExtArgs>>): Prisma__amz_searchtermsClient<$Result.GetResult<Prisma.$amz_searchtermsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_searchterms.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_searchtermsCountArgs} args - Arguments to filter Amz_searchterms to count.
     * @example
     * // Count the number of Amz_searchterms
     * const count = await prisma.amz_searchterms.count({
     *   where: {
     *     // ... the filter for the Amz_searchterms we want to count
     *   }
     * })
    **/
    count<T extends amz_searchtermsCountArgs>(
      args?: Subset<T, amz_searchtermsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_searchtermsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_searchterms.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_searchtermsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_searchtermsAggregateArgs>(args: Subset<T, Amz_searchtermsAggregateArgs>): Prisma.PrismaPromise<GetAmz_searchtermsAggregateType<T>>

    /**
     * Group by Amz_searchterms.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_searchtermsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_searchtermsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_searchtermsGroupByArgs['orderBy'] }
        : { orderBy?: amz_searchtermsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_searchtermsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_searchtermsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_searchterms model
   */
  readonly fields: amz_searchtermsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_searchterms.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_searchtermsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_searchterms model
   */
  interface amz_searchtermsFieldRefs {
    readonly id: FieldRef<"amz_searchterms", 'Int'>
    readonly sku: FieldRef<"amz_searchterms", 'String'>
    readonly searchterms1: FieldRef<"amz_searchterms", 'String'>
    readonly searchterms2: FieldRef<"amz_searchterms", 'String'>
    readonly searchterms3: FieldRef<"amz_searchterms", 'String'>
    readonly searchterms4: FieldRef<"amz_searchterms", 'String'>
    readonly searchterms5: FieldRef<"amz_searchterms", 'String'>
    readonly user_id: FieldRef<"amz_searchterms", 'Int'>
    readonly created_at: FieldRef<"amz_searchterms", 'DateTime'>
    readonly updated_at: FieldRef<"amz_searchterms", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_searchterms findUnique
   */
  export type amz_searchtermsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * Filter, which amz_searchterms to fetch.
     */
    where: amz_searchtermsWhereUniqueInput
  }

  /**
   * amz_searchterms findUniqueOrThrow
   */
  export type amz_searchtermsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * Filter, which amz_searchterms to fetch.
     */
    where: amz_searchtermsWhereUniqueInput
  }

  /**
   * amz_searchterms findFirst
   */
  export type amz_searchtermsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * Filter, which amz_searchterms to fetch.
     */
    where?: amz_searchtermsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_searchterms to fetch.
     */
    orderBy?: amz_searchtermsOrderByWithRelationInput | amz_searchtermsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_searchterms.
     */
    cursor?: amz_searchtermsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_searchterms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_searchterms.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_searchterms.
     */
    distinct?: Amz_searchtermsScalarFieldEnum | Amz_searchtermsScalarFieldEnum[]
  }

  /**
   * amz_searchterms findFirstOrThrow
   */
  export type amz_searchtermsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * Filter, which amz_searchterms to fetch.
     */
    where?: amz_searchtermsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_searchterms to fetch.
     */
    orderBy?: amz_searchtermsOrderByWithRelationInput | amz_searchtermsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_searchterms.
     */
    cursor?: amz_searchtermsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_searchterms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_searchterms.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_searchterms.
     */
    distinct?: Amz_searchtermsScalarFieldEnum | Amz_searchtermsScalarFieldEnum[]
  }

  /**
   * amz_searchterms findMany
   */
  export type amz_searchtermsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * Filter, which amz_searchterms to fetch.
     */
    where?: amz_searchtermsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_searchterms to fetch.
     */
    orderBy?: amz_searchtermsOrderByWithRelationInput | amz_searchtermsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_searchterms.
     */
    cursor?: amz_searchtermsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_searchterms from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_searchterms.
     */
    skip?: number
    distinct?: Amz_searchtermsScalarFieldEnum | Amz_searchtermsScalarFieldEnum[]
  }

  /**
   * amz_searchterms create
   */
  export type amz_searchtermsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_searchterms.
     */
    data: XOR<amz_searchtermsCreateInput, amz_searchtermsUncheckedCreateInput>
  }

  /**
   * amz_searchterms createMany
   */
  export type amz_searchtermsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_searchterms.
     */
    data: amz_searchtermsCreateManyInput | amz_searchtermsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_searchterms update
   */
  export type amz_searchtermsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_searchterms.
     */
    data: XOR<amz_searchtermsUpdateInput, amz_searchtermsUncheckedUpdateInput>
    /**
     * Choose, which amz_searchterms to update.
     */
    where: amz_searchtermsWhereUniqueInput
  }

  /**
   * amz_searchterms updateMany
   */
  export type amz_searchtermsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_searchterms.
     */
    data: XOR<amz_searchtermsUpdateManyMutationInput, amz_searchtermsUncheckedUpdateManyInput>
    /**
     * Filter which amz_searchterms to update
     */
    where?: amz_searchtermsWhereInput
    /**
     * Limit how many amz_searchterms to update.
     */
    limit?: number
  }

  /**
   * amz_searchterms upsert
   */
  export type amz_searchtermsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_searchterms to update in case it exists.
     */
    where: amz_searchtermsWhereUniqueInput
    /**
     * In case the amz_searchterms found by the `where` argument doesn't exist, create a new amz_searchterms with this data.
     */
    create: XOR<amz_searchtermsCreateInput, amz_searchtermsUncheckedCreateInput>
    /**
     * In case the amz_searchterms was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_searchtermsUpdateInput, amz_searchtermsUncheckedUpdateInput>
  }

  /**
   * amz_searchterms delete
   */
  export type amz_searchtermsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
    /**
     * Filter which amz_searchterms to delete.
     */
    where: amz_searchtermsWhereUniqueInput
  }

  /**
   * amz_searchterms deleteMany
   */
  export type amz_searchtermsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_searchterms to delete
     */
    where?: amz_searchtermsWhereInput
    /**
     * Limit how many amz_searchterms to delete.
     */
    limit?: number
  }

  /**
   * amz_searchterms without action
   */
  export type amz_searchtermsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_searchterms
     */
    select?: amz_searchtermsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_searchterms
     */
    omit?: amz_searchtermsOmit<ExtArgs> | null
  }


  /**
   * Model amz_variants
   */

  export type AggregateAmz_variants = {
    _count: Amz_variantsCountAggregateOutputType | null
    _avg: Amz_variantsAvgAggregateOutputType | null
    _sum: Amz_variantsSumAggregateOutputType | null
    _min: Amz_variantsMinAggregateOutputType | null
    _max: Amz_variantsMaxAggregateOutputType | null
  }

  export type Amz_variantsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_variantsSumAggregateOutputType = {
    id: bigint | null
    user_id: number | null
  }

  export type Amz_variantsMinAggregateOutputType = {
    id: bigint | null
    parentasin: string | null
    childasin: string | null
    properties: string | null
    processed: boolean | null
    user_id: number | null
    dateofmodification: Date | null
  }

  export type Amz_variantsMaxAggregateOutputType = {
    id: bigint | null
    parentasin: string | null
    childasin: string | null
    properties: string | null
    processed: boolean | null
    user_id: number | null
    dateofmodification: Date | null
  }

  export type Amz_variantsCountAggregateOutputType = {
    id: number
    parentasin: number
    childasin: number
    properties: number
    processed: number
    user_id: number
    dateofmodification: number
    _all: number
  }


  export type Amz_variantsAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_variantsSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_variantsMinAggregateInputType = {
    id?: true
    parentasin?: true
    childasin?: true
    properties?: true
    processed?: true
    user_id?: true
    dateofmodification?: true
  }

  export type Amz_variantsMaxAggregateInputType = {
    id?: true
    parentasin?: true
    childasin?: true
    properties?: true
    processed?: true
    user_id?: true
    dateofmodification?: true
  }

  export type Amz_variantsCountAggregateInputType = {
    id?: true
    parentasin?: true
    childasin?: true
    properties?: true
    processed?: true
    user_id?: true
    dateofmodification?: true
    _all?: true
  }

  export type Amz_variantsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_variants to aggregate.
     */
    where?: amz_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants to fetch.
     */
    orderBy?: amz_variantsOrderByWithRelationInput | amz_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_variants
    **/
    _count?: true | Amz_variantsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_variantsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_variantsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_variantsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_variantsMaxAggregateInputType
  }

  export type GetAmz_variantsAggregateType<T extends Amz_variantsAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_variants]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_variants[P]>
      : GetScalarType<T[P], AggregateAmz_variants[P]>
  }




  export type amz_variantsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_variantsWhereInput
    orderBy?: amz_variantsOrderByWithAggregationInput | amz_variantsOrderByWithAggregationInput[]
    by: Amz_variantsScalarFieldEnum[] | Amz_variantsScalarFieldEnum
    having?: amz_variantsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_variantsCountAggregateInputType | true
    _avg?: Amz_variantsAvgAggregateInputType
    _sum?: Amz_variantsSumAggregateInputType
    _min?: Amz_variantsMinAggregateInputType
    _max?: Amz_variantsMaxAggregateInputType
  }

  export type Amz_variantsGroupByOutputType = {
    id: bigint
    parentasin: string
    childasin: string
    properties: string
    processed: boolean
    user_id: number
    dateofmodification: Date
    _count: Amz_variantsCountAggregateOutputType | null
    _avg: Amz_variantsAvgAggregateOutputType | null
    _sum: Amz_variantsSumAggregateOutputType | null
    _min: Amz_variantsMinAggregateOutputType | null
    _max: Amz_variantsMaxAggregateOutputType | null
  }

  type GetAmz_variantsGroupByPayload<T extends amz_variantsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_variantsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_variantsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_variantsGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_variantsGroupByOutputType[P]>
        }
      >
    >


  export type amz_variantsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    parentasin?: boolean
    childasin?: boolean
    properties?: boolean
    processed?: boolean
    user_id?: boolean
    dateofmodification?: boolean
  }, ExtArgs["result"]["amz_variants"]>



  export type amz_variantsSelectScalar = {
    id?: boolean
    parentasin?: boolean
    childasin?: boolean
    properties?: boolean
    processed?: boolean
    user_id?: boolean
    dateofmodification?: boolean
  }

  export type amz_variantsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "parentasin" | "childasin" | "properties" | "processed" | "user_id" | "dateofmodification", ExtArgs["result"]["amz_variants"]>

  export type $amz_variantsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_variants"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: bigint
      parentasin: string
      childasin: string
      properties: string
      processed: boolean
      user_id: number
      dateofmodification: Date
    }, ExtArgs["result"]["amz_variants"]>
    composites: {}
  }

  type amz_variantsGetPayload<S extends boolean | null | undefined | amz_variantsDefaultArgs> = $Result.GetResult<Prisma.$amz_variantsPayload, S>

  type amz_variantsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_variantsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_variantsCountAggregateInputType | true
    }

  export interface amz_variantsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_variants'], meta: { name: 'amz_variants' } }
    /**
     * Find zero or one Amz_variants that matches the filter.
     * @param {amz_variantsFindUniqueArgs} args - Arguments to find a Amz_variants
     * @example
     * // Get one Amz_variants
     * const amz_variants = await prisma.amz_variants.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_variantsFindUniqueArgs>(args: SelectSubset<T, amz_variantsFindUniqueArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_variants that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_variantsFindUniqueOrThrowArgs} args - Arguments to find a Amz_variants
     * @example
     * // Get one Amz_variants
     * const amz_variants = await prisma.amz_variants.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_variantsFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_variantsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_variants that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variantsFindFirstArgs} args - Arguments to find a Amz_variants
     * @example
     * // Get one Amz_variants
     * const amz_variants = await prisma.amz_variants.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_variantsFindFirstArgs>(args?: SelectSubset<T, amz_variantsFindFirstArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_variants that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variantsFindFirstOrThrowArgs} args - Arguments to find a Amz_variants
     * @example
     * // Get one Amz_variants
     * const amz_variants = await prisma.amz_variants.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_variantsFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_variantsFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_variants that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variantsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_variants
     * const amz_variants = await prisma.amz_variants.findMany()
     * 
     * // Get first 10 Amz_variants
     * const amz_variants = await prisma.amz_variants.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_variantsWithIdOnly = await prisma.amz_variants.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_variantsFindManyArgs>(args?: SelectSubset<T, amz_variantsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_variants.
     * @param {amz_variantsCreateArgs} args - Arguments to create a Amz_variants.
     * @example
     * // Create one Amz_variants
     * const Amz_variants = await prisma.amz_variants.create({
     *   data: {
     *     // ... data to create a Amz_variants
     *   }
     * })
     * 
     */
    create<T extends amz_variantsCreateArgs>(args: SelectSubset<T, amz_variantsCreateArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_variants.
     * @param {amz_variantsCreateManyArgs} args - Arguments to create many Amz_variants.
     * @example
     * // Create many Amz_variants
     * const amz_variants = await prisma.amz_variants.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_variantsCreateManyArgs>(args?: SelectSubset<T, amz_variantsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_variants.
     * @param {amz_variantsDeleteArgs} args - Arguments to delete one Amz_variants.
     * @example
     * // Delete one Amz_variants
     * const Amz_variants = await prisma.amz_variants.delete({
     *   where: {
     *     // ... filter to delete one Amz_variants
     *   }
     * })
     * 
     */
    delete<T extends amz_variantsDeleteArgs>(args: SelectSubset<T, amz_variantsDeleteArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_variants.
     * @param {amz_variantsUpdateArgs} args - Arguments to update one Amz_variants.
     * @example
     * // Update one Amz_variants
     * const amz_variants = await prisma.amz_variants.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_variantsUpdateArgs>(args: SelectSubset<T, amz_variantsUpdateArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_variants.
     * @param {amz_variantsDeleteManyArgs} args - Arguments to filter Amz_variants to delete.
     * @example
     * // Delete a few Amz_variants
     * const { count } = await prisma.amz_variants.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_variantsDeleteManyArgs>(args?: SelectSubset<T, amz_variantsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variantsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_variants
     * const amz_variants = await prisma.amz_variants.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_variantsUpdateManyArgs>(args: SelectSubset<T, amz_variantsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_variants.
     * @param {amz_variantsUpsertArgs} args - Arguments to update or create a Amz_variants.
     * @example
     * // Update or create a Amz_variants
     * const amz_variants = await prisma.amz_variants.upsert({
     *   create: {
     *     // ... data to create a Amz_variants
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_variants we want to update
     *   }
     * })
     */
    upsert<T extends amz_variantsUpsertArgs>(args: SelectSubset<T, amz_variantsUpsertArgs<ExtArgs>>): Prisma__amz_variantsClient<$Result.GetResult<Prisma.$amz_variantsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variantsCountArgs} args - Arguments to filter Amz_variants to count.
     * @example
     * // Count the number of Amz_variants
     * const count = await prisma.amz_variants.count({
     *   where: {
     *     // ... the filter for the Amz_variants we want to count
     *   }
     * })
    **/
    count<T extends amz_variantsCountArgs>(
      args?: Subset<T, amz_variantsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_variantsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_variantsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_variantsAggregateArgs>(args: Subset<T, Amz_variantsAggregateArgs>): Prisma.PrismaPromise<GetAmz_variantsAggregateType<T>>

    /**
     * Group by Amz_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variantsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_variantsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_variantsGroupByArgs['orderBy'] }
        : { orderBy?: amz_variantsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_variantsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_variantsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_variants model
   */
  readonly fields: amz_variantsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_variants.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_variantsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_variants model
   */
  interface amz_variantsFieldRefs {
    readonly id: FieldRef<"amz_variants", 'BigInt'>
    readonly parentasin: FieldRef<"amz_variants", 'String'>
    readonly childasin: FieldRef<"amz_variants", 'String'>
    readonly properties: FieldRef<"amz_variants", 'String'>
    readonly processed: FieldRef<"amz_variants", 'Boolean'>
    readonly user_id: FieldRef<"amz_variants", 'Int'>
    readonly dateofmodification: FieldRef<"amz_variants", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * amz_variants findUnique
   */
  export type amz_variantsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants to fetch.
     */
    where: amz_variantsWhereUniqueInput
  }

  /**
   * amz_variants findUniqueOrThrow
   */
  export type amz_variantsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants to fetch.
     */
    where: amz_variantsWhereUniqueInput
  }

  /**
   * amz_variants findFirst
   */
  export type amz_variantsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants to fetch.
     */
    where?: amz_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants to fetch.
     */
    orderBy?: amz_variantsOrderByWithRelationInput | amz_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_variants.
     */
    cursor?: amz_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_variants.
     */
    distinct?: Amz_variantsScalarFieldEnum | Amz_variantsScalarFieldEnum[]
  }

  /**
   * amz_variants findFirstOrThrow
   */
  export type amz_variantsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants to fetch.
     */
    where?: amz_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants to fetch.
     */
    orderBy?: amz_variantsOrderByWithRelationInput | amz_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_variants.
     */
    cursor?: amz_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_variants.
     */
    distinct?: Amz_variantsScalarFieldEnum | Amz_variantsScalarFieldEnum[]
  }

  /**
   * amz_variants findMany
   */
  export type amz_variantsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants to fetch.
     */
    where?: amz_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants to fetch.
     */
    orderBy?: amz_variantsOrderByWithRelationInput | amz_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_variants.
     */
    cursor?: amz_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants.
     */
    skip?: number
    distinct?: Amz_variantsScalarFieldEnum | Amz_variantsScalarFieldEnum[]
  }

  /**
   * amz_variants create
   */
  export type amz_variantsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_variants.
     */
    data: XOR<amz_variantsCreateInput, amz_variantsUncheckedCreateInput>
  }

  /**
   * amz_variants createMany
   */
  export type amz_variantsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_variants.
     */
    data: amz_variantsCreateManyInput | amz_variantsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_variants update
   */
  export type amz_variantsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_variants.
     */
    data: XOR<amz_variantsUpdateInput, amz_variantsUncheckedUpdateInput>
    /**
     * Choose, which amz_variants to update.
     */
    where: amz_variantsWhereUniqueInput
  }

  /**
   * amz_variants updateMany
   */
  export type amz_variantsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_variants.
     */
    data: XOR<amz_variantsUpdateManyMutationInput, amz_variantsUncheckedUpdateManyInput>
    /**
     * Filter which amz_variants to update
     */
    where?: amz_variantsWhereInput
    /**
     * Limit how many amz_variants to update.
     */
    limit?: number
  }

  /**
   * amz_variants upsert
   */
  export type amz_variantsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_variants to update in case it exists.
     */
    where: amz_variantsWhereUniqueInput
    /**
     * In case the amz_variants found by the `where` argument doesn't exist, create a new amz_variants with this data.
     */
    create: XOR<amz_variantsCreateInput, amz_variantsUncheckedCreateInput>
    /**
     * In case the amz_variants was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_variantsUpdateInput, amz_variantsUncheckedUpdateInput>
  }

  /**
   * amz_variants delete
   */
  export type amz_variantsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
    /**
     * Filter which amz_variants to delete.
     */
    where: amz_variantsWhereUniqueInput
  }

  /**
   * amz_variants deleteMany
   */
  export type amz_variantsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_variants to delete
     */
    where?: amz_variantsWhereInput
    /**
     * Limit how many amz_variants to delete.
     */
    limit?: number
  }

  /**
   * amz_variants without action
   */
  export type amz_variantsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants
     */
    select?: amz_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants
     */
    omit?: amz_variantsOmit<ExtArgs> | null
  }


  /**
   * Model amz_variants_master
   */

  export type AggregateAmz_variants_master = {
    _count: Amz_variants_masterCountAggregateOutputType | null
    _avg: Amz_variants_masterAvgAggregateOutputType | null
    _sum: Amz_variants_masterSumAggregateOutputType | null
    _min: Amz_variants_masterMinAggregateOutputType | null
    _max: Amz_variants_masterMaxAggregateOutputType | null
  }

  export type Amz_variants_masterAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_variants_masterSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Amz_variants_masterMinAggregateOutputType = {
    id: number | null
    parentasin: string | null
    title: string | null
    classificationtypes: string | null
    attributes: string | null
    user_id: number | null
  }

  export type Amz_variants_masterMaxAggregateOutputType = {
    id: number | null
    parentasin: string | null
    title: string | null
    classificationtypes: string | null
    attributes: string | null
    user_id: number | null
  }

  export type Amz_variants_masterCountAggregateOutputType = {
    id: number
    parentasin: number
    title: number
    classificationtypes: number
    attributes: number
    user_id: number
    _all: number
  }


  export type Amz_variants_masterAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_variants_masterSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Amz_variants_masterMinAggregateInputType = {
    id?: true
    parentasin?: true
    title?: true
    classificationtypes?: true
    attributes?: true
    user_id?: true
  }

  export type Amz_variants_masterMaxAggregateInputType = {
    id?: true
    parentasin?: true
    title?: true
    classificationtypes?: true
    attributes?: true
    user_id?: true
  }

  export type Amz_variants_masterCountAggregateInputType = {
    id?: true
    parentasin?: true
    title?: true
    classificationtypes?: true
    attributes?: true
    user_id?: true
    _all?: true
  }

  export type Amz_variants_masterAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_variants_master to aggregate.
     */
    where?: amz_variants_masterWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants_masters to fetch.
     */
    orderBy?: amz_variants_masterOrderByWithRelationInput | amz_variants_masterOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: amz_variants_masterWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants_masters from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants_masters.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned amz_variants_masters
    **/
    _count?: true | Amz_variants_masterCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Amz_variants_masterAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Amz_variants_masterSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Amz_variants_masterMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Amz_variants_masterMaxAggregateInputType
  }

  export type GetAmz_variants_masterAggregateType<T extends Amz_variants_masterAggregateArgs> = {
        [P in keyof T & keyof AggregateAmz_variants_master]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAmz_variants_master[P]>
      : GetScalarType<T[P], AggregateAmz_variants_master[P]>
  }




  export type amz_variants_masterGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: amz_variants_masterWhereInput
    orderBy?: amz_variants_masterOrderByWithAggregationInput | amz_variants_masterOrderByWithAggregationInput[]
    by: Amz_variants_masterScalarFieldEnum[] | Amz_variants_masterScalarFieldEnum
    having?: amz_variants_masterScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Amz_variants_masterCountAggregateInputType | true
    _avg?: Amz_variants_masterAvgAggregateInputType
    _sum?: Amz_variants_masterSumAggregateInputType
    _min?: Amz_variants_masterMinAggregateInputType
    _max?: Amz_variants_masterMaxAggregateInputType
  }

  export type Amz_variants_masterGroupByOutputType = {
    id: number
    parentasin: string
    title: string
    classificationtypes: string
    attributes: string
    user_id: number
    _count: Amz_variants_masterCountAggregateOutputType | null
    _avg: Amz_variants_masterAvgAggregateOutputType | null
    _sum: Amz_variants_masterSumAggregateOutputType | null
    _min: Amz_variants_masterMinAggregateOutputType | null
    _max: Amz_variants_masterMaxAggregateOutputType | null
  }

  type GetAmz_variants_masterGroupByPayload<T extends amz_variants_masterGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Amz_variants_masterGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Amz_variants_masterGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Amz_variants_masterGroupByOutputType[P]>
            : GetScalarType<T[P], Amz_variants_masterGroupByOutputType[P]>
        }
      >
    >


  export type amz_variants_masterSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    parentasin?: boolean
    title?: boolean
    classificationtypes?: boolean
    attributes?: boolean
    user_id?: boolean
  }, ExtArgs["result"]["amz_variants_master"]>



  export type amz_variants_masterSelectScalar = {
    id?: boolean
    parentasin?: boolean
    title?: boolean
    classificationtypes?: boolean
    attributes?: boolean
    user_id?: boolean
  }

  export type amz_variants_masterOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "parentasin" | "title" | "classificationtypes" | "attributes" | "user_id", ExtArgs["result"]["amz_variants_master"]>

  export type $amz_variants_masterPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "amz_variants_master"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      parentasin: string
      title: string
      classificationtypes: string
      attributes: string
      user_id: number
    }, ExtArgs["result"]["amz_variants_master"]>
    composites: {}
  }

  type amz_variants_masterGetPayload<S extends boolean | null | undefined | amz_variants_masterDefaultArgs> = $Result.GetResult<Prisma.$amz_variants_masterPayload, S>

  type amz_variants_masterCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<amz_variants_masterFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Amz_variants_masterCountAggregateInputType | true
    }

  export interface amz_variants_masterDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['amz_variants_master'], meta: { name: 'amz_variants_master' } }
    /**
     * Find zero or one Amz_variants_master that matches the filter.
     * @param {amz_variants_masterFindUniqueArgs} args - Arguments to find a Amz_variants_master
     * @example
     * // Get one Amz_variants_master
     * const amz_variants_master = await prisma.amz_variants_master.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends amz_variants_masterFindUniqueArgs>(args: SelectSubset<T, amz_variants_masterFindUniqueArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Amz_variants_master that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {amz_variants_masterFindUniqueOrThrowArgs} args - Arguments to find a Amz_variants_master
     * @example
     * // Get one Amz_variants_master
     * const amz_variants_master = await prisma.amz_variants_master.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends amz_variants_masterFindUniqueOrThrowArgs>(args: SelectSubset<T, amz_variants_masterFindUniqueOrThrowArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_variants_master that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variants_masterFindFirstArgs} args - Arguments to find a Amz_variants_master
     * @example
     * // Get one Amz_variants_master
     * const amz_variants_master = await prisma.amz_variants_master.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends amz_variants_masterFindFirstArgs>(args?: SelectSubset<T, amz_variants_masterFindFirstArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Amz_variants_master that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variants_masterFindFirstOrThrowArgs} args - Arguments to find a Amz_variants_master
     * @example
     * // Get one Amz_variants_master
     * const amz_variants_master = await prisma.amz_variants_master.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends amz_variants_masterFindFirstOrThrowArgs>(args?: SelectSubset<T, amz_variants_masterFindFirstOrThrowArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Amz_variants_masters that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variants_masterFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Amz_variants_masters
     * const amz_variants_masters = await prisma.amz_variants_master.findMany()
     * 
     * // Get first 10 Amz_variants_masters
     * const amz_variants_masters = await prisma.amz_variants_master.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const amz_variants_masterWithIdOnly = await prisma.amz_variants_master.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends amz_variants_masterFindManyArgs>(args?: SelectSubset<T, amz_variants_masterFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Amz_variants_master.
     * @param {amz_variants_masterCreateArgs} args - Arguments to create a Amz_variants_master.
     * @example
     * // Create one Amz_variants_master
     * const Amz_variants_master = await prisma.amz_variants_master.create({
     *   data: {
     *     // ... data to create a Amz_variants_master
     *   }
     * })
     * 
     */
    create<T extends amz_variants_masterCreateArgs>(args: SelectSubset<T, amz_variants_masterCreateArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Amz_variants_masters.
     * @param {amz_variants_masterCreateManyArgs} args - Arguments to create many Amz_variants_masters.
     * @example
     * // Create many Amz_variants_masters
     * const amz_variants_master = await prisma.amz_variants_master.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends amz_variants_masterCreateManyArgs>(args?: SelectSubset<T, amz_variants_masterCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Amz_variants_master.
     * @param {amz_variants_masterDeleteArgs} args - Arguments to delete one Amz_variants_master.
     * @example
     * // Delete one Amz_variants_master
     * const Amz_variants_master = await prisma.amz_variants_master.delete({
     *   where: {
     *     // ... filter to delete one Amz_variants_master
     *   }
     * })
     * 
     */
    delete<T extends amz_variants_masterDeleteArgs>(args: SelectSubset<T, amz_variants_masterDeleteArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Amz_variants_master.
     * @param {amz_variants_masterUpdateArgs} args - Arguments to update one Amz_variants_master.
     * @example
     * // Update one Amz_variants_master
     * const amz_variants_master = await prisma.amz_variants_master.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends amz_variants_masterUpdateArgs>(args: SelectSubset<T, amz_variants_masterUpdateArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Amz_variants_masters.
     * @param {amz_variants_masterDeleteManyArgs} args - Arguments to filter Amz_variants_masters to delete.
     * @example
     * // Delete a few Amz_variants_masters
     * const { count } = await prisma.amz_variants_master.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends amz_variants_masterDeleteManyArgs>(args?: SelectSubset<T, amz_variants_masterDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Amz_variants_masters.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variants_masterUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Amz_variants_masters
     * const amz_variants_master = await prisma.amz_variants_master.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends amz_variants_masterUpdateManyArgs>(args: SelectSubset<T, amz_variants_masterUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Amz_variants_master.
     * @param {amz_variants_masterUpsertArgs} args - Arguments to update or create a Amz_variants_master.
     * @example
     * // Update or create a Amz_variants_master
     * const amz_variants_master = await prisma.amz_variants_master.upsert({
     *   create: {
     *     // ... data to create a Amz_variants_master
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Amz_variants_master we want to update
     *   }
     * })
     */
    upsert<T extends amz_variants_masterUpsertArgs>(args: SelectSubset<T, amz_variants_masterUpsertArgs<ExtArgs>>): Prisma__amz_variants_masterClient<$Result.GetResult<Prisma.$amz_variants_masterPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Amz_variants_masters.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variants_masterCountArgs} args - Arguments to filter Amz_variants_masters to count.
     * @example
     * // Count the number of Amz_variants_masters
     * const count = await prisma.amz_variants_master.count({
     *   where: {
     *     // ... the filter for the Amz_variants_masters we want to count
     *   }
     * })
    **/
    count<T extends amz_variants_masterCountArgs>(
      args?: Subset<T, amz_variants_masterCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Amz_variants_masterCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Amz_variants_master.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Amz_variants_masterAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Amz_variants_masterAggregateArgs>(args: Subset<T, Amz_variants_masterAggregateArgs>): Prisma.PrismaPromise<GetAmz_variants_masterAggregateType<T>>

    /**
     * Group by Amz_variants_master.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {amz_variants_masterGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends amz_variants_masterGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: amz_variants_masterGroupByArgs['orderBy'] }
        : { orderBy?: amz_variants_masterGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, amz_variants_masterGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAmz_variants_masterGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the amz_variants_master model
   */
  readonly fields: amz_variants_masterFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for amz_variants_master.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__amz_variants_masterClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the amz_variants_master model
   */
  interface amz_variants_masterFieldRefs {
    readonly id: FieldRef<"amz_variants_master", 'Int'>
    readonly parentasin: FieldRef<"amz_variants_master", 'String'>
    readonly title: FieldRef<"amz_variants_master", 'String'>
    readonly classificationtypes: FieldRef<"amz_variants_master", 'String'>
    readonly attributes: FieldRef<"amz_variants_master", 'String'>
    readonly user_id: FieldRef<"amz_variants_master", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * amz_variants_master findUnique
   */
  export type amz_variants_masterFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants_master to fetch.
     */
    where: amz_variants_masterWhereUniqueInput
  }

  /**
   * amz_variants_master findUniqueOrThrow
   */
  export type amz_variants_masterFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants_master to fetch.
     */
    where: amz_variants_masterWhereUniqueInput
  }

  /**
   * amz_variants_master findFirst
   */
  export type amz_variants_masterFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants_master to fetch.
     */
    where?: amz_variants_masterWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants_masters to fetch.
     */
    orderBy?: amz_variants_masterOrderByWithRelationInput | amz_variants_masterOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_variants_masters.
     */
    cursor?: amz_variants_masterWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants_masters from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants_masters.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_variants_masters.
     */
    distinct?: Amz_variants_masterScalarFieldEnum | Amz_variants_masterScalarFieldEnum[]
  }

  /**
   * amz_variants_master findFirstOrThrow
   */
  export type amz_variants_masterFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants_master to fetch.
     */
    where?: amz_variants_masterWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants_masters to fetch.
     */
    orderBy?: amz_variants_masterOrderByWithRelationInput | amz_variants_masterOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for amz_variants_masters.
     */
    cursor?: amz_variants_masterWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants_masters from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants_masters.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of amz_variants_masters.
     */
    distinct?: Amz_variants_masterScalarFieldEnum | Amz_variants_masterScalarFieldEnum[]
  }

  /**
   * amz_variants_master findMany
   */
  export type amz_variants_masterFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * Filter, which amz_variants_masters to fetch.
     */
    where?: amz_variants_masterWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of amz_variants_masters to fetch.
     */
    orderBy?: amz_variants_masterOrderByWithRelationInput | amz_variants_masterOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing amz_variants_masters.
     */
    cursor?: amz_variants_masterWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` amz_variants_masters from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` amz_variants_masters.
     */
    skip?: number
    distinct?: Amz_variants_masterScalarFieldEnum | Amz_variants_masterScalarFieldEnum[]
  }

  /**
   * amz_variants_master create
   */
  export type amz_variants_masterCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * The data needed to create a amz_variants_master.
     */
    data: XOR<amz_variants_masterCreateInput, amz_variants_masterUncheckedCreateInput>
  }

  /**
   * amz_variants_master createMany
   */
  export type amz_variants_masterCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many amz_variants_masters.
     */
    data: amz_variants_masterCreateManyInput | amz_variants_masterCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * amz_variants_master update
   */
  export type amz_variants_masterUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * The data needed to update a amz_variants_master.
     */
    data: XOR<amz_variants_masterUpdateInput, amz_variants_masterUncheckedUpdateInput>
    /**
     * Choose, which amz_variants_master to update.
     */
    where: amz_variants_masterWhereUniqueInput
  }

  /**
   * amz_variants_master updateMany
   */
  export type amz_variants_masterUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update amz_variants_masters.
     */
    data: XOR<amz_variants_masterUpdateManyMutationInput, amz_variants_masterUncheckedUpdateManyInput>
    /**
     * Filter which amz_variants_masters to update
     */
    where?: amz_variants_masterWhereInput
    /**
     * Limit how many amz_variants_masters to update.
     */
    limit?: number
  }

  /**
   * amz_variants_master upsert
   */
  export type amz_variants_masterUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * The filter to search for the amz_variants_master to update in case it exists.
     */
    where: amz_variants_masterWhereUniqueInput
    /**
     * In case the amz_variants_master found by the `where` argument doesn't exist, create a new amz_variants_master with this data.
     */
    create: XOR<amz_variants_masterCreateInput, amz_variants_masterUncheckedCreateInput>
    /**
     * In case the amz_variants_master was found with the provided `where` argument, update it with this data.
     */
    update: XOR<amz_variants_masterUpdateInput, amz_variants_masterUncheckedUpdateInput>
  }

  /**
   * amz_variants_master delete
   */
  export type amz_variants_masterDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
    /**
     * Filter which amz_variants_master to delete.
     */
    where: amz_variants_masterWhereUniqueInput
  }

  /**
   * amz_variants_master deleteMany
   */
  export type amz_variants_masterDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which amz_variants_masters to delete
     */
    where?: amz_variants_masterWhereInput
    /**
     * Limit how many amz_variants_masters to delete.
     */
    limit?: number
  }

  /**
   * amz_variants_master without action
   */
  export type amz_variants_masterDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the amz_variants_master
     */
    select?: amz_variants_masterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the amz_variants_master
     */
    omit?: amz_variants_masterOmit<ExtArgs> | null
  }


  /**
   * Model aproducts
   */

  export type AggregateAproducts = {
    _count: AproductsCountAggregateOutputType | null
    _avg: AproductsAvgAggregateOutputType | null
    _sum: AproductsSumAggregateOutputType | null
    _min: AproductsMinAggregateOutputType | null
    _max: AproductsMaxAggregateOutputType | null
  }

  export type AproductsAvgAggregateOutputType = {
    id: number | null
    price: number | null
    quantity: number | null
    fbaqty: number | null
    pending_quantity: number | null
    user_id: number | null
    part: number | null
  }

  export type AproductsSumAggregateOutputType = {
    id: bigint | null
    price: number | null
    quantity: number | null
    fbaqty: number | null
    pending_quantity: number | null
    user_id: number | null
    part: number | null
  }

  export type AproductsMinAggregateOutputType = {
    id: bigint | null
    item_name: string | null
    item_description: string | null
    listing_id: string | null
    seller_sku: string | null
    price: number | null
    quantity: number | null
    fbaqty: number | null
    open_date: string | null
    image_url: string | null
    item_is_marketplace: string | null
    product_id_type: string | null
    zshop_shipping_fee: string | null
    item_note: string | null
    item_condition: string | null
    zshop_category1: string | null
    zshop_browse_path: string | null
    zshop_storefront_feature: string | null
    asin1: string | null
    asin2: string | null
    asin3: string | null
    will_ship_internationally: string | null
    expedited_shipping: string | null
    zshop_boldface: string | null
    product_id: string | null
    upc: string | null
    bid_for_featured_placement: string | null
    add_delete: string | null
    pending_quantity: number | null
    fulfillment_channel: string | null
    dateofmodification: Date | null
    parentasin: string | null
    attributes: string | null
    processed: boolean | null
    user_id: number | null
    shopifyproductid: string | null
    shopifyvariantid: string | null
    block: boolean | null
    status: $Enums.aproducts_status | null
    newflag: boolean | null
    quantityflag: boolean | null
    priceflag: boolean | null
    dirty: boolean | null
    duplicate: boolean | null
    deleted: boolean | null
    color: string | null
    size: string | null
    part: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type AproductsMaxAggregateOutputType = {
    id: bigint | null
    item_name: string | null
    item_description: string | null
    listing_id: string | null
    seller_sku: string | null
    price: number | null
    quantity: number | null
    fbaqty: number | null
    open_date: string | null
    image_url: string | null
    item_is_marketplace: string | null
    product_id_type: string | null
    zshop_shipping_fee: string | null
    item_note: string | null
    item_condition: string | null
    zshop_category1: string | null
    zshop_browse_path: string | null
    zshop_storefront_feature: string | null
    asin1: string | null
    asin2: string | null
    asin3: string | null
    will_ship_internationally: string | null
    expedited_shipping: string | null
    zshop_boldface: string | null
    product_id: string | null
    upc: string | null
    bid_for_featured_placement: string | null
    add_delete: string | null
    pending_quantity: number | null
    fulfillment_channel: string | null
    dateofmodification: Date | null
    parentasin: string | null
    attributes: string | null
    processed: boolean | null
    user_id: number | null
    shopifyproductid: string | null
    shopifyvariantid: string | null
    block: boolean | null
    status: $Enums.aproducts_status | null
    newflag: boolean | null
    quantityflag: boolean | null
    priceflag: boolean | null
    dirty: boolean | null
    duplicate: boolean | null
    deleted: boolean | null
    color: string | null
    size: string | null
    part: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type AproductsCountAggregateOutputType = {
    id: number
    item_name: number
    item_description: number
    listing_id: number
    seller_sku: number
    price: number
    quantity: number
    fbaqty: number
    open_date: number
    image_url: number
    item_is_marketplace: number
    product_id_type: number
    zshop_shipping_fee: number
    item_note: number
    item_condition: number
    zshop_category1: number
    zshop_browse_path: number
    zshop_storefront_feature: number
    asin1: number
    asin2: number
    asin3: number
    will_ship_internationally: number
    expedited_shipping: number
    zshop_boldface: number
    product_id: number
    upc: number
    bid_for_featured_placement: number
    add_delete: number
    pending_quantity: number
    fulfillment_channel: number
    dateofmodification: number
    parentasin: number
    attributes: number
    processed: number
    user_id: number
    shopifyproductid: number
    shopifyvariantid: number
    block: number
    status: number
    newflag: number
    quantityflag: number
    priceflag: number
    dirty: number
    duplicate: number
    deleted: number
    color: number
    size: number
    part: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type AproductsAvgAggregateInputType = {
    id?: true
    price?: true
    quantity?: true
    fbaqty?: true
    pending_quantity?: true
    user_id?: true
    part?: true
  }

  export type AproductsSumAggregateInputType = {
    id?: true
    price?: true
    quantity?: true
    fbaqty?: true
    pending_quantity?: true
    user_id?: true
    part?: true
  }

  export type AproductsMinAggregateInputType = {
    id?: true
    item_name?: true
    item_description?: true
    listing_id?: true
    seller_sku?: true
    price?: true
    quantity?: true
    fbaqty?: true
    open_date?: true
    image_url?: true
    item_is_marketplace?: true
    product_id_type?: true
    zshop_shipping_fee?: true
    item_note?: true
    item_condition?: true
    zshop_category1?: true
    zshop_browse_path?: true
    zshop_storefront_feature?: true
    asin1?: true
    asin2?: true
    asin3?: true
    will_ship_internationally?: true
    expedited_shipping?: true
    zshop_boldface?: true
    product_id?: true
    upc?: true
    bid_for_featured_placement?: true
    add_delete?: true
    pending_quantity?: true
    fulfillment_channel?: true
    dateofmodification?: true
    parentasin?: true
    attributes?: true
    processed?: true
    user_id?: true
    shopifyproductid?: true
    shopifyvariantid?: true
    block?: true
    status?: true
    newflag?: true
    quantityflag?: true
    priceflag?: true
    dirty?: true
    duplicate?: true
    deleted?: true
    color?: true
    size?: true
    part?: true
    created_at?: true
    updated_at?: true
  }

  export type AproductsMaxAggregateInputType = {
    id?: true
    item_name?: true
    item_description?: true
    listing_id?: true
    seller_sku?: true
    price?: true
    quantity?: true
    fbaqty?: true
    open_date?: true
    image_url?: true
    item_is_marketplace?: true
    product_id_type?: true
    zshop_shipping_fee?: true
    item_note?: true
    item_condition?: true
    zshop_category1?: true
    zshop_browse_path?: true
    zshop_storefront_feature?: true
    asin1?: true
    asin2?: true
    asin3?: true
    will_ship_internationally?: true
    expedited_shipping?: true
    zshop_boldface?: true
    product_id?: true
    upc?: true
    bid_for_featured_placement?: true
    add_delete?: true
    pending_quantity?: true
    fulfillment_channel?: true
    dateofmodification?: true
    parentasin?: true
    attributes?: true
    processed?: true
    user_id?: true
    shopifyproductid?: true
    shopifyvariantid?: true
    block?: true
    status?: true
    newflag?: true
    quantityflag?: true
    priceflag?: true
    dirty?: true
    duplicate?: true
    deleted?: true
    color?: true
    size?: true
    part?: true
    created_at?: true
    updated_at?: true
  }

  export type AproductsCountAggregateInputType = {
    id?: true
    item_name?: true
    item_description?: true
    listing_id?: true
    seller_sku?: true
    price?: true
    quantity?: true
    fbaqty?: true
    open_date?: true
    image_url?: true
    item_is_marketplace?: true
    product_id_type?: true
    zshop_shipping_fee?: true
    item_note?: true
    item_condition?: true
    zshop_category1?: true
    zshop_browse_path?: true
    zshop_storefront_feature?: true
    asin1?: true
    asin2?: true
    asin3?: true
    will_ship_internationally?: true
    expedited_shipping?: true
    zshop_boldface?: true
    product_id?: true
    upc?: true
    bid_for_featured_placement?: true
    add_delete?: true
    pending_quantity?: true
    fulfillment_channel?: true
    dateofmodification?: true
    parentasin?: true
    attributes?: true
    processed?: true
    user_id?: true
    shopifyproductid?: true
    shopifyvariantid?: true
    block?: true
    status?: true
    newflag?: true
    quantityflag?: true
    priceflag?: true
    dirty?: true
    duplicate?: true
    deleted?: true
    color?: true
    size?: true
    part?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type AproductsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which aproducts to aggregate.
     */
    where?: aproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts to fetch.
     */
    orderBy?: aproductsOrderByWithRelationInput | aproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: aproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned aproducts
    **/
    _count?: true | AproductsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AproductsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AproductsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AproductsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AproductsMaxAggregateInputType
  }

  export type GetAproductsAggregateType<T extends AproductsAggregateArgs> = {
        [P in keyof T & keyof AggregateAproducts]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAproducts[P]>
      : GetScalarType<T[P], AggregateAproducts[P]>
  }




  export type aproductsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: aproductsWhereInput
    orderBy?: aproductsOrderByWithAggregationInput | aproductsOrderByWithAggregationInput[]
    by: AproductsScalarFieldEnum[] | AproductsScalarFieldEnum
    having?: aproductsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AproductsCountAggregateInputType | true
    _avg?: AproductsAvgAggregateInputType
    _sum?: AproductsSumAggregateInputType
    _min?: AproductsMinAggregateInputType
    _max?: AproductsMaxAggregateInputType
  }

  export type AproductsGroupByOutputType = {
    id: bigint
    item_name: string
    item_description: string
    listing_id: string
    seller_sku: string
    price: number
    quantity: number
    fbaqty: number
    open_date: string
    image_url: string
    item_is_marketplace: string
    product_id_type: string
    zshop_shipping_fee: string
    item_note: string
    item_condition: string
    zshop_category1: string
    zshop_browse_path: string
    zshop_storefront_feature: string
    asin1: string
    asin2: string
    asin3: string
    will_ship_internationally: string
    expedited_shipping: string
    zshop_boldface: string
    product_id: string
    upc: string
    bid_for_featured_placement: string
    add_delete: string
    pending_quantity: number
    fulfillment_channel: string
    dateofmodification: Date
    parentasin: string
    attributes: string
    processed: boolean
    user_id: number
    shopifyproductid: string
    shopifyvariantid: string
    block: boolean
    status: $Enums.aproducts_status | null
    newflag: boolean
    quantityflag: boolean
    priceflag: boolean
    dirty: boolean
    duplicate: boolean
    deleted: boolean
    color: string
    size: string
    part: number
    created_at: Date
    updated_at: Date
    _count: AproductsCountAggregateOutputType | null
    _avg: AproductsAvgAggregateOutputType | null
    _sum: AproductsSumAggregateOutputType | null
    _min: AproductsMinAggregateOutputType | null
    _max: AproductsMaxAggregateOutputType | null
  }

  type GetAproductsGroupByPayload<T extends aproductsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AproductsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AproductsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AproductsGroupByOutputType[P]>
            : GetScalarType<T[P], AproductsGroupByOutputType[P]>
        }
      >
    >


  export type aproductsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    item_name?: boolean
    item_description?: boolean
    listing_id?: boolean
    seller_sku?: boolean
    price?: boolean
    quantity?: boolean
    fbaqty?: boolean
    open_date?: boolean
    image_url?: boolean
    item_is_marketplace?: boolean
    product_id_type?: boolean
    zshop_shipping_fee?: boolean
    item_note?: boolean
    item_condition?: boolean
    zshop_category1?: boolean
    zshop_browse_path?: boolean
    zshop_storefront_feature?: boolean
    asin1?: boolean
    asin2?: boolean
    asin3?: boolean
    will_ship_internationally?: boolean
    expedited_shipping?: boolean
    zshop_boldface?: boolean
    product_id?: boolean
    upc?: boolean
    bid_for_featured_placement?: boolean
    add_delete?: boolean
    pending_quantity?: boolean
    fulfillment_channel?: boolean
    dateofmodification?: boolean
    parentasin?: boolean
    attributes?: boolean
    processed?: boolean
    user_id?: boolean
    shopifyproductid?: boolean
    shopifyvariantid?: boolean
    block?: boolean
    status?: boolean
    newflag?: boolean
    quantityflag?: boolean
    priceflag?: boolean
    dirty?: boolean
    duplicate?: boolean
    deleted?: boolean
    color?: boolean
    size?: boolean
    part?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["aproducts"]>



  export type aproductsSelectScalar = {
    id?: boolean
    item_name?: boolean
    item_description?: boolean
    listing_id?: boolean
    seller_sku?: boolean
    price?: boolean
    quantity?: boolean
    fbaqty?: boolean
    open_date?: boolean
    image_url?: boolean
    item_is_marketplace?: boolean
    product_id_type?: boolean
    zshop_shipping_fee?: boolean
    item_note?: boolean
    item_condition?: boolean
    zshop_category1?: boolean
    zshop_browse_path?: boolean
    zshop_storefront_feature?: boolean
    asin1?: boolean
    asin2?: boolean
    asin3?: boolean
    will_ship_internationally?: boolean
    expedited_shipping?: boolean
    zshop_boldface?: boolean
    product_id?: boolean
    upc?: boolean
    bid_for_featured_placement?: boolean
    add_delete?: boolean
    pending_quantity?: boolean
    fulfillment_channel?: boolean
    dateofmodification?: boolean
    parentasin?: boolean
    attributes?: boolean
    processed?: boolean
    user_id?: boolean
    shopifyproductid?: boolean
    shopifyvariantid?: boolean
    block?: boolean
    status?: boolean
    newflag?: boolean
    quantityflag?: boolean
    priceflag?: boolean
    dirty?: boolean
    duplicate?: boolean
    deleted?: boolean
    color?: boolean
    size?: boolean
    part?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type aproductsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "item_name" | "item_description" | "listing_id" | "seller_sku" | "price" | "quantity" | "fbaqty" | "open_date" | "image_url" | "item_is_marketplace" | "product_id_type" | "zshop_shipping_fee" | "item_note" | "item_condition" | "zshop_category1" | "zshop_browse_path" | "zshop_storefront_feature" | "asin1" | "asin2" | "asin3" | "will_ship_internationally" | "expedited_shipping" | "zshop_boldface" | "product_id" | "upc" | "bid_for_featured_placement" | "add_delete" | "pending_quantity" | "fulfillment_channel" | "dateofmodification" | "parentasin" | "attributes" | "processed" | "user_id" | "shopifyproductid" | "shopifyvariantid" | "block" | "status" | "newflag" | "quantityflag" | "priceflag" | "dirty" | "duplicate" | "deleted" | "color" | "size" | "part" | "created_at" | "updated_at", ExtArgs["result"]["aproducts"]>

  export type $aproductsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "aproducts"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: bigint
      item_name: string
      item_description: string
      listing_id: string
      seller_sku: string
      price: number
      quantity: number
      fbaqty: number
      open_date: string
      image_url: string
      item_is_marketplace: string
      product_id_type: string
      zshop_shipping_fee: string
      item_note: string
      item_condition: string
      zshop_category1: string
      zshop_browse_path: string
      zshop_storefront_feature: string
      asin1: string
      asin2: string
      asin3: string
      will_ship_internationally: string
      expedited_shipping: string
      zshop_boldface: string
      product_id: string
      upc: string
      bid_for_featured_placement: string
      add_delete: string
      pending_quantity: number
      fulfillment_channel: string
      dateofmodification: Date
      parentasin: string
      attributes: string
      processed: boolean
      user_id: number
      shopifyproductid: string
      shopifyvariantid: string
      block: boolean
      status: $Enums.aproducts_status | null
      newflag: boolean
      quantityflag: boolean
      priceflag: boolean
      dirty: boolean
      duplicate: boolean
      deleted: boolean
      color: string
      size: string
      part: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["aproducts"]>
    composites: {}
  }

  type aproductsGetPayload<S extends boolean | null | undefined | aproductsDefaultArgs> = $Result.GetResult<Prisma.$aproductsPayload, S>

  type aproductsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<aproductsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AproductsCountAggregateInputType | true
    }

  export interface aproductsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['aproducts'], meta: { name: 'aproducts' } }
    /**
     * Find zero or one Aproducts that matches the filter.
     * @param {aproductsFindUniqueArgs} args - Arguments to find a Aproducts
     * @example
     * // Get one Aproducts
     * const aproducts = await prisma.aproducts.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends aproductsFindUniqueArgs>(args: SelectSubset<T, aproductsFindUniqueArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Aproducts that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {aproductsFindUniqueOrThrowArgs} args - Arguments to find a Aproducts
     * @example
     * // Get one Aproducts
     * const aproducts = await prisma.aproducts.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends aproductsFindUniqueOrThrowArgs>(args: SelectSubset<T, aproductsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Aproducts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproductsFindFirstArgs} args - Arguments to find a Aproducts
     * @example
     * // Get one Aproducts
     * const aproducts = await prisma.aproducts.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends aproductsFindFirstArgs>(args?: SelectSubset<T, aproductsFindFirstArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Aproducts that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproductsFindFirstOrThrowArgs} args - Arguments to find a Aproducts
     * @example
     * // Get one Aproducts
     * const aproducts = await prisma.aproducts.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends aproductsFindFirstOrThrowArgs>(args?: SelectSubset<T, aproductsFindFirstOrThrowArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Aproducts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproductsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Aproducts
     * const aproducts = await prisma.aproducts.findMany()
     * 
     * // Get first 10 Aproducts
     * const aproducts = await prisma.aproducts.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const aproductsWithIdOnly = await prisma.aproducts.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends aproductsFindManyArgs>(args?: SelectSubset<T, aproductsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Aproducts.
     * @param {aproductsCreateArgs} args - Arguments to create a Aproducts.
     * @example
     * // Create one Aproducts
     * const Aproducts = await prisma.aproducts.create({
     *   data: {
     *     // ... data to create a Aproducts
     *   }
     * })
     * 
     */
    create<T extends aproductsCreateArgs>(args: SelectSubset<T, aproductsCreateArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Aproducts.
     * @param {aproductsCreateManyArgs} args - Arguments to create many Aproducts.
     * @example
     * // Create many Aproducts
     * const aproducts = await prisma.aproducts.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends aproductsCreateManyArgs>(args?: SelectSubset<T, aproductsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Aproducts.
     * @param {aproductsDeleteArgs} args - Arguments to delete one Aproducts.
     * @example
     * // Delete one Aproducts
     * const Aproducts = await prisma.aproducts.delete({
     *   where: {
     *     // ... filter to delete one Aproducts
     *   }
     * })
     * 
     */
    delete<T extends aproductsDeleteArgs>(args: SelectSubset<T, aproductsDeleteArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Aproducts.
     * @param {aproductsUpdateArgs} args - Arguments to update one Aproducts.
     * @example
     * // Update one Aproducts
     * const aproducts = await prisma.aproducts.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends aproductsUpdateArgs>(args: SelectSubset<T, aproductsUpdateArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Aproducts.
     * @param {aproductsDeleteManyArgs} args - Arguments to filter Aproducts to delete.
     * @example
     * // Delete a few Aproducts
     * const { count } = await prisma.aproducts.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends aproductsDeleteManyArgs>(args?: SelectSubset<T, aproductsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Aproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproductsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Aproducts
     * const aproducts = await prisma.aproducts.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends aproductsUpdateManyArgs>(args: SelectSubset<T, aproductsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Aproducts.
     * @param {aproductsUpsertArgs} args - Arguments to update or create a Aproducts.
     * @example
     * // Update or create a Aproducts
     * const aproducts = await prisma.aproducts.upsert({
     *   create: {
     *     // ... data to create a Aproducts
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Aproducts we want to update
     *   }
     * })
     */
    upsert<T extends aproductsUpsertArgs>(args: SelectSubset<T, aproductsUpsertArgs<ExtArgs>>): Prisma__aproductsClient<$Result.GetResult<Prisma.$aproductsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Aproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproductsCountArgs} args - Arguments to filter Aproducts to count.
     * @example
     * // Count the number of Aproducts
     * const count = await prisma.aproducts.count({
     *   where: {
     *     // ... the filter for the Aproducts we want to count
     *   }
     * })
    **/
    count<T extends aproductsCountArgs>(
      args?: Subset<T, aproductsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AproductsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Aproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AproductsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AproductsAggregateArgs>(args: Subset<T, AproductsAggregateArgs>): Prisma.PrismaPromise<GetAproductsAggregateType<T>>

    /**
     * Group by Aproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproductsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends aproductsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: aproductsGroupByArgs['orderBy'] }
        : { orderBy?: aproductsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, aproductsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAproductsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the aproducts model
   */
  readonly fields: aproductsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for aproducts.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__aproductsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the aproducts model
   */
  interface aproductsFieldRefs {
    readonly id: FieldRef<"aproducts", 'BigInt'>
    readonly item_name: FieldRef<"aproducts", 'String'>
    readonly item_description: FieldRef<"aproducts", 'String'>
    readonly listing_id: FieldRef<"aproducts", 'String'>
    readonly seller_sku: FieldRef<"aproducts", 'String'>
    readonly price: FieldRef<"aproducts", 'Float'>
    readonly quantity: FieldRef<"aproducts", 'Int'>
    readonly fbaqty: FieldRef<"aproducts", 'Int'>
    readonly open_date: FieldRef<"aproducts", 'String'>
    readonly image_url: FieldRef<"aproducts", 'String'>
    readonly item_is_marketplace: FieldRef<"aproducts", 'String'>
    readonly product_id_type: FieldRef<"aproducts", 'String'>
    readonly zshop_shipping_fee: FieldRef<"aproducts", 'String'>
    readonly item_note: FieldRef<"aproducts", 'String'>
    readonly item_condition: FieldRef<"aproducts", 'String'>
    readonly zshop_category1: FieldRef<"aproducts", 'String'>
    readonly zshop_browse_path: FieldRef<"aproducts", 'String'>
    readonly zshop_storefront_feature: FieldRef<"aproducts", 'String'>
    readonly asin1: FieldRef<"aproducts", 'String'>
    readonly asin2: FieldRef<"aproducts", 'String'>
    readonly asin3: FieldRef<"aproducts", 'String'>
    readonly will_ship_internationally: FieldRef<"aproducts", 'String'>
    readonly expedited_shipping: FieldRef<"aproducts", 'String'>
    readonly zshop_boldface: FieldRef<"aproducts", 'String'>
    readonly product_id: FieldRef<"aproducts", 'String'>
    readonly upc: FieldRef<"aproducts", 'String'>
    readonly bid_for_featured_placement: FieldRef<"aproducts", 'String'>
    readonly add_delete: FieldRef<"aproducts", 'String'>
    readonly pending_quantity: FieldRef<"aproducts", 'Int'>
    readonly fulfillment_channel: FieldRef<"aproducts", 'String'>
    readonly dateofmodification: FieldRef<"aproducts", 'DateTime'>
    readonly parentasin: FieldRef<"aproducts", 'String'>
    readonly attributes: FieldRef<"aproducts", 'String'>
    readonly processed: FieldRef<"aproducts", 'Boolean'>
    readonly user_id: FieldRef<"aproducts", 'Int'>
    readonly shopifyproductid: FieldRef<"aproducts", 'String'>
    readonly shopifyvariantid: FieldRef<"aproducts", 'String'>
    readonly block: FieldRef<"aproducts", 'Boolean'>
    readonly status: FieldRef<"aproducts", 'aproducts_status'>
    readonly newflag: FieldRef<"aproducts", 'Boolean'>
    readonly quantityflag: FieldRef<"aproducts", 'Boolean'>
    readonly priceflag: FieldRef<"aproducts", 'Boolean'>
    readonly dirty: FieldRef<"aproducts", 'Boolean'>
    readonly duplicate: FieldRef<"aproducts", 'Boolean'>
    readonly deleted: FieldRef<"aproducts", 'Boolean'>
    readonly color: FieldRef<"aproducts", 'String'>
    readonly size: FieldRef<"aproducts", 'String'>
    readonly part: FieldRef<"aproducts", 'Int'>
    readonly created_at: FieldRef<"aproducts", 'DateTime'>
    readonly updated_at: FieldRef<"aproducts", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * aproducts findUnique
   */
  export type aproductsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * Filter, which aproducts to fetch.
     */
    where: aproductsWhereUniqueInput
  }

  /**
   * aproducts findUniqueOrThrow
   */
  export type aproductsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * Filter, which aproducts to fetch.
     */
    where: aproductsWhereUniqueInput
  }

  /**
   * aproducts findFirst
   */
  export type aproductsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * Filter, which aproducts to fetch.
     */
    where?: aproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts to fetch.
     */
    orderBy?: aproductsOrderByWithRelationInput | aproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for aproducts.
     */
    cursor?: aproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of aproducts.
     */
    distinct?: AproductsScalarFieldEnum | AproductsScalarFieldEnum[]
  }

  /**
   * aproducts findFirstOrThrow
   */
  export type aproductsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * Filter, which aproducts to fetch.
     */
    where?: aproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts to fetch.
     */
    orderBy?: aproductsOrderByWithRelationInput | aproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for aproducts.
     */
    cursor?: aproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of aproducts.
     */
    distinct?: AproductsScalarFieldEnum | AproductsScalarFieldEnum[]
  }

  /**
   * aproducts findMany
   */
  export type aproductsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * Filter, which aproducts to fetch.
     */
    where?: aproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts to fetch.
     */
    orderBy?: aproductsOrderByWithRelationInput | aproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing aproducts.
     */
    cursor?: aproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts.
     */
    skip?: number
    distinct?: AproductsScalarFieldEnum | AproductsScalarFieldEnum[]
  }

  /**
   * aproducts create
   */
  export type aproductsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * The data needed to create a aproducts.
     */
    data: XOR<aproductsCreateInput, aproductsUncheckedCreateInput>
  }

  /**
   * aproducts createMany
   */
  export type aproductsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many aproducts.
     */
    data: aproductsCreateManyInput | aproductsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * aproducts update
   */
  export type aproductsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * The data needed to update a aproducts.
     */
    data: XOR<aproductsUpdateInput, aproductsUncheckedUpdateInput>
    /**
     * Choose, which aproducts to update.
     */
    where: aproductsWhereUniqueInput
  }

  /**
   * aproducts updateMany
   */
  export type aproductsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update aproducts.
     */
    data: XOR<aproductsUpdateManyMutationInput, aproductsUncheckedUpdateManyInput>
    /**
     * Filter which aproducts to update
     */
    where?: aproductsWhereInput
    /**
     * Limit how many aproducts to update.
     */
    limit?: number
  }

  /**
   * aproducts upsert
   */
  export type aproductsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * The filter to search for the aproducts to update in case it exists.
     */
    where: aproductsWhereUniqueInput
    /**
     * In case the aproducts found by the `where` argument doesn't exist, create a new aproducts with this data.
     */
    create: XOR<aproductsCreateInput, aproductsUncheckedCreateInput>
    /**
     * In case the aproducts was found with the provided `where` argument, update it with this data.
     */
    update: XOR<aproductsUpdateInput, aproductsUncheckedUpdateInput>
  }

  /**
   * aproducts delete
   */
  export type aproductsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
    /**
     * Filter which aproducts to delete.
     */
    where: aproductsWhereUniqueInput
  }

  /**
   * aproducts deleteMany
   */
  export type aproductsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which aproducts to delete
     */
    where?: aproductsWhereInput
    /**
     * Limit how many aproducts to delete.
     */
    limit?: number
  }

  /**
   * aproducts without action
   */
  export type aproductsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts
     */
    select?: aproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts
     */
    omit?: aproductsOmit<ExtArgs> | null
  }


  /**
   * Model aproducts_ext
   */

  export type AggregateAproducts_ext = {
    _count: Aproducts_extCountAggregateOutputType | null
    _avg: Aproducts_extAvgAggregateOutputType | null
    _sum: Aproducts_extSumAggregateOutputType | null
    _min: Aproducts_extMinAggregateOutputType | null
    _max: Aproducts_extMaxAggregateOutputType | null
  }

  export type Aproducts_extAvgAggregateOutputType = {
    id: number | null
    saleprice: number | null
    user_id: number | null
  }

  export type Aproducts_extSumAggregateOutputType = {
    id: number | null
    saleprice: number | null
    user_id: number | null
  }

  export type Aproducts_extMinAggregateOutputType = {
    id: number | null
    sku: string | null
    saleprice: number | null
    category: string | null
    categorytag: string | null
    temp: string | null
    priceflag: boolean | null
    saleapplied: boolean | null
    promotionalSaleID: string | null
    done: boolean | null
    user_id: number | null
  }

  export type Aproducts_extMaxAggregateOutputType = {
    id: number | null
    sku: string | null
    saleprice: number | null
    category: string | null
    categorytag: string | null
    temp: string | null
    priceflag: boolean | null
    saleapplied: boolean | null
    promotionalSaleID: string | null
    done: boolean | null
    user_id: number | null
  }

  export type Aproducts_extCountAggregateOutputType = {
    id: number
    sku: number
    saleprice: number
    category: number
    categorytag: number
    temp: number
    priceflag: number
    saleapplied: number
    promotionalSaleID: number
    done: number
    user_id: number
    _all: number
  }


  export type Aproducts_extAvgAggregateInputType = {
    id?: true
    saleprice?: true
    user_id?: true
  }

  export type Aproducts_extSumAggregateInputType = {
    id?: true
    saleprice?: true
    user_id?: true
  }

  export type Aproducts_extMinAggregateInputType = {
    id?: true
    sku?: true
    saleprice?: true
    category?: true
    categorytag?: true
    temp?: true
    priceflag?: true
    saleapplied?: true
    promotionalSaleID?: true
    done?: true
    user_id?: true
  }

  export type Aproducts_extMaxAggregateInputType = {
    id?: true
    sku?: true
    saleprice?: true
    category?: true
    categorytag?: true
    temp?: true
    priceflag?: true
    saleapplied?: true
    promotionalSaleID?: true
    done?: true
    user_id?: true
  }

  export type Aproducts_extCountAggregateInputType = {
    id?: true
    sku?: true
    saleprice?: true
    category?: true
    categorytag?: true
    temp?: true
    priceflag?: true
    saleapplied?: true
    promotionalSaleID?: true
    done?: true
    user_id?: true
    _all?: true
  }

  export type Aproducts_extAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which aproducts_ext to aggregate.
     */
    where?: aproducts_extWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts_exts to fetch.
     */
    orderBy?: aproducts_extOrderByWithRelationInput | aproducts_extOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: aproducts_extWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts_exts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts_exts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned aproducts_exts
    **/
    _count?: true | Aproducts_extCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Aproducts_extAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Aproducts_extSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Aproducts_extMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Aproducts_extMaxAggregateInputType
  }

  export type GetAproducts_extAggregateType<T extends Aproducts_extAggregateArgs> = {
        [P in keyof T & keyof AggregateAproducts_ext]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAproducts_ext[P]>
      : GetScalarType<T[P], AggregateAproducts_ext[P]>
  }




  export type aproducts_extGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: aproducts_extWhereInput
    orderBy?: aproducts_extOrderByWithAggregationInput | aproducts_extOrderByWithAggregationInput[]
    by: Aproducts_extScalarFieldEnum[] | Aproducts_extScalarFieldEnum
    having?: aproducts_extScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Aproducts_extCountAggregateInputType | true
    _avg?: Aproducts_extAvgAggregateInputType
    _sum?: Aproducts_extSumAggregateInputType
    _min?: Aproducts_extMinAggregateInputType
    _max?: Aproducts_extMaxAggregateInputType
  }

  export type Aproducts_extGroupByOutputType = {
    id: number
    sku: string
    saleprice: number
    category: string
    categorytag: string
    temp: string
    priceflag: boolean
    saleapplied: boolean
    promotionalSaleID: string
    done: boolean
    user_id: number
    _count: Aproducts_extCountAggregateOutputType | null
    _avg: Aproducts_extAvgAggregateOutputType | null
    _sum: Aproducts_extSumAggregateOutputType | null
    _min: Aproducts_extMinAggregateOutputType | null
    _max: Aproducts_extMaxAggregateOutputType | null
  }

  type GetAproducts_extGroupByPayload<T extends aproducts_extGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Aproducts_extGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Aproducts_extGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Aproducts_extGroupByOutputType[P]>
            : GetScalarType<T[P], Aproducts_extGroupByOutputType[P]>
        }
      >
    >


  export type aproducts_extSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    sku?: boolean
    saleprice?: boolean
    category?: boolean
    categorytag?: boolean
    temp?: boolean
    priceflag?: boolean
    saleapplied?: boolean
    promotionalSaleID?: boolean
    done?: boolean
    user_id?: boolean
  }, ExtArgs["result"]["aproducts_ext"]>



  export type aproducts_extSelectScalar = {
    id?: boolean
    sku?: boolean
    saleprice?: boolean
    category?: boolean
    categorytag?: boolean
    temp?: boolean
    priceflag?: boolean
    saleapplied?: boolean
    promotionalSaleID?: boolean
    done?: boolean
    user_id?: boolean
  }

  export type aproducts_extOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "sku" | "saleprice" | "category" | "categorytag" | "temp" | "priceflag" | "saleapplied" | "promotionalSaleID" | "done" | "user_id", ExtArgs["result"]["aproducts_ext"]>

  export type $aproducts_extPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "aproducts_ext"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      sku: string
      saleprice: number
      category: string
      categorytag: string
      temp: string
      priceflag: boolean
      saleapplied: boolean
      promotionalSaleID: string
      done: boolean
      user_id: number
    }, ExtArgs["result"]["aproducts_ext"]>
    composites: {}
  }

  type aproducts_extGetPayload<S extends boolean | null | undefined | aproducts_extDefaultArgs> = $Result.GetResult<Prisma.$aproducts_extPayload, S>

  type aproducts_extCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<aproducts_extFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Aproducts_extCountAggregateInputType | true
    }

  export interface aproducts_extDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['aproducts_ext'], meta: { name: 'aproducts_ext' } }
    /**
     * Find zero or one Aproducts_ext that matches the filter.
     * @param {aproducts_extFindUniqueArgs} args - Arguments to find a Aproducts_ext
     * @example
     * // Get one Aproducts_ext
     * const aproducts_ext = await prisma.aproducts_ext.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends aproducts_extFindUniqueArgs>(args: SelectSubset<T, aproducts_extFindUniqueArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Aproducts_ext that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {aproducts_extFindUniqueOrThrowArgs} args - Arguments to find a Aproducts_ext
     * @example
     * // Get one Aproducts_ext
     * const aproducts_ext = await prisma.aproducts_ext.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends aproducts_extFindUniqueOrThrowArgs>(args: SelectSubset<T, aproducts_extFindUniqueOrThrowArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Aproducts_ext that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproducts_extFindFirstArgs} args - Arguments to find a Aproducts_ext
     * @example
     * // Get one Aproducts_ext
     * const aproducts_ext = await prisma.aproducts_ext.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends aproducts_extFindFirstArgs>(args?: SelectSubset<T, aproducts_extFindFirstArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Aproducts_ext that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproducts_extFindFirstOrThrowArgs} args - Arguments to find a Aproducts_ext
     * @example
     * // Get one Aproducts_ext
     * const aproducts_ext = await prisma.aproducts_ext.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends aproducts_extFindFirstOrThrowArgs>(args?: SelectSubset<T, aproducts_extFindFirstOrThrowArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Aproducts_exts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproducts_extFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Aproducts_exts
     * const aproducts_exts = await prisma.aproducts_ext.findMany()
     * 
     * // Get first 10 Aproducts_exts
     * const aproducts_exts = await prisma.aproducts_ext.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const aproducts_extWithIdOnly = await prisma.aproducts_ext.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends aproducts_extFindManyArgs>(args?: SelectSubset<T, aproducts_extFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Aproducts_ext.
     * @param {aproducts_extCreateArgs} args - Arguments to create a Aproducts_ext.
     * @example
     * // Create one Aproducts_ext
     * const Aproducts_ext = await prisma.aproducts_ext.create({
     *   data: {
     *     // ... data to create a Aproducts_ext
     *   }
     * })
     * 
     */
    create<T extends aproducts_extCreateArgs>(args: SelectSubset<T, aproducts_extCreateArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Aproducts_exts.
     * @param {aproducts_extCreateManyArgs} args - Arguments to create many Aproducts_exts.
     * @example
     * // Create many Aproducts_exts
     * const aproducts_ext = await prisma.aproducts_ext.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends aproducts_extCreateManyArgs>(args?: SelectSubset<T, aproducts_extCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Aproducts_ext.
     * @param {aproducts_extDeleteArgs} args - Arguments to delete one Aproducts_ext.
     * @example
     * // Delete one Aproducts_ext
     * const Aproducts_ext = await prisma.aproducts_ext.delete({
     *   where: {
     *     // ... filter to delete one Aproducts_ext
     *   }
     * })
     * 
     */
    delete<T extends aproducts_extDeleteArgs>(args: SelectSubset<T, aproducts_extDeleteArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Aproducts_ext.
     * @param {aproducts_extUpdateArgs} args - Arguments to update one Aproducts_ext.
     * @example
     * // Update one Aproducts_ext
     * const aproducts_ext = await prisma.aproducts_ext.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends aproducts_extUpdateArgs>(args: SelectSubset<T, aproducts_extUpdateArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Aproducts_exts.
     * @param {aproducts_extDeleteManyArgs} args - Arguments to filter Aproducts_exts to delete.
     * @example
     * // Delete a few Aproducts_exts
     * const { count } = await prisma.aproducts_ext.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends aproducts_extDeleteManyArgs>(args?: SelectSubset<T, aproducts_extDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Aproducts_exts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproducts_extUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Aproducts_exts
     * const aproducts_ext = await prisma.aproducts_ext.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends aproducts_extUpdateManyArgs>(args: SelectSubset<T, aproducts_extUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Aproducts_ext.
     * @param {aproducts_extUpsertArgs} args - Arguments to update or create a Aproducts_ext.
     * @example
     * // Update or create a Aproducts_ext
     * const aproducts_ext = await prisma.aproducts_ext.upsert({
     *   create: {
     *     // ... data to create a Aproducts_ext
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Aproducts_ext we want to update
     *   }
     * })
     */
    upsert<T extends aproducts_extUpsertArgs>(args: SelectSubset<T, aproducts_extUpsertArgs<ExtArgs>>): Prisma__aproducts_extClient<$Result.GetResult<Prisma.$aproducts_extPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Aproducts_exts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproducts_extCountArgs} args - Arguments to filter Aproducts_exts to count.
     * @example
     * // Count the number of Aproducts_exts
     * const count = await prisma.aproducts_ext.count({
     *   where: {
     *     // ... the filter for the Aproducts_exts we want to count
     *   }
     * })
    **/
    count<T extends aproducts_extCountArgs>(
      args?: Subset<T, aproducts_extCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Aproducts_extCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Aproducts_ext.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Aproducts_extAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Aproducts_extAggregateArgs>(args: Subset<T, Aproducts_extAggregateArgs>): Prisma.PrismaPromise<GetAproducts_extAggregateType<T>>

    /**
     * Group by Aproducts_ext.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {aproducts_extGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends aproducts_extGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: aproducts_extGroupByArgs['orderBy'] }
        : { orderBy?: aproducts_extGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, aproducts_extGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAproducts_extGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the aproducts_ext model
   */
  readonly fields: aproducts_extFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for aproducts_ext.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__aproducts_extClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the aproducts_ext model
   */
  interface aproducts_extFieldRefs {
    readonly id: FieldRef<"aproducts_ext", 'Int'>
    readonly sku: FieldRef<"aproducts_ext", 'String'>
    readonly saleprice: FieldRef<"aproducts_ext", 'Float'>
    readonly category: FieldRef<"aproducts_ext", 'String'>
    readonly categorytag: FieldRef<"aproducts_ext", 'String'>
    readonly temp: FieldRef<"aproducts_ext", 'String'>
    readonly priceflag: FieldRef<"aproducts_ext", 'Boolean'>
    readonly saleapplied: FieldRef<"aproducts_ext", 'Boolean'>
    readonly promotionalSaleID: FieldRef<"aproducts_ext", 'String'>
    readonly done: FieldRef<"aproducts_ext", 'Boolean'>
    readonly user_id: FieldRef<"aproducts_ext", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * aproducts_ext findUnique
   */
  export type aproducts_extFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * Filter, which aproducts_ext to fetch.
     */
    where: aproducts_extWhereUniqueInput
  }

  /**
   * aproducts_ext findUniqueOrThrow
   */
  export type aproducts_extFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * Filter, which aproducts_ext to fetch.
     */
    where: aproducts_extWhereUniqueInput
  }

  /**
   * aproducts_ext findFirst
   */
  export type aproducts_extFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * Filter, which aproducts_ext to fetch.
     */
    where?: aproducts_extWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts_exts to fetch.
     */
    orderBy?: aproducts_extOrderByWithRelationInput | aproducts_extOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for aproducts_exts.
     */
    cursor?: aproducts_extWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts_exts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts_exts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of aproducts_exts.
     */
    distinct?: Aproducts_extScalarFieldEnum | Aproducts_extScalarFieldEnum[]
  }

  /**
   * aproducts_ext findFirstOrThrow
   */
  export type aproducts_extFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * Filter, which aproducts_ext to fetch.
     */
    where?: aproducts_extWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts_exts to fetch.
     */
    orderBy?: aproducts_extOrderByWithRelationInput | aproducts_extOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for aproducts_exts.
     */
    cursor?: aproducts_extWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts_exts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts_exts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of aproducts_exts.
     */
    distinct?: Aproducts_extScalarFieldEnum | Aproducts_extScalarFieldEnum[]
  }

  /**
   * aproducts_ext findMany
   */
  export type aproducts_extFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * Filter, which aproducts_exts to fetch.
     */
    where?: aproducts_extWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of aproducts_exts to fetch.
     */
    orderBy?: aproducts_extOrderByWithRelationInput | aproducts_extOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing aproducts_exts.
     */
    cursor?: aproducts_extWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` aproducts_exts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` aproducts_exts.
     */
    skip?: number
    distinct?: Aproducts_extScalarFieldEnum | Aproducts_extScalarFieldEnum[]
  }

  /**
   * aproducts_ext create
   */
  export type aproducts_extCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * The data needed to create a aproducts_ext.
     */
    data: XOR<aproducts_extCreateInput, aproducts_extUncheckedCreateInput>
  }

  /**
   * aproducts_ext createMany
   */
  export type aproducts_extCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many aproducts_exts.
     */
    data: aproducts_extCreateManyInput | aproducts_extCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * aproducts_ext update
   */
  export type aproducts_extUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * The data needed to update a aproducts_ext.
     */
    data: XOR<aproducts_extUpdateInput, aproducts_extUncheckedUpdateInput>
    /**
     * Choose, which aproducts_ext to update.
     */
    where: aproducts_extWhereUniqueInput
  }

  /**
   * aproducts_ext updateMany
   */
  export type aproducts_extUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update aproducts_exts.
     */
    data: XOR<aproducts_extUpdateManyMutationInput, aproducts_extUncheckedUpdateManyInput>
    /**
     * Filter which aproducts_exts to update
     */
    where?: aproducts_extWhereInput
    /**
     * Limit how many aproducts_exts to update.
     */
    limit?: number
  }

  /**
   * aproducts_ext upsert
   */
  export type aproducts_extUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * The filter to search for the aproducts_ext to update in case it exists.
     */
    where: aproducts_extWhereUniqueInput
    /**
     * In case the aproducts_ext found by the `where` argument doesn't exist, create a new aproducts_ext with this data.
     */
    create: XOR<aproducts_extCreateInput, aproducts_extUncheckedCreateInput>
    /**
     * In case the aproducts_ext was found with the provided `where` argument, update it with this data.
     */
    update: XOR<aproducts_extUpdateInput, aproducts_extUncheckedUpdateInput>
  }

  /**
   * aproducts_ext delete
   */
  export type aproducts_extDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
    /**
     * Filter which aproducts_ext to delete.
     */
    where: aproducts_extWhereUniqueInput
  }

  /**
   * aproducts_ext deleteMany
   */
  export type aproducts_extDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which aproducts_exts to delete
     */
    where?: aproducts_extWhereInput
    /**
     * Limit how many aproducts_exts to delete.
     */
    limit?: number
  }

  /**
   * aproducts_ext without action
   */
  export type aproducts_extDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the aproducts_ext
     */
    select?: aproducts_extSelect<ExtArgs> | null
    /**
     * Omit specific fields from the aproducts_ext
     */
    omit?: aproducts_extOmit<ExtArgs> | null
  }


  /**
   * Model buybox
   */

  export type AggregateBuybox = {
    _count: BuyboxCountAggregateOutputType | null
    _avg: BuyboxAvgAggregateOutputType | null
    _sum: BuyboxSumAggregateOutputType | null
    _min: BuyboxMinAggregateOutputType | null
    _max: BuyboxMaxAggregateOutputType | null
  }

  export type BuyboxAvgAggregateOutputType = {
    id: number | null
    listing_price: number | null
    landing_price: number | null
    shipping_price: number | null
  }

  export type BuyboxSumAggregateOutputType = {
    id: number | null
    listing_price: number | null
    landing_price: number | null
    shipping_price: number | null
  }

  export type BuyboxMinAggregateOutputType = {
    id: number | null
    asin: string | null
    item_condition: string | null
    listing_price: number | null
    landing_price: number | null
    shipping_price: number | null
    invalid: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type BuyboxMaxAggregateOutputType = {
    id: number | null
    asin: string | null
    item_condition: string | null
    listing_price: number | null
    landing_price: number | null
    shipping_price: number | null
    invalid: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type BuyboxCountAggregateOutputType = {
    id: number
    asin: number
    item_condition: number
    listing_price: number
    landing_price: number
    shipping_price: number
    invalid: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type BuyboxAvgAggregateInputType = {
    id?: true
    listing_price?: true
    landing_price?: true
    shipping_price?: true
  }

  export type BuyboxSumAggregateInputType = {
    id?: true
    listing_price?: true
    landing_price?: true
    shipping_price?: true
  }

  export type BuyboxMinAggregateInputType = {
    id?: true
    asin?: true
    item_condition?: true
    listing_price?: true
    landing_price?: true
    shipping_price?: true
    invalid?: true
    created_at?: true
    updated_at?: true
  }

  export type BuyboxMaxAggregateInputType = {
    id?: true
    asin?: true
    item_condition?: true
    listing_price?: true
    landing_price?: true
    shipping_price?: true
    invalid?: true
    created_at?: true
    updated_at?: true
  }

  export type BuyboxCountAggregateInputType = {
    id?: true
    asin?: true
    item_condition?: true
    listing_price?: true
    landing_price?: true
    shipping_price?: true
    invalid?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type BuyboxAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which buybox to aggregate.
     */
    where?: buyboxWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of buyboxes to fetch.
     */
    orderBy?: buyboxOrderByWithRelationInput | buyboxOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: buyboxWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` buyboxes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` buyboxes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned buyboxes
    **/
    _count?: true | BuyboxCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: BuyboxAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: BuyboxSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: BuyboxMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: BuyboxMaxAggregateInputType
  }

  export type GetBuyboxAggregateType<T extends BuyboxAggregateArgs> = {
        [P in keyof T & keyof AggregateBuybox]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateBuybox[P]>
      : GetScalarType<T[P], AggregateBuybox[P]>
  }




  export type buyboxGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: buyboxWhereInput
    orderBy?: buyboxOrderByWithAggregationInput | buyboxOrderByWithAggregationInput[]
    by: BuyboxScalarFieldEnum[] | BuyboxScalarFieldEnum
    having?: buyboxScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: BuyboxCountAggregateInputType | true
    _avg?: BuyboxAvgAggregateInputType
    _sum?: BuyboxSumAggregateInputType
    _min?: BuyboxMinAggregateInputType
    _max?: BuyboxMaxAggregateInputType
  }

  export type BuyboxGroupByOutputType = {
    id: number
    asin: string
    item_condition: string
    listing_price: number
    landing_price: number
    shipping_price: number
    invalid: boolean
    created_at: Date
    updated_at: Date
    _count: BuyboxCountAggregateOutputType | null
    _avg: BuyboxAvgAggregateOutputType | null
    _sum: BuyboxSumAggregateOutputType | null
    _min: BuyboxMinAggregateOutputType | null
    _max: BuyboxMaxAggregateOutputType | null
  }

  type GetBuyboxGroupByPayload<T extends buyboxGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<BuyboxGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof BuyboxGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], BuyboxGroupByOutputType[P]>
            : GetScalarType<T[P], BuyboxGroupByOutputType[P]>
        }
      >
    >


  export type buyboxSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    asin?: boolean
    item_condition?: boolean
    listing_price?: boolean
    landing_price?: boolean
    shipping_price?: boolean
    invalid?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["buybox"]>



  export type buyboxSelectScalar = {
    id?: boolean
    asin?: boolean
    item_condition?: boolean
    listing_price?: boolean
    landing_price?: boolean
    shipping_price?: boolean
    invalid?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type buyboxOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "asin" | "item_condition" | "listing_price" | "landing_price" | "shipping_price" | "invalid" | "created_at" | "updated_at", ExtArgs["result"]["buybox"]>

  export type $buyboxPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "buybox"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      asin: string
      item_condition: string
      listing_price: number
      landing_price: number
      shipping_price: number
      invalid: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["buybox"]>
    composites: {}
  }

  type buyboxGetPayload<S extends boolean | null | undefined | buyboxDefaultArgs> = $Result.GetResult<Prisma.$buyboxPayload, S>

  type buyboxCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<buyboxFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: BuyboxCountAggregateInputType | true
    }

  export interface buyboxDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['buybox'], meta: { name: 'buybox' } }
    /**
     * Find zero or one Buybox that matches the filter.
     * @param {buyboxFindUniqueArgs} args - Arguments to find a Buybox
     * @example
     * // Get one Buybox
     * const buybox = await prisma.buybox.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends buyboxFindUniqueArgs>(args: SelectSubset<T, buyboxFindUniqueArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Buybox that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {buyboxFindUniqueOrThrowArgs} args - Arguments to find a Buybox
     * @example
     * // Get one Buybox
     * const buybox = await prisma.buybox.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends buyboxFindUniqueOrThrowArgs>(args: SelectSubset<T, buyboxFindUniqueOrThrowArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Buybox that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {buyboxFindFirstArgs} args - Arguments to find a Buybox
     * @example
     * // Get one Buybox
     * const buybox = await prisma.buybox.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends buyboxFindFirstArgs>(args?: SelectSubset<T, buyboxFindFirstArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Buybox that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {buyboxFindFirstOrThrowArgs} args - Arguments to find a Buybox
     * @example
     * // Get one Buybox
     * const buybox = await prisma.buybox.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends buyboxFindFirstOrThrowArgs>(args?: SelectSubset<T, buyboxFindFirstOrThrowArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Buyboxes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {buyboxFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Buyboxes
     * const buyboxes = await prisma.buybox.findMany()
     * 
     * // Get first 10 Buyboxes
     * const buyboxes = await prisma.buybox.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const buyboxWithIdOnly = await prisma.buybox.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends buyboxFindManyArgs>(args?: SelectSubset<T, buyboxFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Buybox.
     * @param {buyboxCreateArgs} args - Arguments to create a Buybox.
     * @example
     * // Create one Buybox
     * const Buybox = await prisma.buybox.create({
     *   data: {
     *     // ... data to create a Buybox
     *   }
     * })
     * 
     */
    create<T extends buyboxCreateArgs>(args: SelectSubset<T, buyboxCreateArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Buyboxes.
     * @param {buyboxCreateManyArgs} args - Arguments to create many Buyboxes.
     * @example
     * // Create many Buyboxes
     * const buybox = await prisma.buybox.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends buyboxCreateManyArgs>(args?: SelectSubset<T, buyboxCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Buybox.
     * @param {buyboxDeleteArgs} args - Arguments to delete one Buybox.
     * @example
     * // Delete one Buybox
     * const Buybox = await prisma.buybox.delete({
     *   where: {
     *     // ... filter to delete one Buybox
     *   }
     * })
     * 
     */
    delete<T extends buyboxDeleteArgs>(args: SelectSubset<T, buyboxDeleteArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Buybox.
     * @param {buyboxUpdateArgs} args - Arguments to update one Buybox.
     * @example
     * // Update one Buybox
     * const buybox = await prisma.buybox.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends buyboxUpdateArgs>(args: SelectSubset<T, buyboxUpdateArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Buyboxes.
     * @param {buyboxDeleteManyArgs} args - Arguments to filter Buyboxes to delete.
     * @example
     * // Delete a few Buyboxes
     * const { count } = await prisma.buybox.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends buyboxDeleteManyArgs>(args?: SelectSubset<T, buyboxDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Buyboxes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {buyboxUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Buyboxes
     * const buybox = await prisma.buybox.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends buyboxUpdateManyArgs>(args: SelectSubset<T, buyboxUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Buybox.
     * @param {buyboxUpsertArgs} args - Arguments to update or create a Buybox.
     * @example
     * // Update or create a Buybox
     * const buybox = await prisma.buybox.upsert({
     *   create: {
     *     // ... data to create a Buybox
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Buybox we want to update
     *   }
     * })
     */
    upsert<T extends buyboxUpsertArgs>(args: SelectSubset<T, buyboxUpsertArgs<ExtArgs>>): Prisma__buyboxClient<$Result.GetResult<Prisma.$buyboxPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Buyboxes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {buyboxCountArgs} args - Arguments to filter Buyboxes to count.
     * @example
     * // Count the number of Buyboxes
     * const count = await prisma.buybox.count({
     *   where: {
     *     // ... the filter for the Buyboxes we want to count
     *   }
     * })
    **/
    count<T extends buyboxCountArgs>(
      args?: Subset<T, buyboxCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], BuyboxCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Buybox.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BuyboxAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends BuyboxAggregateArgs>(args: Subset<T, BuyboxAggregateArgs>): Prisma.PrismaPromise<GetBuyboxAggregateType<T>>

    /**
     * Group by Buybox.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {buyboxGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends buyboxGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: buyboxGroupByArgs['orderBy'] }
        : { orderBy?: buyboxGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, buyboxGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetBuyboxGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the buybox model
   */
  readonly fields: buyboxFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for buybox.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__buyboxClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the buybox model
   */
  interface buyboxFieldRefs {
    readonly id: FieldRef<"buybox", 'Int'>
    readonly asin: FieldRef<"buybox", 'String'>
    readonly item_condition: FieldRef<"buybox", 'String'>
    readonly listing_price: FieldRef<"buybox", 'Float'>
    readonly landing_price: FieldRef<"buybox", 'Float'>
    readonly shipping_price: FieldRef<"buybox", 'Float'>
    readonly invalid: FieldRef<"buybox", 'Boolean'>
    readonly created_at: FieldRef<"buybox", 'DateTime'>
    readonly updated_at: FieldRef<"buybox", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * buybox findUnique
   */
  export type buyboxFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * Filter, which buybox to fetch.
     */
    where: buyboxWhereUniqueInput
  }

  /**
   * buybox findUniqueOrThrow
   */
  export type buyboxFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * Filter, which buybox to fetch.
     */
    where: buyboxWhereUniqueInput
  }

  /**
   * buybox findFirst
   */
  export type buyboxFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * Filter, which buybox to fetch.
     */
    where?: buyboxWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of buyboxes to fetch.
     */
    orderBy?: buyboxOrderByWithRelationInput | buyboxOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for buyboxes.
     */
    cursor?: buyboxWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` buyboxes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` buyboxes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of buyboxes.
     */
    distinct?: BuyboxScalarFieldEnum | BuyboxScalarFieldEnum[]
  }

  /**
   * buybox findFirstOrThrow
   */
  export type buyboxFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * Filter, which buybox to fetch.
     */
    where?: buyboxWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of buyboxes to fetch.
     */
    orderBy?: buyboxOrderByWithRelationInput | buyboxOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for buyboxes.
     */
    cursor?: buyboxWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` buyboxes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` buyboxes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of buyboxes.
     */
    distinct?: BuyboxScalarFieldEnum | BuyboxScalarFieldEnum[]
  }

  /**
   * buybox findMany
   */
  export type buyboxFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * Filter, which buyboxes to fetch.
     */
    where?: buyboxWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of buyboxes to fetch.
     */
    orderBy?: buyboxOrderByWithRelationInput | buyboxOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing buyboxes.
     */
    cursor?: buyboxWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` buyboxes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` buyboxes.
     */
    skip?: number
    distinct?: BuyboxScalarFieldEnum | BuyboxScalarFieldEnum[]
  }

  /**
   * buybox create
   */
  export type buyboxCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * The data needed to create a buybox.
     */
    data: XOR<buyboxCreateInput, buyboxUncheckedCreateInput>
  }

  /**
   * buybox createMany
   */
  export type buyboxCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many buyboxes.
     */
    data: buyboxCreateManyInput | buyboxCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * buybox update
   */
  export type buyboxUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * The data needed to update a buybox.
     */
    data: XOR<buyboxUpdateInput, buyboxUncheckedUpdateInput>
    /**
     * Choose, which buybox to update.
     */
    where: buyboxWhereUniqueInput
  }

  /**
   * buybox updateMany
   */
  export type buyboxUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update buyboxes.
     */
    data: XOR<buyboxUpdateManyMutationInput, buyboxUncheckedUpdateManyInput>
    /**
     * Filter which buyboxes to update
     */
    where?: buyboxWhereInput
    /**
     * Limit how many buyboxes to update.
     */
    limit?: number
  }

  /**
   * buybox upsert
   */
  export type buyboxUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * The filter to search for the buybox to update in case it exists.
     */
    where: buyboxWhereUniqueInput
    /**
     * In case the buybox found by the `where` argument doesn't exist, create a new buybox with this data.
     */
    create: XOR<buyboxCreateInput, buyboxUncheckedCreateInput>
    /**
     * In case the buybox was found with the provided `where` argument, update it with this data.
     */
    update: XOR<buyboxUpdateInput, buyboxUncheckedUpdateInput>
  }

  /**
   * buybox delete
   */
  export type buyboxDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
    /**
     * Filter which buybox to delete.
     */
    where: buyboxWhereUniqueInput
  }

  /**
   * buybox deleteMany
   */
  export type buyboxDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which buyboxes to delete
     */
    where?: buyboxWhereInput
    /**
     * Limit how many buyboxes to delete.
     */
    limit?: number
  }

  /**
   * buybox without action
   */
  export type buyboxDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the buybox
     */
    select?: buyboxSelect<ExtArgs> | null
    /**
     * Omit specific fields from the buybox
     */
    omit?: buyboxOmit<ExtArgs> | null
  }


  /**
   * Model chargerequest
   */

  export type AggregateChargerequest = {
    _count: ChargerequestCountAggregateOutputType | null
    _avg: ChargerequestAvgAggregateOutputType | null
    _sum: ChargerequestSumAggregateOutputType | null
    _min: ChargerequestMinAggregateOutputType | null
    _max: ChargerequestMaxAggregateOutputType | null
  }

  export type ChargerequestAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    price: number | null
  }

  export type ChargerequestSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    price: number | null
  }

  export type ChargerequestMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    charge_id: string | null
    api_client_id: string | null
    price: number | null
    status: string | null
    created_at: string | null
    updated_at: string | null
    response: string | null
  }

  export type ChargerequestMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    charge_id: string | null
    api_client_id: string | null
    price: number | null
    status: string | null
    created_at: string | null
    updated_at: string | null
    response: string | null
  }

  export type ChargerequestCountAggregateOutputType = {
    id: number
    user_id: number
    charge_id: number
    api_client_id: number
    price: number
    status: number
    created_at: number
    updated_at: number
    response: number
    _all: number
  }


  export type ChargerequestAvgAggregateInputType = {
    id?: true
    user_id?: true
    price?: true
  }

  export type ChargerequestSumAggregateInputType = {
    id?: true
    user_id?: true
    price?: true
  }

  export type ChargerequestMinAggregateInputType = {
    id?: true
    user_id?: true
    charge_id?: true
    api_client_id?: true
    price?: true
    status?: true
    created_at?: true
    updated_at?: true
    response?: true
  }

  export type ChargerequestMaxAggregateInputType = {
    id?: true
    user_id?: true
    charge_id?: true
    api_client_id?: true
    price?: true
    status?: true
    created_at?: true
    updated_at?: true
    response?: true
  }

  export type ChargerequestCountAggregateInputType = {
    id?: true
    user_id?: true
    charge_id?: true
    api_client_id?: true
    price?: true
    status?: true
    created_at?: true
    updated_at?: true
    response?: true
    _all?: true
  }

  export type ChargerequestAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which chargerequest to aggregate.
     */
    where?: chargerequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of chargerequests to fetch.
     */
    orderBy?: chargerequestOrderByWithRelationInput | chargerequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: chargerequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` chargerequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` chargerequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned chargerequests
    **/
    _count?: true | ChargerequestCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ChargerequestAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ChargerequestSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ChargerequestMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ChargerequestMaxAggregateInputType
  }

  export type GetChargerequestAggregateType<T extends ChargerequestAggregateArgs> = {
        [P in keyof T & keyof AggregateChargerequest]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateChargerequest[P]>
      : GetScalarType<T[P], AggregateChargerequest[P]>
  }




  export type chargerequestGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: chargerequestWhereInput
    orderBy?: chargerequestOrderByWithAggregationInput | chargerequestOrderByWithAggregationInput[]
    by: ChargerequestScalarFieldEnum[] | ChargerequestScalarFieldEnum
    having?: chargerequestScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ChargerequestCountAggregateInputType | true
    _avg?: ChargerequestAvgAggregateInputType
    _sum?: ChargerequestSumAggregateInputType
    _min?: ChargerequestMinAggregateInputType
    _max?: ChargerequestMaxAggregateInputType
  }

  export type ChargerequestGroupByOutputType = {
    id: number
    user_id: number
    charge_id: string
    api_client_id: string
    price: number
    status: string
    created_at: string
    updated_at: string
    response: string
    _count: ChargerequestCountAggregateOutputType | null
    _avg: ChargerequestAvgAggregateOutputType | null
    _sum: ChargerequestSumAggregateOutputType | null
    _min: ChargerequestMinAggregateOutputType | null
    _max: ChargerequestMaxAggregateOutputType | null
  }

  type GetChargerequestGroupByPayload<T extends chargerequestGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ChargerequestGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ChargerequestGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ChargerequestGroupByOutputType[P]>
            : GetScalarType<T[P], ChargerequestGroupByOutputType[P]>
        }
      >
    >


  export type chargerequestSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    charge_id?: boolean
    api_client_id?: boolean
    price?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    response?: boolean
  }, ExtArgs["result"]["chargerequest"]>



  export type chargerequestSelectScalar = {
    id?: boolean
    user_id?: boolean
    charge_id?: boolean
    api_client_id?: boolean
    price?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    response?: boolean
  }

  export type chargerequestOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "charge_id" | "api_client_id" | "price" | "status" | "created_at" | "updated_at" | "response", ExtArgs["result"]["chargerequest"]>

  export type $chargerequestPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "chargerequest"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      charge_id: string
      api_client_id: string
      price: number
      status: string
      created_at: string
      updated_at: string
      response: string
    }, ExtArgs["result"]["chargerequest"]>
    composites: {}
  }

  type chargerequestGetPayload<S extends boolean | null | undefined | chargerequestDefaultArgs> = $Result.GetResult<Prisma.$chargerequestPayload, S>

  type chargerequestCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<chargerequestFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ChargerequestCountAggregateInputType | true
    }

  export interface chargerequestDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['chargerequest'], meta: { name: 'chargerequest' } }
    /**
     * Find zero or one Chargerequest that matches the filter.
     * @param {chargerequestFindUniqueArgs} args - Arguments to find a Chargerequest
     * @example
     * // Get one Chargerequest
     * const chargerequest = await prisma.chargerequest.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends chargerequestFindUniqueArgs>(args: SelectSubset<T, chargerequestFindUniqueArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Chargerequest that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {chargerequestFindUniqueOrThrowArgs} args - Arguments to find a Chargerequest
     * @example
     * // Get one Chargerequest
     * const chargerequest = await prisma.chargerequest.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends chargerequestFindUniqueOrThrowArgs>(args: SelectSubset<T, chargerequestFindUniqueOrThrowArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Chargerequest that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {chargerequestFindFirstArgs} args - Arguments to find a Chargerequest
     * @example
     * // Get one Chargerequest
     * const chargerequest = await prisma.chargerequest.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends chargerequestFindFirstArgs>(args?: SelectSubset<T, chargerequestFindFirstArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Chargerequest that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {chargerequestFindFirstOrThrowArgs} args - Arguments to find a Chargerequest
     * @example
     * // Get one Chargerequest
     * const chargerequest = await prisma.chargerequest.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends chargerequestFindFirstOrThrowArgs>(args?: SelectSubset<T, chargerequestFindFirstOrThrowArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Chargerequests that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {chargerequestFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Chargerequests
     * const chargerequests = await prisma.chargerequest.findMany()
     * 
     * // Get first 10 Chargerequests
     * const chargerequests = await prisma.chargerequest.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const chargerequestWithIdOnly = await prisma.chargerequest.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends chargerequestFindManyArgs>(args?: SelectSubset<T, chargerequestFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Chargerequest.
     * @param {chargerequestCreateArgs} args - Arguments to create a Chargerequest.
     * @example
     * // Create one Chargerequest
     * const Chargerequest = await prisma.chargerequest.create({
     *   data: {
     *     // ... data to create a Chargerequest
     *   }
     * })
     * 
     */
    create<T extends chargerequestCreateArgs>(args: SelectSubset<T, chargerequestCreateArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Chargerequests.
     * @param {chargerequestCreateManyArgs} args - Arguments to create many Chargerequests.
     * @example
     * // Create many Chargerequests
     * const chargerequest = await prisma.chargerequest.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends chargerequestCreateManyArgs>(args?: SelectSubset<T, chargerequestCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Chargerequest.
     * @param {chargerequestDeleteArgs} args - Arguments to delete one Chargerequest.
     * @example
     * // Delete one Chargerequest
     * const Chargerequest = await prisma.chargerequest.delete({
     *   where: {
     *     // ... filter to delete one Chargerequest
     *   }
     * })
     * 
     */
    delete<T extends chargerequestDeleteArgs>(args: SelectSubset<T, chargerequestDeleteArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Chargerequest.
     * @param {chargerequestUpdateArgs} args - Arguments to update one Chargerequest.
     * @example
     * // Update one Chargerequest
     * const chargerequest = await prisma.chargerequest.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends chargerequestUpdateArgs>(args: SelectSubset<T, chargerequestUpdateArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Chargerequests.
     * @param {chargerequestDeleteManyArgs} args - Arguments to filter Chargerequests to delete.
     * @example
     * // Delete a few Chargerequests
     * const { count } = await prisma.chargerequest.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends chargerequestDeleteManyArgs>(args?: SelectSubset<T, chargerequestDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Chargerequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {chargerequestUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Chargerequests
     * const chargerequest = await prisma.chargerequest.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends chargerequestUpdateManyArgs>(args: SelectSubset<T, chargerequestUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Chargerequest.
     * @param {chargerequestUpsertArgs} args - Arguments to update or create a Chargerequest.
     * @example
     * // Update or create a Chargerequest
     * const chargerequest = await prisma.chargerequest.upsert({
     *   create: {
     *     // ... data to create a Chargerequest
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Chargerequest we want to update
     *   }
     * })
     */
    upsert<T extends chargerequestUpsertArgs>(args: SelectSubset<T, chargerequestUpsertArgs<ExtArgs>>): Prisma__chargerequestClient<$Result.GetResult<Prisma.$chargerequestPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Chargerequests.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {chargerequestCountArgs} args - Arguments to filter Chargerequests to count.
     * @example
     * // Count the number of Chargerequests
     * const count = await prisma.chargerequest.count({
     *   where: {
     *     // ... the filter for the Chargerequests we want to count
     *   }
     * })
    **/
    count<T extends chargerequestCountArgs>(
      args?: Subset<T, chargerequestCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ChargerequestCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Chargerequest.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ChargerequestAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ChargerequestAggregateArgs>(args: Subset<T, ChargerequestAggregateArgs>): Prisma.PrismaPromise<GetChargerequestAggregateType<T>>

    /**
     * Group by Chargerequest.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {chargerequestGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends chargerequestGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: chargerequestGroupByArgs['orderBy'] }
        : { orderBy?: chargerequestGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, chargerequestGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetChargerequestGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the chargerequest model
   */
  readonly fields: chargerequestFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for chargerequest.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__chargerequestClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the chargerequest model
   */
  interface chargerequestFieldRefs {
    readonly id: FieldRef<"chargerequest", 'Int'>
    readonly user_id: FieldRef<"chargerequest", 'Int'>
    readonly charge_id: FieldRef<"chargerequest", 'String'>
    readonly api_client_id: FieldRef<"chargerequest", 'String'>
    readonly price: FieldRef<"chargerequest", 'Float'>
    readonly status: FieldRef<"chargerequest", 'String'>
    readonly created_at: FieldRef<"chargerequest", 'String'>
    readonly updated_at: FieldRef<"chargerequest", 'String'>
    readonly response: FieldRef<"chargerequest", 'String'>
  }
    

  // Custom InputTypes
  /**
   * chargerequest findUnique
   */
  export type chargerequestFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * Filter, which chargerequest to fetch.
     */
    where: chargerequestWhereUniqueInput
  }

  /**
   * chargerequest findUniqueOrThrow
   */
  export type chargerequestFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * Filter, which chargerequest to fetch.
     */
    where: chargerequestWhereUniqueInput
  }

  /**
   * chargerequest findFirst
   */
  export type chargerequestFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * Filter, which chargerequest to fetch.
     */
    where?: chargerequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of chargerequests to fetch.
     */
    orderBy?: chargerequestOrderByWithRelationInput | chargerequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for chargerequests.
     */
    cursor?: chargerequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` chargerequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` chargerequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of chargerequests.
     */
    distinct?: ChargerequestScalarFieldEnum | ChargerequestScalarFieldEnum[]
  }

  /**
   * chargerequest findFirstOrThrow
   */
  export type chargerequestFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * Filter, which chargerequest to fetch.
     */
    where?: chargerequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of chargerequests to fetch.
     */
    orderBy?: chargerequestOrderByWithRelationInput | chargerequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for chargerequests.
     */
    cursor?: chargerequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` chargerequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` chargerequests.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of chargerequests.
     */
    distinct?: ChargerequestScalarFieldEnum | ChargerequestScalarFieldEnum[]
  }

  /**
   * chargerequest findMany
   */
  export type chargerequestFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * Filter, which chargerequests to fetch.
     */
    where?: chargerequestWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of chargerequests to fetch.
     */
    orderBy?: chargerequestOrderByWithRelationInput | chargerequestOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing chargerequests.
     */
    cursor?: chargerequestWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` chargerequests from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` chargerequests.
     */
    skip?: number
    distinct?: ChargerequestScalarFieldEnum | ChargerequestScalarFieldEnum[]
  }

  /**
   * chargerequest create
   */
  export type chargerequestCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * The data needed to create a chargerequest.
     */
    data: XOR<chargerequestCreateInput, chargerequestUncheckedCreateInput>
  }

  /**
   * chargerequest createMany
   */
  export type chargerequestCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many chargerequests.
     */
    data: chargerequestCreateManyInput | chargerequestCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * chargerequest update
   */
  export type chargerequestUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * The data needed to update a chargerequest.
     */
    data: XOR<chargerequestUpdateInput, chargerequestUncheckedUpdateInput>
    /**
     * Choose, which chargerequest to update.
     */
    where: chargerequestWhereUniqueInput
  }

  /**
   * chargerequest updateMany
   */
  export type chargerequestUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update chargerequests.
     */
    data: XOR<chargerequestUpdateManyMutationInput, chargerequestUncheckedUpdateManyInput>
    /**
     * Filter which chargerequests to update
     */
    where?: chargerequestWhereInput
    /**
     * Limit how many chargerequests to update.
     */
    limit?: number
  }

  /**
   * chargerequest upsert
   */
  export type chargerequestUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * The filter to search for the chargerequest to update in case it exists.
     */
    where: chargerequestWhereUniqueInput
    /**
     * In case the chargerequest found by the `where` argument doesn't exist, create a new chargerequest with this data.
     */
    create: XOR<chargerequestCreateInput, chargerequestUncheckedCreateInput>
    /**
     * In case the chargerequest was found with the provided `where` argument, update it with this data.
     */
    update: XOR<chargerequestUpdateInput, chargerequestUncheckedUpdateInput>
  }

  /**
   * chargerequest delete
   */
  export type chargerequestDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
    /**
     * Filter which chargerequest to delete.
     */
    where: chargerequestWhereUniqueInput
  }

  /**
   * chargerequest deleteMany
   */
  export type chargerequestDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which chargerequests to delete
     */
    where?: chargerequestWhereInput
    /**
     * Limit how many chargerequests to delete.
     */
    limit?: number
  }

  /**
   * chargerequest without action
   */
  export type chargerequestDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the chargerequest
     */
    select?: chargerequestSelect<ExtArgs> | null
    /**
     * Omit specific fields from the chargerequest
     */
    omit?: chargerequestOmit<ExtArgs> | null
  }


  /**
   * Model crons
   */

  export type AggregateCrons = {
    _count: CronsCountAggregateOutputType | null
    _avg: CronsAvgAggregateOutputType | null
    _sum: CronsSumAggregateOutputType | null
    _min: CronsMinAggregateOutputType | null
    _max: CronsMaxAggregateOutputType | null
  }

  export type CronsAvgAggregateOutputType = {
    id: number | null
    counter: number | null
  }

  export type CronsSumAggregateOutputType = {
    id: number | null
    counter: bigint | null
  }

  export type CronsMinAggregateOutputType = {
    id: number | null
    crontype: string | null
    isrunning: boolean | null
    counter: bigint | null
    lastrun: Date | null
  }

  export type CronsMaxAggregateOutputType = {
    id: number | null
    crontype: string | null
    isrunning: boolean | null
    counter: bigint | null
    lastrun: Date | null
  }

  export type CronsCountAggregateOutputType = {
    id: number
    crontype: number
    isrunning: number
    counter: number
    lastrun: number
    _all: number
  }


  export type CronsAvgAggregateInputType = {
    id?: true
    counter?: true
  }

  export type CronsSumAggregateInputType = {
    id?: true
    counter?: true
  }

  export type CronsMinAggregateInputType = {
    id?: true
    crontype?: true
    isrunning?: true
    counter?: true
    lastrun?: true
  }

  export type CronsMaxAggregateInputType = {
    id?: true
    crontype?: true
    isrunning?: true
    counter?: true
    lastrun?: true
  }

  export type CronsCountAggregateInputType = {
    id?: true
    crontype?: true
    isrunning?: true
    counter?: true
    lastrun?: true
    _all?: true
  }

  export type CronsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which crons to aggregate.
     */
    where?: cronsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of crons to fetch.
     */
    orderBy?: cronsOrderByWithRelationInput | cronsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: cronsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` crons from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` crons.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned crons
    **/
    _count?: true | CronsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CronsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CronsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CronsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CronsMaxAggregateInputType
  }

  export type GetCronsAggregateType<T extends CronsAggregateArgs> = {
        [P in keyof T & keyof AggregateCrons]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCrons[P]>
      : GetScalarType<T[P], AggregateCrons[P]>
  }




  export type cronsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: cronsWhereInput
    orderBy?: cronsOrderByWithAggregationInput | cronsOrderByWithAggregationInput[]
    by: CronsScalarFieldEnum[] | CronsScalarFieldEnum
    having?: cronsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CronsCountAggregateInputType | true
    _avg?: CronsAvgAggregateInputType
    _sum?: CronsSumAggregateInputType
    _min?: CronsMinAggregateInputType
    _max?: CronsMaxAggregateInputType
  }

  export type CronsGroupByOutputType = {
    id: number
    crontype: string
    isrunning: boolean
    counter: bigint
    lastrun: Date
    _count: CronsCountAggregateOutputType | null
    _avg: CronsAvgAggregateOutputType | null
    _sum: CronsSumAggregateOutputType | null
    _min: CronsMinAggregateOutputType | null
    _max: CronsMaxAggregateOutputType | null
  }

  type GetCronsGroupByPayload<T extends cronsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CronsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CronsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CronsGroupByOutputType[P]>
            : GetScalarType<T[P], CronsGroupByOutputType[P]>
        }
      >
    >


  export type cronsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    crontype?: boolean
    isrunning?: boolean
    counter?: boolean
    lastrun?: boolean
  }, ExtArgs["result"]["crons"]>



  export type cronsSelectScalar = {
    id?: boolean
    crontype?: boolean
    isrunning?: boolean
    counter?: boolean
    lastrun?: boolean
  }

  export type cronsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "crontype" | "isrunning" | "counter" | "lastrun", ExtArgs["result"]["crons"]>

  export type $cronsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "crons"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      crontype: string
      isrunning: boolean
      counter: bigint
      lastrun: Date
    }, ExtArgs["result"]["crons"]>
    composites: {}
  }

  type cronsGetPayload<S extends boolean | null | undefined | cronsDefaultArgs> = $Result.GetResult<Prisma.$cronsPayload, S>

  type cronsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<cronsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: CronsCountAggregateInputType | true
    }

  export interface cronsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['crons'], meta: { name: 'crons' } }
    /**
     * Find zero or one Crons that matches the filter.
     * @param {cronsFindUniqueArgs} args - Arguments to find a Crons
     * @example
     * // Get one Crons
     * const crons = await prisma.crons.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends cronsFindUniqueArgs>(args: SelectSubset<T, cronsFindUniqueArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Crons that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {cronsFindUniqueOrThrowArgs} args - Arguments to find a Crons
     * @example
     * // Get one Crons
     * const crons = await prisma.crons.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends cronsFindUniqueOrThrowArgs>(args: SelectSubset<T, cronsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Crons that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {cronsFindFirstArgs} args - Arguments to find a Crons
     * @example
     * // Get one Crons
     * const crons = await prisma.crons.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends cronsFindFirstArgs>(args?: SelectSubset<T, cronsFindFirstArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Crons that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {cronsFindFirstOrThrowArgs} args - Arguments to find a Crons
     * @example
     * // Get one Crons
     * const crons = await prisma.crons.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends cronsFindFirstOrThrowArgs>(args?: SelectSubset<T, cronsFindFirstOrThrowArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Crons that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {cronsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Crons
     * const crons = await prisma.crons.findMany()
     * 
     * // Get first 10 Crons
     * const crons = await prisma.crons.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const cronsWithIdOnly = await prisma.crons.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends cronsFindManyArgs>(args?: SelectSubset<T, cronsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Crons.
     * @param {cronsCreateArgs} args - Arguments to create a Crons.
     * @example
     * // Create one Crons
     * const Crons = await prisma.crons.create({
     *   data: {
     *     // ... data to create a Crons
     *   }
     * })
     * 
     */
    create<T extends cronsCreateArgs>(args: SelectSubset<T, cronsCreateArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Crons.
     * @param {cronsCreateManyArgs} args - Arguments to create many Crons.
     * @example
     * // Create many Crons
     * const crons = await prisma.crons.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends cronsCreateManyArgs>(args?: SelectSubset<T, cronsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Crons.
     * @param {cronsDeleteArgs} args - Arguments to delete one Crons.
     * @example
     * // Delete one Crons
     * const Crons = await prisma.crons.delete({
     *   where: {
     *     // ... filter to delete one Crons
     *   }
     * })
     * 
     */
    delete<T extends cronsDeleteArgs>(args: SelectSubset<T, cronsDeleteArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Crons.
     * @param {cronsUpdateArgs} args - Arguments to update one Crons.
     * @example
     * // Update one Crons
     * const crons = await prisma.crons.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends cronsUpdateArgs>(args: SelectSubset<T, cronsUpdateArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Crons.
     * @param {cronsDeleteManyArgs} args - Arguments to filter Crons to delete.
     * @example
     * // Delete a few Crons
     * const { count } = await prisma.crons.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends cronsDeleteManyArgs>(args?: SelectSubset<T, cronsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Crons.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {cronsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Crons
     * const crons = await prisma.crons.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends cronsUpdateManyArgs>(args: SelectSubset<T, cronsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Crons.
     * @param {cronsUpsertArgs} args - Arguments to update or create a Crons.
     * @example
     * // Update or create a Crons
     * const crons = await prisma.crons.upsert({
     *   create: {
     *     // ... data to create a Crons
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Crons we want to update
     *   }
     * })
     */
    upsert<T extends cronsUpsertArgs>(args: SelectSubset<T, cronsUpsertArgs<ExtArgs>>): Prisma__cronsClient<$Result.GetResult<Prisma.$cronsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Crons.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {cronsCountArgs} args - Arguments to filter Crons to count.
     * @example
     * // Count the number of Crons
     * const count = await prisma.crons.count({
     *   where: {
     *     // ... the filter for the Crons we want to count
     *   }
     * })
    **/
    count<T extends cronsCountArgs>(
      args?: Subset<T, cronsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CronsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Crons.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CronsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CronsAggregateArgs>(args: Subset<T, CronsAggregateArgs>): Prisma.PrismaPromise<GetCronsAggregateType<T>>

    /**
     * Group by Crons.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {cronsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends cronsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: cronsGroupByArgs['orderBy'] }
        : { orderBy?: cronsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, cronsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCronsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the crons model
   */
  readonly fields: cronsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for crons.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__cronsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the crons model
   */
  interface cronsFieldRefs {
    readonly id: FieldRef<"crons", 'Int'>
    readonly crontype: FieldRef<"crons", 'String'>
    readonly isrunning: FieldRef<"crons", 'Boolean'>
    readonly counter: FieldRef<"crons", 'BigInt'>
    readonly lastrun: FieldRef<"crons", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * crons findUnique
   */
  export type cronsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * Filter, which crons to fetch.
     */
    where: cronsWhereUniqueInput
  }

  /**
   * crons findUniqueOrThrow
   */
  export type cronsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * Filter, which crons to fetch.
     */
    where: cronsWhereUniqueInput
  }

  /**
   * crons findFirst
   */
  export type cronsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * Filter, which crons to fetch.
     */
    where?: cronsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of crons to fetch.
     */
    orderBy?: cronsOrderByWithRelationInput | cronsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for crons.
     */
    cursor?: cronsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` crons from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` crons.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of crons.
     */
    distinct?: CronsScalarFieldEnum | CronsScalarFieldEnum[]
  }

  /**
   * crons findFirstOrThrow
   */
  export type cronsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * Filter, which crons to fetch.
     */
    where?: cronsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of crons to fetch.
     */
    orderBy?: cronsOrderByWithRelationInput | cronsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for crons.
     */
    cursor?: cronsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` crons from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` crons.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of crons.
     */
    distinct?: CronsScalarFieldEnum | CronsScalarFieldEnum[]
  }

  /**
   * crons findMany
   */
  export type cronsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * Filter, which crons to fetch.
     */
    where?: cronsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of crons to fetch.
     */
    orderBy?: cronsOrderByWithRelationInput | cronsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing crons.
     */
    cursor?: cronsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` crons from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` crons.
     */
    skip?: number
    distinct?: CronsScalarFieldEnum | CronsScalarFieldEnum[]
  }

  /**
   * crons create
   */
  export type cronsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * The data needed to create a crons.
     */
    data: XOR<cronsCreateInput, cronsUncheckedCreateInput>
  }

  /**
   * crons createMany
   */
  export type cronsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many crons.
     */
    data: cronsCreateManyInput | cronsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * crons update
   */
  export type cronsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * The data needed to update a crons.
     */
    data: XOR<cronsUpdateInput, cronsUncheckedUpdateInput>
    /**
     * Choose, which crons to update.
     */
    where: cronsWhereUniqueInput
  }

  /**
   * crons updateMany
   */
  export type cronsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update crons.
     */
    data: XOR<cronsUpdateManyMutationInput, cronsUncheckedUpdateManyInput>
    /**
     * Filter which crons to update
     */
    where?: cronsWhereInput
    /**
     * Limit how many crons to update.
     */
    limit?: number
  }

  /**
   * crons upsert
   */
  export type cronsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * The filter to search for the crons to update in case it exists.
     */
    where: cronsWhereUniqueInput
    /**
     * In case the crons found by the `where` argument doesn't exist, create a new crons with this data.
     */
    create: XOR<cronsCreateInput, cronsUncheckedCreateInput>
    /**
     * In case the crons was found with the provided `where` argument, update it with this data.
     */
    update: XOR<cronsUpdateInput, cronsUncheckedUpdateInput>
  }

  /**
   * crons delete
   */
  export type cronsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
    /**
     * Filter which crons to delete.
     */
    where: cronsWhereUniqueInput
  }

  /**
   * crons deleteMany
   */
  export type cronsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which crons to delete
     */
    where?: cronsWhereInput
    /**
     * Limit how many crons to delete.
     */
    limit?: number
  }

  /**
   * crons without action
   */
  export type cronsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the crons
     */
    select?: cronsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the crons
     */
    omit?: cronsOmit<ExtArgs> | null
  }


  /**
   * Model dup_product_variants
   */

  export type AggregateDup_product_variants = {
    _count: Dup_product_variantsCountAggregateOutputType | null
    _avg: Dup_product_variantsAvgAggregateOutputType | null
    _sum: Dup_product_variantsSumAggregateOutputType | null
    _min: Dup_product_variantsMinAggregateOutputType | null
    _max: Dup_product_variantsMaxAggregateOutputType | null
  }

  export type Dup_product_variantsAvgAggregateOutputType = {
    id: number | null
    product_id: number | null
    orig_variant_id: number | null
    user_id: number | null
  }

  export type Dup_product_variantsSumAggregateOutputType = {
    id: number | null
    product_id: number | null
    orig_variant_id: number | null
    user_id: number | null
  }

  export type Dup_product_variantsMinAggregateOutputType = {
    id: number | null
    product_id: number | null
    orig_variant_id: number | null
    old_sku: string | null
    new_sku: string | null
    old_asin: string | null
    new_asin: string | null
    upc: string | null
    quantityflag: boolean | null
    priceflag: boolean | null
    status: $Enums.dup_product_variants_status | null
    errmsg: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Dup_product_variantsMaxAggregateOutputType = {
    id: number | null
    product_id: number | null
    orig_variant_id: number | null
    old_sku: string | null
    new_sku: string | null
    old_asin: string | null
    new_asin: string | null
    upc: string | null
    quantityflag: boolean | null
    priceflag: boolean | null
    status: $Enums.dup_product_variants_status | null
    errmsg: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Dup_product_variantsCountAggregateOutputType = {
    id: number
    product_id: number
    orig_variant_id: number
    old_sku: number
    new_sku: number
    old_asin: number
    new_asin: number
    upc: number
    quantityflag: number
    priceflag: number
    status: number
    errmsg: number
    user_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Dup_product_variantsAvgAggregateInputType = {
    id?: true
    product_id?: true
    orig_variant_id?: true
    user_id?: true
  }

  export type Dup_product_variantsSumAggregateInputType = {
    id?: true
    product_id?: true
    orig_variant_id?: true
    user_id?: true
  }

  export type Dup_product_variantsMinAggregateInputType = {
    id?: true
    product_id?: true
    orig_variant_id?: true
    old_sku?: true
    new_sku?: true
    old_asin?: true
    new_asin?: true
    upc?: true
    quantityflag?: true
    priceflag?: true
    status?: true
    errmsg?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Dup_product_variantsMaxAggregateInputType = {
    id?: true
    product_id?: true
    orig_variant_id?: true
    old_sku?: true
    new_sku?: true
    old_asin?: true
    new_asin?: true
    upc?: true
    quantityflag?: true
    priceflag?: true
    status?: true
    errmsg?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Dup_product_variantsCountAggregateInputType = {
    id?: true
    product_id?: true
    orig_variant_id?: true
    old_sku?: true
    new_sku?: true
    old_asin?: true
    new_asin?: true
    upc?: true
    quantityflag?: true
    priceflag?: true
    status?: true
    errmsg?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Dup_product_variantsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which dup_product_variants to aggregate.
     */
    where?: dup_product_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_product_variants to fetch.
     */
    orderBy?: dup_product_variantsOrderByWithRelationInput | dup_product_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: dup_product_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_product_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_product_variants.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned dup_product_variants
    **/
    _count?: true | Dup_product_variantsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Dup_product_variantsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Dup_product_variantsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Dup_product_variantsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Dup_product_variantsMaxAggregateInputType
  }

  export type GetDup_product_variantsAggregateType<T extends Dup_product_variantsAggregateArgs> = {
        [P in keyof T & keyof AggregateDup_product_variants]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDup_product_variants[P]>
      : GetScalarType<T[P], AggregateDup_product_variants[P]>
  }




  export type dup_product_variantsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: dup_product_variantsWhereInput
    orderBy?: dup_product_variantsOrderByWithAggregationInput | dup_product_variantsOrderByWithAggregationInput[]
    by: Dup_product_variantsScalarFieldEnum[] | Dup_product_variantsScalarFieldEnum
    having?: dup_product_variantsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Dup_product_variantsCountAggregateInputType | true
    _avg?: Dup_product_variantsAvgAggregateInputType
    _sum?: Dup_product_variantsSumAggregateInputType
    _min?: Dup_product_variantsMinAggregateInputType
    _max?: Dup_product_variantsMaxAggregateInputType
  }

  export type Dup_product_variantsGroupByOutputType = {
    id: number
    product_id: number
    orig_variant_id: number
    old_sku: string
    new_sku: string
    old_asin: string
    new_asin: string
    upc: string
    quantityflag: boolean
    priceflag: boolean
    status: $Enums.dup_product_variants_status
    errmsg: string
    user_id: number
    created_at: Date
    updated_at: Date
    _count: Dup_product_variantsCountAggregateOutputType | null
    _avg: Dup_product_variantsAvgAggregateOutputType | null
    _sum: Dup_product_variantsSumAggregateOutputType | null
    _min: Dup_product_variantsMinAggregateOutputType | null
    _max: Dup_product_variantsMaxAggregateOutputType | null
  }

  type GetDup_product_variantsGroupByPayload<T extends dup_product_variantsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Dup_product_variantsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Dup_product_variantsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Dup_product_variantsGroupByOutputType[P]>
            : GetScalarType<T[P], Dup_product_variantsGroupByOutputType[P]>
        }
      >
    >


  export type dup_product_variantsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    orig_variant_id?: boolean
    old_sku?: boolean
    new_sku?: boolean
    old_asin?: boolean
    new_asin?: boolean
    upc?: boolean
    quantityflag?: boolean
    priceflag?: boolean
    status?: boolean
    errmsg?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["dup_product_variants"]>



  export type dup_product_variantsSelectScalar = {
    id?: boolean
    product_id?: boolean
    orig_variant_id?: boolean
    old_sku?: boolean
    new_sku?: boolean
    old_asin?: boolean
    new_asin?: boolean
    upc?: boolean
    quantityflag?: boolean
    priceflag?: boolean
    status?: boolean
    errmsg?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type dup_product_variantsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "product_id" | "orig_variant_id" | "old_sku" | "new_sku" | "old_asin" | "new_asin" | "upc" | "quantityflag" | "priceflag" | "status" | "errmsg" | "user_id" | "created_at" | "updated_at", ExtArgs["result"]["dup_product_variants"]>

  export type $dup_product_variantsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "dup_product_variants"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      product_id: number
      orig_variant_id: number
      old_sku: string
      new_sku: string
      old_asin: string
      new_asin: string
      upc: string
      quantityflag: boolean
      priceflag: boolean
      status: $Enums.dup_product_variants_status
      errmsg: string
      user_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["dup_product_variants"]>
    composites: {}
  }

  type dup_product_variantsGetPayload<S extends boolean | null | undefined | dup_product_variantsDefaultArgs> = $Result.GetResult<Prisma.$dup_product_variantsPayload, S>

  type dup_product_variantsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<dup_product_variantsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Dup_product_variantsCountAggregateInputType | true
    }

  export interface dup_product_variantsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['dup_product_variants'], meta: { name: 'dup_product_variants' } }
    /**
     * Find zero or one Dup_product_variants that matches the filter.
     * @param {dup_product_variantsFindUniqueArgs} args - Arguments to find a Dup_product_variants
     * @example
     * // Get one Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends dup_product_variantsFindUniqueArgs>(args: SelectSubset<T, dup_product_variantsFindUniqueArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Dup_product_variants that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {dup_product_variantsFindUniqueOrThrowArgs} args - Arguments to find a Dup_product_variants
     * @example
     * // Get one Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends dup_product_variantsFindUniqueOrThrowArgs>(args: SelectSubset<T, dup_product_variantsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Dup_product_variants that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_product_variantsFindFirstArgs} args - Arguments to find a Dup_product_variants
     * @example
     * // Get one Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends dup_product_variantsFindFirstArgs>(args?: SelectSubset<T, dup_product_variantsFindFirstArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Dup_product_variants that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_product_variantsFindFirstOrThrowArgs} args - Arguments to find a Dup_product_variants
     * @example
     * // Get one Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends dup_product_variantsFindFirstOrThrowArgs>(args?: SelectSubset<T, dup_product_variantsFindFirstOrThrowArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Dup_product_variants that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_product_variantsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.findMany()
     * 
     * // Get first 10 Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const dup_product_variantsWithIdOnly = await prisma.dup_product_variants.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends dup_product_variantsFindManyArgs>(args?: SelectSubset<T, dup_product_variantsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Dup_product_variants.
     * @param {dup_product_variantsCreateArgs} args - Arguments to create a Dup_product_variants.
     * @example
     * // Create one Dup_product_variants
     * const Dup_product_variants = await prisma.dup_product_variants.create({
     *   data: {
     *     // ... data to create a Dup_product_variants
     *   }
     * })
     * 
     */
    create<T extends dup_product_variantsCreateArgs>(args: SelectSubset<T, dup_product_variantsCreateArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Dup_product_variants.
     * @param {dup_product_variantsCreateManyArgs} args - Arguments to create many Dup_product_variants.
     * @example
     * // Create many Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends dup_product_variantsCreateManyArgs>(args?: SelectSubset<T, dup_product_variantsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Dup_product_variants.
     * @param {dup_product_variantsDeleteArgs} args - Arguments to delete one Dup_product_variants.
     * @example
     * // Delete one Dup_product_variants
     * const Dup_product_variants = await prisma.dup_product_variants.delete({
     *   where: {
     *     // ... filter to delete one Dup_product_variants
     *   }
     * })
     * 
     */
    delete<T extends dup_product_variantsDeleteArgs>(args: SelectSubset<T, dup_product_variantsDeleteArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Dup_product_variants.
     * @param {dup_product_variantsUpdateArgs} args - Arguments to update one Dup_product_variants.
     * @example
     * // Update one Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends dup_product_variantsUpdateArgs>(args: SelectSubset<T, dup_product_variantsUpdateArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Dup_product_variants.
     * @param {dup_product_variantsDeleteManyArgs} args - Arguments to filter Dup_product_variants to delete.
     * @example
     * // Delete a few Dup_product_variants
     * const { count } = await prisma.dup_product_variants.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends dup_product_variantsDeleteManyArgs>(args?: SelectSubset<T, dup_product_variantsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Dup_product_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_product_variantsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends dup_product_variantsUpdateManyArgs>(args: SelectSubset<T, dup_product_variantsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Dup_product_variants.
     * @param {dup_product_variantsUpsertArgs} args - Arguments to update or create a Dup_product_variants.
     * @example
     * // Update or create a Dup_product_variants
     * const dup_product_variants = await prisma.dup_product_variants.upsert({
     *   create: {
     *     // ... data to create a Dup_product_variants
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Dup_product_variants we want to update
     *   }
     * })
     */
    upsert<T extends dup_product_variantsUpsertArgs>(args: SelectSubset<T, dup_product_variantsUpsertArgs<ExtArgs>>): Prisma__dup_product_variantsClient<$Result.GetResult<Prisma.$dup_product_variantsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Dup_product_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_product_variantsCountArgs} args - Arguments to filter Dup_product_variants to count.
     * @example
     * // Count the number of Dup_product_variants
     * const count = await prisma.dup_product_variants.count({
     *   where: {
     *     // ... the filter for the Dup_product_variants we want to count
     *   }
     * })
    **/
    count<T extends dup_product_variantsCountArgs>(
      args?: Subset<T, dup_product_variantsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Dup_product_variantsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Dup_product_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Dup_product_variantsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Dup_product_variantsAggregateArgs>(args: Subset<T, Dup_product_variantsAggregateArgs>): Prisma.PrismaPromise<GetDup_product_variantsAggregateType<T>>

    /**
     * Group by Dup_product_variants.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_product_variantsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends dup_product_variantsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: dup_product_variantsGroupByArgs['orderBy'] }
        : { orderBy?: dup_product_variantsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, dup_product_variantsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDup_product_variantsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the dup_product_variants model
   */
  readonly fields: dup_product_variantsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for dup_product_variants.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__dup_product_variantsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the dup_product_variants model
   */
  interface dup_product_variantsFieldRefs {
    readonly id: FieldRef<"dup_product_variants", 'Int'>
    readonly product_id: FieldRef<"dup_product_variants", 'Int'>
    readonly orig_variant_id: FieldRef<"dup_product_variants", 'Int'>
    readonly old_sku: FieldRef<"dup_product_variants", 'String'>
    readonly new_sku: FieldRef<"dup_product_variants", 'String'>
    readonly old_asin: FieldRef<"dup_product_variants", 'String'>
    readonly new_asin: FieldRef<"dup_product_variants", 'String'>
    readonly upc: FieldRef<"dup_product_variants", 'String'>
    readonly quantityflag: FieldRef<"dup_product_variants", 'Boolean'>
    readonly priceflag: FieldRef<"dup_product_variants", 'Boolean'>
    readonly status: FieldRef<"dup_product_variants", 'dup_product_variants_status'>
    readonly errmsg: FieldRef<"dup_product_variants", 'String'>
    readonly user_id: FieldRef<"dup_product_variants", 'Int'>
    readonly created_at: FieldRef<"dup_product_variants", 'DateTime'>
    readonly updated_at: FieldRef<"dup_product_variants", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * dup_product_variants findUnique
   */
  export type dup_product_variantsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * Filter, which dup_product_variants to fetch.
     */
    where: dup_product_variantsWhereUniqueInput
  }

  /**
   * dup_product_variants findUniqueOrThrow
   */
  export type dup_product_variantsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * Filter, which dup_product_variants to fetch.
     */
    where: dup_product_variantsWhereUniqueInput
  }

  /**
   * dup_product_variants findFirst
   */
  export type dup_product_variantsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * Filter, which dup_product_variants to fetch.
     */
    where?: dup_product_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_product_variants to fetch.
     */
    orderBy?: dup_product_variantsOrderByWithRelationInput | dup_product_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for dup_product_variants.
     */
    cursor?: dup_product_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_product_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_product_variants.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of dup_product_variants.
     */
    distinct?: Dup_product_variantsScalarFieldEnum | Dup_product_variantsScalarFieldEnum[]
  }

  /**
   * dup_product_variants findFirstOrThrow
   */
  export type dup_product_variantsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * Filter, which dup_product_variants to fetch.
     */
    where?: dup_product_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_product_variants to fetch.
     */
    orderBy?: dup_product_variantsOrderByWithRelationInput | dup_product_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for dup_product_variants.
     */
    cursor?: dup_product_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_product_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_product_variants.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of dup_product_variants.
     */
    distinct?: Dup_product_variantsScalarFieldEnum | Dup_product_variantsScalarFieldEnum[]
  }

  /**
   * dup_product_variants findMany
   */
  export type dup_product_variantsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * Filter, which dup_product_variants to fetch.
     */
    where?: dup_product_variantsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_product_variants to fetch.
     */
    orderBy?: dup_product_variantsOrderByWithRelationInput | dup_product_variantsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing dup_product_variants.
     */
    cursor?: dup_product_variantsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_product_variants from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_product_variants.
     */
    skip?: number
    distinct?: Dup_product_variantsScalarFieldEnum | Dup_product_variantsScalarFieldEnum[]
  }

  /**
   * dup_product_variants create
   */
  export type dup_product_variantsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * The data needed to create a dup_product_variants.
     */
    data: XOR<dup_product_variantsCreateInput, dup_product_variantsUncheckedCreateInput>
  }

  /**
   * dup_product_variants createMany
   */
  export type dup_product_variantsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many dup_product_variants.
     */
    data: dup_product_variantsCreateManyInput | dup_product_variantsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * dup_product_variants update
   */
  export type dup_product_variantsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * The data needed to update a dup_product_variants.
     */
    data: XOR<dup_product_variantsUpdateInput, dup_product_variantsUncheckedUpdateInput>
    /**
     * Choose, which dup_product_variants to update.
     */
    where: dup_product_variantsWhereUniqueInput
  }

  /**
   * dup_product_variants updateMany
   */
  export type dup_product_variantsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update dup_product_variants.
     */
    data: XOR<dup_product_variantsUpdateManyMutationInput, dup_product_variantsUncheckedUpdateManyInput>
    /**
     * Filter which dup_product_variants to update
     */
    where?: dup_product_variantsWhereInput
    /**
     * Limit how many dup_product_variants to update.
     */
    limit?: number
  }

  /**
   * dup_product_variants upsert
   */
  export type dup_product_variantsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * The filter to search for the dup_product_variants to update in case it exists.
     */
    where: dup_product_variantsWhereUniqueInput
    /**
     * In case the dup_product_variants found by the `where` argument doesn't exist, create a new dup_product_variants with this data.
     */
    create: XOR<dup_product_variantsCreateInput, dup_product_variantsUncheckedCreateInput>
    /**
     * In case the dup_product_variants was found with the provided `where` argument, update it with this data.
     */
    update: XOR<dup_product_variantsUpdateInput, dup_product_variantsUncheckedUpdateInput>
  }

  /**
   * dup_product_variants delete
   */
  export type dup_product_variantsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
    /**
     * Filter which dup_product_variants to delete.
     */
    where: dup_product_variantsWhereUniqueInput
  }

  /**
   * dup_product_variants deleteMany
   */
  export type dup_product_variantsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which dup_product_variants to delete
     */
    where?: dup_product_variantsWhereInput
    /**
     * Limit how many dup_product_variants to delete.
     */
    limit?: number
  }

  /**
   * dup_product_variants without action
   */
  export type dup_product_variantsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_product_variants
     */
    select?: dup_product_variantsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_product_variants
     */
    omit?: dup_product_variantsOmit<ExtArgs> | null
  }


  /**
   * Model dup_products
   */

  export type AggregateDup_products = {
    _count: Dup_productsCountAggregateOutputType | null
    _avg: Dup_productsAvgAggregateOutputType | null
    _sum: Dup_productsSumAggregateOutputType | null
    _min: Dup_productsMinAggregateOutputType | null
    _max: Dup_productsMaxAggregateOutputType | null
  }

  export type Dup_productsAvgAggregateOutputType = {
    product_id: number | null
    orig_product_id: number | null
    user_id: number | null
  }

  export type Dup_productsSumAggregateOutputType = {
    product_id: number | null
    orig_product_id: number | null
    user_id: number | null
  }

  export type Dup_productsMinAggregateOutputType = {
    product_id: number | null
    orig_product_id: number | null
    status: $Enums.dup_products_status | null
    sub_status: $Enums.dup_products_sub_status | null
    errmsg: string | null
    user_id: number | null
    deleted: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Dup_productsMaxAggregateOutputType = {
    product_id: number | null
    orig_product_id: number | null
    status: $Enums.dup_products_status | null
    sub_status: $Enums.dup_products_sub_status | null
    errmsg: string | null
    user_id: number | null
    deleted: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Dup_productsCountAggregateOutputType = {
    product_id: number
    orig_product_id: number
    status: number
    sub_status: number
    errmsg: number
    user_id: number
    deleted: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Dup_productsAvgAggregateInputType = {
    product_id?: true
    orig_product_id?: true
    user_id?: true
  }

  export type Dup_productsSumAggregateInputType = {
    product_id?: true
    orig_product_id?: true
    user_id?: true
  }

  export type Dup_productsMinAggregateInputType = {
    product_id?: true
    orig_product_id?: true
    status?: true
    sub_status?: true
    errmsg?: true
    user_id?: true
    deleted?: true
    created_at?: true
    updated_at?: true
  }

  export type Dup_productsMaxAggregateInputType = {
    product_id?: true
    orig_product_id?: true
    status?: true
    sub_status?: true
    errmsg?: true
    user_id?: true
    deleted?: true
    created_at?: true
    updated_at?: true
  }

  export type Dup_productsCountAggregateInputType = {
    product_id?: true
    orig_product_id?: true
    status?: true
    sub_status?: true
    errmsg?: true
    user_id?: true
    deleted?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Dup_productsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which dup_products to aggregate.
     */
    where?: dup_productsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_products to fetch.
     */
    orderBy?: dup_productsOrderByWithRelationInput | dup_productsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: dup_productsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_products.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned dup_products
    **/
    _count?: true | Dup_productsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Dup_productsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Dup_productsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Dup_productsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Dup_productsMaxAggregateInputType
  }

  export type GetDup_productsAggregateType<T extends Dup_productsAggregateArgs> = {
        [P in keyof T & keyof AggregateDup_products]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDup_products[P]>
      : GetScalarType<T[P], AggregateDup_products[P]>
  }




  export type dup_productsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: dup_productsWhereInput
    orderBy?: dup_productsOrderByWithAggregationInput | dup_productsOrderByWithAggregationInput[]
    by: Dup_productsScalarFieldEnum[] | Dup_productsScalarFieldEnum
    having?: dup_productsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Dup_productsCountAggregateInputType | true
    _avg?: Dup_productsAvgAggregateInputType
    _sum?: Dup_productsSumAggregateInputType
    _min?: Dup_productsMinAggregateInputType
    _max?: Dup_productsMaxAggregateInputType
  }

  export type Dup_productsGroupByOutputType = {
    product_id: number
    orig_product_id: number
    status: $Enums.dup_products_status
    sub_status: $Enums.dup_products_sub_status
    errmsg: string
    user_id: number
    deleted: boolean
    created_at: Date
    updated_at: Date
    _count: Dup_productsCountAggregateOutputType | null
    _avg: Dup_productsAvgAggregateOutputType | null
    _sum: Dup_productsSumAggregateOutputType | null
    _min: Dup_productsMinAggregateOutputType | null
    _max: Dup_productsMaxAggregateOutputType | null
  }

  type GetDup_productsGroupByPayload<T extends dup_productsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Dup_productsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Dup_productsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Dup_productsGroupByOutputType[P]>
            : GetScalarType<T[P], Dup_productsGroupByOutputType[P]>
        }
      >
    >


  export type dup_productsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    product_id?: boolean
    orig_product_id?: boolean
    status?: boolean
    sub_status?: boolean
    errmsg?: boolean
    user_id?: boolean
    deleted?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["dup_products"]>



  export type dup_productsSelectScalar = {
    product_id?: boolean
    orig_product_id?: boolean
    status?: boolean
    sub_status?: boolean
    errmsg?: boolean
    user_id?: boolean
    deleted?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type dup_productsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"product_id" | "orig_product_id" | "status" | "sub_status" | "errmsg" | "user_id" | "deleted" | "created_at" | "updated_at", ExtArgs["result"]["dup_products"]>

  export type $dup_productsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "dup_products"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      product_id: number
      orig_product_id: number
      status: $Enums.dup_products_status
      sub_status: $Enums.dup_products_sub_status
      errmsg: string
      user_id: number
      deleted: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["dup_products"]>
    composites: {}
  }

  type dup_productsGetPayload<S extends boolean | null | undefined | dup_productsDefaultArgs> = $Result.GetResult<Prisma.$dup_productsPayload, S>

  type dup_productsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<dup_productsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Dup_productsCountAggregateInputType | true
    }

  export interface dup_productsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['dup_products'], meta: { name: 'dup_products' } }
    /**
     * Find zero or one Dup_products that matches the filter.
     * @param {dup_productsFindUniqueArgs} args - Arguments to find a Dup_products
     * @example
     * // Get one Dup_products
     * const dup_products = await prisma.dup_products.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends dup_productsFindUniqueArgs>(args: SelectSubset<T, dup_productsFindUniqueArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Dup_products that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {dup_productsFindUniqueOrThrowArgs} args - Arguments to find a Dup_products
     * @example
     * // Get one Dup_products
     * const dup_products = await prisma.dup_products.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends dup_productsFindUniqueOrThrowArgs>(args: SelectSubset<T, dup_productsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Dup_products that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_productsFindFirstArgs} args - Arguments to find a Dup_products
     * @example
     * // Get one Dup_products
     * const dup_products = await prisma.dup_products.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends dup_productsFindFirstArgs>(args?: SelectSubset<T, dup_productsFindFirstArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Dup_products that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_productsFindFirstOrThrowArgs} args - Arguments to find a Dup_products
     * @example
     * // Get one Dup_products
     * const dup_products = await prisma.dup_products.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends dup_productsFindFirstOrThrowArgs>(args?: SelectSubset<T, dup_productsFindFirstOrThrowArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Dup_products that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_productsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Dup_products
     * const dup_products = await prisma.dup_products.findMany()
     * 
     * // Get first 10 Dup_products
     * const dup_products = await prisma.dup_products.findMany({ take: 10 })
     * 
     * // Only select the `product_id`
     * const dup_productsWithProduct_idOnly = await prisma.dup_products.findMany({ select: { product_id: true } })
     * 
     */
    findMany<T extends dup_productsFindManyArgs>(args?: SelectSubset<T, dup_productsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Dup_products.
     * @param {dup_productsCreateArgs} args - Arguments to create a Dup_products.
     * @example
     * // Create one Dup_products
     * const Dup_products = await prisma.dup_products.create({
     *   data: {
     *     // ... data to create a Dup_products
     *   }
     * })
     * 
     */
    create<T extends dup_productsCreateArgs>(args: SelectSubset<T, dup_productsCreateArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Dup_products.
     * @param {dup_productsCreateManyArgs} args - Arguments to create many Dup_products.
     * @example
     * // Create many Dup_products
     * const dup_products = await prisma.dup_products.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends dup_productsCreateManyArgs>(args?: SelectSubset<T, dup_productsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Dup_products.
     * @param {dup_productsDeleteArgs} args - Arguments to delete one Dup_products.
     * @example
     * // Delete one Dup_products
     * const Dup_products = await prisma.dup_products.delete({
     *   where: {
     *     // ... filter to delete one Dup_products
     *   }
     * })
     * 
     */
    delete<T extends dup_productsDeleteArgs>(args: SelectSubset<T, dup_productsDeleteArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Dup_products.
     * @param {dup_productsUpdateArgs} args - Arguments to update one Dup_products.
     * @example
     * // Update one Dup_products
     * const dup_products = await prisma.dup_products.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends dup_productsUpdateArgs>(args: SelectSubset<T, dup_productsUpdateArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Dup_products.
     * @param {dup_productsDeleteManyArgs} args - Arguments to filter Dup_products to delete.
     * @example
     * // Delete a few Dup_products
     * const { count } = await prisma.dup_products.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends dup_productsDeleteManyArgs>(args?: SelectSubset<T, dup_productsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Dup_products.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_productsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Dup_products
     * const dup_products = await prisma.dup_products.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends dup_productsUpdateManyArgs>(args: SelectSubset<T, dup_productsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Dup_products.
     * @param {dup_productsUpsertArgs} args - Arguments to update or create a Dup_products.
     * @example
     * // Update or create a Dup_products
     * const dup_products = await prisma.dup_products.upsert({
     *   create: {
     *     // ... data to create a Dup_products
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Dup_products we want to update
     *   }
     * })
     */
    upsert<T extends dup_productsUpsertArgs>(args: SelectSubset<T, dup_productsUpsertArgs<ExtArgs>>): Prisma__dup_productsClient<$Result.GetResult<Prisma.$dup_productsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Dup_products.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_productsCountArgs} args - Arguments to filter Dup_products to count.
     * @example
     * // Count the number of Dup_products
     * const count = await prisma.dup_products.count({
     *   where: {
     *     // ... the filter for the Dup_products we want to count
     *   }
     * })
    **/
    count<T extends dup_productsCountArgs>(
      args?: Subset<T, dup_productsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Dup_productsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Dup_products.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Dup_productsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Dup_productsAggregateArgs>(args: Subset<T, Dup_productsAggregateArgs>): Prisma.PrismaPromise<GetDup_productsAggregateType<T>>

    /**
     * Group by Dup_products.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {dup_productsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends dup_productsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: dup_productsGroupByArgs['orderBy'] }
        : { orderBy?: dup_productsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, dup_productsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDup_productsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the dup_products model
   */
  readonly fields: dup_productsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for dup_products.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__dup_productsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the dup_products model
   */
  interface dup_productsFieldRefs {
    readonly product_id: FieldRef<"dup_products", 'Int'>
    readonly orig_product_id: FieldRef<"dup_products", 'Int'>
    readonly status: FieldRef<"dup_products", 'dup_products_status'>
    readonly sub_status: FieldRef<"dup_products", 'dup_products_sub_status'>
    readonly errmsg: FieldRef<"dup_products", 'String'>
    readonly user_id: FieldRef<"dup_products", 'Int'>
    readonly deleted: FieldRef<"dup_products", 'Boolean'>
    readonly created_at: FieldRef<"dup_products", 'DateTime'>
    readonly updated_at: FieldRef<"dup_products", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * dup_products findUnique
   */
  export type dup_productsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * Filter, which dup_products to fetch.
     */
    where: dup_productsWhereUniqueInput
  }

  /**
   * dup_products findUniqueOrThrow
   */
  export type dup_productsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * Filter, which dup_products to fetch.
     */
    where: dup_productsWhereUniqueInput
  }

  /**
   * dup_products findFirst
   */
  export type dup_productsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * Filter, which dup_products to fetch.
     */
    where?: dup_productsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_products to fetch.
     */
    orderBy?: dup_productsOrderByWithRelationInput | dup_productsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for dup_products.
     */
    cursor?: dup_productsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_products.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of dup_products.
     */
    distinct?: Dup_productsScalarFieldEnum | Dup_productsScalarFieldEnum[]
  }

  /**
   * dup_products findFirstOrThrow
   */
  export type dup_productsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * Filter, which dup_products to fetch.
     */
    where?: dup_productsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_products to fetch.
     */
    orderBy?: dup_productsOrderByWithRelationInput | dup_productsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for dup_products.
     */
    cursor?: dup_productsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_products.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of dup_products.
     */
    distinct?: Dup_productsScalarFieldEnum | Dup_productsScalarFieldEnum[]
  }

  /**
   * dup_products findMany
   */
  export type dup_productsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * Filter, which dup_products to fetch.
     */
    where?: dup_productsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of dup_products to fetch.
     */
    orderBy?: dup_productsOrderByWithRelationInput | dup_productsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing dup_products.
     */
    cursor?: dup_productsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` dup_products from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` dup_products.
     */
    skip?: number
    distinct?: Dup_productsScalarFieldEnum | Dup_productsScalarFieldEnum[]
  }

  /**
   * dup_products create
   */
  export type dup_productsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * The data needed to create a dup_products.
     */
    data: XOR<dup_productsCreateInput, dup_productsUncheckedCreateInput>
  }

  /**
   * dup_products createMany
   */
  export type dup_productsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many dup_products.
     */
    data: dup_productsCreateManyInput | dup_productsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * dup_products update
   */
  export type dup_productsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * The data needed to update a dup_products.
     */
    data: XOR<dup_productsUpdateInput, dup_productsUncheckedUpdateInput>
    /**
     * Choose, which dup_products to update.
     */
    where: dup_productsWhereUniqueInput
  }

  /**
   * dup_products updateMany
   */
  export type dup_productsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update dup_products.
     */
    data: XOR<dup_productsUpdateManyMutationInput, dup_productsUncheckedUpdateManyInput>
    /**
     * Filter which dup_products to update
     */
    where?: dup_productsWhereInput
    /**
     * Limit how many dup_products to update.
     */
    limit?: number
  }

  /**
   * dup_products upsert
   */
  export type dup_productsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * The filter to search for the dup_products to update in case it exists.
     */
    where: dup_productsWhereUniqueInput
    /**
     * In case the dup_products found by the `where` argument doesn't exist, create a new dup_products with this data.
     */
    create: XOR<dup_productsCreateInput, dup_productsUncheckedCreateInput>
    /**
     * In case the dup_products was found with the provided `where` argument, update it with this data.
     */
    update: XOR<dup_productsUpdateInput, dup_productsUncheckedUpdateInput>
  }

  /**
   * dup_products delete
   */
  export type dup_productsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
    /**
     * Filter which dup_products to delete.
     */
    where: dup_productsWhereUniqueInput
  }

  /**
   * dup_products deleteMany
   */
  export type dup_productsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which dup_products to delete
     */
    where?: dup_productsWhereInput
    /**
     * Limit how many dup_products to delete.
     */
    limit?: number
  }

  /**
   * dup_products without action
   */
  export type dup_productsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the dup_products
     */
    select?: dup_productsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the dup_products
     */
    omit?: dup_productsOmit<ExtArgs> | null
  }


  /**
   * Model eb_categories
   */

  export type AggregateEb_categories = {
    _count: Eb_categoriesCountAggregateOutputType | null
    _avg: Eb_categoriesAvgAggregateOutputType | null
    _sum: Eb_categoriesSumAggregateOutputType | null
    _min: Eb_categoriesMinAggregateOutputType | null
    _max: Eb_categoriesMaxAggregateOutputType | null
  }

  export type Eb_categoriesAvgAggregateOutputType = {
    id: number | null
    category_level: number | null
    site: number | null
  }

  export type Eb_categoriesSumAggregateOutputType = {
    id: number | null
    category_level: number | null
    site: number | null
  }

  export type Eb_categoriesMinAggregateOutputType = {
    id: number | null
    category_id: string | null
    category_name: string | null
    parent_category_id: string | null
    category_level: number | null
    site: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_categoriesMaxAggregateOutputType = {
    id: number | null
    category_id: string | null
    category_name: string | null
    parent_category_id: string | null
    category_level: number | null
    site: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_categoriesCountAggregateOutputType = {
    id: number
    category_id: number
    category_name: number
    parent_category_id: number
    category_level: number
    site: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Eb_categoriesAvgAggregateInputType = {
    id?: true
    category_level?: true
    site?: true
  }

  export type Eb_categoriesSumAggregateInputType = {
    id?: true
    category_level?: true
    site?: true
  }

  export type Eb_categoriesMinAggregateInputType = {
    id?: true
    category_id?: true
    category_name?: true
    parent_category_id?: true
    category_level?: true
    site?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_categoriesMaxAggregateInputType = {
    id?: true
    category_id?: true
    category_name?: true
    parent_category_id?: true
    category_level?: true
    site?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_categoriesCountAggregateInputType = {
    id?: true
    category_id?: true
    category_name?: true
    parent_category_id?: true
    category_level?: true
    site?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Eb_categoriesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_categories to aggregate.
     */
    where?: eb_categoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories to fetch.
     */
    orderBy?: eb_categoriesOrderByWithRelationInput | eb_categoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: eb_categoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned eb_categories
    **/
    _count?: true | Eb_categoriesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Eb_categoriesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Eb_categoriesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Eb_categoriesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Eb_categoriesMaxAggregateInputType
  }

  export type GetEb_categoriesAggregateType<T extends Eb_categoriesAggregateArgs> = {
        [P in keyof T & keyof AggregateEb_categories]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateEb_categories[P]>
      : GetScalarType<T[P], AggregateEb_categories[P]>
  }




  export type eb_categoriesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: eb_categoriesWhereInput
    orderBy?: eb_categoriesOrderByWithAggregationInput | eb_categoriesOrderByWithAggregationInput[]
    by: Eb_categoriesScalarFieldEnum[] | Eb_categoriesScalarFieldEnum
    having?: eb_categoriesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Eb_categoriesCountAggregateInputType | true
    _avg?: Eb_categoriesAvgAggregateInputType
    _sum?: Eb_categoriesSumAggregateInputType
    _min?: Eb_categoriesMinAggregateInputType
    _max?: Eb_categoriesMaxAggregateInputType
  }

  export type Eb_categoriesGroupByOutputType = {
    id: number
    category_id: string
    category_name: string
    parent_category_id: string
    category_level: number
    site: number
    created_at: Date
    updated_at: Date
    _count: Eb_categoriesCountAggregateOutputType | null
    _avg: Eb_categoriesAvgAggregateOutputType | null
    _sum: Eb_categoriesSumAggregateOutputType | null
    _min: Eb_categoriesMinAggregateOutputType | null
    _max: Eb_categoriesMaxAggregateOutputType | null
  }

  type GetEb_categoriesGroupByPayload<T extends eb_categoriesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Eb_categoriesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Eb_categoriesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Eb_categoriesGroupByOutputType[P]>
            : GetScalarType<T[P], Eb_categoriesGroupByOutputType[P]>
        }
      >
    >


  export type eb_categoriesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_id?: boolean
    category_name?: boolean
    parent_category_id?: boolean
    category_level?: boolean
    site?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["eb_categories"]>



  export type eb_categoriesSelectScalar = {
    id?: boolean
    category_id?: boolean
    category_name?: boolean
    parent_category_id?: boolean
    category_level?: boolean
    site?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type eb_categoriesOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "category_id" | "category_name" | "parent_category_id" | "category_level" | "site" | "created_at" | "updated_at", ExtArgs["result"]["eb_categories"]>

  export type $eb_categoriesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "eb_categories"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      category_id: string
      category_name: string
      parent_category_id: string
      category_level: number
      site: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["eb_categories"]>
    composites: {}
  }

  type eb_categoriesGetPayload<S extends boolean | null | undefined | eb_categoriesDefaultArgs> = $Result.GetResult<Prisma.$eb_categoriesPayload, S>

  type eb_categoriesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<eb_categoriesFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Eb_categoriesCountAggregateInputType | true
    }

  export interface eb_categoriesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['eb_categories'], meta: { name: 'eb_categories' } }
    /**
     * Find zero or one Eb_categories that matches the filter.
     * @param {eb_categoriesFindUniqueArgs} args - Arguments to find a Eb_categories
     * @example
     * // Get one Eb_categories
     * const eb_categories = await prisma.eb_categories.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends eb_categoriesFindUniqueArgs>(args: SelectSubset<T, eb_categoriesFindUniqueArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Eb_categories that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {eb_categoriesFindUniqueOrThrowArgs} args - Arguments to find a Eb_categories
     * @example
     * // Get one Eb_categories
     * const eb_categories = await prisma.eb_categories.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends eb_categoriesFindUniqueOrThrowArgs>(args: SelectSubset<T, eb_categoriesFindUniqueOrThrowArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_categories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categoriesFindFirstArgs} args - Arguments to find a Eb_categories
     * @example
     * // Get one Eb_categories
     * const eb_categories = await prisma.eb_categories.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends eb_categoriesFindFirstArgs>(args?: SelectSubset<T, eb_categoriesFindFirstArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_categories that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categoriesFindFirstOrThrowArgs} args - Arguments to find a Eb_categories
     * @example
     * // Get one Eb_categories
     * const eb_categories = await prisma.eb_categories.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends eb_categoriesFindFirstOrThrowArgs>(args?: SelectSubset<T, eb_categoriesFindFirstOrThrowArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Eb_categories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categoriesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Eb_categories
     * const eb_categories = await prisma.eb_categories.findMany()
     * 
     * // Get first 10 Eb_categories
     * const eb_categories = await prisma.eb_categories.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const eb_categoriesWithIdOnly = await prisma.eb_categories.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends eb_categoriesFindManyArgs>(args?: SelectSubset<T, eb_categoriesFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Eb_categories.
     * @param {eb_categoriesCreateArgs} args - Arguments to create a Eb_categories.
     * @example
     * // Create one Eb_categories
     * const Eb_categories = await prisma.eb_categories.create({
     *   data: {
     *     // ... data to create a Eb_categories
     *   }
     * })
     * 
     */
    create<T extends eb_categoriesCreateArgs>(args: SelectSubset<T, eb_categoriesCreateArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Eb_categories.
     * @param {eb_categoriesCreateManyArgs} args - Arguments to create many Eb_categories.
     * @example
     * // Create many Eb_categories
     * const eb_categories = await prisma.eb_categories.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends eb_categoriesCreateManyArgs>(args?: SelectSubset<T, eb_categoriesCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Eb_categories.
     * @param {eb_categoriesDeleteArgs} args - Arguments to delete one Eb_categories.
     * @example
     * // Delete one Eb_categories
     * const Eb_categories = await prisma.eb_categories.delete({
     *   where: {
     *     // ... filter to delete one Eb_categories
     *   }
     * })
     * 
     */
    delete<T extends eb_categoriesDeleteArgs>(args: SelectSubset<T, eb_categoriesDeleteArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Eb_categories.
     * @param {eb_categoriesUpdateArgs} args - Arguments to update one Eb_categories.
     * @example
     * // Update one Eb_categories
     * const eb_categories = await prisma.eb_categories.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends eb_categoriesUpdateArgs>(args: SelectSubset<T, eb_categoriesUpdateArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Eb_categories.
     * @param {eb_categoriesDeleteManyArgs} args - Arguments to filter Eb_categories to delete.
     * @example
     * // Delete a few Eb_categories
     * const { count } = await prisma.eb_categories.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends eb_categoriesDeleteManyArgs>(args?: SelectSubset<T, eb_categoriesDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Eb_categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categoriesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Eb_categories
     * const eb_categories = await prisma.eb_categories.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends eb_categoriesUpdateManyArgs>(args: SelectSubset<T, eb_categoriesUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Eb_categories.
     * @param {eb_categoriesUpsertArgs} args - Arguments to update or create a Eb_categories.
     * @example
     * // Update or create a Eb_categories
     * const eb_categories = await prisma.eb_categories.upsert({
     *   create: {
     *     // ... data to create a Eb_categories
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Eb_categories we want to update
     *   }
     * })
     */
    upsert<T extends eb_categoriesUpsertArgs>(args: SelectSubset<T, eb_categoriesUpsertArgs<ExtArgs>>): Prisma__eb_categoriesClient<$Result.GetResult<Prisma.$eb_categoriesPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Eb_categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categoriesCountArgs} args - Arguments to filter Eb_categories to count.
     * @example
     * // Count the number of Eb_categories
     * const count = await prisma.eb_categories.count({
     *   where: {
     *     // ... the filter for the Eb_categories we want to count
     *   }
     * })
    **/
    count<T extends eb_categoriesCountArgs>(
      args?: Subset<T, eb_categoriesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Eb_categoriesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Eb_categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Eb_categoriesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Eb_categoriesAggregateArgs>(args: Subset<T, Eb_categoriesAggregateArgs>): Prisma.PrismaPromise<GetEb_categoriesAggregateType<T>>

    /**
     * Group by Eb_categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categoriesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends eb_categoriesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: eb_categoriesGroupByArgs['orderBy'] }
        : { orderBy?: eb_categoriesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, eb_categoriesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetEb_categoriesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the eb_categories model
   */
  readonly fields: eb_categoriesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for eb_categories.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__eb_categoriesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the eb_categories model
   */
  interface eb_categoriesFieldRefs {
    readonly id: FieldRef<"eb_categories", 'Int'>
    readonly category_id: FieldRef<"eb_categories", 'String'>
    readonly category_name: FieldRef<"eb_categories", 'String'>
    readonly parent_category_id: FieldRef<"eb_categories", 'String'>
    readonly category_level: FieldRef<"eb_categories", 'Int'>
    readonly site: FieldRef<"eb_categories", 'Int'>
    readonly created_at: FieldRef<"eb_categories", 'DateTime'>
    readonly updated_at: FieldRef<"eb_categories", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * eb_categories findUnique
   */
  export type eb_categoriesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories to fetch.
     */
    where: eb_categoriesWhereUniqueInput
  }

  /**
   * eb_categories findUniqueOrThrow
   */
  export type eb_categoriesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories to fetch.
     */
    where: eb_categoriesWhereUniqueInput
  }

  /**
   * eb_categories findFirst
   */
  export type eb_categoriesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories to fetch.
     */
    where?: eb_categoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories to fetch.
     */
    orderBy?: eb_categoriesOrderByWithRelationInput | eb_categoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_categories.
     */
    cursor?: eb_categoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_categories.
     */
    distinct?: Eb_categoriesScalarFieldEnum | Eb_categoriesScalarFieldEnum[]
  }

  /**
   * eb_categories findFirstOrThrow
   */
  export type eb_categoriesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories to fetch.
     */
    where?: eb_categoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories to fetch.
     */
    orderBy?: eb_categoriesOrderByWithRelationInput | eb_categoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_categories.
     */
    cursor?: eb_categoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_categories.
     */
    distinct?: Eb_categoriesScalarFieldEnum | Eb_categoriesScalarFieldEnum[]
  }

  /**
   * eb_categories findMany
   */
  export type eb_categoriesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories to fetch.
     */
    where?: eb_categoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories to fetch.
     */
    orderBy?: eb_categoriesOrderByWithRelationInput | eb_categoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing eb_categories.
     */
    cursor?: eb_categoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories.
     */
    skip?: number
    distinct?: Eb_categoriesScalarFieldEnum | Eb_categoriesScalarFieldEnum[]
  }

  /**
   * eb_categories create
   */
  export type eb_categoriesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * The data needed to create a eb_categories.
     */
    data: XOR<eb_categoriesCreateInput, eb_categoriesUncheckedCreateInput>
  }

  /**
   * eb_categories createMany
   */
  export type eb_categoriesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many eb_categories.
     */
    data: eb_categoriesCreateManyInput | eb_categoriesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * eb_categories update
   */
  export type eb_categoriesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * The data needed to update a eb_categories.
     */
    data: XOR<eb_categoriesUpdateInput, eb_categoriesUncheckedUpdateInput>
    /**
     * Choose, which eb_categories to update.
     */
    where: eb_categoriesWhereUniqueInput
  }

  /**
   * eb_categories updateMany
   */
  export type eb_categoriesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update eb_categories.
     */
    data: XOR<eb_categoriesUpdateManyMutationInput, eb_categoriesUncheckedUpdateManyInput>
    /**
     * Filter which eb_categories to update
     */
    where?: eb_categoriesWhereInput
    /**
     * Limit how many eb_categories to update.
     */
    limit?: number
  }

  /**
   * eb_categories upsert
   */
  export type eb_categoriesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * The filter to search for the eb_categories to update in case it exists.
     */
    where: eb_categoriesWhereUniqueInput
    /**
     * In case the eb_categories found by the `where` argument doesn't exist, create a new eb_categories with this data.
     */
    create: XOR<eb_categoriesCreateInput, eb_categoriesUncheckedCreateInput>
    /**
     * In case the eb_categories was found with the provided `where` argument, update it with this data.
     */
    update: XOR<eb_categoriesUpdateInput, eb_categoriesUncheckedUpdateInput>
  }

  /**
   * eb_categories delete
   */
  export type eb_categoriesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
    /**
     * Filter which eb_categories to delete.
     */
    where: eb_categoriesWhereUniqueInput
  }

  /**
   * eb_categories deleteMany
   */
  export type eb_categoriesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_categories to delete
     */
    where?: eb_categoriesWhereInput
    /**
     * Limit how many eb_categories to delete.
     */
    limit?: number
  }

  /**
   * eb_categories without action
   */
  export type eb_categoriesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories
     */
    select?: eb_categoriesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories
     */
    omit?: eb_categoriesOmit<ExtArgs> | null
  }


  /**
   * Model eb_categories_mapping
   */

  export type AggregateEb_categories_mapping = {
    _count: Eb_categories_mappingCountAggregateOutputType | null
    _avg: Eb_categories_mappingAvgAggregateOutputType | null
    _sum: Eb_categories_mappingSumAggregateOutputType | null
    _min: Eb_categories_mappingMinAggregateOutputType | null
    _max: Eb_categories_mappingMaxAggregateOutputType | null
  }

  export type Eb_categories_mappingAvgAggregateOutputType = {
    id: number | null
    product_id: number | null
    user_id: number | null
  }

  export type Eb_categories_mappingSumAggregateOutputType = {
    id: number | null
    product_id: number | null
    user_id: number | null
  }

  export type Eb_categories_mappingMinAggregateOutputType = {
    id: number | null
    product_id: number | null
    eb_category_id: string | null
    eb_category_name: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_categories_mappingMaxAggregateOutputType = {
    id: number | null
    product_id: number | null
    eb_category_id: string | null
    eb_category_name: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_categories_mappingCountAggregateOutputType = {
    id: number
    product_id: number
    eb_category_id: number
    eb_category_name: number
    user_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Eb_categories_mappingAvgAggregateInputType = {
    id?: true
    product_id?: true
    user_id?: true
  }

  export type Eb_categories_mappingSumAggregateInputType = {
    id?: true
    product_id?: true
    user_id?: true
  }

  export type Eb_categories_mappingMinAggregateInputType = {
    id?: true
    product_id?: true
    eb_category_id?: true
    eb_category_name?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_categories_mappingMaxAggregateInputType = {
    id?: true
    product_id?: true
    eb_category_id?: true
    eb_category_name?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_categories_mappingCountAggregateInputType = {
    id?: true
    product_id?: true
    eb_category_id?: true
    eb_category_name?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Eb_categories_mappingAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_categories_mapping to aggregate.
     */
    where?: eb_categories_mappingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories_mappings to fetch.
     */
    orderBy?: eb_categories_mappingOrderByWithRelationInput | eb_categories_mappingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: eb_categories_mappingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories_mappings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories_mappings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned eb_categories_mappings
    **/
    _count?: true | Eb_categories_mappingCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Eb_categories_mappingAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Eb_categories_mappingSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Eb_categories_mappingMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Eb_categories_mappingMaxAggregateInputType
  }

  export type GetEb_categories_mappingAggregateType<T extends Eb_categories_mappingAggregateArgs> = {
        [P in keyof T & keyof AggregateEb_categories_mapping]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateEb_categories_mapping[P]>
      : GetScalarType<T[P], AggregateEb_categories_mapping[P]>
  }




  export type eb_categories_mappingGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: eb_categories_mappingWhereInput
    orderBy?: eb_categories_mappingOrderByWithAggregationInput | eb_categories_mappingOrderByWithAggregationInput[]
    by: Eb_categories_mappingScalarFieldEnum[] | Eb_categories_mappingScalarFieldEnum
    having?: eb_categories_mappingScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Eb_categories_mappingCountAggregateInputType | true
    _avg?: Eb_categories_mappingAvgAggregateInputType
    _sum?: Eb_categories_mappingSumAggregateInputType
    _min?: Eb_categories_mappingMinAggregateInputType
    _max?: Eb_categories_mappingMaxAggregateInputType
  }

  export type Eb_categories_mappingGroupByOutputType = {
    id: number
    product_id: number
    eb_category_id: string
    eb_category_name: string
    user_id: number
    created_at: Date
    updated_at: Date
    _count: Eb_categories_mappingCountAggregateOutputType | null
    _avg: Eb_categories_mappingAvgAggregateOutputType | null
    _sum: Eb_categories_mappingSumAggregateOutputType | null
    _min: Eb_categories_mappingMinAggregateOutputType | null
    _max: Eb_categories_mappingMaxAggregateOutputType | null
  }

  type GetEb_categories_mappingGroupByPayload<T extends eb_categories_mappingGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Eb_categories_mappingGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Eb_categories_mappingGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Eb_categories_mappingGroupByOutputType[P]>
            : GetScalarType<T[P], Eb_categories_mappingGroupByOutputType[P]>
        }
      >
    >


  export type eb_categories_mappingSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    product_id?: boolean
    eb_category_id?: boolean
    eb_category_name?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["eb_categories_mapping"]>



  export type eb_categories_mappingSelectScalar = {
    id?: boolean
    product_id?: boolean
    eb_category_id?: boolean
    eb_category_name?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type eb_categories_mappingOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "product_id" | "eb_category_id" | "eb_category_name" | "user_id" | "created_at" | "updated_at", ExtArgs["result"]["eb_categories_mapping"]>

  export type $eb_categories_mappingPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "eb_categories_mapping"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      product_id: number
      eb_category_id: string
      eb_category_name: string
      user_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["eb_categories_mapping"]>
    composites: {}
  }

  type eb_categories_mappingGetPayload<S extends boolean | null | undefined | eb_categories_mappingDefaultArgs> = $Result.GetResult<Prisma.$eb_categories_mappingPayload, S>

  type eb_categories_mappingCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<eb_categories_mappingFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Eb_categories_mappingCountAggregateInputType | true
    }

  export interface eb_categories_mappingDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['eb_categories_mapping'], meta: { name: 'eb_categories_mapping' } }
    /**
     * Find zero or one Eb_categories_mapping that matches the filter.
     * @param {eb_categories_mappingFindUniqueArgs} args - Arguments to find a Eb_categories_mapping
     * @example
     * // Get one Eb_categories_mapping
     * const eb_categories_mapping = await prisma.eb_categories_mapping.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends eb_categories_mappingFindUniqueArgs>(args: SelectSubset<T, eb_categories_mappingFindUniqueArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Eb_categories_mapping that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {eb_categories_mappingFindUniqueOrThrowArgs} args - Arguments to find a Eb_categories_mapping
     * @example
     * // Get one Eb_categories_mapping
     * const eb_categories_mapping = await prisma.eb_categories_mapping.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends eb_categories_mappingFindUniqueOrThrowArgs>(args: SelectSubset<T, eb_categories_mappingFindUniqueOrThrowArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_categories_mapping that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categories_mappingFindFirstArgs} args - Arguments to find a Eb_categories_mapping
     * @example
     * // Get one Eb_categories_mapping
     * const eb_categories_mapping = await prisma.eb_categories_mapping.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends eb_categories_mappingFindFirstArgs>(args?: SelectSubset<T, eb_categories_mappingFindFirstArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_categories_mapping that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categories_mappingFindFirstOrThrowArgs} args - Arguments to find a Eb_categories_mapping
     * @example
     * // Get one Eb_categories_mapping
     * const eb_categories_mapping = await prisma.eb_categories_mapping.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends eb_categories_mappingFindFirstOrThrowArgs>(args?: SelectSubset<T, eb_categories_mappingFindFirstOrThrowArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Eb_categories_mappings that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categories_mappingFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Eb_categories_mappings
     * const eb_categories_mappings = await prisma.eb_categories_mapping.findMany()
     * 
     * // Get first 10 Eb_categories_mappings
     * const eb_categories_mappings = await prisma.eb_categories_mapping.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const eb_categories_mappingWithIdOnly = await prisma.eb_categories_mapping.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends eb_categories_mappingFindManyArgs>(args?: SelectSubset<T, eb_categories_mappingFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Eb_categories_mapping.
     * @param {eb_categories_mappingCreateArgs} args - Arguments to create a Eb_categories_mapping.
     * @example
     * // Create one Eb_categories_mapping
     * const Eb_categories_mapping = await prisma.eb_categories_mapping.create({
     *   data: {
     *     // ... data to create a Eb_categories_mapping
     *   }
     * })
     * 
     */
    create<T extends eb_categories_mappingCreateArgs>(args: SelectSubset<T, eb_categories_mappingCreateArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Eb_categories_mappings.
     * @param {eb_categories_mappingCreateManyArgs} args - Arguments to create many Eb_categories_mappings.
     * @example
     * // Create many Eb_categories_mappings
     * const eb_categories_mapping = await prisma.eb_categories_mapping.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends eb_categories_mappingCreateManyArgs>(args?: SelectSubset<T, eb_categories_mappingCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Eb_categories_mapping.
     * @param {eb_categories_mappingDeleteArgs} args - Arguments to delete one Eb_categories_mapping.
     * @example
     * // Delete one Eb_categories_mapping
     * const Eb_categories_mapping = await prisma.eb_categories_mapping.delete({
     *   where: {
     *     // ... filter to delete one Eb_categories_mapping
     *   }
     * })
     * 
     */
    delete<T extends eb_categories_mappingDeleteArgs>(args: SelectSubset<T, eb_categories_mappingDeleteArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Eb_categories_mapping.
     * @param {eb_categories_mappingUpdateArgs} args - Arguments to update one Eb_categories_mapping.
     * @example
     * // Update one Eb_categories_mapping
     * const eb_categories_mapping = await prisma.eb_categories_mapping.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends eb_categories_mappingUpdateArgs>(args: SelectSubset<T, eb_categories_mappingUpdateArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Eb_categories_mappings.
     * @param {eb_categories_mappingDeleteManyArgs} args - Arguments to filter Eb_categories_mappings to delete.
     * @example
     * // Delete a few Eb_categories_mappings
     * const { count } = await prisma.eb_categories_mapping.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends eb_categories_mappingDeleteManyArgs>(args?: SelectSubset<T, eb_categories_mappingDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Eb_categories_mappings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categories_mappingUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Eb_categories_mappings
     * const eb_categories_mapping = await prisma.eb_categories_mapping.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends eb_categories_mappingUpdateManyArgs>(args: SelectSubset<T, eb_categories_mappingUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Eb_categories_mapping.
     * @param {eb_categories_mappingUpsertArgs} args - Arguments to update or create a Eb_categories_mapping.
     * @example
     * // Update or create a Eb_categories_mapping
     * const eb_categories_mapping = await prisma.eb_categories_mapping.upsert({
     *   create: {
     *     // ... data to create a Eb_categories_mapping
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Eb_categories_mapping we want to update
     *   }
     * })
     */
    upsert<T extends eb_categories_mappingUpsertArgs>(args: SelectSubset<T, eb_categories_mappingUpsertArgs<ExtArgs>>): Prisma__eb_categories_mappingClient<$Result.GetResult<Prisma.$eb_categories_mappingPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Eb_categories_mappings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categories_mappingCountArgs} args - Arguments to filter Eb_categories_mappings to count.
     * @example
     * // Count the number of Eb_categories_mappings
     * const count = await prisma.eb_categories_mapping.count({
     *   where: {
     *     // ... the filter for the Eb_categories_mappings we want to count
     *   }
     * })
    **/
    count<T extends eb_categories_mappingCountArgs>(
      args?: Subset<T, eb_categories_mappingCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Eb_categories_mappingCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Eb_categories_mapping.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Eb_categories_mappingAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Eb_categories_mappingAggregateArgs>(args: Subset<T, Eb_categories_mappingAggregateArgs>): Prisma.PrismaPromise<GetEb_categories_mappingAggregateType<T>>

    /**
     * Group by Eb_categories_mapping.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_categories_mappingGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends eb_categories_mappingGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: eb_categories_mappingGroupByArgs['orderBy'] }
        : { orderBy?: eb_categories_mappingGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, eb_categories_mappingGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetEb_categories_mappingGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the eb_categories_mapping model
   */
  readonly fields: eb_categories_mappingFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for eb_categories_mapping.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__eb_categories_mappingClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the eb_categories_mapping model
   */
  interface eb_categories_mappingFieldRefs {
    readonly id: FieldRef<"eb_categories_mapping", 'Int'>
    readonly product_id: FieldRef<"eb_categories_mapping", 'Int'>
    readonly eb_category_id: FieldRef<"eb_categories_mapping", 'String'>
    readonly eb_category_name: FieldRef<"eb_categories_mapping", 'String'>
    readonly user_id: FieldRef<"eb_categories_mapping", 'Int'>
    readonly created_at: FieldRef<"eb_categories_mapping", 'DateTime'>
    readonly updated_at: FieldRef<"eb_categories_mapping", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * eb_categories_mapping findUnique
   */
  export type eb_categories_mappingFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories_mapping to fetch.
     */
    where: eb_categories_mappingWhereUniqueInput
  }

  /**
   * eb_categories_mapping findUniqueOrThrow
   */
  export type eb_categories_mappingFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories_mapping to fetch.
     */
    where: eb_categories_mappingWhereUniqueInput
  }

  /**
   * eb_categories_mapping findFirst
   */
  export type eb_categories_mappingFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories_mapping to fetch.
     */
    where?: eb_categories_mappingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories_mappings to fetch.
     */
    orderBy?: eb_categories_mappingOrderByWithRelationInput | eb_categories_mappingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_categories_mappings.
     */
    cursor?: eb_categories_mappingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories_mappings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories_mappings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_categories_mappings.
     */
    distinct?: Eb_categories_mappingScalarFieldEnum | Eb_categories_mappingScalarFieldEnum[]
  }

  /**
   * eb_categories_mapping findFirstOrThrow
   */
  export type eb_categories_mappingFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories_mapping to fetch.
     */
    where?: eb_categories_mappingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories_mappings to fetch.
     */
    orderBy?: eb_categories_mappingOrderByWithRelationInput | eb_categories_mappingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_categories_mappings.
     */
    cursor?: eb_categories_mappingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories_mappings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories_mappings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_categories_mappings.
     */
    distinct?: Eb_categories_mappingScalarFieldEnum | Eb_categories_mappingScalarFieldEnum[]
  }

  /**
   * eb_categories_mapping findMany
   */
  export type eb_categories_mappingFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * Filter, which eb_categories_mappings to fetch.
     */
    where?: eb_categories_mappingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_categories_mappings to fetch.
     */
    orderBy?: eb_categories_mappingOrderByWithRelationInput | eb_categories_mappingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing eb_categories_mappings.
     */
    cursor?: eb_categories_mappingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_categories_mappings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_categories_mappings.
     */
    skip?: number
    distinct?: Eb_categories_mappingScalarFieldEnum | Eb_categories_mappingScalarFieldEnum[]
  }

  /**
   * eb_categories_mapping create
   */
  export type eb_categories_mappingCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * The data needed to create a eb_categories_mapping.
     */
    data: XOR<eb_categories_mappingCreateInput, eb_categories_mappingUncheckedCreateInput>
  }

  /**
   * eb_categories_mapping createMany
   */
  export type eb_categories_mappingCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many eb_categories_mappings.
     */
    data: eb_categories_mappingCreateManyInput | eb_categories_mappingCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * eb_categories_mapping update
   */
  export type eb_categories_mappingUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * The data needed to update a eb_categories_mapping.
     */
    data: XOR<eb_categories_mappingUpdateInput, eb_categories_mappingUncheckedUpdateInput>
    /**
     * Choose, which eb_categories_mapping to update.
     */
    where: eb_categories_mappingWhereUniqueInput
  }

  /**
   * eb_categories_mapping updateMany
   */
  export type eb_categories_mappingUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update eb_categories_mappings.
     */
    data: XOR<eb_categories_mappingUpdateManyMutationInput, eb_categories_mappingUncheckedUpdateManyInput>
    /**
     * Filter which eb_categories_mappings to update
     */
    where?: eb_categories_mappingWhereInput
    /**
     * Limit how many eb_categories_mappings to update.
     */
    limit?: number
  }

  /**
   * eb_categories_mapping upsert
   */
  export type eb_categories_mappingUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * The filter to search for the eb_categories_mapping to update in case it exists.
     */
    where: eb_categories_mappingWhereUniqueInput
    /**
     * In case the eb_categories_mapping found by the `where` argument doesn't exist, create a new eb_categories_mapping with this data.
     */
    create: XOR<eb_categories_mappingCreateInput, eb_categories_mappingUncheckedCreateInput>
    /**
     * In case the eb_categories_mapping was found with the provided `where` argument, update it with this data.
     */
    update: XOR<eb_categories_mappingUpdateInput, eb_categories_mappingUncheckedUpdateInput>
  }

  /**
   * eb_categories_mapping delete
   */
  export type eb_categories_mappingDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
    /**
     * Filter which eb_categories_mapping to delete.
     */
    where: eb_categories_mappingWhereUniqueInput
  }

  /**
   * eb_categories_mapping deleteMany
   */
  export type eb_categories_mappingDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_categories_mappings to delete
     */
    where?: eb_categories_mappingWhereInput
    /**
     * Limit how many eb_categories_mappings to delete.
     */
    limit?: number
  }

  /**
   * eb_categories_mapping without action
   */
  export type eb_categories_mappingDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_categories_mapping
     */
    select?: eb_categories_mappingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_categories_mapping
     */
    omit?: eb_categories_mappingOmit<ExtArgs> | null
  }


  /**
   * Model eb_keys
   */

  export type AggregateEb_keys = {
    _count: Eb_keysCountAggregateOutputType | null
    _avg: Eb_keysAvgAggregateOutputType | null
    _sum: Eb_keysSumAggregateOutputType | null
    _min: Eb_keysMinAggregateOutputType | null
    _max: Eb_keysMaxAggregateOutputType | null
  }

  export type Eb_keysAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Eb_keysSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Eb_keysMinAggregateOutputType = {
    id: number | null
    sellerid: string | null
    token: string | null
    expirydate: Date | null
    lastordersfetched: Date | null
    terms: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_keysMaxAggregateOutputType = {
    id: number | null
    sellerid: string | null
    token: string | null
    expirydate: Date | null
    lastordersfetched: Date | null
    terms: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_keysCountAggregateOutputType = {
    id: number
    sellerid: number
    token: number
    expirydate: number
    lastordersfetched: number
    terms: number
    user_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Eb_keysAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Eb_keysSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Eb_keysMinAggregateInputType = {
    id?: true
    sellerid?: true
    token?: true
    expirydate?: true
    lastordersfetched?: true
    terms?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_keysMaxAggregateInputType = {
    id?: true
    sellerid?: true
    token?: true
    expirydate?: true
    lastordersfetched?: true
    terms?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_keysCountAggregateInputType = {
    id?: true
    sellerid?: true
    token?: true
    expirydate?: true
    lastordersfetched?: true
    terms?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Eb_keysAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_keys to aggregate.
     */
    where?: eb_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_keys to fetch.
     */
    orderBy?: eb_keysOrderByWithRelationInput | eb_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: eb_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_keys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned eb_keys
    **/
    _count?: true | Eb_keysCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Eb_keysAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Eb_keysSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Eb_keysMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Eb_keysMaxAggregateInputType
  }

  export type GetEb_keysAggregateType<T extends Eb_keysAggregateArgs> = {
        [P in keyof T & keyof AggregateEb_keys]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateEb_keys[P]>
      : GetScalarType<T[P], AggregateEb_keys[P]>
  }




  export type eb_keysGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: eb_keysWhereInput
    orderBy?: eb_keysOrderByWithAggregationInput | eb_keysOrderByWithAggregationInput[]
    by: Eb_keysScalarFieldEnum[] | Eb_keysScalarFieldEnum
    having?: eb_keysScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Eb_keysCountAggregateInputType | true
    _avg?: Eb_keysAvgAggregateInputType
    _sum?: Eb_keysSumAggregateInputType
    _min?: Eb_keysMinAggregateInputType
    _max?: Eb_keysMaxAggregateInputType
  }

  export type Eb_keysGroupByOutputType = {
    id: number
    sellerid: string
    token: string
    expirydate: Date
    lastordersfetched: Date
    terms: string
    user_id: number
    created_at: Date
    updated_at: Date
    _count: Eb_keysCountAggregateOutputType | null
    _avg: Eb_keysAvgAggregateOutputType | null
    _sum: Eb_keysSumAggregateOutputType | null
    _min: Eb_keysMinAggregateOutputType | null
    _max: Eb_keysMaxAggregateOutputType | null
  }

  type GetEb_keysGroupByPayload<T extends eb_keysGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Eb_keysGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Eb_keysGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Eb_keysGroupByOutputType[P]>
            : GetScalarType<T[P], Eb_keysGroupByOutputType[P]>
        }
      >
    >


  export type eb_keysSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    sellerid?: boolean
    token?: boolean
    expirydate?: boolean
    lastordersfetched?: boolean
    terms?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["eb_keys"]>



  export type eb_keysSelectScalar = {
    id?: boolean
    sellerid?: boolean
    token?: boolean
    expirydate?: boolean
    lastordersfetched?: boolean
    terms?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type eb_keysOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "sellerid" | "token" | "expirydate" | "lastordersfetched" | "terms" | "user_id" | "created_at" | "updated_at", ExtArgs["result"]["eb_keys"]>

  export type $eb_keysPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "eb_keys"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      sellerid: string
      token: string
      expirydate: Date
      lastordersfetched: Date
      terms: string
      user_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["eb_keys"]>
    composites: {}
  }

  type eb_keysGetPayload<S extends boolean | null | undefined | eb_keysDefaultArgs> = $Result.GetResult<Prisma.$eb_keysPayload, S>

  type eb_keysCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<eb_keysFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Eb_keysCountAggregateInputType | true
    }

  export interface eb_keysDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['eb_keys'], meta: { name: 'eb_keys' } }
    /**
     * Find zero or one Eb_keys that matches the filter.
     * @param {eb_keysFindUniqueArgs} args - Arguments to find a Eb_keys
     * @example
     * // Get one Eb_keys
     * const eb_keys = await prisma.eb_keys.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends eb_keysFindUniqueArgs>(args: SelectSubset<T, eb_keysFindUniqueArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Eb_keys that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {eb_keysFindUniqueOrThrowArgs} args - Arguments to find a Eb_keys
     * @example
     * // Get one Eb_keys
     * const eb_keys = await prisma.eb_keys.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends eb_keysFindUniqueOrThrowArgs>(args: SelectSubset<T, eb_keysFindUniqueOrThrowArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_keys that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_keysFindFirstArgs} args - Arguments to find a Eb_keys
     * @example
     * // Get one Eb_keys
     * const eb_keys = await prisma.eb_keys.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends eb_keysFindFirstArgs>(args?: SelectSubset<T, eb_keysFindFirstArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_keys that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_keysFindFirstOrThrowArgs} args - Arguments to find a Eb_keys
     * @example
     * // Get one Eb_keys
     * const eb_keys = await prisma.eb_keys.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends eb_keysFindFirstOrThrowArgs>(args?: SelectSubset<T, eb_keysFindFirstOrThrowArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Eb_keys that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_keysFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Eb_keys
     * const eb_keys = await prisma.eb_keys.findMany()
     * 
     * // Get first 10 Eb_keys
     * const eb_keys = await prisma.eb_keys.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const eb_keysWithIdOnly = await prisma.eb_keys.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends eb_keysFindManyArgs>(args?: SelectSubset<T, eb_keysFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Eb_keys.
     * @param {eb_keysCreateArgs} args - Arguments to create a Eb_keys.
     * @example
     * // Create one Eb_keys
     * const Eb_keys = await prisma.eb_keys.create({
     *   data: {
     *     // ... data to create a Eb_keys
     *   }
     * })
     * 
     */
    create<T extends eb_keysCreateArgs>(args: SelectSubset<T, eb_keysCreateArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Eb_keys.
     * @param {eb_keysCreateManyArgs} args - Arguments to create many Eb_keys.
     * @example
     * // Create many Eb_keys
     * const eb_keys = await prisma.eb_keys.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends eb_keysCreateManyArgs>(args?: SelectSubset<T, eb_keysCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Eb_keys.
     * @param {eb_keysDeleteArgs} args - Arguments to delete one Eb_keys.
     * @example
     * // Delete one Eb_keys
     * const Eb_keys = await prisma.eb_keys.delete({
     *   where: {
     *     // ... filter to delete one Eb_keys
     *   }
     * })
     * 
     */
    delete<T extends eb_keysDeleteArgs>(args: SelectSubset<T, eb_keysDeleteArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Eb_keys.
     * @param {eb_keysUpdateArgs} args - Arguments to update one Eb_keys.
     * @example
     * // Update one Eb_keys
     * const eb_keys = await prisma.eb_keys.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends eb_keysUpdateArgs>(args: SelectSubset<T, eb_keysUpdateArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Eb_keys.
     * @param {eb_keysDeleteManyArgs} args - Arguments to filter Eb_keys to delete.
     * @example
     * // Delete a few Eb_keys
     * const { count } = await prisma.eb_keys.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends eb_keysDeleteManyArgs>(args?: SelectSubset<T, eb_keysDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Eb_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_keysUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Eb_keys
     * const eb_keys = await prisma.eb_keys.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends eb_keysUpdateManyArgs>(args: SelectSubset<T, eb_keysUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Eb_keys.
     * @param {eb_keysUpsertArgs} args - Arguments to update or create a Eb_keys.
     * @example
     * // Update or create a Eb_keys
     * const eb_keys = await prisma.eb_keys.upsert({
     *   create: {
     *     // ... data to create a Eb_keys
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Eb_keys we want to update
     *   }
     * })
     */
    upsert<T extends eb_keysUpsertArgs>(args: SelectSubset<T, eb_keysUpsertArgs<ExtArgs>>): Prisma__eb_keysClient<$Result.GetResult<Prisma.$eb_keysPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Eb_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_keysCountArgs} args - Arguments to filter Eb_keys to count.
     * @example
     * // Count the number of Eb_keys
     * const count = await prisma.eb_keys.count({
     *   where: {
     *     // ... the filter for the Eb_keys we want to count
     *   }
     * })
    **/
    count<T extends eb_keysCountArgs>(
      args?: Subset<T, eb_keysCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Eb_keysCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Eb_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Eb_keysAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Eb_keysAggregateArgs>(args: Subset<T, Eb_keysAggregateArgs>): Prisma.PrismaPromise<GetEb_keysAggregateType<T>>

    /**
     * Group by Eb_keys.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_keysGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends eb_keysGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: eb_keysGroupByArgs['orderBy'] }
        : { orderBy?: eb_keysGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, eb_keysGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetEb_keysGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the eb_keys model
   */
  readonly fields: eb_keysFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for eb_keys.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__eb_keysClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the eb_keys model
   */
  interface eb_keysFieldRefs {
    readonly id: FieldRef<"eb_keys", 'Int'>
    readonly sellerid: FieldRef<"eb_keys", 'String'>
    readonly token: FieldRef<"eb_keys", 'String'>
    readonly expirydate: FieldRef<"eb_keys", 'DateTime'>
    readonly lastordersfetched: FieldRef<"eb_keys", 'DateTime'>
    readonly terms: FieldRef<"eb_keys", 'String'>
    readonly user_id: FieldRef<"eb_keys", 'Int'>
    readonly created_at: FieldRef<"eb_keys", 'DateTime'>
    readonly updated_at: FieldRef<"eb_keys", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * eb_keys findUnique
   */
  export type eb_keysFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * Filter, which eb_keys to fetch.
     */
    where: eb_keysWhereUniqueInput
  }

  /**
   * eb_keys findUniqueOrThrow
   */
  export type eb_keysFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * Filter, which eb_keys to fetch.
     */
    where: eb_keysWhereUniqueInput
  }

  /**
   * eb_keys findFirst
   */
  export type eb_keysFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * Filter, which eb_keys to fetch.
     */
    where?: eb_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_keys to fetch.
     */
    orderBy?: eb_keysOrderByWithRelationInput | eb_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_keys.
     */
    cursor?: eb_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_keys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_keys.
     */
    distinct?: Eb_keysScalarFieldEnum | Eb_keysScalarFieldEnum[]
  }

  /**
   * eb_keys findFirstOrThrow
   */
  export type eb_keysFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * Filter, which eb_keys to fetch.
     */
    where?: eb_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_keys to fetch.
     */
    orderBy?: eb_keysOrderByWithRelationInput | eb_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_keys.
     */
    cursor?: eb_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_keys.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_keys.
     */
    distinct?: Eb_keysScalarFieldEnum | Eb_keysScalarFieldEnum[]
  }

  /**
   * eb_keys findMany
   */
  export type eb_keysFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * Filter, which eb_keys to fetch.
     */
    where?: eb_keysWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_keys to fetch.
     */
    orderBy?: eb_keysOrderByWithRelationInput | eb_keysOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing eb_keys.
     */
    cursor?: eb_keysWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_keys from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_keys.
     */
    skip?: number
    distinct?: Eb_keysScalarFieldEnum | Eb_keysScalarFieldEnum[]
  }

  /**
   * eb_keys create
   */
  export type eb_keysCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * The data needed to create a eb_keys.
     */
    data: XOR<eb_keysCreateInput, eb_keysUncheckedCreateInput>
  }

  /**
   * eb_keys createMany
   */
  export type eb_keysCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many eb_keys.
     */
    data: eb_keysCreateManyInput | eb_keysCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * eb_keys update
   */
  export type eb_keysUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * The data needed to update a eb_keys.
     */
    data: XOR<eb_keysUpdateInput, eb_keysUncheckedUpdateInput>
    /**
     * Choose, which eb_keys to update.
     */
    where: eb_keysWhereUniqueInput
  }

  /**
   * eb_keys updateMany
   */
  export type eb_keysUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update eb_keys.
     */
    data: XOR<eb_keysUpdateManyMutationInput, eb_keysUncheckedUpdateManyInput>
    /**
     * Filter which eb_keys to update
     */
    where?: eb_keysWhereInput
    /**
     * Limit how many eb_keys to update.
     */
    limit?: number
  }

  /**
   * eb_keys upsert
   */
  export type eb_keysUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * The filter to search for the eb_keys to update in case it exists.
     */
    where: eb_keysWhereUniqueInput
    /**
     * In case the eb_keys found by the `where` argument doesn't exist, create a new eb_keys with this data.
     */
    create: XOR<eb_keysCreateInput, eb_keysUncheckedCreateInput>
    /**
     * In case the eb_keys was found with the provided `where` argument, update it with this data.
     */
    update: XOR<eb_keysUpdateInput, eb_keysUncheckedUpdateInput>
  }

  /**
   * eb_keys delete
   */
  export type eb_keysDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
    /**
     * Filter which eb_keys to delete.
     */
    where: eb_keysWhereUniqueInput
  }

  /**
   * eb_keys deleteMany
   */
  export type eb_keysDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_keys to delete
     */
    where?: eb_keysWhereInput
    /**
     * Limit how many eb_keys to delete.
     */
    limit?: number
  }

  /**
   * eb_keys without action
   */
  export type eb_keysDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_keys
     */
    select?: eb_keysSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_keys
     */
    omit?: eb_keysOmit<ExtArgs> | null
  }


  /**
   * Model eb_orders
   */

  export type AggregateEb_orders = {
    _count: Eb_ordersCountAggregateOutputType | null
    _avg: Eb_ordersAvgAggregateOutputType | null
    _sum: Eb_ordersSumAggregateOutputType | null
    _min: Eb_ordersMinAggregateOutputType | null
    _max: Eb_ordersMaxAggregateOutputType | null
  }

  export type Eb_ordersAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Eb_ordersSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type Eb_ordersMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    transaction_id: string | null
    order_response: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_ordersMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    transaction_id: string | null
    order_response: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type Eb_ordersCountAggregateOutputType = {
    id: number
    user_id: number
    transaction_id: number
    order_response: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type Eb_ordersAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Eb_ordersSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type Eb_ordersMinAggregateInputType = {
    id?: true
    user_id?: true
    transaction_id?: true
    order_response?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_ordersMaxAggregateInputType = {
    id?: true
    user_id?: true
    transaction_id?: true
    order_response?: true
    created_at?: true
    updated_at?: true
  }

  export type Eb_ordersCountAggregateInputType = {
    id?: true
    user_id?: true
    transaction_id?: true
    order_response?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type Eb_ordersAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_orders to aggregate.
     */
    where?: eb_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_orders to fetch.
     */
    orderBy?: eb_ordersOrderByWithRelationInput | eb_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: eb_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_orders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned eb_orders
    **/
    _count?: true | Eb_ordersCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Eb_ordersAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Eb_ordersSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Eb_ordersMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Eb_ordersMaxAggregateInputType
  }

  export type GetEb_ordersAggregateType<T extends Eb_ordersAggregateArgs> = {
        [P in keyof T & keyof AggregateEb_orders]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateEb_orders[P]>
      : GetScalarType<T[P], AggregateEb_orders[P]>
  }




  export type eb_ordersGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: eb_ordersWhereInput
    orderBy?: eb_ordersOrderByWithAggregationInput | eb_ordersOrderByWithAggregationInput[]
    by: Eb_ordersScalarFieldEnum[] | Eb_ordersScalarFieldEnum
    having?: eb_ordersScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Eb_ordersCountAggregateInputType | true
    _avg?: Eb_ordersAvgAggregateInputType
    _sum?: Eb_ordersSumAggregateInputType
    _min?: Eb_ordersMinAggregateInputType
    _max?: Eb_ordersMaxAggregateInputType
  }

  export type Eb_ordersGroupByOutputType = {
    id: number
    user_id: number
    transaction_id: string
    order_response: string
    created_at: Date
    updated_at: Date
    _count: Eb_ordersCountAggregateOutputType | null
    _avg: Eb_ordersAvgAggregateOutputType | null
    _sum: Eb_ordersSumAggregateOutputType | null
    _min: Eb_ordersMinAggregateOutputType | null
    _max: Eb_ordersMaxAggregateOutputType | null
  }

  type GetEb_ordersGroupByPayload<T extends eb_ordersGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Eb_ordersGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Eb_ordersGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Eb_ordersGroupByOutputType[P]>
            : GetScalarType<T[P], Eb_ordersGroupByOutputType[P]>
        }
      >
    >


  export type eb_ordersSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    transaction_id?: boolean
    order_response?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["eb_orders"]>



  export type eb_ordersSelectScalar = {
    id?: boolean
    user_id?: boolean
    transaction_id?: boolean
    order_response?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type eb_ordersOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "transaction_id" | "order_response" | "created_at" | "updated_at", ExtArgs["result"]["eb_orders"]>

  export type $eb_ordersPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "eb_orders"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      transaction_id: string
      order_response: string
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["eb_orders"]>
    composites: {}
  }

  type eb_ordersGetPayload<S extends boolean | null | undefined | eb_ordersDefaultArgs> = $Result.GetResult<Prisma.$eb_ordersPayload, S>

  type eb_ordersCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<eb_ordersFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Eb_ordersCountAggregateInputType | true
    }

  export interface eb_ordersDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['eb_orders'], meta: { name: 'eb_orders' } }
    /**
     * Find zero or one Eb_orders that matches the filter.
     * @param {eb_ordersFindUniqueArgs} args - Arguments to find a Eb_orders
     * @example
     * // Get one Eb_orders
     * const eb_orders = await prisma.eb_orders.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends eb_ordersFindUniqueArgs>(args: SelectSubset<T, eb_ordersFindUniqueArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Eb_orders that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {eb_ordersFindUniqueOrThrowArgs} args - Arguments to find a Eb_orders
     * @example
     * // Get one Eb_orders
     * const eb_orders = await prisma.eb_orders.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends eb_ordersFindUniqueOrThrowArgs>(args: SelectSubset<T, eb_ordersFindUniqueOrThrowArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_orders that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_ordersFindFirstArgs} args - Arguments to find a Eb_orders
     * @example
     * // Get one Eb_orders
     * const eb_orders = await prisma.eb_orders.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends eb_ordersFindFirstArgs>(args?: SelectSubset<T, eb_ordersFindFirstArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Eb_orders that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_ordersFindFirstOrThrowArgs} args - Arguments to find a Eb_orders
     * @example
     * // Get one Eb_orders
     * const eb_orders = await prisma.eb_orders.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends eb_ordersFindFirstOrThrowArgs>(args?: SelectSubset<T, eb_ordersFindFirstOrThrowArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Eb_orders that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_ordersFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Eb_orders
     * const eb_orders = await prisma.eb_orders.findMany()
     * 
     * // Get first 10 Eb_orders
     * const eb_orders = await prisma.eb_orders.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const eb_ordersWithIdOnly = await prisma.eb_orders.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends eb_ordersFindManyArgs>(args?: SelectSubset<T, eb_ordersFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Eb_orders.
     * @param {eb_ordersCreateArgs} args - Arguments to create a Eb_orders.
     * @example
     * // Create one Eb_orders
     * const Eb_orders = await prisma.eb_orders.create({
     *   data: {
     *     // ... data to create a Eb_orders
     *   }
     * })
     * 
     */
    create<T extends eb_ordersCreateArgs>(args: SelectSubset<T, eb_ordersCreateArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Eb_orders.
     * @param {eb_ordersCreateManyArgs} args - Arguments to create many Eb_orders.
     * @example
     * // Create many Eb_orders
     * const eb_orders = await prisma.eb_orders.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends eb_ordersCreateManyArgs>(args?: SelectSubset<T, eb_ordersCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Eb_orders.
     * @param {eb_ordersDeleteArgs} args - Arguments to delete one Eb_orders.
     * @example
     * // Delete one Eb_orders
     * const Eb_orders = await prisma.eb_orders.delete({
     *   where: {
     *     // ... filter to delete one Eb_orders
     *   }
     * })
     * 
     */
    delete<T extends eb_ordersDeleteArgs>(args: SelectSubset<T, eb_ordersDeleteArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Eb_orders.
     * @param {eb_ordersUpdateArgs} args - Arguments to update one Eb_orders.
     * @example
     * // Update one Eb_orders
     * const eb_orders = await prisma.eb_orders.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends eb_ordersUpdateArgs>(args: SelectSubset<T, eb_ordersUpdateArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Eb_orders.
     * @param {eb_ordersDeleteManyArgs} args - Arguments to filter Eb_orders to delete.
     * @example
     * // Delete a few Eb_orders
     * const { count } = await prisma.eb_orders.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends eb_ordersDeleteManyArgs>(args?: SelectSubset<T, eb_ordersDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Eb_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_ordersUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Eb_orders
     * const eb_orders = await prisma.eb_orders.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends eb_ordersUpdateManyArgs>(args: SelectSubset<T, eb_ordersUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Eb_orders.
     * @param {eb_ordersUpsertArgs} args - Arguments to update or create a Eb_orders.
     * @example
     * // Update or create a Eb_orders
     * const eb_orders = await prisma.eb_orders.upsert({
     *   create: {
     *     // ... data to create a Eb_orders
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Eb_orders we want to update
     *   }
     * })
     */
    upsert<T extends eb_ordersUpsertArgs>(args: SelectSubset<T, eb_ordersUpsertArgs<ExtArgs>>): Prisma__eb_ordersClient<$Result.GetResult<Prisma.$eb_ordersPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Eb_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_ordersCountArgs} args - Arguments to filter Eb_orders to count.
     * @example
     * // Count the number of Eb_orders
     * const count = await prisma.eb_orders.count({
     *   where: {
     *     // ... the filter for the Eb_orders we want to count
     *   }
     * })
    **/
    count<T extends eb_ordersCountArgs>(
      args?: Subset<T, eb_ordersCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Eb_ordersCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Eb_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Eb_ordersAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Eb_ordersAggregateArgs>(args: Subset<T, Eb_ordersAggregateArgs>): Prisma.PrismaPromise<GetEb_ordersAggregateType<T>>

    /**
     * Group by Eb_orders.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {eb_ordersGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends eb_ordersGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: eb_ordersGroupByArgs['orderBy'] }
        : { orderBy?: eb_ordersGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, eb_ordersGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetEb_ordersGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the eb_orders model
   */
  readonly fields: eb_ordersFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for eb_orders.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__eb_ordersClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the eb_orders model
   */
  interface eb_ordersFieldRefs {
    readonly id: FieldRef<"eb_orders", 'Int'>
    readonly user_id: FieldRef<"eb_orders", 'Int'>
    readonly transaction_id: FieldRef<"eb_orders", 'String'>
    readonly order_response: FieldRef<"eb_orders", 'String'>
    readonly created_at: FieldRef<"eb_orders", 'DateTime'>
    readonly updated_at: FieldRef<"eb_orders", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * eb_orders findUnique
   */
  export type eb_ordersFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * Filter, which eb_orders to fetch.
     */
    where: eb_ordersWhereUniqueInput
  }

  /**
   * eb_orders findUniqueOrThrow
   */
  export type eb_ordersFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * Filter, which eb_orders to fetch.
     */
    where: eb_ordersWhereUniqueInput
  }

  /**
   * eb_orders findFirst
   */
  export type eb_ordersFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * Filter, which eb_orders to fetch.
     */
    where?: eb_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_orders to fetch.
     */
    orderBy?: eb_ordersOrderByWithRelationInput | eb_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_orders.
     */
    cursor?: eb_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_orders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_orders.
     */
    distinct?: Eb_ordersScalarFieldEnum | Eb_ordersScalarFieldEnum[]
  }

  /**
   * eb_orders findFirstOrThrow
   */
  export type eb_ordersFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * Filter, which eb_orders to fetch.
     */
    where?: eb_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_orders to fetch.
     */
    orderBy?: eb_ordersOrderByWithRelationInput | eb_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for eb_orders.
     */
    cursor?: eb_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_orders.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of eb_orders.
     */
    distinct?: Eb_ordersScalarFieldEnum | Eb_ordersScalarFieldEnum[]
  }

  /**
   * eb_orders findMany
   */
  export type eb_ordersFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * Filter, which eb_orders to fetch.
     */
    where?: eb_ordersWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of eb_orders to fetch.
     */
    orderBy?: eb_ordersOrderByWithRelationInput | eb_ordersOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing eb_orders.
     */
    cursor?: eb_ordersWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` eb_orders from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` eb_orders.
     */
    skip?: number
    distinct?: Eb_ordersScalarFieldEnum | Eb_ordersScalarFieldEnum[]
  }

  /**
   * eb_orders create
   */
  export type eb_ordersCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * The data needed to create a eb_orders.
     */
    data: XOR<eb_ordersCreateInput, eb_ordersUncheckedCreateInput>
  }

  /**
   * eb_orders createMany
   */
  export type eb_ordersCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many eb_orders.
     */
    data: eb_ordersCreateManyInput | eb_ordersCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * eb_orders update
   */
  export type eb_ordersUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * The data needed to update a eb_orders.
     */
    data: XOR<eb_ordersUpdateInput, eb_ordersUncheckedUpdateInput>
    /**
     * Choose, which eb_orders to update.
     */
    where: eb_ordersWhereUniqueInput
  }

  /**
   * eb_orders updateMany
   */
  export type eb_ordersUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update eb_orders.
     */
    data: XOR<eb_ordersUpdateManyMutationInput, eb_ordersUncheckedUpdateManyInput>
    /**
     * Filter which eb_orders to update
     */
    where?: eb_ordersWhereInput
    /**
     * Limit how many eb_orders to update.
     */
    limit?: number
  }

  /**
   * eb_orders upsert
   */
  export type eb_ordersUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * The filter to search for the eb_orders to update in case it exists.
     */
    where: eb_ordersWhereUniqueInput
    /**
     * In case the eb_orders found by the `where` argument doesn't exist, create a new eb_orders with this data.
     */
    create: XOR<eb_ordersCreateInput, eb_ordersUncheckedCreateInput>
    /**
     * In case the eb_orders was found with the provided `where` argument, update it with this data.
     */
    update: XOR<eb_ordersUpdateInput, eb_ordersUncheckedUpdateInput>
  }

  /**
   * eb_orders delete
   */
  export type eb_ordersDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
    /**
     * Filter which eb_orders to delete.
     */
    where: eb_ordersWhereUniqueInput
  }

  /**
   * eb_orders deleteMany
   */
  export type eb_ordersDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which eb_orders to delete
     */
    where?: eb_ordersWhereInput
    /**
     * Limit how many eb_orders to delete.
     */
    limit?: number
  }

  /**
   * eb_orders without action
   */
  export type eb_ordersDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the eb_orders
     */
    select?: eb_ordersSelect<ExtArgs> | null
    /**
     * Omit specific fields from the eb_orders
     */
    omit?: eb_ordersOmit<ExtArgs> | null
  }


  /**
   * Model ebproducts
   */

  export type AggregateEbproducts = {
    _count: EbproductsCountAggregateOutputType | null
    _avg: EbproductsAvgAggregateOutputType | null
    _sum: EbproductsSumAggregateOutputType | null
    _min: EbproductsMinAggregateOutputType | null
    _max: EbproductsMaxAggregateOutputType | null
  }

  export type EbproductsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    qty: number | null
    price: number | null
  }

  export type EbproductsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    qty: number | null
    price: number | null
  }

  export type EbproductsMinAggregateOutputType = {
    id: number | null
    sku: string | null
    ebayitemid: string | null
    listingdate: Date | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
    qty: number | null
    price: number | null
    title: string | null
    promotional_sale_id: string | null
    ended: boolean | null
    todelete: boolean | null
  }

  export type EbproductsMaxAggregateOutputType = {
    id: number | null
    sku: string | null
    ebayitemid: string | null
    listingdate: Date | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
    qty: number | null
    price: number | null
    title: string | null
    promotional_sale_id: string | null
    ended: boolean | null
    todelete: boolean | null
  }

  export type EbproductsCountAggregateOutputType = {
    id: number
    sku: number
    ebayitemid: number
    listingdate: number
    user_id: number
    created_at: number
    updated_at: number
    qty: number
    price: number
    title: number
    promotional_sale_id: number
    ended: number
    todelete: number
    _all: number
  }


  export type EbproductsAvgAggregateInputType = {
    id?: true
    user_id?: true
    qty?: true
    price?: true
  }

  export type EbproductsSumAggregateInputType = {
    id?: true
    user_id?: true
    qty?: true
    price?: true
  }

  export type EbproductsMinAggregateInputType = {
    id?: true
    sku?: true
    ebayitemid?: true
    listingdate?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    qty?: true
    price?: true
    title?: true
    promotional_sale_id?: true
    ended?: true
    todelete?: true
  }

  export type EbproductsMaxAggregateInputType = {
    id?: true
    sku?: true
    ebayitemid?: true
    listingdate?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    qty?: true
    price?: true
    title?: true
    promotional_sale_id?: true
    ended?: true
    todelete?: true
  }

  export type EbproductsCountAggregateInputType = {
    id?: true
    sku?: true
    ebayitemid?: true
    listingdate?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    qty?: true
    price?: true
    title?: true
    promotional_sale_id?: true
    ended?: true
    todelete?: true
    _all?: true
  }

  export type EbproductsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ebproducts to aggregate.
     */
    where?: ebproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ebproducts to fetch.
     */
    orderBy?: ebproductsOrderByWithRelationInput | ebproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ebproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ebproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ebproducts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ebproducts
    **/
    _count?: true | EbproductsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: EbproductsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: EbproductsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: EbproductsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: EbproductsMaxAggregateInputType
  }

  export type GetEbproductsAggregateType<T extends EbproductsAggregateArgs> = {
        [P in keyof T & keyof AggregateEbproducts]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateEbproducts[P]>
      : GetScalarType<T[P], AggregateEbproducts[P]>
  }




  export type ebproductsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ebproductsWhereInput
    orderBy?: ebproductsOrderByWithAggregationInput | ebproductsOrderByWithAggregationInput[]
    by: EbproductsScalarFieldEnum[] | EbproductsScalarFieldEnum
    having?: ebproductsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: EbproductsCountAggregateInputType | true
    _avg?: EbproductsAvgAggregateInputType
    _sum?: EbproductsSumAggregateInputType
    _min?: EbproductsMinAggregateInputType
    _max?: EbproductsMaxAggregateInputType
  }

  export type EbproductsGroupByOutputType = {
    id: number
    sku: string
    ebayitemid: string
    listingdate: Date
    user_id: number
    created_at: Date
    updated_at: Date
    qty: number
    price: number
    title: string
    promotional_sale_id: string
    ended: boolean
    todelete: boolean
    _count: EbproductsCountAggregateOutputType | null
    _avg: EbproductsAvgAggregateOutputType | null
    _sum: EbproductsSumAggregateOutputType | null
    _min: EbproductsMinAggregateOutputType | null
    _max: EbproductsMaxAggregateOutputType | null
  }

  type GetEbproductsGroupByPayload<T extends ebproductsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<EbproductsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof EbproductsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], EbproductsGroupByOutputType[P]>
            : GetScalarType<T[P], EbproductsGroupByOutputType[P]>
        }
      >
    >


  export type ebproductsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    sku?: boolean
    ebayitemid?: boolean
    listingdate?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    qty?: boolean
    price?: boolean
    title?: boolean
    promotional_sale_id?: boolean
    ended?: boolean
    todelete?: boolean
  }, ExtArgs["result"]["ebproducts"]>



  export type ebproductsSelectScalar = {
    id?: boolean
    sku?: boolean
    ebayitemid?: boolean
    listingdate?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    qty?: boolean
    price?: boolean
    title?: boolean
    promotional_sale_id?: boolean
    ended?: boolean
    todelete?: boolean
  }

  export type ebproductsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "sku" | "ebayitemid" | "listingdate" | "user_id" | "created_at" | "updated_at" | "qty" | "price" | "title" | "promotional_sale_id" | "ended" | "todelete", ExtArgs["result"]["ebproducts"]>

  export type $ebproductsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ebproducts"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      sku: string
      ebayitemid: string
      listingdate: Date
      user_id: number
      created_at: Date
      updated_at: Date
      qty: number
      price: number
      title: string
      promotional_sale_id: string
      ended: boolean
      todelete: boolean
    }, ExtArgs["result"]["ebproducts"]>
    composites: {}
  }

  type ebproductsGetPayload<S extends boolean | null | undefined | ebproductsDefaultArgs> = $Result.GetResult<Prisma.$ebproductsPayload, S>

  type ebproductsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ebproductsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: EbproductsCountAggregateInputType | true
    }

  export interface ebproductsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ebproducts'], meta: { name: 'ebproducts' } }
    /**
     * Find zero or one Ebproducts that matches the filter.
     * @param {ebproductsFindUniqueArgs} args - Arguments to find a Ebproducts
     * @example
     * // Get one Ebproducts
     * const ebproducts = await prisma.ebproducts.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ebproductsFindUniqueArgs>(args: SelectSubset<T, ebproductsFindUniqueArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Ebproducts that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ebproductsFindUniqueOrThrowArgs} args - Arguments to find a Ebproducts
     * @example
     * // Get one Ebproducts
     * const ebproducts = await prisma.ebproducts.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ebproductsFindUniqueOrThrowArgs>(args: SelectSubset<T, ebproductsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Ebproducts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebproductsFindFirstArgs} args - Arguments to find a Ebproducts
     * @example
     * // Get one Ebproducts
     * const ebproducts = await prisma.ebproducts.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ebproductsFindFirstArgs>(args?: SelectSubset<T, ebproductsFindFirstArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Ebproducts that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebproductsFindFirstOrThrowArgs} args - Arguments to find a Ebproducts
     * @example
     * // Get one Ebproducts
     * const ebproducts = await prisma.ebproducts.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ebproductsFindFirstOrThrowArgs>(args?: SelectSubset<T, ebproductsFindFirstOrThrowArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Ebproducts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebproductsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Ebproducts
     * const ebproducts = await prisma.ebproducts.findMany()
     * 
     * // Get first 10 Ebproducts
     * const ebproducts = await prisma.ebproducts.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const ebproductsWithIdOnly = await prisma.ebproducts.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ebproductsFindManyArgs>(args?: SelectSubset<T, ebproductsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Ebproducts.
     * @param {ebproductsCreateArgs} args - Arguments to create a Ebproducts.
     * @example
     * // Create one Ebproducts
     * const Ebproducts = await prisma.ebproducts.create({
     *   data: {
     *     // ... data to create a Ebproducts
     *   }
     * })
     * 
     */
    create<T extends ebproductsCreateArgs>(args: SelectSubset<T, ebproductsCreateArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Ebproducts.
     * @param {ebproductsCreateManyArgs} args - Arguments to create many Ebproducts.
     * @example
     * // Create many Ebproducts
     * const ebproducts = await prisma.ebproducts.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ebproductsCreateManyArgs>(args?: SelectSubset<T, ebproductsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Ebproducts.
     * @param {ebproductsDeleteArgs} args - Arguments to delete one Ebproducts.
     * @example
     * // Delete one Ebproducts
     * const Ebproducts = await prisma.ebproducts.delete({
     *   where: {
     *     // ... filter to delete one Ebproducts
     *   }
     * })
     * 
     */
    delete<T extends ebproductsDeleteArgs>(args: SelectSubset<T, ebproductsDeleteArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Ebproducts.
     * @param {ebproductsUpdateArgs} args - Arguments to update one Ebproducts.
     * @example
     * // Update one Ebproducts
     * const ebproducts = await prisma.ebproducts.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ebproductsUpdateArgs>(args: SelectSubset<T, ebproductsUpdateArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Ebproducts.
     * @param {ebproductsDeleteManyArgs} args - Arguments to filter Ebproducts to delete.
     * @example
     * // Delete a few Ebproducts
     * const { count } = await prisma.ebproducts.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ebproductsDeleteManyArgs>(args?: SelectSubset<T, ebproductsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Ebproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebproductsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Ebproducts
     * const ebproducts = await prisma.ebproducts.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ebproductsUpdateManyArgs>(args: SelectSubset<T, ebproductsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Ebproducts.
     * @param {ebproductsUpsertArgs} args - Arguments to update or create a Ebproducts.
     * @example
     * // Update or create a Ebproducts
     * const ebproducts = await prisma.ebproducts.upsert({
     *   create: {
     *     // ... data to create a Ebproducts
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Ebproducts we want to update
     *   }
     * })
     */
    upsert<T extends ebproductsUpsertArgs>(args: SelectSubset<T, ebproductsUpsertArgs<ExtArgs>>): Prisma__ebproductsClient<$Result.GetResult<Prisma.$ebproductsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Ebproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebproductsCountArgs} args - Arguments to filter Ebproducts to count.
     * @example
     * // Count the number of Ebproducts
     * const count = await prisma.ebproducts.count({
     *   where: {
     *     // ... the filter for the Ebproducts we want to count
     *   }
     * })
    **/
    count<T extends ebproductsCountArgs>(
      args?: Subset<T, ebproductsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], EbproductsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Ebproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {EbproductsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends EbproductsAggregateArgs>(args: Subset<T, EbproductsAggregateArgs>): Prisma.PrismaPromise<GetEbproductsAggregateType<T>>

    /**
     * Group by Ebproducts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebproductsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ebproductsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ebproductsGroupByArgs['orderBy'] }
        : { orderBy?: ebproductsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ebproductsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetEbproductsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ebproducts model
   */
  readonly fields: ebproductsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ebproducts.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ebproductsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ebproducts model
   */
  interface ebproductsFieldRefs {
    readonly id: FieldRef<"ebproducts", 'Int'>
    readonly sku: FieldRef<"ebproducts", 'String'>
    readonly ebayitemid: FieldRef<"ebproducts", 'String'>
    readonly listingdate: FieldRef<"ebproducts", 'DateTime'>
    readonly user_id: FieldRef<"ebproducts", 'Int'>
    readonly created_at: FieldRef<"ebproducts", 'DateTime'>
    readonly updated_at: FieldRef<"ebproducts", 'DateTime'>
    readonly qty: FieldRef<"ebproducts", 'Int'>
    readonly price: FieldRef<"ebproducts", 'Float'>
    readonly title: FieldRef<"ebproducts", 'String'>
    readonly promotional_sale_id: FieldRef<"ebproducts", 'String'>
    readonly ended: FieldRef<"ebproducts", 'Boolean'>
    readonly todelete: FieldRef<"ebproducts", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * ebproducts findUnique
   */
  export type ebproductsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * Filter, which ebproducts to fetch.
     */
    where: ebproductsWhereUniqueInput
  }

  /**
   * ebproducts findUniqueOrThrow
   */
  export type ebproductsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * Filter, which ebproducts to fetch.
     */
    where: ebproductsWhereUniqueInput
  }

  /**
   * ebproducts findFirst
   */
  export type ebproductsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * Filter, which ebproducts to fetch.
     */
    where?: ebproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ebproducts to fetch.
     */
    orderBy?: ebproductsOrderByWithRelationInput | ebproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ebproducts.
     */
    cursor?: ebproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ebproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ebproducts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ebproducts.
     */
    distinct?: EbproductsScalarFieldEnum | EbproductsScalarFieldEnum[]
  }

  /**
   * ebproducts findFirstOrThrow
   */
  export type ebproductsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * Filter, which ebproducts to fetch.
     */
    where?: ebproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ebproducts to fetch.
     */
    orderBy?: ebproductsOrderByWithRelationInput | ebproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ebproducts.
     */
    cursor?: ebproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ebproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ebproducts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ebproducts.
     */
    distinct?: EbproductsScalarFieldEnum | EbproductsScalarFieldEnum[]
  }

  /**
   * ebproducts findMany
   */
  export type ebproductsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * Filter, which ebproducts to fetch.
     */
    where?: ebproductsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ebproducts to fetch.
     */
    orderBy?: ebproductsOrderByWithRelationInput | ebproductsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ebproducts.
     */
    cursor?: ebproductsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ebproducts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ebproducts.
     */
    skip?: number
    distinct?: EbproductsScalarFieldEnum | EbproductsScalarFieldEnum[]
  }

  /**
   * ebproducts create
   */
  export type ebproductsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * The data needed to create a ebproducts.
     */
    data: XOR<ebproductsCreateInput, ebproductsUncheckedCreateInput>
  }

  /**
   * ebproducts createMany
   */
  export type ebproductsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ebproducts.
     */
    data: ebproductsCreateManyInput | ebproductsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ebproducts update
   */
  export type ebproductsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * The data needed to update a ebproducts.
     */
    data: XOR<ebproductsUpdateInput, ebproductsUncheckedUpdateInput>
    /**
     * Choose, which ebproducts to update.
     */
    where: ebproductsWhereUniqueInput
  }

  /**
   * ebproducts updateMany
   */
  export type ebproductsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ebproducts.
     */
    data: XOR<ebproductsUpdateManyMutationInput, ebproductsUncheckedUpdateManyInput>
    /**
     * Filter which ebproducts to update
     */
    where?: ebproductsWhereInput
    /**
     * Limit how many ebproducts to update.
     */
    limit?: number
  }

  /**
   * ebproducts upsert
   */
  export type ebproductsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * The filter to search for the ebproducts to update in case it exists.
     */
    where: ebproductsWhereUniqueInput
    /**
     * In case the ebproducts found by the `where` argument doesn't exist, create a new ebproducts with this data.
     */
    create: XOR<ebproductsCreateInput, ebproductsUncheckedCreateInput>
    /**
     * In case the ebproducts was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ebproductsUpdateInput, ebproductsUncheckedUpdateInput>
  }

  /**
   * ebproducts delete
   */
  export type ebproductsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
    /**
     * Filter which ebproducts to delete.
     */
    where: ebproductsWhereUniqueInput
  }

  /**
   * ebproducts deleteMany
   */
  export type ebproductsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ebproducts to delete
     */
    where?: ebproductsWhereInput
    /**
     * Limit how many ebproducts to delete.
     */
    limit?: number
  }

  /**
   * ebproducts without action
   */
  export type ebproductsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ebproducts
     */
    select?: ebproductsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ebproducts
     */
    omit?: ebproductsOmit<ExtArgs> | null
  }


  /**
   * Model ebpromotions
   */

  export type AggregateEbpromotions = {
    _count: EbpromotionsCountAggregateOutputType | null
    _avg: EbpromotionsAvgAggregateOutputType | null
    _sum: EbpromotionsSumAggregateOutputType | null
    _min: EbpromotionsMinAggregateOutputType | null
    _max: EbpromotionsMaxAggregateOutputType | null
  }

  export type EbpromotionsAvgAggregateOutputType = {
    id: number | null
    discount_value: number | null
    promotional_sale_id: number | null
  }

  export type EbpromotionsSumAggregateOutputType = {
    id: bigint | null
    discount_value: number | null
    promotional_sale_id: bigint | null
  }

  export type EbpromotionsMinAggregateOutputType = {
    id: bigint | null
    name: string | null
    discount_type: $Enums.ebpromotions_discount_type | null
    discount_value: number | null
    start_time: Date | null
    end_time: Date | null
    type: $Enums.ebpromotions_type | null
    promotional_sale_id: bigint | null
    deleted: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type EbpromotionsMaxAggregateOutputType = {
    id: bigint | null
    name: string | null
    discount_type: $Enums.ebpromotions_discount_type | null
    discount_value: number | null
    start_time: Date | null
    end_time: Date | null
    type: $Enums.ebpromotions_type | null
    promotional_sale_id: bigint | null
    deleted: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type EbpromotionsCountAggregateOutputType = {
    id: number
    name: number
    discount_type: number
    discount_value: number
    start_time: number
    end_time: number
    type: number
    promotional_sale_id: number
    deleted: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type EbpromotionsAvgAggregateInputType = {
    id?: true
    discount_value?: true
    promotional_sale_id?: true
  }

  export type EbpromotionsSumAggregateInputType = {
    id?: true
    discount_value?: true
    promotional_sale_id?: true
  }

  export type EbpromotionsMinAggregateInputType = {
    id?: true
    name?: true
    discount_type?: true
    discount_value?: true
    start_time?: true
    end_time?: true
    type?: true
    promotional_sale_id?: true
    deleted?: true
    created_at?: true
    updated_at?: true
  }

  export type EbpromotionsMaxAggregateInputType = {
    id?: true
    name?: true
    discount_type?: true
    discount_value?: true
    start_time?: true
    end_time?: true
    type?: true
    promotional_sale_id?: true
    deleted?: true
    created_at?: true
    updated_at?: true
  }

  export type EbpromotionsCountAggregateInputType = {
    id?: true
    name?: true
    discount_type?: true
    discount_value?: true
    start_time?: true
    end_time?: true
    type?: true
    promotional_sale_id?: true
    deleted?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type EbpromotionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ebpromotions to aggregate.
     */
    where?: ebpromotionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ebpromotions to fetch.
     */
    orderBy?: ebpromotionsOrderByWithRelationInput | ebpromotionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ebpromotionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ebpromotions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ebpromotions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ebpromotions
    **/
    _count?: true | EbpromotionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: EbpromotionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: EbpromotionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: EbpromotionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: EbpromotionsMaxAggregateInputType
  }

  export type GetEbpromotionsAggregateType<T extends EbpromotionsAggregateArgs> = {
        [P in keyof T & keyof AggregateEbpromotions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateEbpromotions[P]>
      : GetScalarType<T[P], AggregateEbpromotions[P]>
  }




  export type ebpromotionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ebpromotionsWhereInput
    orderBy?: ebpromotionsOrderByWithAggregationInput | ebpromotionsOrderByWithAggregationInput[]
    by: EbpromotionsScalarFieldEnum[] | EbpromotionsScalarFieldEnum
    having?: ebpromotionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: EbpromotionsCountAggregateInputType | true
    _avg?: EbpromotionsAvgAggregateInputType
    _sum?: EbpromotionsSumAggregateInputType
    _min?: EbpromotionsMinAggregateInputType
    _max?: EbpromotionsMaxAggregateInputType
  }

  export type EbpromotionsGroupByOutputType = {
    id: bigint
    name: string | null
    discount_type: $Enums.ebpromotions_discount_type | null
    discount_value: number | null
    start_time: Date | null
    end_time: Date | null
    type: $Enums.ebpromotions_type | null
    promotional_sale_id: bigint | null
    deleted: boolean
    created_at: Date | null
    updated_at: Date | null
    _count: EbpromotionsCountAggregateOutputType | null
    _avg: EbpromotionsAvgAggregateOutputType | null
    _sum: EbpromotionsSumAggregateOutputType | null
    _min: EbpromotionsMinAggregateOutputType | null
    _max: EbpromotionsMaxAggregateOutputType | null
  }

  type GetEbpromotionsGroupByPayload<T extends ebpromotionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<EbpromotionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof EbpromotionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], EbpromotionsGroupByOutputType[P]>
            : GetScalarType<T[P], EbpromotionsGroupByOutputType[P]>
        }
      >
    >


  export type ebpromotionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    discount_type?: boolean
    discount_value?: boolean
    start_time?: boolean
    end_time?: boolean
    type?: boolean
    promotional_sale_id?: boolean
    deleted?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["ebpromotions"]>



  export type ebpromotionsSelectScalar = {
    id?: boolean
    name?: boolean
    discount_type?: boolean
    discount_value?: boolean
    start_time?: boolean
    end_time?: boolean
    type?: boolean
    promotional_sale_id?: boolean
    deleted?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ebpromotionsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "discount_type" | "discount_value" | "start_time" | "end_time" | "type" | "promotional_sale_id" | "deleted" | "created_at" | "updated_at", ExtArgs["result"]["ebpromotions"]>

  export type $ebpromotionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ebpromotions"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: bigint
      name: string | null
      discount_type: $Enums.ebpromotions_discount_type | null
      discount_value: number | null
      start_time: Date | null
      end_time: Date | null
      type: $Enums.ebpromotions_type | null
      promotional_sale_id: bigint | null
      deleted: boolean
      created_at: Date | null
      updated_at: Date | null
    }, ExtArgs["result"]["ebpromotions"]>
    composites: {}
  }

  type ebpromotionsGetPayload<S extends boolean | null | undefined | ebpromotionsDefaultArgs> = $Result.GetResult<Prisma.$ebpromotionsPayload, S>

  type ebpromotionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ebpromotionsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: EbpromotionsCountAggregateInputType | true
    }

  export interface ebpromotionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ebpromotions'], meta: { name: 'ebpromotions' } }
    /**
     * Find zero or one Ebpromotions that matches the filter.
     * @param {ebpromotionsFindUniqueArgs} args - Arguments to find a Ebpromotions
     * @example
     * // Get one Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ebpromotionsFindUniqueArgs>(args: SelectSubset<T, ebpromotionsFindUniqueArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Ebpromotions that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ebpromotionsFindUniqueOrThrowArgs} args - Arguments to find a Ebpromotions
     * @example
     * // Get one Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ebpromotionsFindUniqueOrThrowArgs>(args: SelectSubset<T, ebpromotionsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Ebpromotions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebpromotionsFindFirstArgs} args - Arguments to find a Ebpromotions
     * @example
     * // Get one Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ebpromotionsFindFirstArgs>(args?: SelectSubset<T, ebpromotionsFindFirstArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Ebpromotions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebpromotionsFindFirstOrThrowArgs} args - Arguments to find a Ebpromotions
     * @example
     * // Get one Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ebpromotionsFindFirstOrThrowArgs>(args?: SelectSubset<T, ebpromotionsFindFirstOrThrowArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Ebpromotions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebpromotionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.findMany()
     * 
     * // Get first 10 Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const ebpromotionsWithIdOnly = await prisma.ebpromotions.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ebpromotionsFindManyArgs>(args?: SelectSubset<T, ebpromotionsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Ebpromotions.
     * @param {ebpromotionsCreateArgs} args - Arguments to create a Ebpromotions.
     * @example
     * // Create one Ebpromotions
     * const Ebpromotions = await prisma.ebpromotions.create({
     *   data: {
     *     // ... data to create a Ebpromotions
     *   }
     * })
     * 
     */
    create<T extends ebpromotionsCreateArgs>(args: SelectSubset<T, ebpromotionsCreateArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Ebpromotions.
     * @param {ebpromotionsCreateManyArgs} args - Arguments to create many Ebpromotions.
     * @example
     * // Create many Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ebpromotionsCreateManyArgs>(args?: SelectSubset<T, ebpromotionsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Ebpromotions.
     * @param {ebpromotionsDeleteArgs} args - Arguments to delete one Ebpromotions.
     * @example
     * // Delete one Ebpromotions
     * const Ebpromotions = await prisma.ebpromotions.delete({
     *   where: {
     *     // ... filter to delete one Ebpromotions
     *   }
     * })
     * 
     */
    delete<T extends ebpromotionsDeleteArgs>(args: SelectSubset<T, ebpromotionsDeleteArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Ebpromotions.
     * @param {ebpromotionsUpdateArgs} args - Arguments to update one Ebpromotions.
     * @example
     * // Update one Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ebpromotionsUpdateArgs>(args: SelectSubset<T, ebpromotionsUpdateArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Ebpromotions.
     * @param {ebpromotionsDeleteManyArgs} args - Arguments to filter Ebpromotions to delete.
     * @example
     * // Delete a few Ebpromotions
     * const { count } = await prisma.ebpromotions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ebpromotionsDeleteManyArgs>(args?: SelectSubset<T, ebpromotionsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Ebpromotions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebpromotionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ebpromotionsUpdateManyArgs>(args: SelectSubset<T, ebpromotionsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Ebpromotions.
     * @param {ebpromotionsUpsertArgs} args - Arguments to update or create a Ebpromotions.
     * @example
     * // Update or create a Ebpromotions
     * const ebpromotions = await prisma.ebpromotions.upsert({
     *   create: {
     *     // ... data to create a Ebpromotions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Ebpromotions we want to update
     *   }
     * })
     */
    upsert<T extends ebpromotionsUpsertArgs>(args: SelectSubset<T, ebpromotionsUpsertArgs<ExtArgs>>): Prisma__ebpromotionsClient<$Result.GetResult<Prisma.$ebpromotionsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Ebpromotions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebpromotionsCountArgs} args - Arguments to filter Ebpromotions to count.
     * @example
     * // Count the number of Ebpromotions
     * const count = await prisma.ebpromotions.count({
     *   where: {
     *     // ... the filter for the Ebpromotions we want to count
     *   }
     * })
    **/
    count<T extends ebpromotionsCountArgs>(
      args?: Subset<T, ebpromotionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], EbpromotionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Ebpromotions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {EbpromotionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends EbpromotionsAggregateArgs>(args: Subset<T, EbpromotionsAggregateArgs>): Prisma.PrismaPromise<GetEbpromotionsAggregateType<T>>

    /**
     * Group by Ebpromotions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ebpromotionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ebpromotionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ebpromotionsGroupByArgs['orderBy'] }
        : { orderBy?: ebpromotionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}