var _a;
import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { PassThrough } from "stream";
import { renderToPipeableStream } from "react-dom/server";
import { RemixServer, Meta, Links, Outlet, ScrollRestoration, Scripts, useLoaderData, useActionData, Form, Link, useRouteError, useNavigate } from "@remix-run/react";
import { createReadableStreamFromReadable, json, redirect } from "@remix-run/node";
import { isbot } from "isbot";
import "@shopify/shopify-app-remix/adapters/node";
import { shopifyApp, AppDistribution, ApiVersion, LoginErrorType, boundary } from "@shopify/shopify-app-remix/server";
import { PrismaSessionStorage } from "@shopify/shopify-app-session-storage-prisma";
import { PrismaClient } from "@prisma/client";
import { useState, useEffect, useCallback } from "react";
import { AppProvider, Page, Card, FormLayout, Text, TextField, Button, useSetIndexFiltersMode, useIndexResourceState, IndexTable, Link as Link$1, Badge, Tooltip, LegacyCard, SkeletonBodyText, Banner, Modal, IndexFilters, Pagination, TextContainer, EmptyState, InlineGrid, BlockStack, Select, DataTable, InlineStack, Layout, ProgressBar, CalloutCard, Icon, Box, LegacyStack, Collapsible, RadioButton, Tabs } from "@shopify/polaris";
import { AppProvider as AppProvider$1 } from "@shopify/shopify-app-remix/react";
import { NavMenu } from "@shopify/app-bridge-react";
import { ImportIcon, StatusActiveIcon, XCircleIcon, AlertCircleIcon, StoreIcon, ArrowRightIcon, ChevronUpIcon, ChevronDownIcon } from "@shopify/polaris-icons";
import axios from "axios";
import wrap from "word-wrap";
import { FcPicture } from "react-icons/fc";
import { FaShopify } from "react-icons/fa";
import Joyride, { STATUS } from "react-joyride";
import { TbExternalLink } from "react-icons/tb";
if (process.env.NODE_ENV !== "production") {
  if (!global.prismaGlobal) {
    global.prismaGlobal = new PrismaClient();
  }
}
const prisma = global.prismaGlobal ?? new PrismaClient();
const shopify$1 = shopifyApp({
  apiKey: process.env.SHOPIFY_API_KEY,
  apiSecretKey: process.env.SHOPIFY_API_SECRET || "",
  apiVersion: ApiVersion.January25,
  scopes: (_a = process.env.SCOPES) == null ? void 0 : _a.split(","),
  appUrl: process.env.SHOPIFY_APP_URL || "",
  authPathPrefix: "/auth",
  sessionStorage: new PrismaSessionStorage(prisma),
  distribution: AppDistribution.AppStore,
  future: {
    unstable_newEmbeddedAuthStrategy: true,
    removeRest: true
  },
  ...process.env.SHOP_CUSTOM_DOMAIN ? { customShopDomains: [process.env.SHOP_CUSTOM_DOMAIN] } : {},
  hooks: {
    afterAuth: async ({ session, admin }) => {
      try {
        await shopify$1.registerWebhooks({ session });
        console.log("Webhooks registered successfully for", session.shop);
      } catch (error) {
        console.error("Error registering webhooks for", session.shop, error);
      }
      await userInsert(session, admin);
      return new Response(null, {
        status: 302,
        headers: {
          Location: `/app?shop=${session.shop}`
        }
      });
    }
  }
});
const userInsert = async (session, admin) => {
  try {
    let user = await prisma.users.findFirst({
      where: { shopurl: session.shop }
    });
    if (!user) {
      const shopQuery = `
              {
              shop {
                id
                name
                createdAt
                updatedAt
                shopOwnerName
                email
                plan {
                  displayName
                  partnerDevelopment
                  shopifyPlus
                }
              }
            }
          `;
      const shopResponse = await admin.graphql(shopQuery);
      const shopData = await shopResponse.json();
      user = await prisma.users.create({
        data: {
          ownername: shopData.data.shop.shopOwnerName,
          email: shopData.data.shop.email,
          password: "",
          avatar_url: "",
          shopurl: session.shop,
          token: session.accessToken,
          status: "active",
          catalogfetched: 0,
          shopifyimported: 0,
          tempcode: "",
          usermsg: "",
          review: 0,
          discount: 0,
          installationstatus: 1,
          membershiptype: "free",
          plan: 0,
          sync: 0,
          storecreated_at: /* @__PURE__ */ new Date(),
          storeupdated_at: /* @__PURE__ */ new Date(),
          created_at: /* @__PURE__ */ new Date(),
          updated_at: /* @__PURE__ */ new Date(),
          plan_name: "Free",
          skulimit: 5,
          skuconsumed: 0,
          tosaccepted: 0,
          publishstatus: 0,
          keysemail: 0,
          wmfetched: false,
          ebfetched: false,
          fbainvnt: 0,
          includeoutofstock: 0,
          includesaleprice: false,
          ebtoken: false
        }
      });
      localStorage.setItem("setup", "first");
      console.log("now step is first");
    } else {
      await prisma.users.update({
        where: { id: user.id },
        data: {
          token: session.accessToken,
          installationstatus: 1
        }
      });
      console.log("User token updated for existing user:", user.id);
      localStorage.setItem("setup", user.setup_step);
    }
  } catch (error) {
    console.error("Error handling user data for", session.shop, error);
  }
};
ApiVersion.January25;
const addDocumentResponseHeaders = shopify$1.addDocumentResponseHeaders;
const authenticate = shopify$1.authenticate;
shopify$1.unauthenticated;
const login = shopify$1.login;
shopify$1.registerWebhooks;
shopify$1.sessionStorage;
const streamTimeout = 5e3;
async function handleRequest(request, responseStatusCode, responseHeaders, remixContext) {
  addDocumentResponseHeaders(request, responseHeaders);
  const userAgent = request.headers.get("user-agent");
  const callbackName = isbot(userAgent ?? "") ? "onAllReady" : "onShellReady";
  return new Promise((resolve, reject) => {
    const { pipe, abort } = renderToPipeableStream(
      /* @__PURE__ */ jsx(RemixServer, { context: remixContext, url: request.url }),
      {
        [callbackName]: () => {
          const body = new PassThrough();
          const stream = createReadableStreamFromReadable(body);
          responseHeaders.set("Content-Type", "text/html");
          resolve(
            new Response(stream, {
              headers: responseHeaders,
              status: responseStatusCode
            })
          );
          pipe(body);
        },
        onShellError(error) {
          reject(error);
        },
        onError(error) {
          responseStatusCode = 500;
          console.error(error);
        }
      }
    );
    setTimeout(abort, streamTimeout + 1e3);
  });
}
const entryServer = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: handleRequest,
  streamTimeout
}, Symbol.toStringTag, { value: "Module" }));
function App$2() {
  return /* @__PURE__ */ jsxs("html", { children: [
    /* @__PURE__ */ jsxs("head", { children: [
      /* @__PURE__ */ jsx("meta", { charSet: "utf-8" }),
      /* @__PURE__ */ jsx("meta", { name: "viewport", content: "width=device-width,initial-scale=1" }),
      /* @__PURE__ */ jsx("link", { rel: "preconnect", href: "https://cdn.shopify.com/" }),
      /* @__PURE__ */ jsx(
        "link",
        {
          rel: "stylesheet",
          href: "https://cdn.shopify.com/static/fonts/inter/v4/styles.css"
        }
      ),
      /* @__PURE__ */ jsx(Meta, {}),
      /* @__PURE__ */ jsx(Links, {})
    ] }),
    /* @__PURE__ */ jsxs("body", { children: [
      /* @__PURE__ */ jsx(Outlet, {}),
      /* @__PURE__ */ jsx(ScrollRestoration, {}),
      /* @__PURE__ */ jsx(Scripts, {})
    ] })
  ] });
}
const route0 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: App$2
}, Symbol.toStringTag, { value: "Module" }));
const action$6 = async ({ request }) => {
  const { payload, session, topic, shop } = await authenticate.webhook(request);
  console.log(`Received ${topic} webhook for ${shop}`);
  const current = payload.current;
  if (session) {
    await prisma.session.update({
      where: {
        id: session.id
      },
      data: {
        scope: current.toString()
      }
    });
  }
  return new Response();
};
const route1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$6
}, Symbol.toStringTag, { value: "Module" }));
const action$5 = async ({ request }) => {
  const { shop, session, topic } = await authenticate.webhook(request);
  console.log(`Received ${topic} webhook for ${shop}`);
  if (session) {
    await prisma.session.deleteMany({ where: { shop } });
  }
  return new Response();
};
const route2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$5
}, Symbol.toStringTag, { value: "Module" }));
const loader$i = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userIdRaw = url.searchParams.get("userId");
    const userId = parseInt(userIdRaw, 10);
    if (!userIdRaw || Number.isNaN(userId)) {
      return json({ error: "Invalid or missing userId" }, { status: 400 });
    }
    const existingRequest = await prisma.amz_reportrequests.findFirst({
      where: {
        user_id: userId,
        status: { not: "readyforshopify" }
        // <-- fixed syntax
      },
      orderBy: { created_at: "desc" }
    });
    if (existingRequest) {
      return json(
        { msg: "A fetch request is already pending." },
        { status: 202 }
        // conflict
      );
    }
    await prisma.amz_reportrequests.create({
      data: {
        user_id: userId,
        status: "pending",
        requestid: "",
        // placeholder, to be updated later
        reportid: "",
        // placeholder, to be updated later
        inprocess: false,
        reporttype: "_GET_MERCHANT_LISTINGS_DATA_"
      }
    });
    return json(
      { msg: "Product fetch request submitted successfully." },
      { status: 201 }
    );
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route3 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$i
}, Symbol.toStringTag, { value: "Module" }));
const loader$h = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("userId"));
    const [all, ready_to_import, imported, import_in_progress] = await Promise.all([
      prisma.products.count({ where: { user_id: userId } }),
      prisma.products.count({ where: { status: "Ready_to_Import", user_id: userId } }),
      prisma.products.count({ where: { status: "Imported", user_id: userId } }),
      prisma.products.count({ where: { status: "Import_in_progress", user_id: userId } })
    ]);
    const amzRequest = await prisma.amz_reportrequests.findFirst({
      where: {
        user_id: userId
      },
      orderBy: {
        id: "desc"
      }
    });
    return json({
      countsByStatus: {
        all,
        ready_to_import,
        imported,
        import_in_progress
      },
      amzRequest
    });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route4 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$h
}, Symbol.toStringTag, { value: "Module" }));
const action$4 = async ({ request }) => {
  try {
    const body = await request.json();
    const { product_id } = body;
    if (!product_id) {
      return json({ success: false, message: "product_id is required" }, { status: 400 });
    }
    const variants = await prisma.product_variants.findMany({
      where: { product_id },
      select: {
        id: true,
        price: true,
        sku: true,
        quantity: true,
        option1val: true,
        option2val: true,
        option3val: true
      }
    });
    console.log("variantss: ", variants);
    return json({ success: true, data: variants });
  } catch (error) {
    console.error("Fetch variants error:", error);
    return json({ success: false, message: error.message }, { status: 500 });
  }
};
const route5 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$4
}, Symbol.toStringTag, { value: "Module" }));
const loader$g = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userIdRaw = url.searchParams.get("userId");
    const productIdRaw = url.searchParams.get("productId") || "";
    const userId = parseInt(userIdRaw, 10);
    if (!userIdRaw || Number.isNaN(userId)) {
      return json({ error: "Invalid or missing userId" }, { status: 400 });
    }
    const productIdArray = productIdRaw.split(",").map((s) => s.trim()).filter((s) => s !== "");
    const productIdInts = productIdArray.map((s) => {
      const n = parseInt(s, 10);
      return Number.isNaN(n) ? null : n;
    }).filter((n) => n !== null);
    if (productIdInts.length === 0) {
      return json({ error: "No valid product IDs provided" }, { status: 400 });
    }
    const user = await prisma.users.findUnique({
      where: { id: userId },
      select: { id: true, skuconsumed: true, skulimit: true }
    });
    if (!user) {
      return json({ error: "User not found" }, { status: 404 });
    }
    const updatedProducts = await prisma.products.updateMany({
      where: {
        user_id: userId,
        product_id: { in: productIdInts }
      },
      data: {
        block: false
      }
    });
    return json({ message: "Products unblocked successfully", updatedCount: updatedProducts.count });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route6 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$g
}, Symbol.toStringTag, { value: "Module" }));
const loader$f = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userIdRaw = url.searchParams.get("userId");
    const productIdRaw = url.searchParams.get("productId") || "";
    const userId = parseInt(userIdRaw, 10);
    if (!userIdRaw || Number.isNaN(userId)) {
      return json({ error: "Invalid or missing userId" }, { status: 400 });
    }
    const productIdArray = productIdRaw.split(",").map((s) => s.trim()).filter((s) => s !== "");
    const productIdInts = productIdArray.map((s) => {
      const n = parseInt(s, 10);
      return Number.isNaN(n) ? null : n;
    }).filter((n) => n !== null);
    if (productIdInts.length === 0) {
      return json({ error: "No valid product IDs provided" }, { status: 400 });
    }
    const user = await prisma.users.findUnique({
      where: { id: userId },
      select: { id: true, skuconsumed: true, skulimit: true }
    });
    if (!user) {
      return json({ error: "User not found" }, { status: 404 });
    }
    const updatedProducts = await prisma.products.updateMany({
      where: {
        user_id: userId,
        product_id: { in: productIdInts }
      },
      data: {
        block: true
      }
    });
    return json({ message: "Products blocked successfully", updatedCount: updatedProducts.count });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route7 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$f
}, Symbol.toStringTag, { value: "Module" }));
const loader$e = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("user_id"));
    const [all, ready_to_import, imported, import_in_progress] = await Promise.all([
      prisma.products.count({ where: { user_id: userId } }),
      prisma.products.count({ where: { status: "Ready_to_Import", user_id: userId } }),
      prisma.products.count({ where: { status: "Imported", user_id: userId } }),
      prisma.products.count({ where: { status: "Import_in_progress", user_id: userId } })
    ]);
    return json({
      countsByStatus: {
        all,
        ready_to_import,
        imported,
        import_in_progress
      }
    });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route8 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$e
}, Symbol.toStringTag, { value: "Module" }));
const action$3 = async ({ request }) => {
  try {
    const body = await request.json();
    const { data, userId } = body;
    let inventory_sync = false;
    let price_sync = false;
    console.log("data    ", data);
    switch (data[0]) {
      case "priceOnly":
        price_sync = true;
        break;
      case "inventoryOnly":
        inventory_sync = true;
        break;
      case "syncBoth":
        inventory_sync = true;
        price_sync = true;
        break;
      case "none":
      default:
        break;
    }
    const existingSetting = await prisma.settings.findFirst({
      where: { user_id: userId }
    });
    if (!existingSetting) {
      await prisma.settings.create({
        data: {
          user_id: userId,
          fulfilment_service: "manual",
          inventory_policy: "continue",
          shopifylocationid: "",
          product_import: false,
          includeoutofstock: false,
          inventory_sync,
          price_sync,
          published: true
        }
      });
    } else {
      await prisma.settings.update({
        where: { user_id: userId, id: existingSetting.id },
        data: {
          inventory_sync,
          price_sync
        }
      });
    }
    await prisma.users.update({
      where: { id: userId },
      data: {
        setup_step: "Done"
      }
    });
    return json({ msg: "Setting Updated", success: true });
  } catch (error) {
    console.error("Error updating settings:", error);
    return json(
      { msg: "Setting Not Updated", success: false },
      { status: 500 }
    );
  }
};
const route9 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$3
}, Symbol.toStringTag, { value: "Module" }));
const loader$d = async ({ request }) => {
  console.log(request);
  const url = new URL(request.url);
  const userId = parseInt(url.searchParams.get("userId"), 10);
  if (isNaN(userId)) {
    return json({ error: "Invalid product ID" }, { status: 400 });
  }
  const user = await prisma.users.update({
    where: {
      id: userId
    },
    data: {
      welcome_tour: true
    }
  });
  return json({ user }, { status: 202 });
};
const route10 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$d
}, Symbol.toStringTag, { value: "Module" }));
const loader$c = async ({ request }) => {
  const url = new URL(request.url);
  const userId = Number(url.searchParams.get("user_id"));
  const status = url.searchParams.get("status");
  const query = url.searchParams.get("query") ?? "";
  const order = url.searchParams.get("orderBy") ?? "";
  const parPage = Number(url.searchParams.get("parPage")) || 20;
  const page = Math.max(Number(url.searchParams.get("page")) || 1, 1);
  const skip = parPage * (page - 1);
  const keywords = query ? query.split(/\s+/).filter(Boolean) : [];
  let orderByTitle = false;
  let orderDirection = "desc";
  if (order === "Title asc" || order === "Title desc") {
    orderByTitle = true;
    orderDirection = order === "Title asc" ? "asc" : "desc";
  } else if (order === "Product asc" || order === "Product desc") {
    orderDirection = order === "Product asc" ? "asc" : "desc";
  }
  const statusMap = {
    "already exist": "Already_Exist",
    "ready to import": "Ready_to_Import",
    "import in progress": "Import_in_progress",
    "imported": "Imported",
    "error": "error",
    "reimport in progress": "reimport_in_progress",
    "linked": "linked"
  };
  const normalizedStatus = status == null ? void 0 : status.toLowerCase();
  const prismaStatus = normalizedStatus && normalizedStatus !== "all" ? statusMap[normalizedStatus] : void 0;
  const where = {
    user_id: userId,
    ...prismaStatus && { status: prismaStatus },
    ...keywords.length && {
      AND: keywords.map((word) => ({
        title: { contains: word.trim() }
      }))
    }
  };
  const totalCount = await prisma.products.count({ where });
  const totalProduct = await prisma.products.count({
    where: { user_id: userId }
  });
  const products = await prisma.products.findMany({
    where,
    select: {
      product_id: true,
      title: true,
      block: true,
      status: true
    },
    skip,
    take: parPage,
    orderBy: orderByTitle ? { title: orderDirection } : { created_at: orderDirection }
  });
  const productIds = products.map((p) => p.product_id);
  const variants = await prisma.product_variants.findMany({
    where: { product_id: { in: productIds } },
    select: {
      id: true,
      product_id: true,
      price: true,
      asin: true,
      sku: true,
      quantity: true,
      option1val: true,
      option2val: true,
      option3val: true
    }
  });
  const asins = [
    ...new Set(variants.map((v) => v.asin).filter((a) => a != null && a !== ""))
  ];
  const images = asins.length ? await prisma.pc_images.findMany({
    where: { asin: { in: asins } },
    select: {
      asin: true,
      imageArr: true
      // assuming this is an array of image URLs
    }
  }) : [];
  const productsWithData = products.map((p) => {
    var _a2;
    const productVariants = variants.filter((v) => v.product_id === p.product_id);
    const firstVariant = productVariants.length ? productVariants : [];
    const variantAsin = ((_a2 = firstVariant[0]) == null ? void 0 : _a2.asin) ?? null;
    const matchedImages = images.find((img) => img.asin === variantAsin);
    const firstImage = Array.isArray(matchedImages == null ? void 0 : matchedImages.imageArr) && matchedImages.imageArr.length ? matchedImages.imageArr[0] : (matchedImages == null ? void 0 : matchedImages.imageArr) ?? null;
    return {
      ...p,
      variant: firstVariant,
      firstImage
      // single image URL (or null)
    };
  });
  return json({ productsWithData, totalCount, totalProduct });
};
const route11 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$c
}, Symbol.toStringTag, { value: "Module" }));
const action$2 = async ({ request }) => {
  try {
    const { session } = await authenticate.admin(request);
    const body = await request.json();
    console.log("Session:", session == null ? void 0 : session.shop);
    console.log("Received Bodyyy:", body);
    const user = await prisma.users.findFirst({
      where: { shopurl: session.shop }
    });
    if (!user) {
      return json({ success: false, message: "User not found" }, { status: 404 });
    }
    if (body.userId && !body.data) {
      const settings = await prisma.settings.findFirst({
        where: { user_id: Number(body.userId) }
      });
      if (!settings) {
        return json({ success: false, message: "No settings found", data: null });
      }
      return json({ success: true, message: "Settings found", data: settings });
    }
    if (body.data) {
      const d = body.data;
      const payload = {
        published: d.productSetting === "Active",
        fulfilment_service: d.fulfillmentService,
        inventory_policy: d.inventoryPolicy,
        inventory_sync: d.inSynchronization === "Enable",
        price_sync: d.prSynchronization === "Enable",
        autoimport: d.autoImport === "Enable",
        product_import: true,
        includeoutofstock: false,
        shopifylocationid: ""
      };
      console.log("Prepared payload for DB:", payload);
      const existing = await prisma.settings.findFirst({
        where: { user_id: user.id }
      });
      let result;
      if (existing) {
        result = await prisma.settings.update({
          where: { id: existing.id },
          data: payload
        });
        console.log("Settings updated:", result);
        return json({ success: true, message: "Settings updated", data: result });
      } else {
        result = await prisma.settings.create({
          data: {
            ...payload,
            user_id: user.id
          }
        });
        console.log("Settings created:", result);
        return json({ success: true, message: "Settings created", data: result });
      }
    }
    return json({ success: false, message: "Invalid request" }, { status: 400 });
  } catch (error) {
    console.error("Settings Action Error:", error);
    return json(
      { success: false, message: "Server error", error: String(error) },
      { status: 500 }
    );
  }
};
const route12 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$2
}, Symbol.toStringTag, { value: "Module" }));
const loader$b = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userIdRaw = url.searchParams.get("userId");
    const userId = parseInt(userIdRaw, 10);
    if (!userIdRaw || Number.isNaN(userId)) {
      return json({ error: "Invalid or missing userId" }, { status: 400 });
    }
    const user = await prisma.users.findUnique({
      where: { id: userId },
      select: { id: true, skuconsumed: true, skulimit: true }
    });
    if (!user) {
      return json({ error: "User not found" }, { status: 404 });
    }
    const countOfProduct = await prisma.products.count({
      where: { user_id: userId, status: "Ready_to_Import" }
    });
    const maxAllowedConsumed = user.skulimit - countOfProduct + user.skuconsumed;
    if (maxAllowedConsumed < 0) {
      return json(
        { msg: "Requested import count exceeds your total SKU limit." },
        { status: 403 }
      );
    }
    const updatedUsers = await prisma.users.update({
      where: {
        id: userId
      },
      data: {
        skuconsumed: { increment: countOfProduct }
      }
    });
    if (updatedUsers.count === 0) {
      return json(
        {
          msg: "You have reached your import limit. Please upgrade your plan to import more products."
        },
        { status: 403 }
      );
    }
    const updateProducts = await prisma.products.updateMany({
      where: {
        user_id: userId,
        status: "Ready_to_Import",
        block: false
      },
      data: {
        status: "Import_in_progress"
      }
    });
    if (updateProducts.count === 0) {
      return json(
        {
          success: false,
          message: "No products for import were found.",
          productsUpdated: updateProducts.count
        },
        { status: 404 }
      );
    }
    return json({
      success: true,
      message: "Products import initiated successfully.",
      productsUpdated: updateProducts.count
    });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route13 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$b
}, Symbol.toStringTag, { value: "Module" }));
const Polaris = /* @__PURE__ */ JSON.parse('{"ActionMenu":{"Actions":{"moreActions":"More actions"},"RollupActions":{"rollupButton":"View actions"}},"ActionList":{"SearchField":{"clearButtonLabel":"Clear","search":"Search","placeholder":"Search actions"}},"Avatar":{"label":"Avatar","labelWithInitials":"Avatar with initials {initials}"},"Autocomplete":{"spinnerAccessibilityLabel":"Loading","ellipsis":"{content}…"},"Badge":{"PROGRESS_LABELS":{"incomplete":"Incomplete","partiallyComplete":"Partially complete","complete":"Complete"},"TONE_LABELS":{"info":"Info","success":"Success","warning":"Warning","critical":"Critical","attention":"Attention","new":"New","readOnly":"Read-only","enabled":"Enabled"},"progressAndTone":"{toneLabel} {progressLabel}"},"Banner":{"dismissButton":"Dismiss notification"},"Button":{"spinnerAccessibilityLabel":"Loading"},"Common":{"checkbox":"checkbox","undo":"Undo","cancel":"Cancel","clear":"Clear","close":"Close","submit":"Submit","more":"More"},"ContextualSaveBar":{"save":"Save","discard":"Discard"},"DataTable":{"sortAccessibilityLabel":"sort {direction} by","navAccessibilityLabel":"Scroll table {direction} one column","totalsRowHeading":"Totals","totalRowHeading":"Total"},"DatePicker":{"previousMonth":"Show previous month, {previousMonthName} {showPreviousYear}","nextMonth":"Show next month, {nextMonth} {nextYear}","today":"Today ","start":"Start of range","end":"End of range","months":{"january":"January","february":"February","march":"March","april":"April","may":"May","june":"June","july":"July","august":"August","september":"September","october":"October","november":"November","december":"December"},"days":{"monday":"Monday","tuesday":"Tuesday","wednesday":"Wednesday","thursday":"Thursday","friday":"Friday","saturday":"Saturday","sunday":"Sunday"},"daysAbbreviated":{"monday":"Mo","tuesday":"Tu","wednesday":"We","thursday":"Th","friday":"Fr","saturday":"Sa","sunday":"Su"}},"DiscardConfirmationModal":{"title":"Discard all unsaved changes","message":"If you discard changes, you’ll delete any edits you made since you last saved.","primaryAction":"Discard changes","secondaryAction":"Continue editing"},"DropZone":{"single":{"overlayTextFile":"Drop file to upload","overlayTextImage":"Drop image to upload","overlayTextVideo":"Drop video to upload","actionTitleFile":"Add file","actionTitleImage":"Add image","actionTitleVideo":"Add video","actionHintFile":"or drop file to upload","actionHintImage":"or drop image to upload","actionHintVideo":"or drop video to upload","labelFile":"Upload file","labelImage":"Upload image","labelVideo":"Upload video"},"allowMultiple":{"overlayTextFile":"Drop files to upload","overlayTextImage":"Drop images to upload","overlayTextVideo":"Drop videos to upload","actionTitleFile":"Add files","actionTitleImage":"Add images","actionTitleVideo":"Add videos","actionHintFile":"or drop files to upload","actionHintImage":"or drop images to upload","actionHintVideo":"or drop videos to upload","labelFile":"Upload files","labelImage":"Upload images","labelVideo":"Upload videos"},"errorOverlayTextFile":"File type is not valid","errorOverlayTextImage":"Image type is not valid","errorOverlayTextVideo":"Video type is not valid"},"EmptySearchResult":{"altText":"Empty search results"},"Frame":{"skipToContent":"Skip to content","navigationLabel":"Navigation","Navigation":{"closeMobileNavigationLabel":"Close navigation"}},"FullscreenBar":{"back":"Back","accessibilityLabel":"Exit fullscreen mode"},"Filters":{"moreFilters":"More filters","moreFiltersWithCount":"More filters ({count})","filter":"Filter {resourceName}","noFiltersApplied":"No filters applied","cancel":"Cancel","done":"Done","clearAllFilters":"Clear all filters","clear":"Clear","clearLabel":"Clear {filterName}","addFilter":"Add filter","clearFilters":"Clear all","searchInView":"in:{viewName}"},"FilterPill":{"clear":"Clear","unsavedChanges":"Unsaved changes - {label}"},"IndexFilters":{"searchFilterTooltip":"Search and filter","searchFilterTooltipWithShortcut":"Search and filter (F)","searchFilterAccessibilityLabel":"Search and filter results","sort":"Sort your results","addView":"Add a new view","newView":"Custom search","SortButton":{"ariaLabel":"Sort the results","tooltip":"Sort","title":"Sort by","sorting":{"asc":"Ascending","desc":"Descending","az":"A-Z","za":"Z-A"}},"EditColumnsButton":{"tooltip":"Edit columns","accessibilityLabel":"Customize table column order and visibility"},"UpdateButtons":{"cancel":"Cancel","update":"Update","save":"Save","saveAs":"Save as","modal":{"title":"Save view as","label":"Name","sameName":"A view with this name already exists. Please choose a different name.","save":"Save","cancel":"Cancel"}}},"IndexProvider":{"defaultItemSingular":"Item","defaultItemPlural":"Items","allItemsSelected":"All {itemsLength}+ {resourceNamePlural} are selected","selected":"{selectedItemsCount} selected","a11yCheckboxDeselectAllSingle":"Deselect {resourceNameSingular}","a11yCheckboxSelectAllSingle":"Select {resourceNameSingular}","a11yCheckboxDeselectAllMultiple":"Deselect all {itemsLength} {resourceNamePlural}","a11yCheckboxSelectAllMultiple":"Select all {itemsLength} {resourceNamePlural}"},"IndexTable":{"emptySearchTitle":"No {resourceNamePlural} found","emptySearchDescription":"Try changing the filters or search term","onboardingBadgeText":"New","resourceLoadingAccessibilityLabel":"Loading {resourceNamePlural}…","selectAllLabel":"Select all {resourceNamePlural}","selected":"{selectedItemsCount} selected","undo":"Undo","selectAllItems":"Select all {itemsLength}+ {resourceNamePlural}","selectItem":"Select {resourceName}","selectButtonText":"Select","sortAccessibilityLabel":"sort {direction} by"},"Loading":{"label":"Page loading bar"},"Modal":{"iFrameTitle":"body markup","modalWarning":"These required properties are missing from Modal: {missingProps}"},"Page":{"Header":{"rollupActionsLabel":"View actions for {title}","pageReadyAccessibilityLabel":"{title}. This page is ready"}},"Pagination":{"previous":"Previous","next":"Next","pagination":"Pagination"},"ProgressBar":{"negativeWarningMessage":"Values passed to the progress prop shouldn’t be negative. Resetting {progress} to 0.","exceedWarningMessage":"Values passed to the progress prop shouldn’t exceed 100. Setting {progress} to 100."},"ResourceList":{"sortingLabel":"Sort by","defaultItemSingular":"item","defaultItemPlural":"items","showing":"Showing {itemsCount} {resource}","showingTotalCount":"Showing {itemsCount} of {totalItemsCount} {resource}","loading":"Loading {resource}","selected":"{selectedItemsCount} selected","allItemsSelected":"All {itemsLength}+ {resourceNamePlural} in your store are selected","allFilteredItemsSelected":"All {itemsLength}+ {resourceNamePlural} in this filter are selected","selectAllItems":"Select all {itemsLength}+ {resourceNamePlural} in your store","selectAllFilteredItems":"Select all {itemsLength}+ {resourceNamePlural} in this filter","emptySearchResultTitle":"No {resourceNamePlural} found","emptySearchResultDescription":"Try changing the filters or search term","selectButtonText":"Select","a11yCheckboxDeselectAllSingle":"Deselect {resourceNameSingular}","a11yCheckboxSelectAllSingle":"Select {resourceNameSingular}","a11yCheckboxDeselectAllMultiple":"Deselect all {itemsLength} {resourceNamePlural}","a11yCheckboxSelectAllMultiple":"Select all {itemsLength} {resourceNamePlural}","Item":{"actionsDropdownLabel":"Actions for {accessibilityLabel}","actionsDropdown":"Actions dropdown","viewItem":"View details for {itemName}"},"BulkActions":{"actionsActivatorLabel":"Actions","moreActionsActivatorLabel":"More actions"}},"SkeletonPage":{"loadingLabel":"Page loading"},"Tabs":{"newViewAccessibilityLabel":"Create new view","newViewTooltip":"Create view","toggleTabsLabel":"More views","Tab":{"rename":"Rename view","duplicate":"Duplicate view","edit":"Edit view","editColumns":"Edit columns","delete":"Delete view","copy":"Copy of {name}","deleteModal":{"title":"Delete view?","description":"This can’t be undone. {viewName} view will no longer be available in your admin.","cancel":"Cancel","delete":"Delete view"}},"RenameModal":{"title":"Rename view","label":"Name","cancel":"Cancel","create":"Save","errors":{"sameName":"A view with this name already exists. Please choose a different name."}},"DuplicateModal":{"title":"Duplicate view","label":"Name","cancel":"Cancel","create":"Create view","errors":{"sameName":"A view with this name already exists. Please choose a different name."}},"CreateViewModal":{"title":"Create new view","label":"Name","cancel":"Cancel","create":"Create view","errors":{"sameName":"A view with this name already exists. Please choose a different name."}}},"Tag":{"ariaLabel":"Remove {children}"},"TextField":{"characterCount":"{count} characters","characterCountWithMaxLength":"{count} of {limit} characters used"},"TooltipOverlay":{"accessibilityLabel":"Tooltip: {label}"},"TopBar":{"toggleMenuLabel":"Toggle menu","SearchField":{"clearButtonLabel":"Clear","search":"Search"}},"MediaCard":{"dismissButton":"Dismiss","popoverButton":"Actions"},"VideoThumbnail":{"playButtonA11yLabel":{"default":"Play video","defaultWithDuration":"Play video of length {duration}","duration":{"hours":{"other":{"only":"{hourCount} hours","andMinutes":"{hourCount} hours and {minuteCount} minutes","andMinute":"{hourCount} hours and {minuteCount} minute","minutesAndSeconds":"{hourCount} hours, {minuteCount} minutes, and {secondCount} seconds","minutesAndSecond":"{hourCount} hours, {minuteCount} minutes, and {secondCount} second","minuteAndSeconds":"{hourCount} hours, {minuteCount} minute, and {secondCount} seconds","minuteAndSecond":"{hourCount} hours, {minuteCount} minute, and {secondCount} second","andSeconds":"{hourCount} hours and {secondCount} seconds","andSecond":"{hourCount} hours and {secondCount} second"},"one":{"only":"{hourCount} hour","andMinutes":"{hourCount} hour and {minuteCount} minutes","andMinute":"{hourCount} hour and {minuteCount} minute","minutesAndSeconds":"{hourCount} hour, {minuteCount} minutes, and {secondCount} seconds","minutesAndSecond":"{hourCount} hour, {minuteCount} minutes, and {secondCount} second","minuteAndSeconds":"{hourCount} hour, {minuteCount} minute, and {secondCount} seconds","minuteAndSecond":"{hourCount} hour, {minuteCount} minute, and {secondCount} second","andSeconds":"{hourCount} hour and {secondCount} seconds","andSecond":"{hourCount} hour and {secondCount} second"}},"minutes":{"other":{"only":"{minuteCount} minutes","andSeconds":"{minuteCount} minutes and {secondCount} seconds","andSecond":"{minuteCount} minutes and {secondCount} second"},"one":{"only":"{minuteCount} minute","andSeconds":"{minuteCount} minute and {secondCount} seconds","andSecond":"{minuteCount} minute and {secondCount} second"}},"seconds":{"other":"{secondCount} seconds","one":"{secondCount} second"}}}}}');
const polarisTranslations = {
  Polaris
};
const polarisStyles = "/assets/styles-CV7GIAUv.css";
function loginErrorMessage(loginErrors) {
  if ((loginErrors == null ? void 0 : loginErrors.shop) === LoginErrorType.MissingShop) {
    return { shop: "Please enter your shop domain to log in" };
  } else if ((loginErrors == null ? void 0 : loginErrors.shop) === LoginErrorType.InvalidShop) {
    return { shop: "Please enter a valid shop domain to log in" };
  }
  return {};
}
const links$1 = () => [{ rel: "stylesheet", href: polarisStyles }];
const loader$a = async ({ request }) => {
  const errors = loginErrorMessage(await login(request));
  return { errors, polarisTranslations };
};
const action$1 = async ({ request }) => {
  const errors = loginErrorMessage(await login(request));
  return {
    errors
  };
};
function Auth() {
  const loaderData = useLoaderData();
  const actionData = useActionData();
  const [shop, setShop] = useState("");
  const { errors } = actionData || loaderData;
  return /* @__PURE__ */ jsx(AppProvider, { i18n: loaderData.polarisTranslations, children: /* @__PURE__ */ jsx(Page, { children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(Form, { method: "post", children: /* @__PURE__ */ jsxs(FormLayout, { children: [
    /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h2", children: "Log in" }),
    /* @__PURE__ */ jsx(
      TextField,
      {
        type: "text",
        name: "shop",
        label: "Shop domain",
        helpText: "example.myshopify.com",
        value: shop,
        onChange: setShop,
        autoComplete: "on",
        error: errors.shop
      }
    ),
    /* @__PURE__ */ jsx(Button, { submit: true, children: "Log in" })
  ] }) }) }) }) });
}
const route14 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$1,
  default: Auth,
  links: links$1,
  loader: loader$a
}, Symbol.toStringTag, { value: "Module" }));
const loader$9 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  console.log(session);
  const user = await prisma.users.findFirst({
    where: {
      shopurl: session.shop
    }
  });
  return json({ plan: user.plan });
};
const action = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  const body = await request.json();
  const { plan, userId } = body;
  console.log(userId);
  await prisma.users.update({
    where: { id: userId },
    data: { plan }
  });
  return json({ success: true, plan });
};
const route15 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action,
  loader: loader$9
}, Symbol.toStringTag, { value: "Module" }));
const loader$8 = async ({ request }) => {
  try {
    const url = new URL(request.url);
    const userIdRaw = url.searchParams.get("userId");
    const productIdRaw = url.searchParams.get("productId") || "";
    const userId = parseInt(userIdRaw, 10);
    if (!userIdRaw || Number.isNaN(userId)) {
      return json({ error: "Invalid or missing userId" }, { status: 400 });
    }
    const productIdArray = productIdRaw.split(",").map((s) => s.trim()).filter((s) => s !== "");
    const productIdInts = productIdArray.map((s) => {
      const n = parseInt(s, 10);
      return Number.isNaN(n) ? null : n;
    }).filter((n) => n !== null);
    if (productIdInts.length === 0) {
      return json({ error: "No valid product IDs provided" }, { status: 400 });
    }
    const user = await prisma.users.findUnique({
      where: { id: userId },
      select: { id: true, skuconsumed: true, skulimit: true }
    });
    if (!user) {
      return json({ error: "User not found" }, { status: 404 });
    }
    const countToConsume = productIdInts.length;
    const maxAllowedConsumed = user.skulimit - countToConsume;
    if (maxAllowedConsumed < 0) {
      return json(
        { msg: "Requested import count exceeds your total SKU limit." },
        { status: 403 }
      );
    }
    const updatedUsers = await prisma.users.updateMany({
      where: {
        id: userId
      },
      data: {
        skuconsumed: { increment: countToConsume }
      }
    });
    if (updatedUsers.count === 0) {
      return json(
        {
          msg: "You have reached your import limit. Please upgrade your plan to import more products."
        },
        { status: 403 }
      );
    }
    const updateProducts = await prisma.products.updateMany({
      where: {
        product_id: { in: productIdInts }
      },
      data: {
        status: "Import_in_progress"
      }
    });
    if (updateProducts.count === 0) {
      await prisma.users.update({
        where: { id: userId },
        data: { skuconsumed: { decrement: countToConsume } }
      });
      return json(
        {
          success: false,
          message: "No products for import were found.",
          productsRequested: productIdInts.length,
          productsUpdated: updateProducts.count
        },
        { status: 404 }
      );
    }
    return json({
      success: true,
      message: "Products import initiated successfully.",
      productsRequested: productIdInts.length,
      productsUpdated: updateProducts.count
    });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
const route16 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$8
}, Symbol.toStringTag, { value: "Module" }));
const index = "_index_1hqgz_1";
const heading = "_heading_1hqgz_21";
const text = "_text_1hqgz_23";
const content = "_content_1hqgz_43";
const form = "_form_1hqgz_53";
const label = "_label_1hqgz_69";
const input = "_input_1hqgz_85";
const button = "_button_1hqgz_93";
const list = "_list_1hqgz_101";
const styles$1 = {
  index,
  heading,
  text,
  content,
  form,
  label,
  input,
  button,
  list
};
const loader$7 = async ({ request }) => {
  const url = new URL(request.url);
  if (url.searchParams.get("shop")) {
    throw redirect(`/app?${url.searchParams.toString()}`);
  }
  return { showForm: Boolean(login) };
};
function App$1() {
  const { showForm } = useLoaderData();
  return /* @__PURE__ */ jsx("div", { className: styles$1.index, children: /* @__PURE__ */ jsxs("div", { className: styles$1.content, children: [
    /* @__PURE__ */ jsx("h1", { className: styles$1.heading, children: "A short heading about [your app]" }),
    /* @__PURE__ */ jsx("p", { className: styles$1.text, children: "A tagline about [your app] that describes your value proposition." }),
    showForm && /* @__PURE__ */ jsxs(Form, { className: styles$1.form, method: "post", action: "/auth/login", children: [
      /* @__PURE__ */ jsxs("label", { className: styles$1.label, children: [
        /* @__PURE__ */ jsx("span", { children: "Shop domain" }),
        /* @__PURE__ */ jsx("input", { className: styles$1.input, type: "text", name: "shop" }),
        /* @__PURE__ */ jsx("span", { children: "e.g: my-shop-domain.myshopify.com" })
      ] }),
      /* @__PURE__ */ jsx("button", { className: styles$1.button, type: "submit", children: "Log in" })
    ] }),
    /* @__PURE__ */ jsxs("ul", { className: styles$1.list, children: [
      /* @__PURE__ */ jsxs("li", { children: [
        /* @__PURE__ */ jsx("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] }),
      /* @__PURE__ */ jsxs("li", { children: [
        /* @__PURE__ */ jsx("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] }),
      /* @__PURE__ */ jsxs("li", { children: [
        /* @__PURE__ */ jsx("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] })
    ] })
  ] }) });
}
const route17 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: App$1,
  loader: loader$7
}, Symbol.toStringTag, { value: "Module" }));
const loader$6 = async ({ request }) => {
  await authenticate.admin(request);
  return null;
};
const route18 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$6
}, Symbol.toStringTag, { value: "Module" }));
const links = () => [{ rel: "stylesheet", href: polarisStyles }];
function sleep$1(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
const loader$5 = async ({ request }) => {
  await authenticate.admin(request);
  const { session } = await authenticate.admin(request);
  let user = await prisma.users.findFirst({
    where: { shopurl: session.shop }
  });
  if (!user) {
    await sleep$1(2e3);
    user = await prisma.users.findFirst({
      where: {
        shopurl: session.shop
      }
    });
  }
  return { apiKey: process.env.SHOPIFY_API_KEY || "", user };
};
function App() {
  const { apiKey, user } = useLoaderData();
  let route;
  if ((user == null ? void 0 : user.setup_step) == "Done") {
    route = /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(Link, { to: "/app", rel: "home", children: "Home" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/products", children: "Products" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/account", children: "Amazon Account" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/settings", children: "Settings" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/plan", children: "Plan And Pricing" }),
      /* @__PURE__ */ jsx(Link, { to: "/app/faq", children: "FAQ" })
    ] });
  }
  return /* @__PURE__ */ jsxs(AppProvider$1, { isEmbeddedApp: true, apiKey, children: [
    /* @__PURE__ */ jsx(NavMenu, { children: route }),
    /* @__PURE__ */ jsx(Outlet, {})
  ] });
}
function ErrorBoundary() {
  return boundary.error(useRouteError());
}
const route19 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  ErrorBoundary,
  default: App,
  links,
  loader: loader$5
}, Symbol.toStringTag, { value: "Module" }));
function IsMobile(breakpoint = 760) {
  const [isMobile, setIsMobile] = useState(
    typeof window !== "undefined" && window.innerWidth < breakpoint
  );
  useEffect(() => {
    function handleResize() {
      setIsMobile(window.innerWidth < breakpoint);
    }
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, [breakpoint]);
  return isMobile;
}
const loader$4 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  const user = await prisma.users.findFirst({
    where: { shopurl: session.shop }
  });
  const user_id = user == null ? void 0 : user.id;
  const amzKey = await prisma.amz_keys.findFirst({
    where: { user_id },
    select: { marketplace_id: true }
  });
  const marketplaceId = (amzKey == null ? void 0 : amzKey.marketplace_id) ?? null;
  return json({ user, marketplaceId });
};
function Products() {
  let { user } = useLoaderData();
  const navigate = useNavigate();
  const [products, setProducts] = useState([]);
  const [loading, setLoading] = useState(true);
  const [selectedTab, setSelectedTab] = useState(0);
  const [counts, setCounts] = useState({});
  const [perPageValue, setPerPageValue] = useState("20");
  const [current_page, setCurrentPage] = useState(1);
  const [productData, setproductData] = useState(false);
  const [firstProductNo, setFirstProductNo] = useState(1);
  const [lastProductNo, setLastProductNo] = useState("20");
  const [status, setStatus] = useState("All");
  const userId = user == null ? void 0 : user.id;
  const [totalItems, setTotalItems] = useState(0);
  const [totalProduct, setTotalProduct] = useState(0);
  const isMobile = IsMobile();
  const [orderBy, setOrderBy] = useState("Product desc");
  const [activeModal, setActiveModal] = useState(false);
  const [variants, setvariants] = useState([]);
  const [page, setPage] = useState(1);
  const [pageSize, setPageSize] = useState(5);
  const [pagination, setPagination] = useState({ total: 0, totalPages: 1 });
  const [sortSelected, setSortSelected] = useState(["Product desc"]);
  const [queryValue, setQueryValue] = useState("");
  const [upgradeModalActive, setUpgradeModalActive] = useState(false);
  const toggleUpgradeModal = () => setUpgradeModalActive((prev) => !prev);
  const selectable = user.plan > 0 ? true : false;
  const [selectImportIds, setSelectedImport] = useState([]);
  const [countOfProduct, setCountOfProduct] = useState({
    all: 0,
    already_exist: 0,
    ready_to_import: 0,
    import_in_progress: 0,
    imported: 0,
    error: 0,
    linked: 0
  });
  const [query, setQuery] = useState("");
  const { mode: mode2, setMode } = useSetIndexFiltersMode();
  const {
    selectedResources,
    allResourcesSelected,
    handleSelectionChange,
    removeSelectedResources
  } = useIndexResourceState(products);
  const sortOptions = [
    { label: "Product", value: "Product asc", directionLabel: "Ascending" },
    { label: "Product", value: "Product desc", directionLabel: "Descending" },
    { label: "Title", value: "Title asc", directionLabel: "Title asc" },
    { label: "Title", value: "Title desc", directionLabel: "Title desc" }
  ];
  const headerStyle = {
    padding: "10px 14px",
    textAlign: "left",
    fontWeight: 600,
    fontSize: "14px",
    color: "#202223",
    borderBottom: "1px solid #dfe3e8"
  };
  const cellStyle = {
    padding: "10px 14px",
    textAlign: "left",
    fontSize: "14px",
    color: "#3c3f41",
    borderBottom: "1px solid #dfe3e8",
    backgroundColor: "#fff"
  };
  const statusKeyMap = {
    All: "all",
    "Already Exist": "already_exist",
    "Ready To Import": "ready_to_import",
    "Import In Progress": "import_in_progress",
    Imported: "imported",
    Error: "error",
    Linked: "linked"
  };
  const [itemProducts, setItemProducts] = useState([
    `All`,
    `Ready To Import`,
    "Imported",
    "Import In Progress",
    "Already Exist"
  ]);
  const tabs = itemProducts.map((item, index2) => {
    const key = statusKeyMap[item];
    const badgeValue = key ? countOfProduct[key] ?? 0 : 0;
    return {
      content: item,
      badge: badgeValue,
      index: index2,
      onAction: () => {
      },
      id: `${item}-${index2}`,
      isLocked: index2 === 0,
      actions: index2 === 0 ? [] : []
    };
  });
  const handlePerPage = (event) => {
    setCurrentPage(1);
    setPerPageValue(event.target.value);
    setLastProductNo(event.target.value);
    fetchproduct(status, query, orderBy, event.target.value);
  };
  const getBadgeTone = (status2) => {
    switch (status2.toLowerCase()) {
      case "ready to import":
        return "info";
      case "import in progress":
      case "reimport in progress":
        return "warning";
      case "imported":
        return "success";
      case "already exist":
        return "attention";
      case "error":
        return "critical";
      case "block":
        return "warning";
      default:
        return "attention";
    }
  };
  const promotedBulkActions = [
    {
      content: `Import Selected ${selectImportIds.length} Products`,
      onAction: () => {
        handleImportRequest(selectImportIds);
      }
    },
    ...user.plan > 0 ? [
      {
        title: "Action",
        actions: [
          {
            icon: ImportIcon,
            content: "Import Selected Product",
            onAction: () => handleImportRequest(selectImportIds)
          },
          {
            icon: ImportIcon,
            content: "Import All Products",
            onAction: () => handleAllImportRequest()
          }
        ]
      }
    ] : []
  ];
  const handleFetchShopifyProductCount = async () => {
    try {
      const response = await axios.get("/api/productCount", {
        params: {
          user_id: user.id
        }
      });
      console.log("handleFetchShopifyProductCount ", response);
      if (response.data.countsByStatus) {
        setCountOfProduct(response.data.countsByStatus);
      }
    } catch (error) {
      console.log(error);
    }
  };
  useEffect(() => {
    fetchproduct("All");
  }, [user]);
  const reverseStatusMap = {
    Already_Exist: "Already Exist",
    Ready_to_Import: "Ready to Import",
    Import_in_progress: "Import in progress",
    Imported: "Imported",
    error: "error",
    linked: "Linked"
  };
  const fetchproduct = async (status2, query2, orderBy2, parPage = perPageValue, page2 = current_page) => {
    try {
      setproductData(false);
      setStatus(status2);
      let lastpage = current_page * page2 / current_page * parPage;
      setLastProductNo(lastpage);
      setFirstProductNo(lastpage - parPage + 1);
      const res = await axios.get(`/api/products/`, {
        params: {
          status: status2,
          user_id: userId,
          query: query2,
          orderBy: orderBy2,
          parPage,
          page: page2
        }
      });
      console.log("res.data -> ", res);
      handleFetchShopifyProductCount();
      const productData2 = res.data.productsWithData;
      setproductData(true);
      setTotalProduct(res.data.totalProduct);
      setTotalItems(res.data.totalCount);
      if (lastProductNo > res.data.totalCount) {
        setLastProductNo(res.data.totalCount);
      }
      const formattedProducts = productData2.map((product) => {
        console.log(product);
        let firstImage = "";
        try {
          firstImage = product.firstImage.split("|")[0] ?? "";
        } catch (e) {
          console.error(
            "Invalid JSON in product_image_data:",
            product.product_image_data
          );
        }
        console.log("product.status ->>> ", product.status);
        console.log(reverseStatusMap[product.status]);
        console.log("product?.block ->>> ", product == null ? void 0 : product.block);
        return {
          id: product.product_id,
          title: wrap(product.title, { width: 70 }),
          status: reverseStatusMap[product.status],
          block: (product == null ? void 0 : product.block) || 0,
          has_variation: product.has_variation || 0,
          shopifyproductid: product.shopifyproductid || 0,
          image: firstImage,
          variants: product.variant || [],
          variantCount: product.variant ? product.variant.length : 0
        };
      });
      setProducts(formattedProducts);
    } catch (error) {
      console.log("error while fetching products :: ", error);
    }
  };
  const handleblockproduct = async (productId) => {
    console.log("productId ->>> ", productId);
    let productIdArray = Array.isArray(productId) ? productId : [productId];
    if (productIdArray.length === 0) {
      console.error("No valid product IDs provided");
      return;
    }
    try {
      const response = await axios.get(`/api/blockProduct`, {
        params: {
          userId: user.id,
          productId: productIdArray.join(",")
        }
      });
      console.log("response ->>> ", response);
      shopify.toast.show("Product blocked successfully");
      fetchproduct(status, query, orderBy, perPageValue, current_page);
    } catch (error) {
      console.error("Error blocking product:", error);
    }
  };
  const fetchAmazonProducts = async () => {
    try {
      const response = await axios.get(`/api/fetchAmazonProducts`, {
        params: {
          userId: user.id
        }
      });
      console.log("Amazon products fetched:", response.data);
      if (response.data.msg) {
        shopify.toast.show(response.data.msg);
      }
    } catch (error) {
      console.error("Error fetching Amazon products:", error);
    }
  };
  const handleunblockproduct = async (productId) => {
    console.log("productId ->>> ", productId);
    let productIdArray = Array.isArray(productId) ? productId : [productId];
    if (productIdArray.length === 0) {
      console.error("No valid product IDs provided");
      return;
    }
    try {
      const response = await axios.get(`/api/unblockproduct`, {
        params: {
          userId: user.id,
          productId: productIdArray.join(",")
        }
      });
      console.log("response ->>> ", response);
      shopify.toast.show("Product unblocked successfully");
      fetchproduct(status, query, orderBy, perPageValue, current_page);
    } catch (error) {
      console.error("Error unblocking product:", error);
    }
  };
  const handleFiltersQueryChange = (value) => {
    console.log(value);
    setQuery(value);
    setQueryValue(value);
    fetchproduct(status, value);
  };
  const handleImportRequest = async (productId) => {
    console.log("productId ->>> ", productId);
    let productIdArray = Array.isArray(productId) ? productId : [productId];
    if (productIdArray.length === 0) {
      console.error("No valid product IDs provided");
      return;
    }
    console.log(user.skuconsumed);
    console.log(user.skulimit);
    if (user.skuconsumed + productIdArray.length > user.skulimit) {
      toggleUpgradeModal();
      return;
    }
    try {
      if (user.plan === 0) {
        setProducts(
          (prevProducts) => prevProducts.map(
            (product) => productIdArray.includes(product.id) ? { ...product, status: "Import in progress" } : product
          )
        );
        const response = await axios.get(
          `https://shopify.infoshore.biz/xpert/cronjobs/importtoshopifytrail.php`,
          {
            params: {
              user_id: user.id,
              product_id: productIdArray.join(",")
            }
          }
        );
        user.skuconsumed += productIdArray.length;
        setProducts([]);
        fetchproduct(status, query, orderBy, perPageValue, current_page);
        console.log("response ->>> ", response);
      } else {
        setProducts(
          (prevProducts) => prevProducts.map(
            (product) => productIdArray.includes(product.id) ? { ...product, status: "Import in progress" } : product
          )
        );
        const response = await axios.get(`/api/push`, {
          params: {
            userId: user.id,
            productId: productIdArray.join(",")
          }
        });
        console.log("response ->>> ", response);
        user.skuconsumed += productIdArray.length;
        removeSelectedResources(selectedResources);
        console.log(response.data);
        if (response.data.message) {
          shopify.toast.show(response.data.message);
        }
        fetchproduct(status, query, orderBy, perPageValue, current_page);
      }
    } catch (error) {
      setProducts([]);
      fetchproduct(status, query, orderBy, perPageValue, current_page);
      console.error("Error sending import request:", error);
    }
  };
  const handleAllImportRequest = async () => {
    console.log(user.skuconsumed);
    console.log(user.skulimit);
    try {
      const response = await axios.get(`/api/pushall`, {
        params: {
          userId: user.id
        }
      });
      console.log("response ->>> ", response);
      removeSelectedResources(selectedResources);
      if (response.data.message) {
        shopify.toast.show(response.data.message);
      }
      fetchproduct(status, query, orderBy, perPageValue, current_page);
    } catch (error) {
      console.error("Error sending import request:", error);
    }
  };
  const handleModalVariants = async (variant) => {
    console.log("product ->> ", variant);
    if (activeModal) {
      setActiveModal(false);
      setvariants([]);
      return;
    }
    if (variant) {
      try {
        if (variant) {
          console.log("ifffffffffff");
          setvariants(variant);
        } else {
          setvariants([]);
          console.error("Failed to load variants:");
        }
      } catch (error) {
        console.error("Error fetching variants:", error);
        setvariants([]);
      }
    } else {
      setvariants([]);
    }
    setActiveModal((prev) => !prev);
  };
  useEffect(() => {
    const userData = user;
    if (Array.isArray(selectedResources) && selectedResources.length > 0) {
      if (userData.plan === 0) {
        if (selectedResources.length > 5) ;
      }
      console.log(products);
      products.filter(
        (product) => selectedResources.includes(product.id) && product.status === "Ready to Import" && product.block === 1
      ).map((product) => product.id);
      const filteredProductIds = products.filter(
        (product) => selectedResources.includes(product.id) && product.status === "Ready to Import" && product.block === 0
      ).map((product) => product.id);
      if (userData.plan === 0) {
        if (userData.skuconsumed >= userData.skulimit) ;
        else {
          const importIds = filteredProductIds.slice(
            0,
            userData.skulimit - userData.skuconsumed
          );
          setSelectedImport(importIds);
        }
      } else {
        setSelectedImport(filteredProductIds);
      }
    }
  }, [selectedResources, products]);
  const activeTab = tabs[selectedTab];
  activeTab.status ? products.filter((p) => p.status === activeTab.status) : products;
  const resourceName = { singular: "product", plural: "products" };
  const handleSortChange = (value) => {
    setSortSelected(value);
    fetchproduct(status, query, value[0], perPageValue);
    console.log(value);
  };
  const handleCancelSearch = () => {
    setQuery("");
    console.log("handleCancelSearch");
    setQueryValue("");
    fetchproduct(status);
  };
  const rowMarkup = products.map(
    ({
      id,
      title: title2,
      status: status2,
      block,
      has_variation,
      shopifyproductid,
      image,
      variantCount,
      variants: variants2
    }, index2) => /* @__PURE__ */ jsx(
      IndexTable.Row,
      {
        id,
        selected: selectedResources.includes(id),
        position: index2,
        onClick: () => {
          console.log(id);
        },
        children: isMobile ? /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: image ? /* @__PURE__ */ jsx(
            "img",
            {
              src: image,
              alt: "iamgeProduct",
              style: { borderRadius: "5px" },
              width: "60",
              className: "iamgeProduct",
              height: "110"
            }
          ) : /* @__PURE__ */ jsx(
            FcPicture,
            {
              style: {
                width: "50px",
                height: "50px",
                color: "forestgreen"
              }
            }
          ) }),
          /* @__PURE__ */ jsxs(IndexTable.Cell, { children: [
            /* @__PURE__ */ jsx(
              Text,
              {
                variant: "bodySm",
                as: "p",
                style: { wordBreak: "break-word", whiteSpace: "normal" },
                children: title2.split("\n").map((line, idx) => /* @__PURE__ */ jsxs("span", { children: [
                  line,
                  /* @__PURE__ */ jsx("br", {})
                ] }, idx))
              }
            ),
            /* @__PURE__ */ jsxs(Link$1, { removeUnderline: true, children: [
              has_variation,
              " variants"
            ] }),
            block == 0 ? /* @__PURE__ */ jsx(Badge, { children: status2 }) : /* @__PURE__ */ jsx(Badge, { children: "Block" }),
            /* @__PURE__ */ jsx(
              "div",
              {
                style: {
                  display: "flex",
                  alignItems: "center",
                  gap: "8px",
                  marginTop: "5px",
                  flexWrap: "wrap"
                },
                children: shopifyproductid > 0 && /* @__PURE__ */ jsx(Tooltip, { content: "View on Shopify", preferredPosition: "below", children: /* @__PURE__ */ jsx(
                  "a",
                  {
                    target: "_blank",
                    rel: "noopener noreferrer",
                    onClick: (e) => e.stopPropagation(),
                    style: { display: "flex", alignItems: "center" },
                    children: /* @__PURE__ */ jsx(
                      FaShopify,
                      {
                        style: {
                          width: "28px",
                          height: "28px",
                          color: "forestgreen"
                        }
                      }
                    )
                  }
                ) })
              }
            ),
            status2 == "Ready to Import" && block == 0 && /* @__PURE__ */ jsxs(
              "div",
              {
                style: {
                  display: "flex",
                  flexWrap: "wrap",
                  gap: "8px",
                  marginTop: "10px"
                },
                children: [
                  /* @__PURE__ */ jsx(
                    Tooltip,
                    {
                      content: "Click here to import Amazon listings into your Shopify store.",
                      preferredPosition: "below",
                      children: /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "primary",
                          icon: ImportIcon,
                          style: { flex: "1 1 auto", minWidth: "140px" },
                          children: "Import On Shopify"
                        }
                      )
                    }
                  ),
                  user.plan > 0 && /* @__PURE__ */ jsx(
                    Tooltip,
                    {
                      content: "Block this product.",
                      preferredPosition: "mostSpace",
                      children: /* @__PURE__ */ jsx(Button, { style: { flex: "1 1 auto", minWidth: "100px" }, children: "Block" })
                    }
                  )
                ]
              }
            ),
            status2 == "Imported" && /* @__PURE__ */ jsx(Fragment, { children: user.plan > 0 && /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(
              "div",
              {
                style: {
                  display: "flex",
                  flexWrap: "wrap",
                  gap: "8px"
                },
                children: /* @__PURE__ */ jsx(Tooltip, { content: "Delete From Shopify", children: /* @__PURE__ */ jsx(
                  Button,
                  {
                    tone: "critical",
                    style: { flex: "1 1 auto", minWidth: "120px" },
                    children: "Delete"
                  }
                ) })
              }
            ) }) }),
            block == 1 && /* @__PURE__ */ jsx(
              Tooltip,
              {
                content: "Unblock this product.",
                preferredPosition: "mostSpace",
                children: /* @__PURE__ */ jsx(Button, { style: { marginTop: "10px" }, children: "Unblock" })
              }
            )
          ] })
        ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: image ? /* @__PURE__ */ jsx(
            "img",
            {
              src: image,
              alt: "iamgeProduct",
              style: { borderRadius: "5px" },
              width: "50",
              className: "iamgeProduct",
              height: "50"
            }
          ) : /* @__PURE__ */ jsx(
            FcPicture,
            {
              style: {
                width: "50px",
                height: "50px",
                color: "forestgreen"
              }
            }
          ) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsx(Text, { variant: "bodySm", as: "p", children: title2.split("\n").map((line, idx) => /* @__PURE__ */ jsxs("span", { children: [
            line,
            /* @__PURE__ */ jsx("br", {})
          ] }, idx)) }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: /* @__PURE__ */ jsxs(
            Link$1,
            {
              onClick: () => handleModalVariants(variants2),
              removeUnderline: true,
              children: [
                variantCount,
                " variants"
              ]
            }
          ) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: block == 0 ? /* @__PURE__ */ jsx(Badge, { tone: getBadgeTone(status2), children: status2 }) : /* @__PURE__ */ jsx(Badge, { tone: getBadgeTone("block"), children: "Block" }) }),
          /* @__PURE__ */ jsx(IndexTable.Cell, { children: shopifyproductid > 0 && /* @__PURE__ */ jsx(Tooltip, { content: "view on Shopify", preferredPosition: "below", children: /* @__PURE__ */ jsx(
            "a",
            {
              target: "_blank",
              rel: "noopener noreferrer",
              onClick: (e) => e.stopPropagation(),
              className: "shopify-link",
              children: /* @__PURE__ */ jsx(
                FaShopify,
                {
                  style: {
                    width: "40px",
                    height: "40px",
                    color: "forestgreen"
                  }
                }
              )
            }
          ) }) }),
          /* @__PURE__ */ jsxs(IndexTable.Cell, { children: [
            status2 == "Ready to Import" && block == 0 && /* @__PURE__ */ jsxs("div", { style: { display: "flex", gap: "8px" }, children: [
              /* @__PURE__ */ jsx(
                Tooltip,
                {
                  content: "Click here to import Amazon listings into your Shopify store.",
                  preferredPosition: "below",
                  children: /* @__PURE__ */ jsx(
                    Button,
                    {
                      variant: "primary",
                      icon: ImportIcon,
                      onClick: () => handleImportRequest(id),
                      children: "Import On shopify"
                    }
                  )
                }
              ),
              user.plan > 0 && /* @__PURE__ */ jsx(
                Tooltip,
                {
                  content: "Block this product.",
                  preferredPosition: "mostSpace",
                  children: /* @__PURE__ */ jsx(Button, { onClick: () => handleblockproduct(id), children: "Block" })
                }
              )
            ] }),
            status2 == "Imported" && /* @__PURE__ */ jsx(Fragment, { children: user.plan > 0 && /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx("div", { style: { display: "flex", gap: "8px" }, children: /* @__PURE__ */ jsx(Tooltip, { content: "Delete From Shopify", children: /* @__PURE__ */ jsx(Button, { tone: "critical", children: "Delete" }) }) }) }) }),
            block == 1 && /* @__PURE__ */ jsx(
              Tooltip,
              {
                content: "Unblock this product.",
                preferredPosition: "mostSpace",
                children: /* @__PURE__ */ jsx(Button, { onClick: () => handleunblockproduct(id), children: "Unblock" })
              }
            )
          ] })
        ] })
      },
      id
    )
  );
  let content2;
  if (!productData) {
    content2 = /* @__PURE__ */ jsxs(Card, { children: [
      /* @__PURE__ */ jsxs(LegacyCard, { subdued: true, children: [
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) }),
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) })
      ] }),
      /* @__PURE__ */ jsxs(LegacyCard, { subdued: true, children: [
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) }),
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) })
      ] }),
      /* @__PURE__ */ jsxs(LegacyCard, { subdued: true, children: [
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) }),
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) })
      ] }),
      /* @__PURE__ */ jsxs(LegacyCard, { subdued: true, children: [
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) }),
        /* @__PURE__ */ jsx(LegacyCard.Section, { children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 2 }) })
      ] })
    ] });
  } else if (products.length === 0) {
    if (totalProduct == 0) {
      content2 = /* @__PURE__ */ jsxs(Card, { children: [
        " ",
        /* @__PURE__ */ jsx(
          EmptyState,
          {
            heading: "Product Not Found On Amazon",
            image: "https://cdn.shopify.com/shopifycloud/web/assets/v1/vite/client/en/assets/empty-state-personalized-Bu4xlcHV0rQu.svg",
            fullWidth: true,
            children: /* @__PURE__ */ jsxs(Text, { variant: "bodyLg", as: "p", children: [
              "You currently have no products available in your",
              " ",
              /* @__PURE__ */ jsx("strong", { children: "Amazon store." }),
              " Please create a product to continue."
            ] })
          }
        )
      ] });
    } else {
      content2 = /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsx(
        EmptyState,
        {
          heading: "Product Not Found",
          image: "https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png",
          fullWidth: true
        }
      ) });
    }
  } else {
    content2 = /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(
      IndexTable,
      {
        resourceName,
        itemCount: products.length,
        selectedItemsCount: allResourcesSelected ? "All" : selectedResources.length,
        onSelectionChange: handleSelectionChange,
        headings: [
          { title: "Image" },
          { title: "Title" },
          { title: "Variations" },
          { title: "Status" },
          { title: "View On" },
          { title: "Action" }
        ],
        promotedBulkActions,
        selectable,
        children: rowMarkup
      }
    ) });
  }
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      title: "Amazon Products",
      primaryAction: {
        content: "Fetch Amazon Products",
        icon: ImportIcon,
        onAction: fetchAmazonProducts
      },
      children: [
        /* @__PURE__ */ jsx("div", { style: { marginBottom: 20 }, children: /* @__PURE__ */ jsx(
          Banner,
          {
            children: /* @__PURE__ */ jsx("p", { children: "Here you can view the products from your Amazon store and easily import them into your Shopify store." })
          }
        ) }),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: activeModal,
            onClose: handleModalVariants,
            title: "Product Variation List",
            primaryAction: {
              content: "Close",
              onAction: handleModalVariants
            },
            children: /* @__PURE__ */ jsx(Modal.Section, { children: variants.length > 0 ? /* @__PURE__ */ jsx("div", { style: { width: "100%", overflowX: "auto" }, children: /* @__PURE__ */ jsxs(
              "table",
              {
                className: "Polaris-Table",
                style: {
                  width: "100%",
                  minWidth: "600px",
                  // ensures proper layout on mobile
                  borderCollapse: "collapse",
                  marginTop: "10px"
                },
                children: [
                  /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { style: { backgroundColor: "#f6f6f7" }, children: [
                    /* @__PURE__ */ jsx("th", { style: headerStyle, children: "Option 1" }),
                    /* @__PURE__ */ jsx("th", { style: headerStyle, children: "Option 2" }),
                    /* @__PURE__ */ jsx("th", { style: headerStyle, children: "Sku" }),
                    /* @__PURE__ */ jsx("th", { style: headerStyle, children: "Quantity" }),
                    /* @__PURE__ */ jsx("th", { style: headerStyle, children: "Price" })
                  ] }) }),
                  /* @__PURE__ */ jsx("tbody", { children: variants.map((variant, index2) => /* @__PURE__ */ jsxs("tr", { children: [
                    /* @__PURE__ */ jsx("td", { style: cellStyle, children: variant.option1val }),
                    /* @__PURE__ */ jsx("td", { style: cellStyle, children: variant.option2val }),
                    /* @__PURE__ */ jsx("td", { style: cellStyle, children: variant.sku }),
                    /* @__PURE__ */ jsx("td", { style: cellStyle, children: variant.quantity }),
                    /* @__PURE__ */ jsx("td", { style: cellStyle, children: variant.price })
                  ] }, index2)) })
                ]
              }
            ) }) : /* @__PURE__ */ jsx(Text, { children: "No Variants Available" }) })
          }
        ),
        /* @__PURE__ */ jsxs(LegacyCard, { children: [
          /* @__PURE__ */ jsx(
            IndexFilters,
            {
              sortOptions,
              sortSelected,
              queryValue,
              queryPlaceholder: "Search products",
              onQueryChange: handleFiltersQueryChange,
              onQueryClear: () => setQueryValue(""),
              onSort: handleSortChange,
              primaryAction: null,
              cancelAction: {
                content: "cancel",
                onAction: handleCancelSearch
              },
              tabs,
              selected: selectedTab,
              filters: [],
              onSelect: (index2) => {
                setSelectedTab(index2);
                const selectedStatus = itemProducts[index2];
                fetchproduct(selectedStatus);
              },
              mode: mode2,
              setMode,
              canCreateNewView: false
            }
          ),
          content2
        ] }),
        /* @__PURE__ */ jsxs(
          "div",
          {
            style: {
              display: "flex",
              alignItems: "center",
              justifyContent: "space-between",
              backgroundColor: "#f6f6f7",
              padding: "10px 16px",
              borderTop: "1px solid #dfe3e8",
              borderBottom: "1px solid #dfe3e8"
            },
            children: [
              /* @__PURE__ */ jsx(
                Pagination,
                {
                  onPrevious: () => {
                    setCurrentPage(current_page - 1);
                    fetchproduct(
                      status,
                      query,
                      orderBy,
                      perPageValue,
                      current_page - 1
                    );
                  },
                  onNext: () => {
                    setCurrentPage(current_page + 1);
                    fetchproduct(
                      status,
                      query,
                      orderBy,
                      perPageValue,
                      current_page + 1
                    );
                  },
                  hasPrevious: current_page !== 1,
                  hasNext: lastProductNo < totalItems,
                  type: "table",
                  label: `${firstProductNo}-${lastProductNo} of ${totalItems} products`
                }
              ),
              /* @__PURE__ */ jsx("pre", { style: { marginLeft: "auto" }, children: "Items per page - " }),
              /* @__PURE__ */ jsxs(
                "select",
                {
                  name: "perPageSelect",
                  style: {
                    height: "32px",
                    padding: "4px 8px",
                    fontSize: "14px",
                    border: "1px solid #dfe3e8",
                    borderRadius: "4px",
                    backgroundColor: "#f6f6f7",
                    color: "#000",
                    appearance: "none",
                    backgroundImage: `url("data:image/svg+xml;utf8,<svg fill='black' height='12' viewBox='0 0 24 24' width='12' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>")`,
                    backgroundRepeat: "no-repeat",
                    backgroundPosition: "right 8px center",
                    backgroundSize: "12px",
                    paddingRight: "24px",
                    cursor: "pointer"
                  },
                  value: perPageValue,
                  onChange: handlePerPage,
                  children: [
                    /* @__PURE__ */ jsx("option", { value: "20", children: "20" }),
                    /* @__PURE__ */ jsx("option", { value: "50", children: "50" }),
                    /* @__PURE__ */ jsx("option", { value: "100", children: "100" })
                  ]
                }
              )
            ]
          }
        ),
        /* @__PURE__ */ jsx(
          Modal,
          {
            open: upgradeModalActive,
            onClose: toggleUpgradeModal,
            title: "Upgrade Required",
            primaryAction: {
              content: "Upgrade Plan",
              onAction: () => {
                navigate("/app/plan");
              }
            },
            secondaryActions: [
              {
                content: "Cancel",
                onAction: toggleUpgradeModal
              }
            ],
            children: /* @__PURE__ */ jsx(Modal.Section, { children: /* @__PURE__ */ jsx(TextContainer, { children: /* @__PURE__ */ jsx("p", { children: "You have reached your import limit. Please upgrade your plan to import more products." }) }) })
          }
        )
      ]
    }
  ) });
}
const route20 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: Products,
  loader: loader$4
}, Symbol.toStringTag, { value: "Module" }));
const loader$3 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  console.log(session);
  const user = await prisma.users.findFirst({
    where: {
      shopurl: session.shop
    }
  });
  console.log(user);
  return json({ user });
};
function Setting() {
  const { user } = useLoaderData();
  const [loading, setLoading] = useState(true);
  const [productSetting, setProductSetting] = useState("");
  const [fulfillmentService, setFulfillmentService] = useState("");
  const [inventoryPolicy, setInventoryPolicy] = useState("");
  const [inSynchronization, setInSynchronization] = useState("");
  const [prSynchronization, setPrSynchronization] = useState("");
  const [autoImport, setAutoImport] = useState("");
  const productSettingOptions = [
    { label: "Draft", value: "Draft" },
    { label: "Active", value: "Active" }
  ];
  const fulfillmentServiceOptions = [
    { label: "Manual", value: "Manual" },
    { label: "Amazon Marketplace Web", value: "Amazon Marketplace Web" }
  ];
  const inventoryPolicyOptions = [
    { label: "Don't track inventory", value: "Don't track inventory" },
    { label: "Shopify tracks this product's inventory", value: "Shopify tracks this product's inventory" }
  ];
  const inSynchronizationOptions = [
    { label: "Enable", value: "Enable" },
    { label: "Disable", value: "Disable" }
  ];
  const prSynchronizationOptions = [
    { label: "Enable", value: "Enable" },
    { label: "Disable", value: "Disable" }
  ];
  const autoImportOptions = [
    { label: "Enable", value: "Enable" },
    { label: "Disable", value: "Disable" }
  ];
  useEffect(() => {
    if (user == null ? void 0 : user.id) {
      const fetchSettings = async () => {
        try {
          const response = await fetch("/api/settings", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ userId: user.id })
          });
          const result = await response.json();
          if (result.data) {
            const s = result.data;
            console.log("settings table data : ", s);
            setProductSetting(s.published === true ? "Active" : "Draft");
            setFulfillmentService(s.fulfilment_service || "Manual");
            setInventoryPolicy(s.inventory_policy || "Don't track inventory");
            setInSynchronization(s.inventory_sync || "Disable");
            setPrSynchronization(s.price_sync || "Disable");
            setAutoImport(s.autoimport || "Disable");
          }
        } catch (err) {
          console.error("Failed to fetch settings:", err);
        } finally {
          setLoading(false);
        }
      };
      fetchSettings();
    }
  }, [user]);
  const handleSubmit = async () => {
    const payload = {
      productSetting,
      fulfillmentService,
      inventoryPolicy,
      inSynchronization,
      prSynchronization,
      autoImport
    };
    console.log("Submitting payload:", payload);
    try {
      const response = await fetch("/api/settings", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ data: payload })
      });
      const data = await response.json();
      console.log("Data is : ", data);
      if (data.success) {
        shopify.toast.show("Submitted");
      } else {
        shopify.toast.show("Error while saving");
      }
    } catch (error) {
      console.error(error);
      shopify.toast.show("Server error");
    }
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(
      Page,
      {
        title: "Settings",
        subtitle: "Configure your import and sync preferences",
        children: [
          /* @__PURE__ */ jsxs("div", { style: { padding: "20px" }, children: [
            /* @__PURE__ */ jsxs(InlineGrid, { columns: { xs: 1, sm: 1, md: 2 }, gap: "500", children: [
              loading ? /* @__PURE__ */ jsx(Card, { roundedAbove: "sm", children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 15 }) }) : /* @__PURE__ */ jsx(Card, { roundedAbove: "sm", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Product Import Settings" }),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Products should be published?",
                    onChange: setProductSetting,
                    value: productSetting,
                    options: productSettingOptions
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Fulfillment service",
                    onChange: setFulfillmentService,
                    value: fulfillmentService,
                    options: fulfillmentServiceOptions
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Inventory policy",
                    onChange: setInventoryPolicy,
                    value: inventoryPolicy,
                    options: inventoryPolicyOptions
                  }
                )
              ] }) }),
              loading ? /* @__PURE__ */ jsx(Card, { roundedAbove: "sm", children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 15 }) }) : /* @__PURE__ */ jsx(Card, { roundedAbove: "sm", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Sync Settings" }),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Inventory Synchronization",
                    onChange: setInSynchronization,
                    value: inSynchronization,
                    options: inSynchronizationOptions,
                    helpText: "Sync inventory levels between Amazon and Shopify"
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Price Synchronization",
                    onChange: setPrSynchronization,
                    value: prSynchronization,
                    options: prSynchronizationOptions,
                    helpText: "Sync prices between Amazon and Shopify"
                  }
                ),
                /* @__PURE__ */ jsx(
                  Select,
                  {
                    label: "Auto Import",
                    onChange: setAutoImport,
                    value: autoImport,
                    options: autoImportOptions,
                    helpText: "Automatically import new products"
                  }
                )
              ] }) })
            ] }),
            /* @__PURE__ */ jsx("div", { style: { marginTop: "20px" }, children: /* @__PURE__ */ jsx(Button, { fullWidth: true, variant: "primary", onClick: handleSubmit, children: "Save Settings" }) })
          ] }),
          /* @__PURE__ */ jsx("p", { style: { textAlign: "center", marginTop: "30px", color: "#666" }, children: "Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved." })
        ]
      }
    ),
    /* @__PURE__ */ jsx("style", { children: `
          {/* .settings-grid {
            grid-template-columns: repeat(2, 1fr);
          }

          @media (max-width: 768px) 
            .settings-grid {
              grid-template-columns: repeat(1, 1fr) !important;
              backgroundColor:"blue";
            }
          } */}
       ` })
  ] });
}
const route21 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: Setting,
  loader: loader$3
}, Symbol.toStringTag, { value: "Module" }));
const loader$2 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  console.log(session);
  const user = await prisma.users.findFirst({
    where: {
      shopurl: session.shop
    }
  });
  console.log(user);
  const user_id = user == null ? void 0 : user.id;
  const amz_keys = await prisma.amz_keys.findFirst({
    where: {
      user_id
    },
    select: {
      id: true,
      merchant_id: true,
      marketplace_id: true,
      valid: true,
      lastdatafetched: true
    }
  });
  console.log("keys : ", amz_keys);
  return json({ user, amz_keys });
};
function Account() {
  var _a2;
  const { user, amz_keys } = useLoaderData();
  const [loading, setLoading] = useState(true);
  useEffect(() => {
    if (amz_keys) {
      setLoading(false);
    }
  }, [amz_keys]);
  const marketplaceList = [
    { id: "A2Q3Y263D00KWC", country: "BR" },
    { id: "A2EUQ1WTGCTBG2", country: "CA" },
    { id: "A1AM78C64UM0Y8", country: "MX" },
    { id: "ATVPDKIKX0DER", country: "US" },
    { id: "A2VIGQ35RCS4UG", country: "AE" },
    { id: "A1PA6795UKMFR9", country: "DE" },
    { id: "ARBP9OOSHTCHU", country: "EG" },
    { id: "A1RKKUPIHCS9HS", country: "ES" },
    { id: "A13V1IB3VIYZZH", country: "FR" },
    { id: "AMEN7PMS3EDWL", country: "BE" },
    { id: "A1F83G8C2ARO7P", country: "UK" },
    { id: "A21TJRUUN4KGV", country: "IN" },
    { id: "APJ6JRA9NG5V4", country: "IT" },
    { id: "A1805IZSGTT6HS", country: "NL" },
    { id: "A1C3SOZRARQ6R3", country: "PL" },
    { id: "A17E79C6D8DWNP", country: "SA" },
    { id: "A2NODRKZP88ZB9", country: "SE" },
    { id: "A33AVAJ2PDY3EV", country: "TR" },
    { id: "A28R8C7NBKEWEA", country: "IE" },
    { id: "A1VC38T7YXB528", country: "JP" },
    { id: "A19VAU5U5O7RUS", country: "SG" },
    { id: "A39IBJ37TRP1C6", country: "AU" }
  ];
  const marketplaceName = ((_a2 = marketplaceList.find((m) => m.id === (amz_keys == null ? void 0 : amz_keys.marketplace_id))) == null ? void 0 : _a2.country) || "Unknown Marketplace";
  const rows = [
    [
      (amz_keys == null ? void 0 : amz_keys.id) || 1,
      (amz_keys == null ? void 0 : amz_keys.merchant_id) || "N/A",
      /* @__PURE__ */ jsx(Badge, { tone: (amz_keys == null ? void 0 : amz_keys.valid) ? "success" : "critical", children: (amz_keys == null ? void 0 : amz_keys.valid) ? "Active" : "InActive" }),
      marketplaceName,
      amz_keys == null ? void 0 : amz_keys.lastdatafetched
    ]
  ];
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(
      Page,
      {
        title: "Amazon Account Settings",
        subtitle: "Configure your Amazon integration",
        children: [
          loading ? /* @__PURE__ */ jsx(LegacyCard, { sectioned: true, children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 4 }) }) : /* @__PURE__ */ jsx(LegacyCard, { children: /* @__PURE__ */ jsx("div", { className: "centerTable", children: /* @__PURE__ */ jsx(
            DataTable,
            {
              columnContentTypes: [
                "text",
                "text",
                "text",
                "text",
                "text"
              ],
              headings: [
                "Id",
                "Merchant Id",
                "Status",
                "Site",
                "Last Data Fetched"
              ],
              hideScrollIndicator: true,
              rows
            }
          ) }) }),
          /* @__PURE__ */ jsx("p", { style: { textAlign: "center", marginTop: "30px", color: "#666" }, children: "Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved." })
        ]
      }
    ),
    /* @__PURE__ */ jsx("style", { children: `
          .centerTable table td,
          .centerTable table th {
            text-align: center !important;
          }
        ` })
  ] });
}
const route22 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: Account,
  loader: loader$2
}, Symbol.toStringTag, { value: "Module" }));
const upgradePremium = "/assets/upgradePremium-BkWq7pWk.jpg";
function sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
const loader$1 = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  console.log(session);
  let user = await prisma.users.findFirst({
    where: {
      shopurl: session.shop
    }
  });
  if (!user) {
    await sleep(2e3);
    user = await prisma.users.findFirst({
      where: {
        shopurl: session.shop
      }
    });
  }
  console.log(user);
  const user_id = user == null ? void 0 : user.id;
  console.log("userId: ", user_id);
  console.log("user plan :", user.plan);
  const amz_keys = await prisma.amz_keys.findFirst({
    where: {
      user_id
    }
  });
  const amzRequest = await prisma.amz_reportrequests.findFirst({
    where: {
      user_id
    },
    orderBy: {
      id: "desc"
    }
  });
  console.log("keys : ", amz_keys);
  return json({ user, amz_keys, amzRequest });
};
function Index() {
  var _a2;
  const { user, amz_keys, amzRequest } = useLoaderData();
  const navigate = useNavigate();
  const marketplaceList = [
    { id: "A2Q3Y263D00KWC", country: "BR" },
    { id: "A2EUQ1WTGCTBG2", country: "CA" },
    { id: "A1AM78C64UM0Y8", country: "MX" },
    { id: "ATVPDKIKX0DER", country: "US" },
    { id: "A2VIGQ35RCS4UG", country: "AE" },
    { id: "A1PA6795UKMFR9", country: "DE" },
    { id: "ARBP9OOSHTCHU", country: "EG" },
    { id: "A1RKKUPIHCS9HS", country: "ES" },
    { id: "A13V1IB3VIYZZH", country: "FR" },
    { id: "AMEN7PMS3EDWL", country: "BE" },
    { id: "A1F83G8C2ARO7P", country: "UK" },
    { id: "A21TJRUUN4KGV", country: "IN" },
    { id: "APJ6JRA9NG5V4", country: "IT" },
    { id: "A1805IZSGTT6HS", country: "NL" },
    { id: "A1C3SOZRARQ6R3", country: "PL" },
    { id: "A17E79C6D8DWNP", country: "SA" },
    { id: "A2NODRKZP88ZB9", country: "SE" },
    { id: "A33AVAJ2PDY3EV", country: "TR" },
    { id: "A28R8C7NBKEWEA", country: "IE" },
    { id: "A1VC38T7YXB528", country: "JP" },
    { id: "A19VAU5U5O7RUS", country: "SG" },
    { id: "A39IBJ37TRP1C6", country: "AU" }
  ];
  const marketplace = [
    { key: "ATVPDKIKX0DER", value: "amazon.com" },
    { key: "A2EUQ1WTGCTBG2", value: "amazon.ca" },
    { key: "A1AM78C64UM0Y8", value: "amazon.com.mx" },
    { key: "A1F83G8C2ARO7P", value: "amazon.co.uk" },
    { key: "A21TJRUUN4KGV", value: "amazon.in" },
    { key: "A1PA6795UKMFR9", value: "amazon.de" },
    { key: "A1RKKUPIHCS9HS", value: "amazon.es" },
    { key: "A13V1IB3VIYZZH", value: "amazon.fr" },
    { key: "APJ6JRA9NG5V4", value: "amazon.it" },
    { key: "ARBP9OOSHTCHU", value: "amazon.eg" },
    { key: "A2VIGQ35RCS4UG", value: "amazon.ae" }
  ];
  const marketplaceName = ((_a2 = marketplaceList.find((m) => m.id === (amz_keys == null ? void 0 : amz_keys.marketplace_id))) == null ? void 0 : _a2.country) || "Unknown Marketplace";
  const [welcome_tour, setWelcomeTour] = useState(user.welcome_tour ?? false);
  const [loading, setLoading] = useState(true);
  const [counts, setCounts] = useState(null);
  const [pending_request, setPendingRequest] = useState((amzRequest == null ? void 0 : amzRequest.status) === "pending" ? 1 : 0);
  useEffect(() => {
    if (user) {
      setLoading(false);
    }
  }, [user]);
  useEffect(() => {
    if (user == null ? void 0 : user.id) fetchCounts();
  }, [user]);
  async function fetchCounts() {
    const res = await fetch(`/api/productCount?user_id=${user.id}`);
    const data = await res.json();
    setCounts(data.countsByStatus);
  }
  useEffect(() => {
    let timeoutId;
    const fetchRequest = async () => {
      var _a3, _b, _c;
      if (pending_request === 1) {
        console.log("ssssssssssssssssssssssssskkkkkkkdk");
        try {
          const response = await axios.get("/api/fetchProductCount", {
            params: {
              userId: user.id
            }
          });
          if (((_a3 = response.data) == null ? void 0 : _a3.amzRequest) != null && ((_c = (_b = response.data) == null ? void 0 : _b.amzRequest) == null ? void 0 : _c.status) == "readyforshopify") {
            console.log("444444444444444444");
            clearTimeout(timeoutId);
            setPendingRequest(0);
            return;
          }
          setCounts(response.data.countsByStatus);
          timeoutId = setTimeout(fetchRequest, 5e3);
        } catch (error) {
          console.log(error);
        }
      }
    };
    fetchRequest();
    return () => clearTimeout(timeoutId);
  }, []);
  const handleJoyrideCallback = useCallback(async (data) => {
    const { status, type } = data;
    const finishedStatuses = [STATUS.FINISHED, STATUS.SKIPPED];
    if (finishedStatuses.includes(status)) {
      try {
        console.log("sdfsdfsdfsdfs");
        const response = await axios.get("/api/welcomeTour", {
          params: {
            userId: user.id
          }
        });
        console.log(response);
      } catch (e) {
        console.log(e);
      }
    }
  }, []);
  console.log("user plan :", user.plan);
  console.log("user membership :", user.membershiptype);
  const planMapping = {
    0: { type: "Free", cycle: "-" },
    1: { type: "Premium - Bronze", cycle: "Monthly" },
    2: { type: "Premium - Silver", cycle: "Monthly" },
    3: { type: "Premium - Gold", cycle: "Monthly" },
    4: { type: "Premium - Bronze", cycle: "Yearly" },
    5: { type: "Premium - Silver", cycle: "Yearly" },
    6: { type: "Premium - Gold", cycle: "Yearly" },
    7: { type: "Premium - custom", cycle: "Yearly" }
  };
  const userPlan = user.plan;
  const billingPlan = planMapping[userPlan] || planMapping[0];
  const membershipType = user.membershiptype ?? "free";
  const [steps] = useState([
    {
      target: ".tour-header",
      content: "Start the tour.",
      placement: "bottom"
    },
    {
      target: ".amazon-product",
      content: "Here is the number of your amazon products , you can go to the amazon products page by clicking on this card .",
      placement: "right"
    },
    {
      target: ".ready-to-import-product",
      content: "Here is the total number of products ready to import.",
      placement: "top"
    },
    {
      target: ".import-product",
      content: "Here is the total number of imported products from this app.",
      placement: "left"
    },
    {
      target: ".plan",
      content: "This is your plan details.",
      placement: "top"
    },
    {
      target: ".Aaccount",
      content: "This is your Amazon account details.",
      placement: "top"
    },
    {
      target: ".account_status",
      content: "This is your account status.",
      placement: "top"
    },
    {
      target: "body",
      placement: "center",
      content: /* @__PURE__ */ jsxs("div", { style: { textAlign: "center" }, children: [
        /* @__PURE__ */ jsx("strong", { children: "🎉 Tour complete!" }),
        /* @__PURE__ */ jsx("div", { className: "mt-2 text-sm", children: "Thanks for taking the tour." })
      ] })
    }
  ]);
  const amazonProducts = (counts == null ? void 0 : counts.all) ?? 0;
  const shopifyProducts = (counts == null ? void 0 : counts.ready_to_import) ?? 0;
  const importedProducts = (counts == null ? void 0 : counts.imported) ?? 0;
  const skuLimit = user.skulimit ?? 5;
  const importConsumed = user.skuconsumed ?? 0;
  const [setupStep, setSetupStep] = useState(user.setup_step ?? "first");
  const [progressBarText, setProgressBarText] = useState(
    user.setup_step === "first" ? "0 of 2 Task completed" : "1 of 2 Task completed"
  );
  const [progressBarValue, setProgressBarValue] = useState(
    user.setup_step === "first" ? 0 : 50
  );
  const [selectedOption, setSelectedOption] = useState("syncBoth");
  const [marketplaceId, setMarketplaceId] = useState("ATVPDKIKX0DER");
  const [activeStep, setActiveStep] = useState(
    user.setup_step === "first" ? 1 : 2
  );
  let content2;
  const handleSettingSave = async () => {
    var _a3;
    try {
      const response = await axios.post("/api/setupSetting", {
        data: [selectedOption],
        userId: user.id
      });
      if ((_a3 = response.data) == null ? void 0 : _a3.msg) {
        window.location.reload();
        setSetupStep("Done");
      }
    } catch (error) {
      console.log(error);
    }
  };
  const handleAccount = () => {
    console.log("Connecting account with marketplace ID:", marketplaceId);
    setSetupStep("second");
    const authUrl = `https://shopify.infoshore.biz/xpert/authorize.php?key=${user.id}&marketplace_id=${marketplaceId}`;
    window.open(authUrl, "_top");
  };
  if (user.setup_step == "Done") {
    content2 = /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(
        Joyride,
        {
          steps,
          run: !welcome_tour,
          continuous: true,
          showSkipButton: true,
          showProgress: true,
          disableScrolling: false,
          styles: {
            options: {
              zIndex: 1e4,
              primaryColor: "#FF9900",
              borderRadius: 8
            },
            tooltip: {
              width: "280px",
              maxWidth: "280px",
              fontSize: "14px",
              lineHeight: "1.4"
            },
            buttonNext: {
              backgroundColor: "#FF9900	",
              fontSize: "12px"
            },
            buttonBack: {
              color: "#FF9900",
              fontSize: "12px"
            }
          },
          callback: handleJoyrideCallback
        }
      ),
      /* @__PURE__ */ jsxs(Page, { fullWidth: true, children: [
        user.plan === 0 && user.skuconsumed < 5 && (amzRequest == null ? void 0 : amzRequest.status) != "readyforshopify" && /* @__PURE__ */ jsx("div", { style: { marginBottom: 20 }, children: /* @__PURE__ */ jsx(Banner, { children: /* @__PURE__ */ jsxs("p", { children: [
          "We are fetching Amazon listings from your Amazon seller account. Please",
          " ",
          /* @__PURE__ */ jsxs(
            Button,
            {
              variant: "plain",
              onClick: () => navigate("/app/products"),
              children: [
                "Click here",
                " "
              ]
            }
          ),
          " ",
          "to view and import 5 FREE products."
        ] }) }) }),
        user.plan > 1 && (amzRequest == null ? void 0 : amzRequest.status) != "readyforshopify" && /* @__PURE__ */ jsx("div", { style: { marginBottom: 20 }, children: /* @__PURE__ */ jsx(Banner, { children: /* @__PURE__ */ jsxs("p", { children: [
          "We are fetching Amazon listings from your Amazon seller account. Please",
          " ",
          /* @__PURE__ */ jsxs(
            Button,
            {
              variant: "plain",
              onClick: () => navigate("/app/products"),
              children: [
                "Click here",
                " "
              ]
            }
          ),
          " ",
          "to view and import products."
        ] }) }) }),
        (amzRequest == null ? void 0 : amzRequest.status) == "readyforshopify" && user.skuconsumed < user.skulimit && /* @__PURE__ */ jsx("div", { style: { marginBottom: 20 }, children: /* @__PURE__ */ jsx(
          Banner,
          {
            children: /* @__PURE__ */ jsxs(Text, { as: "p", fontWeight: "medium", children: [
              "All your Amazon products are fetched and ready —",
              " ",
              /* @__PURE__ */ jsxs(
                Button,
                {
                  variant: "plain",
                  onClick: () => navigate("/app/products"),
                  children: [
                    "click here",
                    " "
                  ]
                }
              ),
              " ",
              "to import them into your Shopify store.",
              " "
            ] })
          }
        ) }),
        /* @__PURE__ */ jsx("div", { className: "banner", children: user.skuconsumed >= user.skulimit ? /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs(Banner, { tone: "critical", children: [
          "Please upgrade your plan to continue importing items.",
          /* @__PURE__ */ jsx(Button, { onClick: () => navigate("/app/plan"), children: "Upgrade Plan" })
        ] }) }) : /* @__PURE__ */ jsx(Fragment, {}) }),
        /* @__PURE__ */ jsx("div", { style: { marginBottom: "20px" }, children: /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsxs(InlineStack, { gap: 300, blockAlign: "center", align: "space-evenly", children: [
          /* @__PURE__ */ jsx("div", { className: "amazon-product hover-card", children: loading ? /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 4 }) }) : /* @__PURE__ */ jsxs(Card, { sectioned: true, children: [
            /* @__PURE__ */ jsxs("p", { className: "heading_title", children: [
              "Amazon Products",
              /* @__PURE__ */ jsx(TbExternalLink, {})
            ] }),
            /* @__PURE__ */ jsx("br", {}),
            /* @__PURE__ */ jsx(
              Tooltip,
              {
                preferredPosition: "below",
                content: "Here is a comprehensive list of your active amazon listings.",
                children: /* @__PURE__ */ jsxs("h1", { className: "heading_text", children: [
                  amazonProducts,
                  " "
                ] })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsx("div", { className: "ready-to-import-product hover-card", children: loading ? /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 4 }) }) : /* @__PURE__ */ jsxs(Card, { sectioned: true, children: [
            /* @__PURE__ */ jsx("p", { className: "heading_title", children: "Ready To Import" }),
            /* @__PURE__ */ jsx("br", {}),
            /* @__PURE__ */ jsx(
              Tooltip,
              {
                preferredPosition: "below",
                content: "This indicates the total number of products available on your Shopify store.",
                children: /* @__PURE__ */ jsx("h1", { className: "heading_text", children: shopifyProducts })
              }
            )
          ] }) }),
          /* @__PURE__ */ jsx("div", { className: "import-product hover-card", children: loading ? /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 4 }) }) : /* @__PURE__ */ jsxs(Card, { sectioned: true, children: [
            /* @__PURE__ */ jsx("p", { className: "heading_title", children: "Imported Products" }),
            /* @__PURE__ */ jsx("br", {}),
            /* @__PURE__ */ jsx(
              Tooltip,
              {
                preferredPosition: "below",
                content: "This is the quantity of products you've successfully imported on Amazon or Shopify through this application.",
                children: /* @__PURE__ */ jsx("h1", { className: "heading_text", children: importedProducts })
              }
            )
          ] }) })
        ] }) }) }),
        /* @__PURE__ */ jsxs(Layout, { children: [
          /* @__PURE__ */ jsxs(Layout.Section, { variant: "oneThird", children: [
            /* @__PURE__ */ jsx("div", { style: { marginBottom: "20px" }, className: "plan", children: loading ? /* @__PURE__ */ jsx(Card, { roundedAbove: "md", children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 4 }) }) : /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "h2", variant: "headingMd", children: "Plan" }),
              /* @__PURE__ */ jsx(
                Banner,
                {
                  tone: membershipType === "free" ? "info" : "success",
                  title: membershipType === "free" ? "Free Plan" : "Paid Plan"
                }
              ),
              /* @__PURE__ */ jsx(BlockStack, { gap: "200", children: [
                {
                  label: "Pricing",
                  value: membershipType === "free" ? "$0/month" : billingPlan.cycle
                },
                { label: "Import Credit", value: skuLimit },
                { label: "Import Consumed", value: importConsumed }
              ].map((item, index2) => /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: item.label }),
                /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: item.value })
              ] }, index2)) })
            ] }) }) }),
            loading ? /* @__PURE__ */ jsx(Card, { roundedAbove: "md", children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 4 }) }) : /* @__PURE__ */ jsx("div", { className: "Aaccount", children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
              /* @__PURE__ */ jsx(Text, { as: "h2", variant: "headingMd", children: "Amazon Account" }),
              /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Merchant ID" }),
                  console.log(amz_keys),
                  /* @__PURE__ */ jsx(Badge, { children: amz_keys == null ? void 0 : amz_keys.merchant_id })
                ] }),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Status" }),
                  /* @__PURE__ */ jsx(
                    Badge,
                    {
                      tone: (amz_keys == null ? void 0 : amz_keys.valid) === true ? "success" : "critical",
                      children: (amz_keys == null ? void 0 : amz_keys.valid) === true ? "Active" : "InActive"
                    }
                  )
                ] }),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Site" }),
                  /* @__PURE__ */ jsx(Text, { children: marketplaceName })
                ] })
              ] })
            ] }) }) })
          ] }),
          /* @__PURE__ */ jsx(Layout.Section, { children: /* @__PURE__ */ jsx("div", { className: "account_status", children: loading ? /* @__PURE__ */ jsx(Card, { sectioned: true, children: /* @__PURE__ */ jsx(SkeletonBodyText, { lines: 10 }) }) : /* @__PURE__ */ jsx(Fragment, { children: membershipType === "paid" ? /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "300", children: [
            /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
              /* @__PURE__ */ jsx(Text, { as: "h2", variant: "headingMd", children: "Account Status" }),
              /* @__PURE__ */ jsx(Badge, { tone: "info", children: "Premium" })
            ] }),
            /* @__PURE__ */ jsx(
              ProgressBar,
              {
                progress: 100,
                tone: "success",
                size: "small"
              }
            ),
            /* @__PURE__ */ jsxs(InlineGrid, { gap: "300", columns: 2, children: [
              /* @__PURE__ */ jsx(Card, { sectioned: true, background: "bg-surface-secondary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Your Subscription" }),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { children: "Plan Type" }),
                  /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: billingPlan.type })
                ] }),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { children: "Billing Cycle" }),
                  /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: billingPlan.cycle })
                ] })
              ] }) }),
              /* @__PURE__ */ jsx(Card, { sectioned: true, background: "bg-surface-secondary", children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                /* @__PURE__ */ jsx(Text, { variant: "headingMd", children: "Usage Statistics" }),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { children: "Products Imported" }),
                  /* @__PURE__ */ jsxs(Text, { fontWeight: "bold", children: [
                    importedProducts,
                    " of ",
                    skuLimit
                  ] })
                ] }),
                /* @__PURE__ */ jsxs(InlineStack, { align: "space-between", children: [
                  /* @__PURE__ */ jsx(Text, { children: "Remaining Products" }),
                  /* @__PURE__ */ jsx(Text, { fontWeight: "bold", children: skuLimit - importedProducts })
                ] })
              ] }) })
            ] }),
            /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(InlineStack, { align: "center", children: /* @__PURE__ */ jsx(
              CalloutCard,
              {
                title: "Want to Get the Most Out of Your Premium Features?",
                illustration: upgradePremium,
                primaryAction: {
                  content: "Book Now",
                  url: "https://calendly.com/madhu-infoshore/30min?month=2025-05",
                  target: "_blank"
                },
                children: /* @__PURE__ */ jsx(Text, { as: "p", children: "📅 Book a personalized strategy session to unlock the full potential of premium tools and features of your plan!" })
              }
            ) }) })
          ] }) }) : /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
            /* @__PURE__ */ jsx(Text, { as: "h2", variant: "headingMd", children: "Account Status" }),
            /* @__PURE__ */ jsx(
              ProgressBar,
              {
                progress: 66,
                tone: "success",
                size: "small"
              }
            ),
            /* @__PURE__ */ jsxs(InlineStack, { blockAlign: "center", gap: "300", children: [
              /* @__PURE__ */ jsx(
                "div",
                {
                  style: {
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "center"
                  },
                  children: /* @__PURE__ */ jsx(Icon, { source: StatusActiveIcon, tone: "success" })
                }
              ),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Connect your amazon or Shopify store" })
            ] }),
            /* @__PURE__ */ jsxs(InlineStack, { blockAlign: "center", gap: "300", children: [
              /* @__PURE__ */ jsx(
                "div",
                {
                  style: {
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "center"
                  },
                  children: /* @__PURE__ */ jsx(Icon, { source: StatusActiveIcon, tone: "success" })
                }
              ),
              /* @__PURE__ */ jsx(Text, { variant: "bodyMd", children: "Complete account setup" })
            ] }),
            /* @__PURE__ */ jsxs(InlineStack, { blockAlign: "center", gap: "300", children: [
              /* @__PURE__ */ jsx(
                "div",
                {
                  style: {
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "center"
                  },
                  children: /* @__PURE__ */ jsx(Icon, { source: XCircleIcon, tone: "critical" })
                }
              ),
              importedProducts === 0 ? /* @__PURE__ */ jsx(Button, { variant: "plain", url: "/app/products", children: /* @__PURE__ */ jsx("div", { style: { color: "black" }, children: "Import your first product" }) }) : /* @__PURE__ */ jsx(Button, { variant: "plain", children: /* @__PURE__ */ jsx("div", { style: { color: "black" }, children: "Upgrade to a Premium Plan" }) })
            ] }),
            /* @__PURE__ */ jsx("div", { style: { marginTop: "6%" }, children: /* @__PURE__ */ jsx(InlineStack, { gap: "400", align: "center", children: /* @__PURE__ */ jsx(
              CalloutCard,
              {
                title: "Supercharge Your Store with Premium",
                illustration: "https://cp.infoshoreapps.com/api/public/uploads/image.png",
                primaryAction: {
                  content: "Upgrade to Premium"
                },
                children: /* @__PURE__ */ jsx(Text, { as: "p", children: "🚀 Import more products, unlock powerful analytics, and get 24/7 support to grow your business faster." })
              }
            ) }) })
          ] }) }) }) }) })
        ] }),
        /* @__PURE__ */ jsx("p", { style: { textAlign: "center", marginTop: "20px", color: "#666" }, children: "Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved." })
      ] }),
      /* @__PURE__ */ jsx("style", { children: `
        .hover-card {
          transition: transform 0.3s ease, box-shadow 0.3s ease;
          min-width: 190px;
          width: min-content;
          flex-grow: 1;
          cursor: pointer;
          border-radius: 15px;
        }
        .hover-card:hover{
           transform: translateY(-10px);
           box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
           border-radius: 15px;
        }
        .heading_text{
          text-align: center;
          font-size: 25px;
          font-weight: bold;
          color: #4e5358;
        }
        .heading_title{
          font-size: 15px;
          font-weight: 550;
          cursor: pointer;
          padding: 0%;
          text-align: center;
          color: #5f729c;
        }
        ` })
    ] });
  } else {
    content2 = /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsxs(Box, { paddingBlockEnd: "4", children: [
        /* @__PURE__ */ jsx(Text, { variant: "headingXl", as: "h1", alignment: "center", children: "PRO Importer For Amazon" }),
        /* @__PURE__ */ jsx(Text, { variant: "bodyMd", as: "p", alignment: "center", tone: "subdued", children: "Set up your Amazon account to start importing products" })
      ] }),
      /* @__PURE__ */ jsx(Page, { children: /* @__PURE__ */ jsx(Box, { children: /* @__PURE__ */ jsxs(Card, { children: [
        /* @__PURE__ */ jsxs("div", { style: { padding: "16px" }, children: [
          /* @__PURE__ */ jsx(
            "div",
            {
              style: {
                display: "flex",
                justifyContent: "space-between",
                alignItems: "center",
                width: "100%",
                marginBottom: "8px"
              },
              children: /* @__PURE__ */ jsx(Text, { as: "span", variant: "bodyMd", fontWeight: "bold", children: progressBarText })
            }
          ),
          /* @__PURE__ */ jsx(
            ProgressBar,
            {
              progress: progressBarValue,
              tone: "highlight",
              size: "small"
            }
          )
        ] }),
        /* @__PURE__ */ jsx("div", { style: { margin: "30px" }, children: /* @__PURE__ */ jsxs(BlockStack, { gap: "400", children: [
          /* @__PURE__ */ jsxs(LegacyStack, { vertical: true, children: [
            /* @__PURE__ */ jsx(
              Button,
              {
                ariaControls: "step-1",
                variant: "tertiary",
                fullWidth: true,
                textAlign: "left",
                disabled: setupStep == "second",
                children: /* @__PURE__ */ jsxs(
                  "div",
                  {
                    style: {
                      display: "flex",
                      alignItems: "center",
                      gap: "8px"
                    },
                    children: [
                      /* @__PURE__ */ jsx(
                        Icon,
                        {
                          source: user.setup_step === "first" ? AlertCircleIcon : StatusActiveIcon,
                          tone: "success"
                        }
                      ),
                      /* @__PURE__ */ jsx(Text, { as: "h2", variant: "headingMd", style: { margin: 0 }, children: "Step 1: Connect your Amazon account" })
                    ]
                  }
                )
              }
            ),
            /* @__PURE__ */ jsx("div", { style: { marginLeft: "20px" }, children: /* @__PURE__ */ jsx(
              Collapsible,
              {
                open: activeStep === 1,
                id: "step-1",
                transition: {
                  duration: "200ms",
                  timingFunction: "ease-in-out"
                },
                expandOnPrint: true,
                children: /* @__PURE__ */ jsxs(
                  Tooltip,
                  {
                    content: "Click here to connect your amazon account.",
                    preferredPosition: "below",
                    children: [
                      /* @__PURE__ */ jsx(
                        Select,
                        {
                          label: "Select Marketplace",
                          options: marketplace.map((m) => ({
                            label: m.value,
                            value: m.key
                          })),
                          value: marketplaceId,
                          onChange: (value) => {
                            setMarketplaceId(value);
                          }
                        }
                      ),
                      /* @__PURE__ */ jsx("br", {}),
                      /* @__PURE__ */ jsx(
                        Button,
                        {
                          icon: StoreIcon,
                          variant: "primary",
                          onClick: () => {
                            handleAccount();
                            setProgressBarValue(50);
                            setProgressBarText("1 of 2 Task completed");
                          },
                          children: "Connect Amazon Shop"
                        }
                      )
                    ]
                  }
                )
              }
            ) })
          ] }),
          /* @__PURE__ */ jsxs(LegacyStack, { vertical: true, children: [
            /* @__PURE__ */ jsx(
              Button,
              {
                ariaControls: "step-2",
                variant: "tertiary",
                fullWidth: true,
                textAlign: "left",
                disabled: setupStep != "second",
                children: /* @__PURE__ */ jsxs(
                  "div",
                  {
                    style: {
                      display: "flex",
                      alignItems: "center",
                      gap: "8px"
                    },
                    children: [
                      /* @__PURE__ */ jsx(Icon, { source: AlertCircleIcon, tone: "success" }),
                      /* @__PURE__ */ jsx(Text, { as: "h2", variant: "headingMd", style: { margin: 0 }, children: "Step 2: Inventory Sync Setting" })
                    ]
                  }
                )
              }
            ),
            /* @__PURE__ */ jsx("div", { style: { marginLeft: "20px" }, children: /* @__PURE__ */ jsx(
              Collapsible,
              {
                open: activeStep === 2,
                id: "step-2",
                transition: {
                  duration: "200ms",
                  timingFunction: "ease-in-out"
                },
                expandOnPrint: true,
                children: /* @__PURE__ */ jsxs(Fragment, { children: [
                  /* @__PURE__ */ jsx(Text, { as: "p", children: "Select the appropriate order and inventory sync option for your Shopify and Amazon store" }),
                  /* @__PURE__ */ jsxs(BlockStack, { gap: "200", children: [
                    /* @__PURE__ */ jsx(
                      RadioButton,
                      {
                        label: "Enable both Inventory & Price sync",
                        checked: selectedOption === "syncBoth",
                        id: "syncBoth",
                        name: "syncOption",
                        onChange: () => setSelectedOption("syncBoth")
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      RadioButton,
                      {
                        label: "Enable Inventory sync only",
                        checked: selectedOption === "inventoryOnly",
                        id: "inventoryOnly",
                        name: "syncOption",
                        onChange: () => setSelectedOption("inventoryOnly")
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      RadioButton,
                      {
                        label: "Enable Price sync only",
                        checked: selectedOption === "priceOnly",
                        id: "priceOnly",
                        name: "syncOption",
                        onChange: () => setSelectedOption("priceOnly")
                      }
                    ),
                    /* @__PURE__ */ jsx(
                      RadioButton,
                      {
                        label: "None",
                        checked: selectedOption === "none",
                        id: "none",
                        name: "syncOption",
                        onChange: () => setSelectedOption("none")
                      }
                    )
                  ] }),
                  /* @__PURE__ */ jsx(
                    Tooltip,
                    {
                      content: "click here to complete setup.",
                      preferredPosition: "below",
                      children: /* @__PURE__ */ jsx(
                        Button,
                        {
                          variant: "primary",
                          onClick: handleSettingSave,
                          className: "flex items-center gap-2",
                          fullWidth: true,
                          icon: ArrowRightIcon,
                          children: /* @__PURE__ */ jsxs(
                            "div",
                            {
                              style: {
                                display: "flex",
                                alignItems: "center",
                                gap: "8px"
                              },
                              children: [
                                "Complete",
                                /* @__PURE__ */ jsx(ArrowRightIcon, {})
                              ]
                            }
                          )
                        }
                      )
                    }
                  )
                ] })
              }
            ) })
          ] })
        ] }) })
      ] }) }) })
    ] });
  }
  return /* @__PURE__ */ jsx(Fragment, { children: content2 });
}
const route23 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: Index,
  loader: loader$1
}, Symbol.toStringTag, { value: "Module" }));
const title = "_title_ujytu_1";
const toggleSwitch = "_toggleSwitch_ujytu_15";
const checkbox = "_checkbox_ujytu_27";
const switchLabel = "_switchLabel_ujytu_41";
const green = "_green_ujytu_61";
const gray = "_gray_ujytu_69";
const switchCircle = "_switchCircle_ujytu_77";
const switchLeft = "_switchLeft_ujytu_99";
const switchRight = "_switchRight_ujytu_107";
const planCards = "_planCards_ujytu_117";
const cardContent = "_cardContent_ujytu_161";
const cardHeader = "_cardHeader_ujytu_175";
const gold = "_gold_ujytu_185";
const normal = "_normal_ujytu_191";
const cardBody = "_cardBody_ujytu_199";
const activateButton = "_activateButton_ujytu_215";
const styles = {
  title,
  toggleSwitch,
  checkbox,
  switchLabel,
  green,
  gray,
  switchCircle,
  switchLeft,
  switchRight,
  planCards,
  cardContent,
  cardHeader,
  gold,
  normal,
  cardBody,
  activateButton
};
const support = "/assets/support-DyFOvJuR.jpg";
const loader = async ({ request }) => {
  const { session } = await authenticate.admin(request);
  console.log(session);
  const user = await prisma.users.findFirst({
    where: {
      shopurl: session.shop
    }
  });
  console.log(user);
  return json({ user });
};
function Plan() {
  const { user } = useLoaderData();
  const [planType, setPlanType] = useState("Yearly");
  const [activePlan, setActivePlan] = useState(0);
  const [planId, setPlanId] = useState("0");
  useEffect(() => {
    async function fetchPlan() {
      const res = await fetch("/api/plan");
      const data = await res.json();
      const userPlanId = data.plan;
      setActivePlan(userPlanId);
      if ([4, 5, 6].includes(userPlanId)) {
        setPlanType("Yearly");
      } else {
        setPlanType("Monthly");
      }
    }
    fetchPlan();
  }, []);
  const handleTabChange = () => {
    setPlanType((prevType) => prevType === "Monthly" ? "Yearly" : "Monthly");
  };
  const handleActivatePlan = async (planId2) => {
    let url = "";
    if (planType === "Yearly") {
      url = `https://shopify.infoshore.biz/xpert/upgradeannual.php?key=${user.id}&type=${planId2}`;
    } else {
      url = `https://shopify.infoshore.biz/xpert/upgrade2.php?key=${user.id}&type=${planId2}`;
    }
    window.open(url, "_top");
    setActivePlan(planId2);
    console.log("plan : ", planId2);
  };
  const getPlans = (planType2) => [
    {
      id: 0,
      name: "FREE",
      price: "$0",
      period: "Valid for 30 days",
      features: planType2 === "Yearly" ? [
        "Manage 25 SKUs",
        "Import Products"
      ] : [
        "Manage 25 SKUs",
        "Import Products"
      ],
      notIncluded: [
        "Inventory Sync",
        "Price Sync",
        "Real-time Sync",
        "Priority Customer Support"
      ]
    },
    {
      id: planType2 === "Yearly" ? 4 : 1,
      name: "BRONZE",
      price: planType2 === "Yearly" ? "$199/year" : "$20/month",
      period: planType2 === "Monthly" ? "Billed at $199 per year" : "",
      features: planType2 === "Yearly" ? [
        "Manage 500 SKUs",
        "Import Products",
        "Inventory Sync",
        "Price Sync"
      ] : [
        "Manage 500 SKUsh",
        "Import Products",
        "Inventory Sync",
        "Price Sync"
      ],
      notIncluded: ["Real-time Sync", "Priority Customer Support"]
    },
    {
      id: planType2 === "Yearly" ? 5 : 2,
      name: "SILVER",
      price: planType2 === "Yearly" ? "$299/year" : "$30/month",
      period: planType2 === "Monthly" ? "Billed at $299 per year" : "",
      features: planType2 === "Yearly" ? [
        "Manage 2000 SKUs",
        "Import Products",
        "Sync up to 6000 items",
        "Inventory Sync",
        "Price Sync",
        "Real-time Sync",
        "Priority Customer Support"
      ] : [
        "Manage 2000 SKUs",
        "Import Products",
        "Inventory Sync",
        "Price Sync",
        "Real-time Sync",
        "Priority Customer Support"
      ]
    },
    {
      id: planType2 === "Yearly" ? 6 : 3,
      name: "GOLD",
      price: planType2 === "Yearly" ? "$599/year" : "$60/month",
      period: planType2 === "Monthly" ? "Billed at $599 per year" : "",
      features: planType2 === "Yearly" ? [
        "Manage 5000 SKUs",
        "Import Products",
        "Sync up to 15000 items",
        "Inventory Sync",
        "Price Sync",
        "Real-time Sync",
        "Priority Customer Support"
      ] : [
        "Manage 5000 SKUs",
        "Import Products",
        "Inventory Sync",
        "Price Sync",
        "Real-time Sync",
        "Priority Customer Support"
      ]
    }
  ];
  const plans = getPlans(planType);
  return /* @__PURE__ */ jsxs(
    Page,
    {
      fullWidth: true,
      children: [
        /* @__PURE__ */ jsx("div", { className: styles.title, children: /* @__PURE__ */ jsxs(Text, { variant: "headingLg", as: "h5", children: [
          planType,
          " Plans With Real time Inventory Sync"
        ] }) }),
        /* @__PURE__ */ jsxs("div", { className: styles.toggleSwitch, children: [
          /* @__PURE__ */ jsx(
            "input",
            {
              type: "checkbox",
              checked: planType === "Yearly",
              onChange: handleTabChange,
              id: "plan-toggle",
              className: styles.checkbox
            }
          ),
          /* @__PURE__ */ jsx("span", { children: "Billed Annually" }),
          /* @__PURE__ */ jsx("label", { htmlFor: "plan-toggle", className: `${styles.switchLabel} ${planType === "Monthly" ? styles.green : styles.gray}`, children: /* @__PURE__ */ jsx(
            "span",
            {
              className: `${styles.switchCircle} ${planType === "Monthly" ? styles.switchRight : styles.switchLeft}`
            }
          ) }),
          /* @__PURE__ */ jsx("span", { children: "Billed Monthly" })
        ] }),
        /* @__PURE__ */ jsx("div", { className: styles.planCards, children: plans.map((plan) => /* @__PURE__ */ jsx("div", { className: styles.planCardWrapper, children: /* @__PURE__ */ jsx(Card, { children: /* @__PURE__ */ jsxs("div", { className: styles.cardContent, children: [
          /* @__PURE__ */ jsxs("div", { className: `${styles.cardHeader} ${plan.name === "GOLD" ? styles.gold : styles.normal}`, children: [
            /* @__PURE__ */ jsxs(Text, { variant: "headingLg", as: "h5", children: [
              plan.name,
              " ",
              planType === "Yearly" && plan.name !== "FREE" ? "Annual" : ""
            ] }),
            /* @__PURE__ */ jsx(Text, { variant: "headingMd", as: "h5", tone: "success", children: plan.price }),
            /* @__PURE__ */ jsx(Text, { tone: "success", children: plan.period })
          ] }),
          /* @__PURE__ */ jsxs("div", { className: styles.cardBody, children: [
            plan.features.map((f) => /* @__PURE__ */ jsxs("p", { children: [
              "✓ ",
              f
            ] }, f)),
            plan.notIncluded && plan.notIncluded.map((f) => /* @__PURE__ */ jsxs("p", { children: [
              "✗ ",
              f
            ] }, f))
          ] }),
          /* @__PURE__ */ jsx("div", { className: styles.activateButton, children: /* @__PURE__ */ jsx(
            Button,
            {
              fullWidth: true,
              variant: activePlan === plan.id ? "" : "primary",
              disabled: activePlan === plan.id,
              onClick: () => handleActivatePlan(plan.id),
              children: activePlan === plan.id ? "Activated" : "Activate Now"
            }
          ) })
        ] }) }, plan.name) }, plan.name)) }),
        /* @__PURE__ */ jsx("div", { style: { marginTop: "20px" }, children: /* @__PURE__ */ jsx(InlineStack, { fullWidth: true, children: /* @__PURE__ */ jsx(
          CalloutCard,
          {
            title: "Need More Than 5,000 SKUs?",
            fullWidth: true,
            illustration: support,
            primaryAction: {
              content: "Email Now",
              url: "mailto:shopifyapps@infoshore.biz"
              // target: "_blank",
            },
            children: /* @__PURE__ */ jsxs(Text, { as: "p", children: [
              "Yes we do support more than 5,000 amazon SKUs. Drop us an email at ",
              " ",
              /* @__PURE__ */ jsx("a", { href: "mailto:shopifyapps@infoshore.biz", target: "_blank", children: "shopifyapps@infoshore.biz " }),
              "for a quote with all the details."
            ] })
          }
        ) }) }),
        /* @__PURE__ */ jsx("p", { style: { textAlign: "center", marginTop: "30px", color: "#666" }, children: "Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved." })
      ]
    }
  );
}
const route24 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: Plan,
  loader
}, Symbol.toStringTag, { value: "Module" }));
function FAQItem({ title: title2, children }) {
  const [open, setOpen] = useState(false);
  return /* @__PURE__ */ jsxs("div", { style: {
    marginBottom: "20px",
    borderRadius: "8px",
    border: "1px solid #E3E3E3",
    padding: "12px 16px"
  }, children: [
    /* @__PURE__ */ jsxs(
      "div",
      {
        onClick: () => setOpen(!open),
        style: { display: "flex", justifyContent: "space-between", cursor: "pointer", font: "20px" },
        children: [
          /* @__PURE__ */ jsx(Text, { variant: "bodyLg", children: title2 }),
          /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Icon, { source: open ? ChevronUpIcon : ChevronDownIcon }) })
        ]
      }
    ),
    /* @__PURE__ */ jsx(Collapsible, { open, children: /* @__PURE__ */ jsx("div", { style: { marginTop: "10px", color: "#616161" }, children: /* @__PURE__ */ jsx(Text, { variant: "headingMd", children }) }) })
  ] });
}
function FaqPage() {
  const [selected, setSelected] = useState(0);
  const handleTabChange = (selectedTabIndex) => setSelected(selectedTabIndex);
  const tabs = [
    { id: "general-1", content: "General", badge: "4" },
    { id: "about-sync-2", content: "About Sync", badge: "3" },
    { id: "product-import-3", content: "About Product Import", badge: "4" }
  ];
  return /* @__PURE__ */ jsxs(Page, { children: [
    /* @__PURE__ */ jsxs("div", { style: { textAlign: "center", marginTop: "10px", marginBottom: "30px" }, children: [
      /* @__PURE__ */ jsx(Text, { variant: "heading2xl", as: "h3", children: "Frequently Asked Questions" }),
      /* @__PURE__ */ jsx(Text, { tone: "subdued", children: "Find answers to common questions about our xpert app" })
    ] }),
    /* @__PURE__ */ jsxs(LegacyCard, { children: [
      /* @__PURE__ */ jsx("div", { style: { display: "flex", justifyContent: "center" }, children: /* @__PURE__ */ jsx(Tabs, { tabs, selected, onSelect: handleTabChange }) }),
      /* @__PURE__ */ jsxs(LegacyCard.Section, { children: [
        selected === 0 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx(FAQItem, { title: "How do I connect my Amazon account?", children: /* @__PURE__ */ jsx("div", { style: { display: "flex", flexDirection: "column", gap: "10px" }, children: /* @__PURE__ */ jsxs(Text, { children: [
            "Go to Amazon Account Settings, click ",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "  Authenticate Amazon Account " }),
            "to link your Amazon seller account. You'll be redirected to Amazon's authorization page to grant permissions."
          ] }) }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "How many products can I import with the FREE plan?", children: /* @__PURE__ */ jsxs(Text, { children: [
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "The FREE plan " }),
            "allows you to import up to",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: " 25 Amazon SKUs " }),
            "to your Shopify store. This plan is valid for",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: " 30 days " }),
            " and includes basic import functionality."
          ] }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "Can I import products from multiple Amazon marketplaces?", children: /* @__PURE__ */ jsx("div", { style: { display: "flex", flexDirection: "column", gap: "10px" }, children: /* @__PURE__ */ jsxs(Text, { children: [
            "Currently, the app supports ",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "one Amazon marketplace per connection. " }),
            "If you sell on multiple Amazon sites (US, UK, DE, etc.), you'll need to switch between accounts or contact support at",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: " shopifyapps@infoshore.biz " }),
            "for enterprise solutions."
          ] }) }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "What happens when my subcription expires?", children: /* @__PURE__ */ jsx(Text, { children: "When your subscription expires, you'll no longer be able to import new products or use sync features. Existing imported products will remain in your Shopify store, but won't receive updates from Amazon." }) })
        ] }),
        selected === 1 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx(FAQItem, { title: "What's the difference between Inventory Sync and Price Sync?", children: /* @__PURE__ */ jsxs(Text, { children: [
            "Inventory Sync automatically updates your Shopify product quantities based on your Amazon inventory levels. Price Sync keeps your Shopify prices in sync with your Amazon prices.",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: " Both features are available in paid plans only." })
          ] }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "How often does the app sync Inventory Sync and Price Sync?", children: /* @__PURE__ */ jsx("div", { style: { display: "flex", flexDirection: "column", gap: "10px" }, children: /* @__PURE__ */ jsxs(Text, { children: [
            "For paid plans with sync features enabled, inventory and prices are updated every ",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "24 hours" }),
            " automatically."
          ] }) }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "Are sync features available during the free trial ?", children: /* @__PURE__ */ jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "10px" }, children: [
            /* @__PURE__ */ jsxs(Text, { children: [
              "No, ",
              /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "sync features (price and inventory sync)" }),
              " are not available during the free trial."
            ] }),
            /* @__PURE__ */ jsx(Text, { children: "To access these features, you will need to upgrade to a paid plan." })
          ] }) })
        ] }),
        selected === 2 && /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx(FAQItem, { title: "Can I customize how products are imported?", children: /* @__PURE__ */ jsxs(Text, { children: [
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "Yes! " }),
            "In Settings, you can configure whether products should be published immediately, set fulfillment services, choose inventory policies, and enable/disable sync features."
          ] }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "Is there a limit on product variants?", children: /* @__PURE__ */ jsxs(Text, { children: [
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "Yes, " }),
            "there's a limit on product variants as in Shopify, a product can have a ",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "maximum of 100 variants. " }),
            "Each Amazon ASIN with multiple variations (size, color, etc.) will be imported as a single Shopify product with multiple variants."
          ] }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "What if I need to import more than 5,000 SKUs?", children: /* @__PURE__ */ jsxs(Text, { children: [
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "Yes, " }),
            "there's a limit on product variants as in Shopify, a product can have a ",
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "maximum of 100 variants. " }),
            "Each Amazon ASIN with multiple variations (size, color, etc.) will be imported as a single Shopify product with multiple variants."
          ] }) }),
          /* @__PURE__ */ jsx(FAQItem, { title: "Can I uninstall the app after imoprting products?", children: /* @__PURE__ */ jsxs(Text, { children: [
            /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "Yes, " }),
            "if you only need one-time import without ongoing sync, you can uninstall the app after importing your products. The imported products will remain in your Shopify store."
          ] }) })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsx("div", { style: { marginTop: "20px", marginBottom: "30px" }, children: /* @__PURE__ */ jsx(InlineStack, { align: "center", children: /* @__PURE__ */ jsx(
      CalloutCard,
      {
        title: "Still have questions?",
        illustration: support,
        primaryAction: {
          content: "Email Now",
          url: "mailto:shopifyapps@infoshore.biz",
          target: "_blank"
        },
        children: /* @__PURE__ */ jsx(Text, { as: "p", children: "If you couldn't find what you're looking for, our friendly support team is here to help with all your Amazon to Shopify import needs." })
      }
    ) }) }),
    /* @__PURE__ */ jsx("p", { style: { textAlign: "center", marginTop: "30px", color: "#666" }, children: "Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved." })
  ] });
}
const route25 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: FaqPage
}, Symbol.toStringTag, { value: "Module" }));
const serverManifest = { "entry": { "module": "/assets/entry.client-gpAJEJts.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/components-Cx8rd7AF.js"], "css": [] }, "routes": { "root": { "id": "root", "parentId": void 0, "path": "", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/root-CltOIpDo.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/components-Cx8rd7AF.js"], "css": [] }, "routes/webhooks.app.scopes_update": { "id": "routes/webhooks.app.scopes_update", "parentId": "root", "path": "webhooks/app/scopes_update", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/webhooks.app.scopes_update-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/webhooks.app.uninstalled": { "id": "routes/webhooks.app.uninstalled", "parentId": "root", "path": "webhooks/app/uninstalled", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/webhooks.app.uninstalled-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.fetchAmazonProducts": { "id": "routes/api.fetchAmazonProducts", "parentId": "root", "path": "api/fetchAmazonProducts", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.fetchAmazonProducts-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.fetchProductCount": { "id": "routes/api.fetchProductCount", "parentId": "root", "path": "api/fetchProductCount", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.fetchProductCount-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.productVariant": { "id": "routes/api.productVariant", "parentId": "root", "path": "api/productVariant", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.productVariant-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.unblockproduct": { "id": "routes/api.unblockproduct", "parentId": "root", "path": "api/unblockproduct", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.unblockproduct-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.blockProduct": { "id": "routes/api.blockProduct", "parentId": "root", "path": "api/blockProduct", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.blockProduct-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.productCount": { "id": "routes/api.productCount", "parentId": "root", "path": "api/productCount", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.productCount-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.setupSetting": { "id": "routes/api.setupSetting", "parentId": "root", "path": "api/setupSetting", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.setupSetting-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.welcomeTour": { "id": "routes/api.welcomeTour", "parentId": "root", "path": "api/welcomeTour", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.welcomeTour-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.products": { "id": "routes/api.products", "parentId": "root", "path": "api/products", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.products-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.settings": { "id": "routes/api.settings", "parentId": "root", "path": "api/settings", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.settings-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.pushall": { "id": "routes/api.pushall", "parentId": "root", "path": "api/pushall", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.pushall-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/auth.login": { "id": "routes/auth.login", "parentId": "root", "path": "auth/login", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/route-uoqUV5EQ.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/styles-CzQq0O8K.js", "/assets/components-Cx8rd7AF.js", "/assets/Page-B0rKNhuS.js", "/assets/Card-BFf8yJ6t.js", "/assets/FormLayout-B5cHeF8N.js", "/assets/context-BbmIOJGV.js", "/assets/context-CCgK-ll5.js"], "css": [] }, "routes/api.plan": { "id": "routes/api.plan", "parentId": "root", "path": "api/plan", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.plan-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/api.push": { "id": "routes/api.push", "parentId": "root", "path": "api/push", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/api.push-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/_index": { "id": "routes/_index", "parentId": "root", "path": void 0, "index": true, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/route-DWyTuQdY.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/components-Cx8rd7AF.js"], "css": ["/assets/route-CNPfFM0M.css"] }, "routes/auth.$": { "id": "routes/auth.$", "parentId": "root", "path": "auth/*", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/auth._-l0sNRNKZ.js", "imports": [], "css": [] }, "routes/app": { "id": "routes/app", "parentId": "root", "path": "app", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": true, "module": "/assets/app-CDslID0t.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/components-Cx8rd7AF.js", "/assets/styles-CzQq0O8K.js", "/assets/context-BbmIOJGV.js", "/assets/context-CCgK-ll5.js"], "css": [] }, "routes/app.products": { "id": "routes/app.products", "parentId": "routes/app", "path": "products", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/app.products-CAIihu17.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/iconBase-FUo1lpJK.js", "/assets/components-Cx8rd7AF.js", "/assets/context-BbmIOJGV.js", "/assets/Page-B0rKNhuS.js", "/assets/LegacyCard-DXzry5rq.js", "/assets/Image-C2yUA1Dt.js", "/assets/Sticky-BZ1aWOXL.js", "/assets/CSSTransition-BYpPa09r.js", "/assets/Card-BFf8yJ6t.js", "/assets/SkeletonBodyText-C-lyMTjV.js", "/assets/Tabs-DM1y4PgX.js", "/assets/FormLayout-B5cHeF8N.js", "/assets/context-CCgK-ll5.js", "/assets/InlineGrid-B1yRZjGa.js"], "css": [] }, "routes/app.settings": { "id": "routes/app.settings", "parentId": "routes/app", "path": "settings", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/app.settings-wP7I_-Hg.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/components-Cx8rd7AF.js", "/assets/Page-B0rKNhuS.js", "/assets/InlineGrid-B1yRZjGa.js", "/assets/Card-BFf8yJ6t.js", "/assets/SkeletonBodyText-C-lyMTjV.js", "/assets/Select-CdbOsvFg.js", "/assets/context-BbmIOJGV.js"], "css": [] }, "routes/app.account": { "id": "routes/app.account", "parentId": "routes/app", "path": "account", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/app.account-dAWe6_n5.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/components-Cx8rd7AF.js", "/assets/Page-B0rKNhuS.js", "/assets/LegacyCard-DXzry5rq.js", "/assets/SkeletonBodyText-C-lyMTjV.js", "/assets/context-BbmIOJGV.js", "/assets/Sticky-BZ1aWOXL.js"], "css": [] }, "routes/app._index": { "id": "routes/app._index", "parentId": "routes/app", "path": void 0, "index": true, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/app._index-FSHoWqNI.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/context-BbmIOJGV.js", "/assets/iconBase-FUo1lpJK.js", "/assets/components-Cx8rd7AF.js", "/assets/Page-B0rKNhuS.js", "/assets/Card-BFf8yJ6t.js", "/assets/SkeletonBodyText-C-lyMTjV.js", "/assets/CSSTransition-BYpPa09r.js", "/assets/InlineGrid-B1yRZjGa.js", "/assets/CalloutCard-BHQpTEFD.js", "/assets/LegacyCard-DXzry5rq.js", "/assets/Collapsible-BjE-VXf-.js", "/assets/Select-CdbOsvFg.js", "/assets/Image-C2yUA1Dt.js"], "css": [] }, "routes/app.plan": { "id": "routes/app.plan", "parentId": "routes/app", "path": "plan", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/app.plan-BvPOW2I6.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/support-BX1FHkWx.js", "/assets/components-Cx8rd7AF.js", "/assets/Page-B0rKNhuS.js", "/assets/Card-BFf8yJ6t.js", "/assets/CalloutCard-BHQpTEFD.js", "/assets/context-BbmIOJGV.js", "/assets/LegacyCard-DXzry5rq.js", "/assets/Image-C2yUA1Dt.js"], "css": ["/assets/app-C95PfHTP.css"] }, "routes/app.faq": { "id": "routes/app.faq", "parentId": "routes/app", "path": "faq", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasErrorBoundary": false, "module": "/assets/app.faq-DW9Bd26R.js", "imports": ["/assets/index-BybyV3_0.js", "/assets/support-BX1FHkWx.js", "/assets/Page-B0rKNhuS.js", "/assets/LegacyCard-DXzry5rq.js", "/assets/Tabs-DM1y4PgX.js", "/assets/CalloutCard-BHQpTEFD.js", "/assets/Collapsible-BjE-VXf-.js", "/assets/context-BbmIOJGV.js", "/assets/context-CCgK-ll5.js", "/assets/CSSTransition-BYpPa09r.js", "/assets/InlineGrid-B1yRZjGa.js", "/assets/FormLayout-B5cHeF8N.js", "/assets/Image-C2yUA1Dt.js"], "css": [] } }, "url": "/assets/manifest-f11aca7a.js", "version": "f11aca7a" };
const mode = "production";
const assetsBuildDirectory = "build/client";
const basename = "/";
const future = { "v3_fetcherPersist": true, "v3_relativeSplatPath": true, "v3_throwAbortReason": true, "v3_routeConfig": true, "v3_singleFetch": false, "v3_lazyRouteDiscovery": true, "unstable_optimizeDeps": false };
const isSpaMode = false;
const publicPath = "/";
const entry = { module: entryServer };
const routes = {
  "root": {
    id: "root",
    parentId: void 0,
    path: "",
    index: void 0,
    caseSensitive: void 0,
    module: route0
  },
  "routes/webhooks.app.scopes_update": {
    id: "routes/webhooks.app.scopes_update",
    parentId: "root",
    path: "webhooks/app/scopes_update",
    index: void 0,
    caseSensitive: void 0,
    module: route1
  },
  "routes/webhooks.app.uninstalled": {
    id: "routes/webhooks.app.uninstalled",
    parentId: "root",
    path: "webhooks/app/uninstalled",
    index: void 0,
    caseSensitive: void 0,
    module: route2
  },
  "routes/api.fetchAmazonProducts": {
    id: "routes/api.fetchAmazonProducts",
    parentId: "root",
    path: "api/fetchAmazonProducts",
    index: void 0,
    caseSensitive: void 0,
    module: route3
  },
  "routes/api.fetchProductCount": {
    id: "routes/api.fetchProductCount",
    parentId: "root",
    path: "api/fetchProductCount",
    index: void 0,
    caseSensitive: void 0,
    module: route4
  },
  "routes/api.productVariant": {
    id: "routes/api.productVariant",
    parentId: "root",
    path: "api/productVariant",
    index: void 0,
    caseSensitive: void 0,
    module: route5
  },
  "routes/api.unblockproduct": {
    id: "routes/api.unblockproduct",
    parentId: "root",
    path: "api/unblockproduct",
    index: void 0,
    caseSensitive: void 0,
    module: route6
  },
  "routes/api.blockProduct": {
    id: "routes/api.blockProduct",
    parentId: "root",
    path: "api/blockProduct",
    index: void 0,
    caseSensitive: void 0,
    module: route7
  },
  "routes/api.productCount": {
    id: "routes/api.productCount",
    parentId: "root",
    path: "api/productCount",
    index: void 0,
    caseSensitive: void 0,
    module: route8
  },
  "routes/api.setupSetting": {
    id: "routes/api.setupSetting",
    parentId: "root",
    path: "api/setupSetting",
    index: void 0,
    caseSensitive: void 0,
    module: route9
  },
  "routes/api.welcomeTour": {
    id: "routes/api.welcomeTour",
    parentId: "root",
    path: "api/welcomeTour",
    index: void 0,
    caseSensitive: void 0,
    module: route10
  },
  "routes/api.products": {
    id: "routes/api.products",
    parentId: "root",
    path: "api/products",
    index: void 0,
    caseSensitive: void 0,
    module: route11
  },
  "routes/api.settings": {
    id: "routes/api.settings",
    parentId: "root",
    path: "api/settings",
    index: void 0,
    caseSensitive: void 0,
    module: route12
  },
  "routes/api.pushall": {
    id: "routes/api.pushall",
    parentId: "root",
    path: "api/pushall",
    index: void 0,
    caseSensitive: void 0,
    module: route13
  },
  "routes/auth.login": {
    id: "routes/auth.login",
    parentId: "root",
    path: "auth/login",
    index: void 0,
    caseSensitive: void 0,
    module: route14
  },
  "routes/api.plan": {
    id: "routes/api.plan",
    parentId: "root",
    path: "api/plan",
    index: void 0,
    caseSensitive: void 0,
    module: route15
  },
  "routes/api.push": {
    id: "routes/api.push",
    parentId: "root",
    path: "api/push",
    index: void 0,
    caseSensitive: void 0,
    module: route16
  },
  "routes/_index": {
    id: "routes/_index",
    parentId: "root",
    path: void 0,
    index: true,
    caseSensitive: void 0,
    module: route17
  },
  "routes/auth.$": {
    id: "routes/auth.$",
    parentId: "root",
    path: "auth/*",
    index: void 0,
    caseSensitive: void 0,
    module: route18
  },
  "routes/app": {
    id: "routes/app",
    parentId: "root",
    path: "app",
    index: void 0,
    caseSensitive: void 0,
    module: route19
  },
  "routes/app.products": {
    id: "routes/app.products",
    parentId: "routes/app",
    path: "products",
    index: void 0,
    caseSensitive: void 0,
    module: route20
  },
  "routes/app.settings": {
    id: "routes/app.settings",
    parentId: "routes/app",
    path: "settings",
    index: void 0,
    caseSensitive: void 0,
    module: route21
  },
  "routes/app.account": {
    id: "routes/app.account",
    parentId: "routes/app",
    path: "account",
    index: void 0,
    caseSensitive: void 0,
    module: route22
  },
  "routes/app._index": {
    id: "routes/app._index",
    parentId: "routes/app",
    path: void 0,
    index: true,
    caseSensitive: void 0,
    module: route23
  },
  "routes/app.plan": {
    id: "routes/app.plan",
    parentId: "routes/app",
    path: "plan",
    index: void 0,
    caseSensitive: void 0,
    module: route24
  },
  "routes/app.faq": {
    id: "routes/app.faq",
    parentId: "routes/app",
    path: "faq",
    index: void 0,
    caseSensitive: void 0,
    module: route25
  }
};
export {
  serverManifest as assets,
  assetsBuildDirectory,
  basename,
  entry,
  future,
  isSpaMode,
  mode,
  publicPath,
  routes
};
