import { json } from "@remix-run/node";
import prisma from "../db.server";

export const action = async ({ request }) => {
  try {
    const body = await request.json();
    const { product_id } = body;

    if (!product_id) {
      return json({ success: false, message: "product_id is required" }, { status: 400 });
    }

    const variants = await prisma.product_variants.findMany({
      where: { product_id },
      select: {
        id: true,
        price: true,
        sku: true,
        quantity: true,
        option1val: true,
        option2val: true,
        option3val: true,
      },
    });

    console.log("variantss: ", variants);

    return json({ success: true, data: variants });
  } catch (error) {
    console.error("Fetch variants error:", error);
    return json({ success: false, message: error.message }, { status: 500 });
  }
};
