import { json } from "@remix-run/node";
import prisma from "../db.server";

export const loader = async ({request}) => {
  try {
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("user_id"));

    const [all, ready_to_import, imported, import_in_progress] = await Promise.all([
      prisma.products.count({ where: { user_id: userId } }),
      prisma.products.count({ where: { status: "Ready_to_Import",user_id: userId } }),
      prisma.products.count({ where: { status: "Imported", user_id: userId } }),
      prisma.products.count({ where: { status: "Import_in_progress", user_id: userId } }),
    ]);


    return json({
      countsByStatus: {
        all,
        ready_to_import,
        imported,
        import_in_progress,
      }
    });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
