import {Page,Badge,LegacyCard,DataTable,SkeletonBodyText} from "@shopify/polaris";
import {useLoaderData} from "@remix-run/react";
import{ useEffect, useState } from "react";
import { authenticate } from "../shopify.server";
import prisma from "../db.server";
import { json } from "@remix-run/node";

export const loader = async ({ request }) => {
  const {session} = await authenticate.admin(request);

  console.log(session);

  const user = await prisma.users.findFirst({
    where:{
      shopurl:session.shop
    }
  });
  console.log(user);
  const user_id = user?.id;

  const amz_keys = await prisma.amz_keys.findFirst({
    where:{
      user_id:user_id,
      access_token:user.token,
    },
    select:{
      id:true,
      merchant_id:true,
      marketplace_id:true,
      valid:true,
      lastdatafetched:true,
    }
  });

   console.log("keys : ",amz_keys)
  return json({user,amz_keys});
};

export default function Account() {
const {user,amz_keys} = useLoaderData();

const [loading, setLoading] = useState(true);

 useEffect(() => {
    if (amz_keys) {
      setLoading(false);
    }
  }, [amz_keys]);

  const marketplaceList = [
  { id: "A2Q3Y263D00KWC", country: "BR" },
  { id: "A2EUQ1WTGCTBG2", country: "CA" },
  { id: "A1AM78C64UM0Y8", country: "MX" },
  { id: "ATVPDKIKX0DER",  country: "US"},
  { id: "A2VIGQ35RCS4UG", country: "AE" },
  { id: "A1PA6795UKMFR9", country: "DE" },
  { id: "ARBP9OOSHTCHU", country: "EG" },
  { id: "A1RKKUPIHCS9HS", country: "ES" },
  { id: "A13V1IB3VIYZZH", country: "FR" },
  { id: "AMEN7PMS3EDWL", country: "BE" },
  { id: "A1F83G8C2ARO7P", country: "UK" },
  { id: "A21TJRUUN4KGV", country: "IN" },
  { id: "APJ6JRA9NG5V4", country: "IT" },
  { id: "A1805IZSGTT6HS", country: "NL" },
  { id: "A1C3SOZRARQ6R3", country: "PL" },
  { id: "A17E79C6D8DWNP", country: "SA" },
  { id: "A2NODRKZP88ZB9", country: "SE" },
  { id: "A33AVAJ2PDY3EV", country: "TR" },
  { id: "A28R8C7NBKEWEA", country: "IE" },
  { id: "A1VC38T7YXB528", country: "JP" },
  { id: "A19VAU5U5O7RUS", country: "SG" },
  { id: "A39IBJ37TRP1C6", country: "AU" },
];
const marketplaceName = marketplaceList.find(m => m.id === amz_keys?.marketplace_id)?.country || "Unknown Marketplace";

  const rows = [
    [
      amz_keys?.id || 1,
      amz_keys?.merchant_id || "N/A",

      <Badge tone={amz_keys?.valid ? "success" : "critical"}>
        {amz_keys?.valid ? "Active" : "InActive"}
      </Badge>,

      marketplaceName,
      amz_keys?.lastdatafetched
    ],
  ];

 return(
    <>
     <Page
     title="Amazon Account Settings"
     subtitle="Configure your Amazon integration">
     {loading ? (
      <LegacyCard sectioned>
          <SkeletonBodyText lines={4} />
        </LegacyCard>
      ) : (
      <LegacyCard>
       <div className="centerTable">
        <DataTable
          columnContentTypes={[
            'text',
            'text',
            'text',
            'text',
            'text',
          ]}
          headings={[
            'Id',
            'Merchant Id',
            'Status',
            'Site',
            'Last Data Fetched',
          ]}
          hideScrollIndicator = {true}
          rows={rows}
        />
        </div>
      </LegacyCard>
      )}
       <p style={{ textAlign:"center", marginTop: "30px", color:"#666" }}>
          Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved.
        </p>
     </Page>
      <style>
        {`
          .centerTable table td,
          .centerTable table th {
            text-align: center !important;
          }
        `}
      </style>
    </>
 );
}
