import { json } from "@remix-run/node";
import prisma from "../db.server";

export const loader = async ({request}) => {
  try {
    const url = new URL(request.url);
    const userId = parseInt(url.searchParams.get("userId"));
    const product_id = url.searchParams.get("productId") || "";
    const productIdArray = product_id.split(',').map(id => id.trim()).filter(id => id !== '');
    console.log("product id array ", productIdArray);
    
    


    return json({ success: true, message: "Product IDs received", data: productIdArray });
  } catch (error) {
    console.error("Count API Error:", error);
    return json({ error: error.message }, { status: 500 });
  }
};
