    import { json } from "@remix-run/node";
    import prisma from "../db.server";
    
    export const loader = async ({ request }) => {
      try {
        const url = new URL(request.url);
        const userIdRaw = url.searchParams.get("userId");

        //  validate userId
        const userId = parseInt(userIdRaw, 10);
        if (!userIdRaw || Number.isNaN(userId)) {
            return json({ error: "Invalid or missing userId" }, { status: 400 });
        }
        // check user in queue
        const existingRequest = await prisma.productFetchRequests.findFirst({
          where: {
            user_id: userId,
            status: {
                not in :"readyforshopify"
            },
          },
        });
        if (existingRequest) {
          return json({ msg: "A fetch request is already pending for this user." });
        }

        await prisma.productFetchRequests.create({
          data: {
            user_id: userId,
            status: "pending",
          },
        });

        return json({ msg: "Products fetch Request Submitted successfully" });
    
       
      } catch (error) {
        console.error("Count API Error:", error);
        return json({ error: error.message }, { status: 500 });
      }
    };
    