import { LegacyCard, Tabs, Page, Text,Icon,Collapsible, Card,InlineStack,CalloutCard} from '@shopify/polaris';
import { useState } from 'react';
import {  ChevronDownIcon,  ChevronUpIcon } from '@shopify/polaris-icons';
import support from "./assets/support.jpg";

function FAQItem({ title, children }) {
  const [open, setOpen] = useState(false);

  return (
    <div style={{
      marginBottom: '20px',
      borderRadius: '8px',
      border: '1px solid #E3E3E3',
      padding: '12px 16px'
    }}>
      <div
        onClick={() => setOpen(!open)}
        style={{display:'flex', justifyContent:'space-between', cursor:'pointer', font:'20px'}}>
        <Text variant="bodyLg">{title}</Text>
        <div>
            <Icon source={open ?  ChevronUpIcon :  ChevronDownIcon} />
        </div>
      </div>

      <Collapsible open={open}>
        <div style={{ marginTop: '10px', color:'#616161',}}>
          <Text variant='headingMd' >{children}</Text>
        </div>
      </Collapsible>
    </div>
  );
}

function FaqPage() {
  const [selected, setSelected] = useState(0);

  const handleTabChange = (selectedTabIndex) => setSelected(selectedTabIndex);

  const tabs = [
    { id: 'general-1', content: 'General', badge: '4' },
    { id: 'about-sync-2', content: 'About Sync', badge: '3' },
    { id: 'product-import-3', content: 'About Product Import', badge: '4' },
  ];

  return (
    <Page>
      <div style={{textAlign:'center', marginTop:"10px",marginBottom:"30px"}}>
        <Text variant="heading2xl" as="h3">Frequently Asked Questions</Text>
        <Text tone="subdued">Find answers to common questions about our xpert app</Text>
      </div>

      <LegacyCard>
       <div style={{ display: "flex", justifyContent: "center" }}>
          <Tabs tabs={tabs} selected={selected} onSelect={handleTabChange}/>
       </div> 
          <LegacyCard.Section>
            
            {selected === 0 && (
              <>
                <FAQItem title="How do I connect my Amazon account?">
                 <div style={{display:'flex',flexDirection:'column',gap:'10px'}}>
                   <Text>Go to Amazon Account Settings, click <span style={{fontWeight:"bold"}}>  Authenticate Amazon Account </span>to link your Amazon seller account. You'll be redirected to Amazon's authorization page to grant permissions.</Text>
                 </div>
                </FAQItem>

                <FAQItem title="How many products can I import with the FREE plan?">
                <Text>
                <span style={{fontWeight:"bold"}}>The FREE plan </span>allows you to import up to<span style={{fontWeight:"bold"}}> 25 Amazon SKUs </span>to your Shopify store. This plan is valid for<span style={{fontWeight:"bold"}}> 30 days </span> and includes basic import functionality.
                 </Text>
                </FAQItem>

                <FAQItem title="Can I import products from multiple Amazon marketplaces?">
                  <div style={{display:'flex',flexDirection:'column',gap:'10px'}}>
                   <Text>Currently, the app supports <span style={{fontWeight:"bold"}}>one Amazon marketplace per connection. </span>If you sell on multiple Amazon sites (US, UK, DE, etc.), you'll need to switch between accounts or contact support at<span style={{fontWeight:"bold"}}> shopifyapps@infoshore.biz </span>for enterprise solutions.</Text>
                  </div>
                </FAQItem>

                <FAQItem title="What happens when my subcription expires?">
                <Text>
                  When your subscription expires, you'll no longer be able to import new products or use sync features. Existing imported products will remain in your Shopify store, but won't receive updates from Amazon.
                 </Text>
                </FAQItem>
              </>
            )}
            {selected === 1 && (
              <>
                <FAQItem title="What's the difference between Inventory Sync and Price Sync?">
                 <Text>Inventory Sync automatically updates your Shopify product quantities based on your Amazon inventory levels. Price Sync keeps your Shopify prices in sync with your Amazon prices.<span style={{fontWeight:"bold"}}> Both features are available in paid plans only.</span></Text>
                </FAQItem>

                <FAQItem title="How often does the app sync Inventory Sync and Price Sync?">
                <div style={{display:'flex',flexDirection:'column',gap:'10px'}}>
                 <Text>For paid plans with sync features enabled, inventory and prices are updated every <span style={{fontWeight:"bold"}}>24 hours</span> automatically.</Text>
                </div>
                </FAQItem>

                <FAQItem title="Are sync features available during the free trial ?">
                  <div style={{display:'flex',flexDirection:'column',gap:'10px'}}>
                   <Text>No, <span style={{fontWeight:"bold"}}>sync features (price and inventory sync)</span> are not available during the free trial.</Text>
                   <Text>To access these features, you will need to upgrade to a paid plan.</Text>
                  </div>
                </FAQItem>
              </>
            )}
            {selected === 2 && (
              <>
                <FAQItem title="Can I customize how products are imported?">
                <Text>
                 <span style={{fontWeight:"bold"}}>Yes! </span>In Settings, you can configure whether products should be published immediately, set fulfillment services, choose inventory policies, and enable/disable sync features.
                 </Text>
                </FAQItem>

                <FAQItem title="Is there a limit on product variants?">
                <Text>
                 <span style={{fontWeight:"bold"}}>Yes, </span>there's a limit on product variants as in Shopify, a product can have a <span style={{fontWeight:"bold"}}>maximum of 100 variants. </span>Each Amazon ASIN with multiple variations (size, color, etc.) will be imported as a single Shopify product with multiple variants.
                 </Text>
                </FAQItem>

                <FAQItem title="What if I need to import more than 5,000 SKUs?">
                <Text>
                 <span style={{fontWeight:"bold"}}>Yes, </span>there's a limit on product variants as in Shopify, a product can have a <span style={{fontWeight:"bold"}}>maximum of 100 variants. </span>Each Amazon ASIN with multiple variations (size, color, etc.) will be imported as a single Shopify product with multiple variants.
                 </Text>
                </FAQItem>

                <FAQItem title="Can I uninstall the app after imoprting products?">
                <Text>
                 <span style={{fontWeight:"bold"}}>Yes, </span>if you only need one-time import without ongoing sync, you can uninstall the app after importing your products. The imported products will remain in your Shopify store.
                 </Text>
                </FAQItem>
              </>
            )}
            
          </LegacyCard.Section>
      </LegacyCard>

      <div style={{marginTop:"20px",marginBottom:"30px"}}>
          <InlineStack align="center">
              <CalloutCard
                 title="Still have questions?"
                 illustration={support}
                 primaryAction={{
                    content: "Email Now",
                    url: "mailto:shopifyapps@infoshore.biz",
                    target: "_blank",
                }}>
                 <Text as="p">
                    If you couldn't find what you're looking for, our friendly support team is here to help with all your Amazon to Shopify import needs.
                </Text>
                </CalloutCard>
          </InlineStack>
      </div>

        <p style={{ textAlign:"center", marginTop: "30px",color:"#666" }}>
          Copyright 2022 InfoShore Technology Solutions LLP. All rights reserved.
        </p>
    </Page>
  );
}

export default FaqPage;
