"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FederatedLinkImport = void 0;
const graphql_1 = require("graphql");
class FederatedLinkImport {
    name;
    as;
    constructor(name, as) {
        this.name = name;
        this.as = as;
    }
    toString() {
        return this.as
            ? `{ name: "${this.name}", as: "${this.as}" }`
            : `"${this.name}"`;
    }
    static fromTypedefs(node) {
        if (node.kind == graphql_1.Kind.LIST) {
            const imports = node.values.map((v) => {
                if (v.kind === graphql_1.Kind.STRING) {
                    return new FederatedLinkImport(v.value, null);
                }
                if (v.kind === graphql_1.Kind.OBJECT) {
                    let name = "";
                    let as = null;
                    v.fields.forEach((f) => {
                        if (f.name.value === "name") {
                            if (f.value.kind !== graphql_1.Kind.STRING) {
                                throw new Error(`Expected string value for @link "name" field but got "${f.value.kind}"`);
                            }
                            name = f.value.value;
                        }
                        else if (f.name.value === "as") {
                            if (f.value.kind !== graphql_1.Kind.STRING) {
                                throw new Error(`Expected string value for @link "as" field but got "${f.value.kind}"`);
                            }
                            as = f.value.value;
                        }
                    });
                    return new FederatedLinkImport(name, as);
                }
                throw new Error(`Unexpected value kind "${v.kind}" in @link import declaration`);
            });
            return imports;
        }
        throw new Error(`Expected a list of @link imports but got "${node.kind}"`);
    }
}
exports.FederatedLinkImport = FederatedLinkImport;
