import { AbstractMigrationEngine } from './abstract-migration-engine';
import { RdbmsSessionStorageMigratorOptions, RdbmsConnection, MigrationOperation } from './types';
export declare abstract class RdbmsSessionStorageMigrator extends AbstractMigrationEngine<RdbmsConnection, RdbmsSessionStorageMigratorOptions> {
    constructor(dbConnection: RdbmsConnection, opts: Partial<RdbmsSessionStorageMigratorOptions> | undefined, migrations: MigrationOperation[]);
    hasMigrationBeenApplied(migrationName: string): Promise<boolean>;
    saveAppliedMigration(migrationName: string): Promise<void>;
    getOptions(): RdbmsSessionStorageMigratorOptions;
    abstract initMigrationPersistence(): Promise<void>;
}
//# sourceMappingURL=rdbms-session-storage-migrator.d.ts.map