import { LogSeverity } from '@shopify/shopify-api';
import { MemorySessionStorage } from '../../session-storage/shopify-app-session-storage-memory/dist/esm/memory.mjs';
import { API_KEY, APP_URL, API_SECRET_KEY } from '@shopify/shopify-api/test-helpers';

const TEST_CONFIG = {
    apiKey: API_KEY,
    apiSecretKey: API_SECRET_KEY,
    scopes: ['testScope'],
    appUrl: APP_URL,
    adminApiAccessToken: API_KEY,
    privateAppStorefrontAccessToken: API_KEY,
    logger: {
        level: LogSeverity.Debug,
    },
    sessionStorage: new MemorySessionStorage(),
    isTesting: true,
};
function testConfig({ future, ...overrides } = {}) {
    return {
        ...TEST_CONFIG,
        ...overrides,
        logger: {
            ...TEST_CONFIG.logger,
            ...overrides.logger,
        },
        future,
    };
}

export { testConfig };
//# sourceMappingURL=test-config.mjs.map
