function storefrontClientFactory({ params, session, }) {
    const { api } = params;
    return {
        graphql: async (query, options = {}) => {
            const client = new api.clients.Storefront({
                session,
                apiVersion: options.apiVersion,
            });
            const apiResponse = await client.request(query, {
                variables: options?.variables,
                retries: options?.tries ? options.tries - 1 : 0,
                headers: options?.headers,
            });
            return new Response(JSON.stringify(apiResponse));
        },
    };
}

export { storefrontClientFactory };
//# sourceMappingURL=factory.mjs.map
