import { respondToInvalidSessionToken } from './respond-to-invalid-session-token.mjs';
import { getShopFromRequest } from './get-shop-from-request.mjs';

async function validateSessionToken(params, request, token, { checkAudience = true, retryRequest = true } = {}) {
    const { api, logger } = params;
    const shop = getShopFromRequest(request);
    logger.debug('Validating session token', { shop });
    try {
        const payload = await api.session.decodeSessionToken(token, {
            checkAudience,
        });
        logger.debug('Session token is valid - validated', {
            shop,
            payload: JSON.stringify(payload),
        });
        return payload;
    }
    catch (error) {
        logger.debug(`Failed to validate session token: ${error.message}`, {
            shop,
        });
        throw respondToInvalidSessionToken({ params, request, retryRequest });
    }
}

export { validateSessionToken };
//# sourceMappingURL=validate-session-token.mjs.map
