import { ShopifyError } from '@shopify/shopify-api';
import '@remix-run/server-runtime';
import { handleClientErrorFactory } from '../helpers/handle-client-error.mjs';
import { getShopFromRequest } from '../../helpers/get-shop-from-request.mjs';
import 'isbot';
import '../../../types.mjs';

class MerchantCustomAuth {
    api;
    config;
    logger;
    constructor({ api, config, logger }) {
        this.api = api;
        this.config = config;
        this.logger = logger;
    }
    async respondToOAuthRequests(request) {
        this.logger.debug('Skipping OAuth request for merchant custom app', {
            shop: getShopFromRequest(request),
        });
    }
    async authenticate(_request, sessionContext) {
        const { shop } = sessionContext;
        this.logger.debug('Building session from configured access token for merchant custom app', { shop });
        const session = this.api.session.customAppSession(shop);
        return session;
    }
    handleClientError(request) {
        return handleClientErrorFactory({
            request,
            onError: async ({ error }) => {
                if (error.response.code === 401) {
                    this.logger.info('Request failed with 401. Review your API credentials or generate new tokens. https://shopify.dev/docs/apps/build/authentication-authorization/access-token-types/generate-app-access-tokens-admin#rotating-api-credentials-for-admin-created-apps ');
                    throw new ShopifyError('Unauthorized: Access token has been revoked.');
                }
            },
        });
    }
}

export { MerchantCustomAuth };
//# sourceMappingURL=merchant-custom-app.mjs.map
