import { AuthScopes } from '@shopify/shopify-api';
import { redirectToInstallPage } from '../helpers/redirect-to-install-page.mjs';
import { fetchScopeDetail } from './client/fetch-scopes-details.mjs';

function requestScopesFactory(params, session, admin) {
    return async function requestScopes(scopes) {
        const { logger } = params;
        logger.debug('Requesting optional scopes: ', { shop: session.shop, scopes });
        if (scopes.length === 0)
            return;
        if (await alreadyGranted(scopes, admin))
            return;
        throw await redirectToInstallPage(params, session.shop, scopes);
    };
    async function alreadyGranted(scopes, admin) {
        const scopesDetail = await fetchScopeDetail(admin);
        const grantedScopes = scopesDetail.app.installation.accessScopes.map((scope) => scope.handle);
        return new AuthScopes(grantedScopes).has(scopes);
    }
}

export { requestScopesFactory };
//# sourceMappingURL=request.mjs.map
