import { createAdminApiContext } from './create-admin-api-context.mjs';

async function triggerAfterAuthHook(params, session, request, authStrategy) {
    const { config, logger } = params;
    if (config.hooks.afterAuth) {
        logger.info('Running afterAuth hook', { shop: session.shop });
        const admin = createAdminApiContext(session, params, authStrategy.handleClientError(request));
        await config.hooks.afterAuth({
            session,
            admin,
        });
    }
}

export { triggerAfterAuthHook };
//# sourceMappingURL=trigger-after-auth-hook.mjs.map
