'use strict';

const SESSION_TOKEN_PARAM = 'id_token';
function getSessionTokenHeader(request) {
    return request.headers.get('authorization')?.replace('Bearer ', '');
}
function getSessionTokenFromUrlParam(request) {
    const url = new URL(request.url);
    return url.searchParams.get(SESSION_TOKEN_PARAM);
}

exports.getSessionTokenFromUrlParam = getSessionTokenFromUrlParam;
exports.getSessionTokenHeader = getSessionTokenHeader;
//# sourceMappingURL=get-session-token-header.js.map
