'use strict';

var shopifyApi = require('@shopify/shopify-api');
require('@remix-run/server-runtime');
var handleClientError = require('../helpers/handle-client-error.js');
var getShopFromRequest = require('../../helpers/get-shop-from-request.js');
require('isbot');
require('../../../types.js');

class MerchantCustomAuth {
    api;
    config;
    logger;
    constructor({ api, config, logger }) {
        this.api = api;
        this.config = config;
        this.logger = logger;
    }
    async respondToOAuthRequests(request) {
        this.logger.debug('Skipping OAuth request for merchant custom app', {
            shop: getShopFromRequest.getShopFromRequest(request),
        });
    }
    async authenticate(_request, sessionContext) {
        const { shop } = sessionContext;
        this.logger.debug('Building session from configured access token for merchant custom app', { shop });
        const session = this.api.session.customAppSession(shop);
        return session;
    }
    handleClientError(request) {
        return handleClientError.handleClientErrorFactory({
            request,
            onError: async ({ error }) => {
                if (error.response.code === 401) {
                    this.logger.info('Request failed with 401. Review your API credentials or generate new tokens. https://shopify.dev/docs/apps/build/authentication-authorization/access-token-types/generate-app-access-tokens-admin#rotating-api-credentials-for-admin-created-apps ');
                    throw new shopifyApi.ShopifyError('Unauthorized: Access token has been revoked.');
                }
            },
        });
    }
}

exports.MerchantCustomAuth = MerchantCustomAuth;
//# sourceMappingURL=merchant-custom-app.js.map
