'use strict';

var revokeScopes = require('./client/revoke-scopes.js');

function revokeScopesFactory(params, session, admin) {
    return async function revoke(scopes) {
        const { logger } = params;
        await validateScopes(scopes);
        logger.debug('Revoke scopes: ', {
            shop: session.shop,
            scopes,
        });
        const revokeScopesResult = await revokeScopes.revokeScopes(admin, scopes);
        if (revokeScopesResult.userErrors?.length > 0) {
            logger.error('Failed to revoke scopes: ', {
                shop: session.shop,
                errors: revokeScopesResult.userErrors,
            });
            throw new Response(JSON.stringify(revokeScopesResult.userErrors), {
                status: 422,
                headers: {
                    'Content-Type': 'application/json',
                },
            });
        }
        return {
            revoked: revokeScopesResult.revoked.map((scope) => scope.handle),
        };
    };
}
async function validateScopes(scopes) {
    if (!scopes || scopes.length === 0) {
        throw new Response('No scopes provided', { status: 400 });
    }
}

exports.revokeScopesFactory = revokeScopesFactory;
//# sourceMappingURL=revoke.js.map
