'use strict';

var shopifyApi = require('@shopify/shopify-api');
var redirectToInstallPage = require('../helpers/redirect-to-install-page.js');
var fetchScopesDetails = require('./client/fetch-scopes-details.js');

function requestScopesFactory(params, session, admin) {
    return async function requestScopes(scopes) {
        const { logger } = params;
        logger.debug('Requesting optional scopes: ', { shop: session.shop, scopes });
        if (scopes.length === 0)
            return;
        if (await alreadyGranted(scopes, admin))
            return;
        throw await redirectToInstallPage.redirectToInstallPage(params, session.shop, scopes);
    };
    async function alreadyGranted(scopes, admin) {
        const scopesDetail = await fetchScopesDetails.fetchScopeDetail(admin);
        const grantedScopes = scopesDetail.app.installation.accessScopes.map((scope) => scope.handle);
        return new shopifyApi.AuthScopes(grantedScopes).has(scopes);
    }
}

exports.requestScopesFactory = requestScopesFactory;
//# sourceMappingURL=request.js.map
