'use strict';

var serverRuntime = require('@remix-run/server-runtime');

function redirectWithExitIframe(params, request, shop) {
    const { api, config } = params;
    const url = new URL(request.url);
    const queryParams = url.searchParams;
    const host = api.utils.sanitizeHost(queryParams.get('host'));
    queryParams.set('shop', shop);
    let destination = `${config.auth.path}?shop=${shop}`;
    if (host) {
        queryParams.set('host', host);
        destination = `${destination}&host=${host}`;
    }
    queryParams.set('exitIframe', destination);
    throw serverRuntime.redirect(`${config.auth.exitIframePath}?${queryParams.toString()}`);
}

exports.redirectWithExitIframe = redirectWithExitIframe;
//# sourceMappingURL=redirect-with-exitiframe.js.map
