'use strict';

var _const = require('../../const.js');

function redirectWithAppBridgeHeaders(redirectUri) {
    throw new Response(undefined, {
        status: 401,
        statusText: 'Unauthorized',
        headers: getAppBridgeHeaders(redirectUri),
    });
}
function getAppBridgeHeaders(url) {
    return new Headers({ [_const.REAUTH_URL_HEADER]: url });
}

exports.getAppBridgeHeaders = getAppBridgeHeaders;
exports.redirectWithAppBridgeHeaders = redirectWithAppBridgeHeaders;
//# sourceMappingURL=redirect-with-app-bridge-headers.js.map
